

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daPopulateASRTempTbl.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daPopulateASRTempTbl.sp,v $ $Id: daPopulateASRTempTbl.sp,v 1.6.208.1 2018/03/20 19:58:09 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daPopulateASRTempTbl()
--  |
--  | Description:  Populate data for ASR backups.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daPopulateASRTempTbl <<<'

IF EXISTS (select * from sysobjects where name='daPopulateASRTempTbl')
	drop procedure daPopulateASRTempTbl
IF EXISTS (select * from GxQscripts where name='daPopulateASRTempTbl')
	delete from GxQscripts where name = 'daPopulateASRTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateASRTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateASRTempTbl'
GO
print '... Creating Procedure: daPopulateASRTempTbl'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daPopulateASRTempTbl
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobCopy INTEGER;
	SET NOCOUNT ON
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @errorCode		INTEGER
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@errorCode		= 0
	-------------------------------------------------------------------------------
	-- Get the @numAppIdToAge rows to be processed from ArchAppCopyToBeAged
	-- appId with logs will not be processed here
	-------------------------------------------------------------------------------
	-- Get appId to be processed for ASR
	INSERT INTO	#DA_AppCopyList
	SELECT	a.*
FROM	ArchAppCopyToBeAged a
WHERE	(a.AppFlags & 512) > 0
AND		a.AppFlags & (33554432 | 67108864) = 0
	AND		a.DoNotAge = 0
	AND		a.AgeStatus = 0
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-- Get the data from JMJobDataStats table for the appIds to be processed
	-- on all copies
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
Disabled=MAX(b.Disabled & 1),
ManualRet=MAX(b.Disabled & 2),
JobFlags = ((MAX(CASE WHEN (b.Disabled & 64) <> 0 THEN 1 ELSE 0 END)) | (MAX(CASE WHEN C.type > 1 THEN 2 ELSE 0 END)))
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK), APP_CommCell C WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
	AND 	(a.FileType = 512 OR a.FileType = b.dataType)
	AND		b.CommCellId = c.id
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId, b.JobId, b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	-------------------------------------------------------------------------------
	-- Remove NON-ASR backups if there are any
	-------------------------------------------------------------------------------
	DELETE	#DA_JobDataStats
	FROM	#DA_JobDataStats a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	AND		b.BkpLevel <> 512
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Remove Foreign backups if there are any
	-------------------------------------------------------------------------------
	DELETE	#DA_JobDataStats
WHERE	(JobFlags & 2) <> 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-- Get the data from #DA_JobDataStats table for the appIds to be processed
	-- on selected copies only
	-------------------------------------------------------------------------------
	INSERT	INTO #DA_JobCopyList
	SELECT	DISTINCT a.AppId, a.AppFlags,
					a.CopyId, a.FileType,
					b.JobId, b.CommCellId,
					StartTime = -1, EndTime = -1,
					BkpLevel = -1, JobStatus = -1,
					DataStatus = b.DataStatus, Disabled = b.Disabled,
					ManualRet = b.ManualRet, RetainForAuxCopy = 0,
					ExtendedJob = 0, OnLinkedSP = 0, fullCycleNum = 0,
					CycleId = 0, jobRetainReason = 0,
					a.isCWEjobValid, JobFlags = b.JobFlags
	FROM	#DA_AppCopyList a, #DA_JobDataStats b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_EXIT
	IF		@numJobCopy = 0 GOTO CX_EXIT
	----------------------------------------------------------------------------------------------
	-- Get the Start Time, End Time, Backuplevel, JobStatus and fullCycleNum of the selected jobs
	----------------------------------------------------------------------------------------------
	-- Update job info for ASR backup jobs
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate,
				EndTime = b.ServEndDate,
				BkpLevel = b.BkpLevel,
				JobStatus = b.Status,
				fullCycleNum = b.fullCycleNum
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- Do not process the Failed/Killed jobs here
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE JobStatus NOT IN (1, 3, 14) -- Success / Completed With Errors / Completed With Warnings
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-----------------------------------------------------------------------------
	-- In case if no job history is available then do not process such jobs
	-----------------------------------------------------------------------------
	DELETE	#DA_JobCopyList
	WHERE StartTime = -1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update EndTime if EndTime is 0
	UPDATE	#DA_JobCopyList
	SET 	EndTime = StartTime
	WHERE	EndTime = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @errorCode != 0
	BEGIN
		DELETE	FROM #DA_JobCopyList
		SELECT	@errorCode, -1, -1
	END
	ELSE
	BEGIN
		SELECT	@errorCode, @numAppIdAged, @numJobCopy
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daPopulateASRTempTbl')
	delete from GxQscripts where name = 'daPopulateASRTempTbl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daPopulateASRTempTbl')
	delete from GXDBVersions where aliasname = 'daPopulateASRTempTbl'
GO

insert into GXDBVersions values(2, 'daPopulateASRTempTbl',  '00010006020800010000', 'daPopulateASRTempTbl', '00010006020800010000')
GO

