

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daJobHistoryUpdate.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daJobHistoryUpdate()
--  | Description:  Update backup histories.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daJobHistoryUpdate.sp,v $ $Id: daJobHistoryUpdate.sp,v 1.26.12.8 2020/04/22 21:29:07 hkapadia Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daJobHistoryUpdate')
BEGIN
	print '>>> Drop Stored Procedure: daJobHistoryUpdate <<<'
	drop procedure daJobHistoryUpdate
END
IF EXISTS (select * from GxQscripts where name='daJobHistoryUpdate')
	delete from GxQscripts where name = 'daJobHistoryUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daJobHistoryUpdate')
	delete from GXDBVersions where aliasname = 'daJobHistoryUpdate'
GO
print '... Creating Procedure: daJobHistoryUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daJobHistoryUpdate
AS
  DECLARE @numJobUpdated integer;
SET NOCOUNT ON
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @rowCnt	INTEGER
	SET 		@rowCnt = 0
	DECLARE @TotalJobsUpdated	INTEGER
	SET 		@TotalJobsUpdated = 0
	DECLARE @maxJobsToUpdateInBatch INTEGER
	SET			@maxJobsToUpdateInBatch	= 2000
	DECLARE @honorCopyRetForJobsWithNoData INTEGER
	SET			@honorCopyRetForJobsWithNoData	= 1
	DECLARE @DAJobId INTEGER
	SET			@DAJobId = 0
	DECLARE		@ARCHIVE_GROUP_ITEM	INTEGER
	SET				@ARCHIVE_GROUP_ITEM	= 2231
	DECLARE		@SUB_CLIENT_ITEM	INTEGER
	SET				@SUB_CLIENT_ITEM	= 2013
   DECLARE @checkSumDDBSC INTEGER
   SET @checkSumDDBSC = CHECKSUM(N'DDB Backup')
   DECLARE @checkSumIndexSC INTEGER
   SET @checkSumIndexSC = CHECKSUM(N'Index SubClient')
	DECLARE	@retCode INT
	SELECT @maxJobsToUpdateInBatch = isnull(value, 2000)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
	SELECT @honorCopyRetForJobsWithNoData = isnull(value, 1)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_HONOR_COPY_RETENTION_FOR_JOBS_WITHOUT_DATA'
	IF OBJECT_ID('tempdb.dbo.#tblJobToUpdate') IS NOT NULL
		DROP TABLE #tblJobToUpdate
	IF OBJECT_ID('tempdb.dbo.#tmpAllJobToUpdate') IS NOT NULL
		DROP TABLE #tmpAllJobToUpdate
	IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
		DROP TABLE #tblEntityInfo
	CREATE TABLE #tblEntityInfo
	(
			EntityTypeId			INTEGER,
			EntityId				 	INTEGER
	)
	CREATE INDEX Idx_tblEntityInfo_1 ON #tblEntityInfo (EntityTypeId, EntityId)
	CREATE TABLE #tblJobToUpdate
	(
		jobId 			int,
		commCellId 	int,
		primary key (jobId, commCellId)
	)
	CREATE TABLE #tmpAllJobToUpdate
	(
		jobId 			int,
		commCellId 	int,
		appId				int,
		archGrpId		int,
		primary key (jobId, commCellId) WITH (ignore_dup_key = ON)
	)
	SELECT TOP 1 @DAJobId = JobId
	FROM JMAdminJobInfoTable WITH (NOLOCK)
	WHERE opType = 10
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Get the selected entities for pruning
	EXEC @retCode = daGetGranularSelection @DAJobId
	SELECT	@retVal = @@ERROR
	IF @retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	IF EXISTS (SELECT * FROM #tblEntityInfo WHERE EntityTypeId = -1)
		GOTO CX_EXIT_ERROR
	-- Get all jobs with data including failed/killed jobs
	INSERT	INTO #tmpAllJobToUpdate
	SELECT	JBS.jobId, JBS.commCellId, JBS.appId, JBS.dataArchGrpId
	FROM	JMBkpStats JBS WITH (NOLOCK), JMJobStats JJS WITH (NOLOCK)
	WHERE	JBS.JobId = JJS.JobId
	AND		JBS.commCellId = JJS.commCellId
	AND		JBS.dataStatus IN (0, 1)
	AND		(			(JBS.opType NOT IN (60, 59))
					OR 	(JBS.opType IN (59) AND JJS.subOpType NOT IN (96))
				)	-- Exclude Tape Movement/Deferred Cataloging Jobs. Prune them with other job histories
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	-- Age the Failed/Killed Tape Movement/deferred cataloging Jobs immediately.
	INSERT	INTO #tmpAllJobToUpdate
	SELECT	JBS.jobId, JBS.commCellId, JBS.appId, JBS.dataArchGrpId
	FROM	JMBkpStats JBS WITH (NOLOCK), JMJobStats JJS WITH (NOLOCK)
	WHERE	JBS.JobId = JJS.JobId
	AND		JBS.commCellId = JJS.commCellId
	AND		JBS.dataStatus IN (0, 1)
	AND		JBS.status NOT IN (1, 3, 14)
	AND		(			(JBS.opType IN (60))
					OR 	(JBS.opType IN (59) AND JJS.subOpType IN (96))
				)
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	-- Get all jobs with no data. Exclude CI/SRM/Replication Backup jobs/CDR/EDC Discovery jobs/Exchange Mailbox Cleanup jobs
	INSERT	INTO #tmpAllJobToUpdate
	SELECT	jobId, commCellId, appId, dataArchGrpId
	FROM	JMBkpStats WITH (NOLOCK)
	WHERE	dataStatus IN (3)
	AND		opType NOT IN (22, 23, 24, 53, 57, 58, 60, 109)	-- CI /SRM / Replication Backup jobs / Backup Copy / Exchange Mailbox Cleanup jobs
	AND		appType NOT IN (
48,
84,
107,
127
											)
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	IF @honorCopyRetForJobsWithNoData = 1
	BEGIN
		--Exclude Full backup jobs without data until older than SP/Primary Copy Days
		--If days rentention = 0 , then keep until new Full is available
		DELETE #tmpAllJobToUpdate
		FROM  #tmpAllJobToUpdate T, JMBkpStats JBK WITH (NOLOCK), archGroup AG WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK)
		WHERE T.jobId = JBK.jobId
		AND		T.commcellId = JBK.commcellId
		AND		JBK.bkpLevel IN (1, 64, 128, 1024, 32768, 131072, 262144)
		AND		JBK.dataStatus = 3
		AND		JBK.opType = 4
		AND		JBK.status IN (1, 3, 14)
		AND		JBK.dataArchGrpId = AG.Id
		AND		AG.defaultCopy = AAR.copyId
		AND		JBK.appId NOT IN (SELECT componentNameId FROM App_SubclientProp WITH (NOLOCK) WHERE attrName = N'DDB Backup' AND cs_attrName = @checkSumDDBSC AND attrVal = '1' AND modified = 0)
		AND		JBK.appId NOT IN (SELECT componentNameId FROM App_SubclientProp WITH (NOLOCK) WHERE	attrName = N'Index SubClient' AND	cs_attrName = @checkSumIndexSC AND attrVal = '1' AND	modified = 0)
		AND		( (AAR.RetentionDays = -1)
						OR
						(AAR.RetentionDays > 0 AND JBK.servStartDate >= dbo.GetUnixTime(GETUTCDATE()) - CAST(AAR.RetentionDays AS BIGINT) * 24 * 3600)
						OR
						(AAR.RetentionDays = 0 AND NOT EXISTS (SELECT jobId FROM JMBkpStats TMP WITH (NOLOCK) WHERE JBK.appId = TMP.appId AND JBK.fullCycleNum < TMP.FullCycleNum)
							AND EXISTS (SELECT id FROM App_Application APP WITH (NOLOCK) WHERE APP.id = JBK.appId AND APP.subclientStatus & (4 | 2) = 0) --CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
						)
					)
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
		--If DDB backup job writes no data then wait until next DDB backup job runs (CMR# 191330)
		DELETE #tmpAllJobToUpdate
		FROM  #tmpAllJobToUpdate T, JMBkpStats JBK WITH (NOLOCK)
		WHERE T.jobId = JBK.jobId
		AND		T.commcellId = JBK.commcellId
		AND		JBK.bkpLevel IN (1, 64, 128, 1024, 32768, 131072, 262144)
		AND		JBK.dataStatus = 3
		AND		JBK.opType = 4
		AND		JBK.status IN (1, 3, 14)
		AND		JBK.appId IN (SELECT componentNameId
												FROM App_SubclientProp P WITH (NOLOCK), App_Application APP WITH (NOLOCK)
												WHERE APP.id = P.componentNameId
												AND APP.subclientStatus & (4 | 2) = 0 --CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
												AND	P.attrName = N'DDB Backup'
												AND P.cs_attrName = @checkSumDDBSC
												AND P.attrVal = '1'
												AND P.modified = 0
											 )
		AND		NOT EXISTS (SELECT jobId FROM JMBkpStats TMP WITH (NOLOCK) WHERE JBK.appId = TMP.appId AND JBK.fullCycleNum < TMP.FullCycleNum)
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
		--If Index DB backup job writes no data then wait until next Index DB backup job runs
		DELETE #tmpAllJobToUpdate
		FROM  #tmpAllJobToUpdate T, JMBkpStats JBK WITH (NOLOCK)
		WHERE T.jobId = JBK.jobId
		AND		T.commcellId = JBK.commcellId
		AND		JBK.bkpLevel IN (1, 64, 128, 1024, 32768, 131072, 262144)
		AND		JBK.dataStatus = 3
		AND		JBK.opType = 4
		AND		JBK.status IN (1, 3, 14)
		AND		JBK.appId IN (SELECT componentNameId
												FROM App_SubclientProp P WITH (NOLOCK), App_Application APP WITH (NOLOCK)
												WHERE APP.id = P.componentNameId
												AND APP.subclientStatus & (4 | 2) = 0 --CV_STATUS_DELETED | CV_STATUS_UNINSTALLED
												AND	P.attrName = N'Index SubClient'
												AND P.cs_attrName = @checkSumIndexSC
												AND P.attrVal = '1'
												AND P.modified = 0
											 )
		AND		NOT EXISTS (SELECT jobId FROM JMBkpStats TMP WITH (NOLOCK) WHERE JBK.appId = TMP.appId AND JBK.fullCycleNum < TMP.FullCycleNum)
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
		--Exclude Incr backup jobs without data until corresponding Full is available
		DELETE #tmpAllJobToUpdate
		FROM  #tmpAllJobToUpdate T, JMBkpStats JBK WITH (NOLOCK)
		WHERE T.jobId = JBK.jobId
		AND		T.commcellId = JBK.commcellId
		AND		JBK.bkpLevel NOT IN (1, 64, 128, 1024, 32768, 131072, 262144)
		AND		JBK.dataStatus = 3
		AND		JBK.opType = 4
		AND		JBK.status IN (1, 3, 14)
		AND		EXISTS (SELECT TMP.JobId
									FROM JMBkpStats TMP WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK), archGroup AG WITH (NOLOCK)
									WHERE JBK.appId = TMP.appId
									AND 	JBK.fullCycleNum = TMP.FullCycleNum
									AND		TMP.bkpLevel IN (1, 64, 128, 1024, 32768, 131072, 262144)
									AND 	TMP.dataStatus IN (0, 3)
									AND		TMP.jobId = JDS.jobId
									AND		TMP.commCellId = JDS.commCellId
									AND 	JDS.archGrpId = AG.id
									AND		JDS.archGrpCopyId = AG.defaultCopy
									AND		JDS.disabled & 256 = 0
								 )
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
	END
	INSERT	INTO #tmpAllJobToUpdate
	SELECT	jobId, commCellId, appId, archGrpId
	FROM	JMAdminJobStatsTable WITH (NOLOCK)
	WHERE	optype in (11, 44, 64)
	AND		dataStatus in (0, 1)
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Compute status for VSA V2 parent jobs
	INSERT	INTO #tmpAllJobToUpdate
	SELECT	DISTINCT JBKP.jobId, JBKP.commCellId, JBKP.appId, JBKP.dataArchGrpId
	FROM	JMBkpStats JBKP WITH (NOLOCK), JMJobDataLink JDL WITH (NOLOCK)
	WHERE	JBKP.jobId = JDL.parentJobId
	AND		JBKP.commCellId = JDL.commCellId
	AND		JBKP.dataStatus = 3
AND		JDL.linkType IN (7, 8)
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	-- Do Not process jobs on SP/Subclients not selected or not associated for current user
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#tmpAllJobToUpdate
		WHERE appId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM)
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO CX_EXIT_ERROR
	END
	IF NOT EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM AND EntityId = 0)
	BEGIN
		DELETE	#tmpAllJobToUpdate
		WHERE archGrpId NOT IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM)
		SET	@retVal = @@ERROR
		IF	@retVal <> 0 GOTO CX_EXIT_ERROR
	END
	-- DO NOT PROCESS ANY FOREIGN JOBS
	DELETE	#tmpAllJobToUpdate
	FROM	#tmpAllJobToUpdate A, APP_CommCell C WITH (NOLOCK)
	WHERE	A.commCellId = C.id
	AND		C.type > 1
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT_ERROR
	-- Filter out jobs with data not aged
	DELETE	#tmpAllJobToUpdate
	FROM	#tmpAllJobToUpdate A, JMJobDataStats B WITH (NOLOCK)
	WHERE	A.jobId = B.jobId
	AND 	A.commCellId = B.commCellId
	AND		B.status in (2, 3, 100, 102, 103)
AND		(B.disabled & 256) = 0
	SET	@retVal = @@ERROR
	IF	@retVal <> 0 GOTO CX_EXIT_ERROR
	-- Update all jobs in batches
	WHILE (1 = 1)
	BEGIN
		INSERT	INTO #tblJobToUpdate
		SELECT TOP (@maxJobsToUpdateInBatch) jobId, commCellId
		FROM #tmpAllJobToUpdate
		SELECT @retVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @retVal <> 0
			GOTO CX_EXIT_ERROR
		IF @rowCnt = 0
			BREAK
		--Remove the rows that are selected for update
		DELETE #tmpAllJobToUpdate
		FROM #tmpAllJobToUpdate T, #tblJobToUpdate TT
		WHERE T.jobId = TT.jobId
		AND		T.commCellId = TT.commCellId
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
		EXEC @retVal = daUpdateJobHistory 0
		IF @retVal = -1
			GOTO CX_EXIT_ERROR
		ELSE
			SET @TotalJobsUpdated = @TotalJobsUpdated + @retVal
		TRUNCATE TABLE #tblJobToUpdate
		SET @retVal = @@ERROR
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
	END
	SELECT @TotalJobsUpdated
	RETURN
CX_EXIT_ERROR:
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daJobHistoryUpdate')
	delete from GxQscripts where name = 'daJobHistoryUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daJobHistoryUpdate')
	delete from GXDBVersions where aliasname = 'daJobHistoryUpdate'
GO

insert into GXDBVersions values(2, 'daJobHistoryUpdate',  '00010026001200080000', 'daJobHistoryUpdate', '00010026001200080000')
GO

