

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daJobHistoryDelete.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daJobHistoryDelete()
--  | Description:  Delete job histories based on time.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daJobHistoryDelete.sp,v $ $Id: daJobHistoryDelete.sp,v 1.52.2.22.12.1 2021/03/08 19:01:14 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daJobHistoryDelete')
BEGIN
	print '>>> Drop Stored Procedure: daJobHistoryDelete <<<'
	drop procedure daJobHistoryDelete
END
IF EXISTS (select * from GxQscripts where name='daJobHistoryDelete')
	delete from GxQscripts where name = 'daJobHistoryDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daJobHistoryDelete')
	delete from GXDBVersions where aliasname = 'daJobHistoryDelete'
GO
print '... Creating Procedure: daJobHistoryDelete'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daJobHistoryDelete
  @lifeSpanGeneral integer,
  @lifeSpanSuccessfulBkUp integer,
  @lifeSpanArchiver integer,
  @LifeSpanBkUpMgmtJobs integer,
  @LifeSpanRepBkUpJobs integer
AS
  DECLARE @numJobDeleted integer;
SET NOCOUNT ON
	DECLARE @lifeSpanLibraryHistory INTEGER
	SET			@lifeSpanLibraryHistory = 30
	DECLARE @lifeSpanSiteReplicationHistory INTEGER
	SET			@lifeSpanSiteReplicationHistory = 30
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @errVal	INTEGER
	SET 		@errVal = 0
	DECLARE @rowCnt	INTEGER
	SET 		@rowCnt = 0
	DECLARE @TotalJobsPruned	INTEGER
	SET 		@TotalJobsPruned = 0
	DECLARE @JobsToSelect	INTEGER
	SET 		@JobsToSelect = 0
	DECLARE @RestJobsCnt	INTEGER
	SET 		@RestJobsCnt = 0
	DECLARE @currentTime INTEGER
	SET 		@currentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @daysToKeepPipelineInfo INTEGER
	SET 		@daysToKeepPipelineInfo = 1
	DECLARE @daysToKeepRestoreJobHistory INTEGER
	SET			@daysToKeepRestoreJobHistory = 90
	DECLARE @daysToKeepBLRPairStats INTEGER
	SET 		@daysToKeepBLRPairStats = 10
	DECLARE @DAJobId INTEGER
	SET			@DAJobId = 0
	DECLARE		@ARCHIVE_GROUP_ITEM	INTEGER
	SET				@ARCHIVE_GROUP_ITEM	= 2231
	DECLARE		@SUB_CLIENT_ITEM	INTEGER
	SET				@SUB_CLIENT_ITEM	= 2013
	DECLARE		@allSCSelected	INTEGER
	SET				@allSCSelected	= 0
	DECLARE		@allSPSelected	INTEGER
	SET				@allSPSelected	= 0
	DECLARE @90daysTime INT = @currentTime - (90 * 24 * 60 * 60)
	DECLARE	@retCode INT
	SELECT	@lifeSpanLibraryHistory = ISNULL(value, 30) FROM MMConfigs WITH (NOLOCK) WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_LIBRARY_HISTORY'
	DECLARE	@pDateTimeLibraryHistory DATETIME
	SET		@pDateTimeLibraryHistory = DATEADD(d, (-1 * @lifeSpanLibraryHistory), GetUTCDate())
	DECLARE	@pTimeLibraryHistory INTEGER
	SET		@pTimeLibraryHistory = dbo.GetUnixTime(@pDateTimeLibraryHistory)
	-- CNJobDataCostHistory
	DECLARE @pTimeJobDataCostHist DATETIME
	DECLARE @lifeSpanJobDataCostHist INT
	SELECT @lifeSpanJobDataCostHist = ISNULL(value, 90) FROM MMConfigs WITH (NOLOCK) WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_CN_JOBDATACOSTHISTORY'
	SET		@pTimeJobDataCostHist = DATEADD(d, (-1 * @lifeSpanJobDataCostHist), GetUTCDate())
	SELECT	@lifeSpanSiteReplicationHistory = ISNULL(value, 30)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_SITE_REPLICATION_JOB_HISTORY'
	SELECT	@daysToKeepRestoreJobHistory = ISNULL(value, 90)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_RESTORE_JOB_HISTORY'
	DECLARE @daysToKeepJobInfoHistory INT = ISNULL((SELECT value FROM MMConfigs WITH(READUNCOMMITTED)
												WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_JOB_INFO_HISTORY'), 7)
	DECLARE @pTimeJobInfoHistory INT =  @currentTime - @daysToKeepJobInfoHistory * 24 * 60 * 60
  -- HistoryDb..RMReservationRequestHistory
  DECLARE @daysToKeepRMReservationRequestHistory INTEGER
SELECT @daysToKeepRMReservationRequestHistory = ISNULL(value, 2)
	FROM MMConfigs WITH (NOLOCK) WHERE name = 'RM_CONFIG_RESOURCE_ALLOCATION_PRUNING_INTERVAL'
	DECLARE @pTimeRMReservationHistory INTEGER = 0
	SET 	@pTimeRMReservationHistory = @currentTime - @daysToKeepRMReservationRequestHistory * 24 * 60 * 60;
    DECLARE @HistoryDbRMResHistExists integer = 0
    IF (EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = 'HistoryDB') AND OBJECT_ID('HistoryDB..RMReservationRequestHistory') IS NOT NULL)
        SET @HistoryDbRMResHistExists = 1
	-- Set minimum allowed value to 7 days for troubleshooting purpose
	-- 0 is allowed for infinite retention
	-- GUI is not setting this checks, so added safety checks here
	IF (@lifeSpanGeneral > 0 AND @lifeSpanGeneral < 7)
		SET		@lifeSpanGeneral = 7
	IF (@lifeSpanSuccessfulBkUp > 0 AND @lifeSpanSuccessfulBkUp < 7)
		SET		@lifeSpanSuccessfulBkUp = 7
	IF (@lifeSpanArchiver > 0 AND @lifeSpanArchiver < 7)
		SET		@lifeSpanArchiver = 7
	IF (@LifeSpanBkUpMgmtJobs > 0 AND @LifeSpanBkUpMgmtJobs < 7)
		SET		@LifeSpanBkUpMgmtJobs = 7
	IF (@LifeSpanRepBkUpJobs > 0 AND @LifeSpanRepBkUpJobs < 7)
		SET		@LifeSpanRepBkUpJobs = 7
	IF (@lifeSpanSiteReplicationHistory > 0 AND @lifeSpanSiteReplicationHistory < 7)
		SET		@lifeSpanSiteReplicationHistory = 7
	IF (@daysToKeepRestoreJobHistory > 0 AND @daysToKeepRestoreJobHistory < 7)
		SET		@daysToKeepRestoreJobHistory = 7
	DECLARE @pTimeGeneral INTEGER
	IF @lifeSpanGeneral <= 0 	-- 0 is treated as infinite retention
		SET		@pTimeGeneral  = -1
	ELSE
		SET 	@pTimeGeneral = @currentTime - @lifeSpanGeneral * 24 * 60 * 60;
	DECLARE @pTimeSuccessfulBkUp INTEGER
	IF @lifeSpanSuccessfulBkUp <= 0		-- 0 is treated as infinite retention
			SET		@pTimeSuccessfulBkUp = -1
	ELSE
			SET 	@pTimeSuccessfulBkUp = @currentTime - @lifeSpanSuccessfulBkUp * 24 * 60 * 60;
	DECLARE @pTimeArchiver INTEGER
	IF @lifeSpanArchiver <= 0		-- 0 is treated as infinite retention
		SET 		@pTimeArchiver = -1
	ELSE
		SET 		@pTimeArchiver = @currentTime - @lifeSpanArchiver * 24 * 60 * 60;
	DECLARE @pTimeBkUpMgmtJobs INTEGER
	IF @LifeSpanBkUpMgmtJobs <= 0		-- 0 is treated as infinite retention
		SET 		@pTimeBkUpMgmtJobs = -1
	ELSE
		SET 		@pTimeBkUpMgmtJobs = @currentTime - @LifeSpanBkUpMgmtJobs * 24 * 60 * 60;
	DECLARE @pTimeRepBkUpJobs INTEGER
	IF @LifeSpanRepBkUpJobs <= 0		-- 0 is treated as infinite retention
		SET 		@pTimeRepBkUpJobs = -1
	ELSE
		SET 		@pTimeRepBkUpJobs = @currentTime - @LifeSpanRepBkUpJobs * 24 * 60 * 60;
	DECLARE @pTimeSiteReplication INTEGER
	IF @lifeSpanSiteReplicationHistory <= 0 	-- 0 is treated as infinite retention
		SET		@pTimeSiteReplication  = -1
	ELSE
		SET 	@pTimeSiteReplication = @currentTime - @lifeSpanSiteReplicationHistory * 24 * 60 * 60;
	DECLARE @pTimeRestoreHistory INTEGER
	IF @daysToKeepRestoreJobHistory <= 0 	-- 0 is treated as infinite retention
		SET		@pTimeRestoreHistory  = -1
	ELSE
		SET 	@pTimeRestoreHistory = @currentTime - @daysToKeepRestoreJobHistory * 24 * 60 * 60;
	DECLARE @maxJobsToPruneInBatch 	INTEGER
	SET			@maxJobsToPruneInBatch	= 2000
	SELECT @maxJobsToPruneInBatch = isnull(value, 2000)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
	declare @pTimeFailed integer
	set @pTimeFailed = @pTimeGeneral
	IF OBJECT_ID('tempdb.dbo.#tblJobToDelete') IS NOT NULL
		DROP TABLE #tblJobToDelete
	CREATE TABLE #tblJobToDelete
	(
		jobId 			int,
		commCellId 	int,
		primary key (jobId, commCellId)
	)
	IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
		DROP TABLE #tblEntityInfo
	CREATE TABLE #tblEntityInfo
	(
			EntityTypeId			INTEGER,
			EntityId				 	INTEGER
	)
	CREATE INDEX Idx_tblEntityInfo_1 ON #tblEntityInfo (EntityTypeId, EntityId)
	SELECT TOP 1 @DAJobId = JobId
	FROM JMAdminJobInfoTable WITH (NOLOCK)
	WHERE opType = 10
	SET @retVal = @@ERROR
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Get the selected entities for pruning
	EXEC @retCode = daGetGranularSelection @DAJobId
	SELECT	@retVal = @@ERROR
	IF @retVal = 0 SET @retVal = @retCode
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	IF EXISTS (SELECT * FROM #tblEntityInfo WHERE EntityTypeId = -1)
		GOTO CX_EXIT_ERROR
	IF EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM AND EntityId = 0)
			SET @allSCSelected = 1
	IF EXISTS (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM AND EntityId = 0)
			SET @allSPSelected = 1
	---------------------------------------------------------------
	--------  Delete Stub Recall Jobs from JMStubRecallJobs  ------
	---------------------------------------------------------------
	-- Stub recall job histories can be deleted if older than @pTimeGeneral
	-- Consider endTime here as there is no startTime in the table and
	-- very less difference between startTime and endTime of these jobs
	-- Process for any user running DA job since this table doesn't have Storage Policy / Subcient information
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) JMStubRecallJobs
		WHERE endTime < @pTimeGeneral
		AND		@pTimeGeneral >= 0
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	---------------------------------------------------------------
	-----------------  Delete Job Data Cost History   -------------
	---------------------------------------------------------------
	WHILE (1 = 1)
	BEGIN
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	---------------------------------------------------------------
	------------------ Get Backup Jobs to Delete ------------------
	---------------------------------------------------------------
	-- The foreign job histories will also be cleaned up after being marked with dataStatus = 2 flag
	-- Discovery jobs will mark the jobs with dataStatus = 2
	SET @JobsToSelect = @maxJobsToPruneInBatch
	-- Successful backup job histories can be deleted
	-- if data is deleted from media
	-- if older than @lifeSpanSuccessfulBkUp days after deleted from media
	-- 22, 23, 24 - Replication Backup jobs
	-- 53, 57 		- CI
	-- 58 				- SRM
	-- 60 				- Snap Tape Movement Jobs
	-- 59 with subOpType 96 - Deferred Cataloging Jobs
	-- 109 				- Exchange Mailbox Cleanup jobs
	WHILE (1 = 1)
	BEGIN
		INSERT	INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats J WITH (NOLOCK) INNER JOIN JMJobStats JS WITH (NOLOCK)
		ON 	J.jobId = JS.jobId
		AND	J.commCellId = JS.commCellId
		LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status IN (1, 3, 14)
		AND		J.dataStatus = 2
		AND		NOT EXISTS (SELECT parentJobId
											FROM JMJobDataLink JDL WITH (NOLOCK)
											WHERE JDL.parentJobId = J.jobId
											AND JDL.commCellId = J.commCellId
AND JDL.linkType IN (7, 8)
										 ) -- Do not delete VSA job history until the VM job history is deleted
		AND		(			(J.opType NOT IN (22, 23, 24, 53, 57, 58, 59, 60, 109))	-- CI /SRM / Replication Backup jobs / Snap Tape Movement Jobs / Deferred Cataloging Jobs / Exchange Mailbox Cleanup jobs
						OR 	(J.opType IN (59) AND JS.subOpType NOT IN (96))
					)
		AND		J.appType NOT IN (
48,
84,
107,
127
													)
		AND  	J.mediaDeletedTime < @pTimeSuccessfulBkUp
		AND		@pTimeSuccessfulBkUp >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- GET all successful SRM File Analytical Jobs with data
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status in (1, 3, 14)
		AND		J.dataStatus = 2
		AND		J.opType IN (58)
		AND		J.secondaryBkpLevel > 0
		AND  	J.mediaDeletedTime < @pTimeSuccessfulBkUp
		AND		@pTimeSuccessfulBkUp >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Failed/killed/failed-to-start client backup job histories can be deleted
	-- if older than @pTimeFailed and if job has no data or data is deleted from media
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status not in (1, 3, 14)
		AND		J.dataStatus in (2, 3)
		AND		NOT EXISTS (SELECT parentJobId
											FROM JMJobDataLink JDL WITH (NOLOCK)
											WHERE JDL.parentJobId = J.jobId
											AND JDL.commCellId = J.commCellId
AND JDL.linkType IN (7, 8)
										 ) -- Do not delete VSA job history until the VM job history is deleted
		AND		J.modifiedTime < @pTimeFailed
		AND		@pTimeFailed >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful/Failed/Killed admin backup job histories can be deleted
	-- immediately if data is deleted from media
	-- DR Backups, Erase Backups and Information Management jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMAdminJobStatsTable  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.dataStatus in (2, 3)
		AND		J.optype in (11, 44, 64)
		AND		J.servStart < @pTimeGeneral
		AND		@pTimeGeneral >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.archGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Non-backup admin job histories can be delete if older than @pTimeGeneral
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMAdminJobStatsTable J WITH (NOLOCK)
		LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.optype not in (11, 44, 64)
		AND 	J.servStart < @pTimeGeneral
		AND		@pTimeGeneral >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.archGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		AND NOT EXISTS (SELECT 1 FROM JMJobDataLink WITH(NOLOCK) WHERE parentJobId = J.jobId AND commCellId = J.commCellId)
		AND NOT EXISTS (SELECT 1 FROM JMJobDataLink WITH(NOLOCK) WHERE childJobId = J.jobId AND commCellId = J.commCellId)
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful Tape Movement/Deferred Cataloging Jobs. Prune them with other job histories
	-- Successful Exchange Mailbox Cleanup job histories can be deleted with other job histories
	-- Failed Tape Movement backup job histories have been processed with other failed jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats J WITH (NOLOCK) INNER JOIN JMJobStats JS WITH (NOLOCK)
		ON 	J.jobId = JS.jobId
		AND	J.commCellId = JS.commCellId
		LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status IN (1, 3, 14)
		AND		(			(J.opType IN (60, 109))
						OR 	(J.opType IN (59) AND JS.subOpType IN (96))
					)
		AND		J.modifiedTime < @pTimeGeneral
		AND		@pTimeGeneral >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful CI job histories can be deleted if older than @pTimeBkUpMgmtJobs
	-- Failed CI job histories have been processed with other failed jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status in (1, 3, 14)
		AND		J.dataStatus in (2, 3)
		AND		J.opType in (53, 57)									-- CI
		AND		J.modifiedTime < @pTimeBkUpMgmtJobs
		AND		@pTimeBkUpMgmtJobs >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful SRM job without data histories can be deleted if older than @pTimeBkUpMgmtJobs
	-- Failed SRM job histories have been processed with other failed jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status in (1, 3, 14)
		AND		J.dataStatus in (2, 3)
		AND		J.opType IN (58)											-- SRM
		AND		J.secondaryBkpLevel = 0
		AND		J.modifiedTime < @pTimeBkUpMgmtJobs
		AND		@pTimeBkUpMgmtJobs >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful EDC Discovery job without data histories can be deleted if older than @pTimeBkUpMgmtJobs
	-- Failed EDC Discovery job histories have been processed with other failed jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status in (1, 3, 14)
		AND		J.dataStatus in (2, 3)
AND		J.appType IN (127)			-- EDC Discovery appType
		AND		J.modifiedTime < @pTimeBkUpMgmtJobs
		AND		@pTimeBkUpMgmtJobs >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Successful Replication Backup job histories can be deleted if older than @pTimeRepBkUpJobs
	-- Failed replication backup job histories have been processed with other failed jobs
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMBkpStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.status in (1, 3, 14)
		AND		J.dataStatus in (2, 3)
		AND		(
						J.opType in (22, 23, 24) 				-- Replication Backup jobs
						OR
						J.appType in (
48,
84,
107
													)	-- SANVOLUNIX / CDR / WORKSTATION appTypes
				)
		AND		J.modifiedTime < @pTimeRepBkUpJobs
		AND		@pTimeRepBkUpJobs >= 0
		AND		(@allSCSelected = 1 OR J.appId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @SUB_CLIENT_ITEM))
		AND		(@allSPSelected = 1 OR J.dataArchGrpId IN (SELECT EntityId FROM #tblEntityInfo WHERE EntityTypeId = @ARCHIVE_GROUP_ITEM))
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Non-Archive restore job histories can be deleted if older than @pTimeRestoreHistory
	-- Process for any user running DA job since this table doesn't have Storage Policy / Subcient information
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMRestoreStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.servStartTime < @pTimeRestoreHistory
		AND		J.appType not in (67, 68)
		AND		J.opType not in (105)
		AND 	@pTimeRestoreHistory >= 0
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Archive restore job histories can be deleted if older than @pTimeArchiver
	-- Process for any user running DA job since this table doesn't have Storage Policy / Subcient information
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMRestoreStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.servStartTime < @pTimeArchiver
		AND		J.appType in (67, 68)
		AND		J.opType not in (105)
		AND		@pTimeArchiver >= 0
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Site Replication job histories can be deleted if older than @pTimeSiteReplication
	-- Process for any user running DA job since this table doesn't have Storage Policy / Subcient information
	WHILE (1 = 1)
	BEGIN
		INSERT INTO #tblJobToDelete
		SELECT TOP (@JobsToSelect) J.jobId, J.commCellId
		FROM	JMRestoreStats  J WITH (NOLOCK) LEFT OUTER JOIN #tblJobToDelete T
		ON 	J.jobId = T.jobId
		AND	J.commCellId = T.commCellId
		WHERE	T.jobId IS NULL
		AND		J.servStartTime < @pTimeSiteReplication
		AND		J.opType in (105)
		AND		@pTimeSiteReplication >= 0
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		SET @JobsToSelect = @JobsToSelect - @rowCnt
		--Prune the selected jobs and fetch more
		IF @JobsToSelect = 0
		BEGIN
			EXEC @errVal = daDeleteJobHistory 0
			IF @errVal <> 0
				GOTO CX_EXIT_ERROR
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @maxJobsToPruneInBatch
			DELETE #tblJobToDelete
			SET @JobsToSelect = @maxJobsToPruneInBatch
		END
	END
	-- Delete rest of jobs
	SELECT @RestJobsCnt = COUNT(*) FROM #tblJobToDelete
	IF (@RestJobsCnt > 0)
	BEGIN
		EXEC @errVal = daDeleteJobHistory 0
		IF @errVal <> 0
			GOTO CX_EXIT_ERROR
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @RestJobsCnt
		DELETE #tblJobToDelete
		SET @JobsToSelect = @maxJobsToPruneInBatch
	END
	-- Prune other tables history
	-- Process for any user running DA job since these tables are history tables
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) JMJobStateHistory
		WHERE	Modified < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) JMMAPipeLineHistory
		WHERE	Modified < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	-- CommCell History Table Pruning based on MMConfigs parameter
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMLibraryHistory
		WHERE TimeStart < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMDriveHistory
		WHERE TimeStart < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMDriveStateHistory
		WHERE StateChangeTime < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMLibraryStateHistory
		WHERE StateChangeTime < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMMAStateHistory
		WHERE StateChangeTime < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMMediaStateHistory
		WHERE StateChangeTime < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) MMMountPathStateHistory
		WHERE StateChangeTime < @pDateTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	DECLARE	@timeToPruneGRCJobTrack DATETIME
	SET		@timeToPruneGRCJobTrack = DATEADD(d, -ISNULL((SELECT	TOP 1 value FROM MMConfigs WHERE name = 'DA_GRC_CONFIG_NUMBER_OF_DAYS_OF_DATA_TO_KEEP_IN_GRCJMJOBDATASTATSTRACKING'),30), GetUTCDate())
	DECLARE @lastSuccessfulDRbackupTime INTEGER
	DECLARE @minTrackingTime INTEGER
	DECLARE @timeToPruneGRCJob INTEGER
	DECLARE @minTemp INTEGER
	SET @lastSuccessfulDRbackupTime = ISNULL( (SELECT MAX(servStart) FROM JMAdminJobStatsTable with (nolock) WHERE opType = 11 AND status = 1),0)
	SET @minTrackingTime = ISNULL( (SELECT MIN(trackingTime) FROM GRC_SubclientTrackingStats with (nolock) WHERE trackingId > 0),0)
	SET @timeToPruneGRCJob = dbo.GetUnixTime(@timeToPruneGRCJobTrack)
	IF @minTrackingTime > 0
	BEGIN
		IF @lastSuccessfulDRbackupTime > 0
		BEGIN
				SET @minTemp = (SELECT CASE WHEN @lastSuccessfulDRbackupTime > @minTrackingTime THEN @minTrackingTime ELSE @lastSuccessfulDRbackupTime END)
				SET @timeToPruneGRCJob = (SELECT CASE WHEN @timeToPruneGRCJob > @minTemp THEN @timeToPruneGRCJob ELSE @minTemp END)
		END
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) GRCJMJobDataStatsTracking
			WHERE createdTime < @timeToPruneGRCJob
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal <> 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
		END
		/*
		If no successful import since last 30 days then disable trigger which create records into GRCJMJobDataStatsTracking table.
		*/
		SET @timeToPruneGRCJob = dbo.GetUnixTime(@timeToPruneGRCJobTrack)
		IF @minTrackingTime < @timeToPruneGRCJob
		BEGIN
			UPDATE MMConfigs SET value = 1 WHERE name =	'GRC_CONFIG_DISABLE_JMJOBDATASTATS_TRACKING' AND value = 0
			-- There is no point in keeping subclient tracking info if they are not being monitored for more than 30 days by GRC cell, let the next export be full.
			EXEC SQLUtilTruncateTable 'GRC_SubclientTrackingStats'
		END
	END
	DECLARE	@timeToPruneGRCForeignJobsToAgeList DATETIME
	SET		@timeToPruneGRCForeignJobsToAgeList = DATEADD(d, -ISNULL((SELECT	TOP 1 value FROM MMConfigs WHERE name = 'DA_GRC_CONFIG_NUMBER_OF_DAYS_TO_KEEP_JOB_LIST_IN_DAFOREIGNJOBSTOBEMARKEDAGED'),7), GetUTCDate())
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) DAForeignJobsToBeMarkedAged
		FROM DAForeignJobsToBeMarkedAged a left outer join JMJobDataStats b WITH (NOLOCK)
		ON a.jobId = b.jobId AND a.copyId = b.archGrpCopyId AND a.commcellId = b.commcellId AND a.dataType = b.dataType
		WHERE a.modifiedTime < dbo.GetUnixTime(@timeToPruneGRCForeignJobsToAgeList) AND
		(processed = 1 OR (processed = 0 AND b.jobId is null))
		/*
		If they are processed then delete right away if the number of days reached,
		if not processed yet and reached the number of days delete them if no corresponding entry exists in JMJobDataStats
		*/
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) IdxSIDBSubStoreStateHistory
		WHERE Time < @pTimeLibraryHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	DECLARE	@timeToPruneIdxSIDBUsageHistory DATETIME
	SET		@timeToPruneIdxSIDBUsageHistory = DATEADD(d, -ISNULL((SELECT	TOP 1 value FROM MMConfigs WHERE name = 'DA_CONFIG_NUMBER_OF_DAYS_OF_DATA_TO_KEEP_IDXSIDBUSAGEHISTORY'),30), GetUTCDate())
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) IdxSIDBUsageHistory
		WHERE ModifiedTime < dbo.GetUnixTime(@timeToPruneIdxSIDBUsageHistory) AND HistoryType = 0
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	DECLARE	@timeToPruneDayAggeIdxSIDBUsageHistory DATETIME
	SET		@timeToPruneDayAggeIdxSIDBUsageHistory = DATEADD(MONTH, -ISNULL((SELECT	TOP 1 value FROM MMConfigs WHERE name = 'DA_CONFIG_NUMBER_OF_MONTHS_OF_DATA_TO_KEEP_LONGER_IN_IDXSIDBUSAGEHISTORY'),24), GetUTCDate())
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) IdxSIDBUsageHistory
		WHERE ModifiedTime < dbo.GetUnixTime(@timeToPruneDayAggeIdxSIDBUsageHistory) AND HistoryType IN (1, 2)
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Delete dangling rows from archPipelineJobList table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) APJL
   		FROM archPipelineJobList APJL, JMBkpStats JBK WITH (NOLOCK)
		WHERE 	APJL.jobId = JBK.jobId
		AND 	APJL.commCellId = JBK.commCellId
		AND	JBK.servEndDate <= @currentTime - @daysToKeepPipelineInfo * 24 * 60 * 60
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Delete dangling rows from archPipelineJobList table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) APJL
   		FROM archPipelineJobList APJL, JMAdminJobStatsTable JAS WITH (NOLOCK)
		WHERE 	APJL.jobId = JAS.jobId
		AND 	APJL.commCellId = JAS.commCellId
    		AND	JAS.servEnd <= @currentTime - @daysToKeepPipelineInfo * 24 * 60 * 60
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	--Delete dangling rows from archPipelineJobList table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) APJL
   		FROM archPipelineJobList APJL, JMRestoreStats JRS WITH (NOLOCK)
		WHERE 	APJL.jobId = JRS.jobId
		AND 	APJL.commCellId = JRS.commCellId
    		AND	JRS.servEndTime <= @currentTime - @daysToKeepPipelineInfo * 24 * 60 * 60
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
	END
    ---------------------------------------------------------------
	--- Prune older records from RMReservationRequestHistory ------
	---------------------------------------------------------------
	IF(@HistoryDbRMResHistExists = 1)
	BEGIN
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch)
			FROM HistoryDB..RMReservationRequestHistory
			WHERE ResourceReservationEndTime < @pTimeRMReservationHistory
			AND @pTimeRMReservationHistory >= 0
		    SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		    IF @errVal <> 0
		    BEGIN
			    SET @retVal = @errVal
			    BREAK
		    END
		    IF @rowCnt = 0
			    BREAK
			ELSE
				SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
        END
	END
	 ---------------------------------------------------------------
	--- Prune RMPerformanceHistory ------
	---------------------------------------------------------------
	DECLARE @daysToKeepRMPerformanceHistory INT
	SELECT	@daysToKeepRMPerformanceHistory = ISNULL((SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'RM_CONFIG_PERFORMANCE_HISTORY_PRUNING_INTERVAL'), 7)
	DECLARE	@pDateTimeRMPerformanceHistory DATETIME
	SET		@pDateTimeRMPerformanceHistory = DATEADD(d, (-1 * @daysToKeepRMPerformanceHistory), GetUTCDate())
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch)
		FROM HistoryDB..RMPerformanceHistory
		WHERE beginTime < @pDateTimeRMPerformanceHistory
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
		ELSE
			SET @TotalJobsPruned = @TotalJobsPruned + @rowCnt
    END
	IF @retVal <> 0 GOTO CX_EXIT_ERROR
	-- Delete HistoryDB..JMJobInfoHistory
	IF OBJECT_ID('HistoryDB..JMJobInfoHistory') IS NOT NULL
	BEGIN
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) HistoryDB..JMJobInfoHistory
			WHERE 	createTime < @pTimeJobInfoHistory
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal <> 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
	END
	--
	-- Cleanup Edge Online Edit Short Urls
	--
	DECLARE	@timeToPruneShortUrl INT
	SET		@timeToPruneShortUrl = dbo.GetUnixTime(DATEADD(d, -ISNULL((SELECT	TOP 1 value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'DA_CONFIG_NUMBER_OF_DAYS_TO_KEEP_WOPI_SHORT_URLS'), 7), GetUTCDate()))
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) App_ShortUrl
		WHERE lastAccessed < @timeToPruneShortUrl AND longurl like '%editFile.do%'
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
	END
	--MMTaskCleanup
	WHILE(1 = 1)
	BEGIN
		UPDATE TOP (@maxJobsToPruneInBatch) T
SET T.Status = 2
		FROM MMTask T
			INNER JOIN MMTaskType TT ON TT.TaskType = T.TaskType
		WHERE T.RetryCount >= TT.MaxRetryCount AND TT.MaxRetryCount > 0
AND T.Status NOT IN (1, 2)
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
	END
	WHILE(1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) T
		FROM MMTask T
			INNER JOIN MMTaskType TT ON TT.TaskType = T.TaskType
WHERE T.Status IN (1, 2)
			AND ( IIF(T.LastExecutionTime > 0, @currentTime - T.LastExecutionTime, @currentTime - T.CreateTime) > 90 *24 *60*60)
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
	END
	--
	-- archSubclientCopyDDBMapHistory cleanup
	--
	WHILE(1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) T
		FROM HistoryDB..archSubclientCopyDDBMapHistory T
		WHERE T.deleteTime < @90daysTime
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
	END
	--
	-- MetallicStorageUsageHistory cleanup
	--
	WHILE(1 = 1)
	BEGIN
		DELETE TOP (@maxJobsToPruneInBatch) T
		FROM HistoryDB..MetallicStorageUsageHistory T
		WHERE T.CreateTime < @90daysTime
		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
		IF @errVal <> 0
		BEGIN
			SET @retVal = @errVal
			BREAK
		END
		IF @rowCnt = 0
			BREAK
	END
	-- Delete HistoryDB..APPVMClientHistory
	IF OBJECT_ID('HistoryDB..APPVMClientHistory') IS NOT NULL
	BEGIN
		DECLARE @PruneVMClientHistoryDays INTEGER
		DECLARE @VMClientHistorydeletionTime INTEGER
        SET     @PruneVMClientHistoryDays = 90
        --Get parameter to consider number of days to keep VM client association History
        SELECT @PruneVMClientHistoryDays = isnull(value, 90) FROM Gxglobalparam WITH (NOLOCK)   WHERE name = 'NumberOfDaysToKeepVMClientHistory'
        SET @VMClientHistorydeletionTime = dbo.GetUnixTime(GetUTCDate())  - @PruneVMClientHistoryDays * 24 * 3600
		WHILE (1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) HistoryDB..APPVMClientHistory
			WHERE 	CreateTime < @VMClientHistorydeletionTime
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal <> 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
		IF @retVal <> 0 GOTO CX_EXIT_ERROR
	END
	--
	-- BlrPairStats cleanup
	--
	IF OBJECT_ID('HistoryDB..BlrPairStats') IS NOT NULL
	BEGIN
		if object_id('tempdb.dbo.#tblPairRetentionInfo') is not null DROP TABLE #tblPairRetentionInfo
		CREATE TABLE #tblPairRetentionInfo (
			pairId 				INTEGER,
			retentionDays	INTEGER
			PRIMARY KEY (pairId)
		)
		--Override default with global value if defined
		SELECT TOP 1 @daysToKeepBLRPairStats = CAST(value AS INT) FROM GxGlobalParam WITH (NOLOCK) WHERE name = 'nDaysToKeepBLRPairStatsHistory' AND modified = 0 AND CAST(value AS INT) > 0
		INSERT INTO #tblPairRetentionInfo
		SELECT DISTINCT pairId, @daysToKeepBLRPairStats
		FROM HistoryDB..BlrPairStats
		IF @@ERROR <> 0 GOTO CX_EXIT_ERROR
		UPDATE T
		SET retentionDays = CAST(P.propertyValue AS INT)
		FROM #tblPairRetentionInfo T, BlrPairProperties P WITH (NOLOCK)
		WHERE T.pairId = P.pairId
		AND		P.propertyName = 'STATS_RETENTION'
		IF @@ERROR <> 0 GOTO CX_EXIT_ERROR
		WHILE(1 = 1)
		BEGIN
			DELETE TOP (@maxJobsToPruneInBatch) P
			FROM HistoryDB..BlrPairStats P, #tblPairRetentionInfo T
			WHERE P.pairId = T.pairId
			AND		P.timeStamp < (@currentTime - T.retentionDays * 24 * 60 * 60)
			SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
			IF @errVal <> 0
			BEGIN
				SET @retVal = @errVal
				BREAK
			END
			IF @rowCnt = 0
				BREAK
		END
	END
	SELECT @TotalJobsPruned
	RETURN
CX_EXIT_ERROR:
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daJobHistoryDelete')
	delete from GxQscripts where name = 'daJobHistoryDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daJobHistoryDelete')
	delete from GXDBVersions where aliasname = 'daJobHistoryDelete'
GO

insert into GXDBVersions values(2, 'daJobHistoryDelete',  'v1.52.2.22.12.1', 'daJobHistoryDelete', 'v1.52.2.22.12.1')
GO

