

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daGetStoragePolicyForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Bhavyan Mehta
--	Date:   07/20/2009
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daGetStoragePolicyForUser.sp,v $ $Id: daGetStoragePolicyForUser.sp,v 1.5.40.8 2018/03/30 00:40:27 mdilshad Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daGetStoragePolicyForUser <<<'

IF EXISTS (select * from sysobjects where name='daGetStoragePolicyForUser')
	drop procedure daGetStoragePolicyForUser
IF EXISTS (select * from GxQscripts where name='daGetStoragePolicyForUser')
	delete from GxQscripts where name = 'daGetStoragePolicyForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetStoragePolicyForUser')
	delete from GXDBVersions where aliasname = 'daGetStoragePolicyForUser'
GO
print '... Creating Procedure: daGetStoragePolicyForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daGetStoragePolicyForUser
  @i_userId integer,
  @i_fetchOnlyCIEnabled int = 0,
  @i_capability int = 4,
  @i_filter int = 0,
  @getAllSchedules INT = 0
AS
  DECLARE @i_archGroupId integer;
BEGIN
	DECLARE @userObjects	TABLE(	commCellId	integer,
						clientId	integer,
						appTypeId	integer,
						instanceId	integer,
						backupsetId	integer,
						subClientId	integer,
						archGroupId	integer )
	IF object_id('tempdb.dbo.#daGetStoragePolicyForUser_UserObjects') is not null DROP TABLE #daGetStoragePolicyForUser_UserObjects
create table  #daGetStoragePolicyForUser_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 2231, 0, '#daGetStoragePolicyForUser_UserObjects'
	INSERT INTO @userObjects
	SELECT 	DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId, archGroupId
	FROM	#daGetStoragePolicyForUser_UserObjects
	WHERE   @i_capability = 0 OR (capabilities & POWER(2, @i_capability-1)) > 0
	DROP TABLE #daGetStoragePolicyForUser_UserObjects
	SELECT DISTINCT AG.id AS archGroupId, AG.name AS archGroupName, e.retentionDays, e.fullCycles as cycles
	FROM archGroup AG
		INNER JOIN @userObjects AS UO
		ON AG.id = UO.archGroupId OR ( UO.archGroupId = 0 AND UO.commCellId <> 0 )
		LEFT JOIN archAgingRule E WITH(NOLOCK) ON AG.defaultCopy = E.copyId
	WHERE   -- exclude default storage policy
            AG.id > 1
			AND ((@getAllSchedules = 1) OR
            -- exclude various service storage policies
(AG.flags & (33554432 | 256 | 16384 | 8388608) = 0)
            -- exclude plan's storage policies
AND (((@i_filter & 0x1) = 0) OR (CAST(AG.id AS VARCHAR(32)) NOT IN (SELECT attrVal FROM APP_PlanProp WHERE attrName IN ('Storage policy', 'Log storage policy'))))
            -- other filters
AND ((@i_fetchOnlyCIEnabled = 0 AND AG.type = 1) OR (@i_fetchOnlyCIEnabled = 1 AND AG.id in (select R.ArchGroupId from archContentIndexingRules R where R.enabled = 1))))
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'daGetStoragePolicyForUser')
	delete from GxQscripts where name = 'daGetStoragePolicyForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetStoragePolicyForUser')
	delete from GXDBVersions where aliasname = 'daGetStoragePolicyForUser'
GO

insert into GXDBVersions values(2, 'daGetStoragePolicyForUser',  '00010005004000080000', 'daGetStoragePolicyForUser', '00010005004000080000')
GO

