

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daGetSQLDiffChainData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daGetSQLDiffChainData.sp,v $ $Id: daGetSQLDiffChainData.sp,v 1.1.2.1 2020/06/30 10:18:13 hkapadia Exp $";
--  +==================================================================================+
--  | Stored Proc:  daGetSQLDiffChainData()
--  |
--  | Description:  Get the list of JobIds that are required by differential jobs.
--  +==================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daGetSQLDiffChainData')
BEGIN
	print '>>> Drop Stored Procedure: daGetSQLDiffChainData <<<'
	drop procedure daGetSQLDiffChainData
END
IF EXISTS (select * from GxQscripts where name='daGetSQLDiffChainData')
	delete from GxQscripts where name = 'daGetSQLDiffChainData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetSQLDiffChainData')
	delete from GXDBVersions where aliasname = 'daGetSQLDiffChainData'
GO
print '... Creating Procedure: daGetSQLDiffChainData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daGetSQLDiffChainData
  @dummy INTEGER
AS
  DECLARE @o_diffJobId INTEGER;
  DECLARE @o_FullJobId INTEGER;
  DECLARE @o_commCellId INTEGER;
BEGIN TRY
	SET NOCOUNT ON
	if object_id('tempdb.dbo.#tblInstanceInfo') is not null DROP TABLE #tblInstanceInfo
	if object_id('tempdb.dbo.#tblDiffJobs') is not null DROP TABLE #tblDiffJobs
	if object_id('tempdb.dbo.#tblFullJobs') is not null DROP TABLE #tblFullJobs
	CREATE	TABLE #tblInstanceInfo (
			instanceId		INTEGER,
			isSQLAlwaysOn	INTEGER
			)
	CREATE CLUSTERED INDEX Idx_tblInstanceInfo_1 ON #tblInstanceInfo (instanceId)
	CREATE	TABLE #tblDiffJobs (
			instanceId		INTEGER,
			dbId					INTEGER,
			jobId 				INTEGER,
			commCellId 		INTEGER,
			fullBkpLSN 		NUMERIC(25, 0)
			)
	CREATE INDEX Idx_tblDiffJobs_1 ON #tblDiffJobs (instanceId, dbId, jobId, commCellId)
	CREATE CLUSTERED INDEX Idx_tblDiffJobs_2 ON #tblDiffJobs (instanceId, dbId, fullBkpLSN)
	CREATE	TABLE #tblFullJobs (
			instanceId		INTEGER,
			dbId					INTEGER,
			jobId 				INTEGER,
			commCellId 		INTEGER,
			checkPointLSN NUMERIC(25, 0)
			)
	CREATE INDEX Idx_tblFullJobs_1 ON #tblFullJobs (instanceId, dbId, jobId, commCellId)
	CREATE CLUSTERED INDEX Idx_tblFullJobs_2 ON #tblFullJobs (instanceId, dbId, checkPointLSN)
	-------------------------------------------------------------------------------
	--------------------- Get Full - Diff dependent jobs --------------------------
	-------------------------------------------------------------------------------
		--Get Instance info
		INSERT INTO #tblInstanceInfo
		SELECT DISTINCT instanceId, 0
		FROM #DA_AppCopyList
WHERE appFlags & 32 = 32
		IF @@ROWCOUNT	= 0 GOTO CX_EXIT
		UPDATE #tblInstanceInfo
		SET isSQLAlwaysOn = 1
		FROM #tblInstanceInfo T, APP_Application A WITH (NOLOCK), APP_Client C WITH (NOLOCK)
		WHERE T.instanceId = A.Instance
		AND		A.ClientId = C.Id
AND		C.status & 0x20000000 = 0x20000000
		-- Get all differential jobIds
		INSERT INTO #tblDiffJobs
		SELECT SBI.instanceId, (CASE WHEN I.isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END), SAI.backupJobId, SAI.commcellId, CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0))
		FROM 	#tblInstanceInfo I, sqlDBBackupInfo SBI WITH (NOLOCK), sqlArchiveInfo SAI WITH (NOLOCK)
		WHERE I.instanceId = SBI.instanceId
		AND 	SBI.id = SAI.sqldbBackupFileId
		AND		SBI.type = 'I'
		GROUP BY SBI.instanceId, (CASE WHEN I.isSQLAlwaysOn = 0 THEN SBI.dbId ELSE SBI.sqlNameId END), SAI.backupJobId, SAI.commcellId, CAST(SBI.full_bkup_lsn AS NUMERIC(25, 0))
		-- Get all Full jobIds
		INSERT INTO #tblFullJobs
		SELECT SBI.instanceId, T.dbId, SAI.backupJobId, SAI.commcellId, CAST(SBI.checkpoint_lsn AS NUMERIC(25, 0))
		FROM 	#tblInstanceInfo I, #tblDiffJobs T, sqlDBBackupInfo SBI WITH (NOLOCK), sqlArchiveInfo SAI WITH (NOLOCK)
		WHERE I.instanceId = T.instanceId
		AND		T.instanceId = SBI.instanceId
		AND		( (I.isSQLAlwaysOn = 0 AND	T.dbId = SBI.dbId)
						OR
						(I.isSQLAlwaysOn = 1 AND	T.dbId = SBI.sqlNameId)
					)
		AND		T.fullBkpLSN = CAST(SBI.checkpoint_lsn AS NUMERIC(25, 0))
		AND		SBI.type = 'D'
		AND 	SBI.id = SAI.sqldbBackupFileId
		GROUP BY SBI.instanceId, T.dbId, SAI.backupJobId, SAI.commcellId, CAST(SBI.checkpoint_lsn AS NUMERIC(25, 0))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	THROW
END CATCH
CX_EXIT:
	-- Get all dependent job mapping
	IF object_id('tempdb.dbo.#tblChildJobs') is not null
	BEGIN
		INSERT	INTO #tblChildJobs
		SELECT	DISTINCT D.jobId, F.jobId, D.commCellId
		FROM		#tblDiffJobs D, #tblFullJobs F
		WHERE		D.instanceId = F.instanceId
		AND			D.dbId = F.dbId
		AND			D.fullBkpLSN = F.checkPointLSN
	END
	ELSE
	BEGIN
		SELECT	DISTINCT D.jobId, F.jobId, D.commCellId
		FROM		#tblDiffJobs D, #tblFullJobs F
		WHERE		D.instanceId = F.instanceId
		AND			D.dbId = F.dbId
		AND			D.fullBkpLSN = F.checkPointLSN
	END
	if object_id('tempdb.dbo.#tblInstanceInfo') is not null DROP TABLE #tblInstanceInfo
	if object_id('tempdb.dbo.#tblDiffJobs') is not null DROP TABLE #tblDiffJobs
	if object_id('tempdb.dbo.#tblFullJobs') is not null DROP TABLE #tblFullJobs
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daGetSQLDiffChainData')
	delete from GxQscripts where name = 'daGetSQLDiffChainData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetSQLDiffChainData')
	delete from GXDBVersions where aliasname = 'daGetSQLDiffChainData'
GO

insert into GXDBVersions values(2, 'daGetSQLDiffChainData',  '00010001000200010000', 'daGetSQLDiffChainData', '00010001000200010000')
GO

