

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daGetGranularSelection.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daGetGranularSelection.sp,v $ $Id: daGetGranularSelection.sp,v 1.19.42.7 2020/05/10 01:15:55 pveeravalli Exp $";
--  +========================================================================+
--  | Stored Proc:  daGetGranularSelection()
--  |
--  | Description:  Get the parameters selected for DataAging
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daGetGranularSelection')
BEGIN
	print '>>> Drop Stored Procedure: daGetGranularSelection <<<'
	drop procedure daGetGranularSelection
END
IF EXISTS (select * from GxQscripts where name='daGetGranularSelection')
	delete from GxQscripts where name = 'daGetGranularSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetGranularSelection')
	delete from GXDBVersions where aliasname = 'daGetGranularSelection'
GO
print '... Creating Procedure: daGetGranularSelection'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daGetGranularSelection
  @DAJobId INTEGER
AS
  DECLARE @o_item INTEGER;
  DECLARE @o_itemSelected INTEGER;
SET NOCOUNT ON
	DECLARE 	@LIBRARY_ITEM	INTEGER
	SET				@LIBRARY_ITEM	=	2049
	DECLARE		@ARCHIVE_GROUP_ITEM	INTEGER
	SET				@ARCHIVE_GROUP_ITEM	= 2231
	DECLARE 	@ARCHIVE_GROUP_COPY_ITEM	INTEGER
	SET				@ARCHIVE_GROUP_COPY_ITEM	=	8015
	DECLARE 	@CLIENT_ITEM		INTEGER
	SET				@CLIENT_ITEM	=	2009
	DECLARE		@SUB_CLIENT_ITEM	INTEGER
	SET				@SUB_CLIENT_ITEM	= 2013
	DECLARE		@SELECT_COPIES_ID	INTEGER
SET				@SELECT_COPIES_ID	= 1655288559
	DECLARE		@PRUNE_SP_BASED_ID	INTEGER
SET				@PRUNE_SP_BASED_ID	= 32767178
	DECLARE		@INCLUDE_ALL_CLIENTS_ID	INTEGER
SET				@INCLUDE_ALL_CLIENTS_ID	= 1682383091
	DECLARE		@IS_GRANULAR_ID		INTEGER
SET				@IS_GRANULAR_ID		= 1157719732
	DECLARE		@selectCopies		INTEGER
	SET				@selectCopies		= 0
	DECLARE		@pruneSPBased	INTEGER
	SET				@pruneSPBased	= 0
	DECLARE		@includeAllClients INTEGER
	SET				@includeAllClients = 1
	DECLARE		@includeAll	INTEGER
	SET				@includeAll	= 0
	DECLARE 	@isGranularAging	INTEGER
	SET				@isGranularAging	=	0
	DECLARE 	@userId		INTEGER
	SET				@userId		=	0
	DECLARE 	@retVal		INTEGER
	SET 			@retVal 	= 0
	-- Declare table variables
	DECLARE @validLibraryList TABLE(libraryId INTEGER)
	DECLARE @validClientList TABLE(clientId INTEGER)
	DECLARE @validSubClientList TABLE(appId INTEGER)
	DECLARE	@validSPList TABLE(archGrpId INTEGER)
	DECLARE	@validSPCopyList TABLE (archGrpCopyId INTEGER)
	DECLARE @xmlText XML;
	DECLARE @handle INT;
	SET @xmlText = (SELECT dbo.GetXMLJobOptions(@DAJobId))
	EXEC sp_xml_preparedocument @handle OUTPUT, @xmlText
	--Get the User who kicked off the DataAging job
	SELECT @userId = ISNULL(CONVERT(INT, value), 0)
	FROM dbo.GetAllJobOptions(@DAJobId)
where optionId = 140019
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_ERROR_EXIT
	-- Check if granular aging is selected
	SELECT @isGranularAging = ISNULL(CONVERT(INT, value), 0)
	FROM dbo.GetAllJobOptions(@DAJobId)
	WHERE optionId = @IS_GRANULAR_ID
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_ERROR_EXIT
	-- Get the entities on which user has permissions
	-- If 0 - then user has rights on all for that nodeType
	-- Get the list of SPs on which the user has SP Management Capabilities
	INSERT INTO @validSPList
EXEC daGetEntityForUser @userId, @ARCHIVE_GROUP_ITEM, 4
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_ERROR_EXIT
	-- Get the list of SP/Copies on which the user has SP Management Capabilities
	IF EXISTS (SELECT archGrpId FROM @validSPList WHERE archGrpId = 0)
	BEGIN
		INSERT INTO @validSPCopyList
		SELECT 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		INSERT INTO @validSPCopyList
		SELECT AGC.id
		FROm archGroupCopy AGC WITH (NOLOCK), @validSPList T
		WHERE AGC.archGroupId = T.archGrpId
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
	-- Get the list of Libraries on which the user has Library Management Capabilities
	INSERT INTO @validLibraryList
EXEC daGetEntityForUser @userId, @LIBRARY_ITEM, 8
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_ERROR_EXIT
	-- Get the list of Sub-Clients on which the user has Agent Management Capabilities
	INSERT INTO @validSubClientList
EXEC daGetEntityForUser @userId, @SUB_CLIENT_ITEM, 2
	SELECT	@retVal = @@ERROR
	IF (@retVal != 0) GOTO CX_ERROR_EXIT
	-- Get the list of Clients using Sub-Clients on which the user has Agent Management Capabilities
	IF EXISTS (SELECT appId FROM @validSubClientList WHERE appId = 0)
	BEGIN
		INSERT INTO @validClientList
		SELECT 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		INSERT INTO @validClientList
		SELECT DISTINCT APP.clientId
		FROM 	App_Application APP WITH (NOLOCK), @validSubClientList SC
		WHERE APP.id = SC.appId
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
	-- If granular aging, then read individual options
	IF(@isGranularAging != 0)
	BEGIN
		SELECT @selectCopies = ISNULL(CONVERT(INT, value), 0)
		FROM dbo.GetAllJobOptions(@DAJobId)
		WHERE optionId = @SELECT_COPIES_ID
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		SELECT @pruneSPBased = ISNULL(CONVERT(INT, value), 0)
		FROM dbo.GetAllJobOptions(@DAJobId)
		WHERE optionId = @PRUNE_SP_BASED_ID
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		SET @includeAll = ISNULL((SELECT includeAll FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption', 1) WITH (includeAll int)), 0)
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		SELECT @includeAllClients = ISNULL(CONVERT(INT, value), 0)
		FROM dbo.GetAllJobOptions(@DAJobId)
		WHERE optionId = @INCLUDE_ALL_CLIENTS_ID
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		-- If All Clients not selected, then only keep selected clients
		IF(@includeAllClients = 0)
		BEGIN
			IF EXISTS (SELECT clientId FROM @validClientList WHERE clientId = 0)
			BEGIN
				--User has Agent Management Capabilities on ALL Clients / All SubClients
				--Keep only selected clients/subclients for granular pruning
				DELETE @validClientList
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
				INSERT INTO @validClientList
				SELECT DISTINCT clientId
				FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/client', 1) WITH (clientId int)
				WHERE clientId IS NOT NULL
				UNION
				SELECT DISTINCT CGA.clientId
				FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/clientGroup', 1) WITH (clientGroupId int) AS TMP, APP_ClientGroupAssoc AS CGA WITH (NOLOCK)
				WHERE TMP.clientGroupId = CGA.clientGroupId
				AND	  TMP.clientGroupId IS NOT NULL
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
				DELETE @validSubClientList
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
				INSERT INTO @validSubClientList
				SELECT DISTINCT APP.id
				FROM @validClientList T, APP_Application APP WITH (NOLOCK)
				WHERE T.clientId = APP.clientId
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
			END
			ELSE
			BEGIN
				--User has Agent Management Capabilities on specific Clients / SubClients
				--Keep only selected clients/subclients for granular pruning
				DELETE @validClientList
				WHERE clientId NOT IN (
																SELECT DISTINCT clientId
																FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/client', 1) WITH (clientId int)
																WHERE clientId IS NOT NULL
																UNION
																SELECT DISTINCT CGA.clientId
																FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/clientGroup', 1) WITH (clientGroupId int) AS TMP, APP_ClientGroupAssoc AS CGA WITH (NOLOCK)
																WHERE TMP.clientGroupId = CGA.clientGroupId
																AND	  TMP.clientGroupId IS NOT NULL
															)
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
				DELETE @validSubClientList
				FROM @validSubClientList T, APP_Application APP WITH (NOLOCK)
				WHERE T.appId = APP.Id
				AND		APP.clientId NOT IN (SELECT clientId FROM @validClientList)
				SELECT	@retVal = @@ERROR
				IF (@retVal != 0) GOTO CX_ERROR_EXIT
			END
		END
		--If "Select Copies" option is ON
		IF(@selectCopies != 0)
		BEGIN
			-- If "Prune Copies Using Selected Libraries" option is selected
			IF(@pruneSPBased = 0)
			BEGIN
				-- IF selected Libraries only
				IF(@includeAll = 0)
				BEGIN
					IF EXISTS (SELECT libraryId FROM @validLibraryList WHERE libraryId = 0)
					BEGIN
						--User has Library Management Capabilities on ALL Libraries
						--Keep only selected Libraries for granular pruning
						DELETE @validLibraryList
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
						INSERT INTO @validLibraryList
						SELECT libraryId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/library', 1) WITH (libraryId int)
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
					END
					ELSE
					BEGIN
						--User has Agent Management Capabilities on specific Clients / SubClients
						--Keep only selected clients/subclients for granular pruning
						DELETE @validLibraryList
						WHERE libraryId NOT IN (SELECT libraryId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/library', 1) WITH (libraryId int))
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
					END
				END
			END
			ELSE
			BEGIN
				-- If "Prune Selected Copies" option is selected
				-- IF selected SP/Copies only
				IF(@includeAll = 0)
				BEGIN
					IF EXISTS (SELECT archGrpCopyId FROM @validSPCopyList WHERE archGrpCopyId = 0)
					BEGIN
						--User has SP Management Capabilities on ALL SP/Copies
						--Keep only selected SP/Copies for granular pruning
						DELETE @validSPCopyList
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
						INSERT INTO @validSPCopyList
						SELECT copyId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/archiveGroupCopy', 1) WITH (copyId int)
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
						--Get SP/Copies associated to selected GDSP
						INSERT INTO @validSPCopyList
						SELECT DISTINCT C2G.copyId
						FROM	archGroupCopy AGC WITH (READUNCOMMITTED),archCopyToGlobalPolicy C2G WITH (READUNCOMMITTED), @validSPCopyList T
						WHERE	AGC.id = T.archGrpCopyId
						AND		C2G.globalPolicyId = AGC.archGroupId
						AND 	NOT EXISTS (SELECT archGrpCopyId FROM @validSPCopyList WHERE archGrpCopyId = AGC.id)
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
					END
					ELSE
					BEGIN
						--User has SP Management Capabilities on specific SP/Copies
						--Keep only selected SP/Copies for granular pruning
						--Keep SP/Copies associated to selected GDSP
						--Keep SP/Copies associated to selected GACP
						DELETE @validSPCopyList
						WHERE archGrpCopyId NOT IN (SELECT copyId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/archiveGroupCopy', 1) WITH (copyId int))
						AND archGrpCopyId NOT IN (
													SELECT DISTINCT C2G.copyId
													FROM	archGroupCopy AGC WITH (NOLOCK),archCopyToGlobalPolicy C2G WITH (READUNCOMMITTED), (SELECT copyId FROM OPENXML (@handle, 'TMMsg_JobOption/adminOpts/dataAgingOption/archiveGroupCopy', 1) WITH (copyId int)) T
													WHERE	AGC.id = T.copyId
													AND 	C2G.globalPolicyId = AGC.archGroupId
												)
						SELECT	@retVal = @@ERROR
						IF (@retVal != 0) GOTO CX_ERROR_EXIT
					END
				END
			END
		END
	END
	--Keep SP/Copies associated to selected libraries
	IF NOT EXISTS (SELECT libraryId FROM @validLibraryList WHERE libraryId = 0)
	BEGIN
		IF EXISTS (SELECT archGrpCopyId FROM @validSPCopyList WHERE archGrpCopyId = 0)
		BEGIN
			DELETE @validSPCopyList
			SELECT	@retVal = @@ERROR
			IF (@retVal != 0) GOTO CX_ERROR_EXIT
			INSERT INTO @validSPCopyList
			SELECT DISTINCT DPATH.CopyId
			FROM MMMasterPool MP WITH (NOLOCK), MMDrivePool MDP WITH (NOLOCK),
			MMDataPath DPATH WITH (NOLOCK), @validLibraryList T
			WHERE T.LibraryId = MP.LibraryId
			AND 	MP.masterpoolId = MDP.masterpoolId
			AND 	MDP.DrivePoolId = DPATH.DrivePoolId
			SELECT	@retVal = @@ERROR
			IF (@retVal != 0) GOTO CX_ERROR_EXIT
		END
		ELSE
		BEGIN
			DELETE @validSPCopyList
			WHERE archGrpCopyId NOT IN (
																		SELECT DISTINCT DPATH.CopyId
																		FROM MMMasterPool MP WITH (NOLOCK), MMDrivePool MDP WITH (NOLOCK),
																		MMDataPath DPATH WITH (NOLOCK), @validLibraryList T
																		WHERE T.LibraryId = MP.LibraryId
																		AND 	MP.masterpoolId = MDP.masterpoolId
																		AND 	MDP.DrivePoolId = DPATH.DrivePoolId
																	)
			SELECT	@retVal = @@ERROR
			IF (@retVal != 0) GOTO CX_ERROR_EXIT
		END
	END
	--Populate SP list using copies selected
	IF EXISTS (SELECT archGrpCopyId FROM @validSPCopyList WHERE archGrpCopyId = 0)
	BEGIN
		DELETE @validSPList
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		INSERT INTO @validSPList
		SELECT 0
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
	ELSE
	BEGIN
		DELETE @validSPList
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
		INSERT INTO @validSPList
		SELECT DISTINCT AGC.archGroupId
		FROM archGroupCopy AGC WITH (NOLOCK), @validSPCopyList T
		WHERE AGC.id = T.archGrpCopyId
		SELECT	@retVal = @@ERROR
		IF (@retVal != 0) GOTO CX_ERROR_EXIT
	END
CX_EXIT:
	EXEC sp_xml_removedocument @handle
	--Populate data in temp table if caller has created it.
	--To support call from another DataAging stored procedure
	IF object_id('tempdb.dbo.#tblEntityInfo') IS NOT null
	BEGIN
		DELETE #tblEntityInfo
		INSERT INTO #tblEntityInfo (EntityTypeId, EntityId)
		SELECT DISTINCT @LIBRARY_ITEM AS type, libraryId AS data FROM @validLibraryList
		UNION
		SELECT DISTINCT @ARCHIVE_GROUP_ITEM AS type, archGrpId AS data FROM @validSPList
		UNION
		SELECT DISTINCT @ARCHIVE_GROUP_COPY_ITEM AS type, archGrpCopyId AS data FROM @validSpCopyList
		UNION
		SELECT DISTINCT @CLIENT_ITEM AS type, clientId AS data FROM @validClientList
		UNION
		SELECT DISTINCT @SUB_CLIENT_ITEM	AS type, appId	AS data FROM @validSubClientList
	END
	ELSE
	BEGIN
		SELECT DISTINCT @LIBRARY_ITEM AS type, libraryId AS data FROM @validLibraryList
		UNION
		SELECT DISTINCT @ARCHIVE_GROUP_ITEM AS type, archGrpId AS data FROM @validSPList
		UNION
		SELECT DISTINCT @ARCHIVE_GROUP_COPY_ITEM AS type, archGrpCopyId AS data FROM @validSpCopyList
		UNION
		SELECT DISTINCT @CLIENT_ITEM AS type, clientId AS data FROM @validClientList
		UNION
		SELECT DISTINCT @SUB_CLIENT_ITEM	AS type, appId	AS data FROM @validSubClientList
	END
	RETURN 0
CX_ERROR_EXIT:
	EXEC sp_xml_removedocument @handle
	SELECT -1, -1
	RETURN -1
-- END of stored procedure
GO

IF EXISTS (select * from GxQscripts where name = 'daGetGranularSelection')
	delete from GxQscripts where name = 'daGetGranularSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetGranularSelection')
	delete from GXDBVersions where aliasname = 'daGetGranularSelection'
GO

insert into GXDBVersions values(2, 'daGetGranularSelection',  '00010019004200070000', 'daGetGranularSelection', '00010019004200070000')
GO

