

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daGetExtendedJobsAppCopyList.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daGetExtendedJobsAppCopyList.sp,v $ $Id: daGetExtendedJobsAppCopyList.sp,v 1.3.304.1 2018/03/20 20:03:53 jiechen Exp $";
--  +==================================================================================+
--  | Stored Proc:  daGetExtendedJobsAppCopyList()
--  |
--  | Description:  Get the list of AppId Copy for the selected extended retained jobs
--  +==================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daGetExtendedJobsAppCopyList <<<'

IF EXISTS (select * from sysobjects where name='daGetExtendedJobsAppCopyList')
	drop procedure daGetExtendedJobsAppCopyList
IF EXISTS (select * from GxQscripts where name='daGetExtendedJobsAppCopyList')
	delete from GxQscripts where name = 'daGetExtendedJobsAppCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetExtendedJobsAppCopyList')
	delete from GXDBVersions where aliasname = 'daGetExtendedJobsAppCopyList'
GO
print '... Creating Procedure: daGetExtendedJobsAppCopyList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daGetExtendedJobsAppCopyList
  @dummy INTEGER
AS
  DECLARE @o_appId INTEGER;
  DECLARE @o_copyId INTEGER;
  DECLARE @o_archGrpId INTEGER;
  DECLARE @o_fullArchGrpId INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @tblAppCopyList TABLE (
			appId int,
			copyId int,
			archGrpId int,
			fullArchGrpId int
			)
	INSERT INTO @tblAppCopyList
	SELECT DISTINCT a.appId, a.copyId, a.archGrpId, a.fullArchGrpId
FROM ArchAppCopyToBeAged a, ArchJobCopyExtended b
	WHERE a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND 	a.extendedRetention = 1
	AND		a.AgeStatus = 0
	AND		a.DoNotAge = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @errorCode != 0
	BEGIN
		SELECT	-1, -1, -1, -1
	END
	ELSE
	BEGIN
		SELECT	a.appId, a.copyId, a.archGrpId, a.fullArchGrpId
		FROM 		@tblAppCopyList a
		ORDER BY a.copyId, a.appId
	END
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daGetExtendedJobsAppCopyList')
	delete from GxQscripts where name = 'daGetExtendedJobsAppCopyList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetExtendedJobsAppCopyList')
	delete from GXDBVersions where aliasname = 'daGetExtendedJobsAppCopyList'
GO

insert into GXDBVersions values(2, 'daGetExtendedJobsAppCopyList',  '00010003030400010000', 'daGetExtendedJobsAppCopyList', '00010003030400010000')
GO

