

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daGetEntityForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Bhavyan Mehta
--	Date:   07/20/2009
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daGetEntityForUser.sp,v $ $Id: daGetEntityForUser.sp,v 1.2.70.4 2018/03/20 19:51:52 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daGetEntityForUser <<<'

IF EXISTS (select * from sysobjects where name='daGetEntityForUser')
	drop procedure daGetEntityForUser
IF EXISTS (select * from GxQscripts where name='daGetEntityForUser')
	delete from GxQscripts where name = 'daGetEntityForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetEntityForUser')
	delete from GXDBVersions where aliasname = 'daGetEntityForUser'
GO
print '... Creating Procedure: daGetEntityForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daGetEntityForUser
  @i_userId integer,
  @i_nodeType integer,
  @i_capability integer
AS
  DECLARE @i_EntityId integer;
DECLARE @hasCapabilityOnAllEntity INTEGER
SET			@hasCapabilityOnAllEntity = 0
DECLARE @capabilityList VARCHAR(MAX)
SET 		@capabilityList = CAST(1 AS VARCHAR(20)) + ', ' + CAST(@i_capability AS VARCHAR(20))
BEGIN
	IF object_id('tempdb.dbo.#daGetEntityForUser_UserObjects') is not null DROP TABLE #daGetEntityForUser_UserObjects
create table  #daGetEntityForUser_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, @i_nodeType, 0, '#daGetEntityForUser_UserObjects'
	-- LIBRARY_ITEM
	IF (@i_nodeType = 2049)
	BEGIN
		--Check whether user has capabilities on all libraries
EXEC sec_checkPermissionOnEntity @i_userId, @capabilityList, @hasCapabilityOnAllEntity OUTPUT, 9, 0
		IF  (@hasCapabilityOnAllEntity != 0
				 OR EXISTS (SELECT DISTINCT LibraryId
										FROM #daGetEntityForUser_UserObjects sec
										WHERE
										(
(sec.capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
											AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									 )
				)
		BEGIN
			--User has Library Management Capabilities on all libraries
			SELECT 0
		END
		ELSE
		BEGIN
			--User has Library Management Capabilities on specific libraries
			SELECT DISTINCT LibraryId
			FROM	#daGetEntityForUser_UserObjects
WHERE (capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
			AND LibraryId > 0
		END
	END
	-- CLIENT_ITEM
	ELSE IF (@i_nodeType = 2009)
	BEGIN
		--Check whether user has capabilities on all clients
EXEC sec_checkPermissionOnEntity @i_userId, @capabilityList, @hasCapabilityOnAllEntity OUTPUT, 3, 0
		IF  (@hasCapabilityOnAllEntity != 0
				 OR EXISTS (SELECT DISTINCT clientId
										FROM #daGetEntityForUser_UserObjects sec
										WHERE
										(
(sec.capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
											AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									 )
				)
		BEGIN
			--User has Agent Management Capabilities on all Clients
			SELECT 0
		END
		ELSE
		BEGIN
			--User has Agent Management Capabilities on specific Clients
			SELECT DISTINCT clientId
			FROM	#daGetEntityForUser_UserObjects
WHERE (capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
			AND clientId > 0
		END
	END
	-- SUB_CLIENT_ITEM
	ELSE IF (@i_nodeType = 2013)
	BEGIN
		--Check whether user has capabilities on all clients
		--If yes then it is applicable to all subclients
EXEC sec_checkPermissionOnEntity @i_userId, @capabilityList, @hasCapabilityOnAllEntity OUTPUT, 3, 0
		IF  (@hasCapabilityOnAllEntity != 0
				 OR EXISTS (SELECT DISTINCT subClientId
										FROM #daGetEntityForUser_UserObjects sec
										WHERE
										(
(sec.capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
											AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									 )
				)
		BEGIN
			--User has Agent Management Capabilities on all Subclients
			SELECT 0
		END
		ELSE
		BEGIN
			--User has Agent Management Capabilities on specific Subclients
			SELECT DISTINCT APP.id
			FROM	App_Application APP WITH (NOLOCK), #daGetEntityForUser_UserObjects sec
			WHERE
			(
(sec.capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
			)
			AND
			(
				sec.clientId = APP.clientId		--RIGHTS AT CLIENT LEVEL AND BELOW
				AND
				(
					sec.appTypeId = 0 OR sec.appTypeId = APP.appTypeId	--RIGHTS AT AGENT LEVEL AND BELOW
				)
				AND
				(
					sec.instanceId = 0 OR sec.instanceId = APP.instance	--RIGHTS AT INSTANCE LEVEL AND BELOW
				)
				AND
				(
					sec.backupSetId = 0 OR sec.backupSetId = APP.backupSet	--RIGHTS AT BACKUPSET LEVEL AND BELOW
				)
				AND
				(
					sec.subClientId = 0 OR sec.subClientId = APP.id	--RIGHTS AT SUBCLIENT LEVEL
				)
			)
		END
	END
	-- ARCHIVE_GROUP_ITEM
	ELSE IF (@i_nodeType = 2231)
	BEGIN
		--Check whether user has capabilities on all SPs
EXEC sec_checkPermissionOnEntity @i_userId, @capabilityList, @hasCapabilityOnAllEntity OUTPUT, 17, 0
		IF  (@hasCapabilityOnAllEntity != 0
				 OR EXISTS (SELECT DISTINCT archGroupId
										FROM #daGetEntityForUser_UserObjects sec
										WHERE
										(
(sec.capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
											AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
										)
									 )
				)
		BEGIN
			--User has SP Management Capabilities on all SPs
			SELECT 0
		END
		ELSE
		BEGIN
			--User has SP Management Capabilities on specific SPs
			SELECT DISTINCT archGroupId
			FROM	#daGetEntityForUser_UserObjects
WHERE (capabilities & (POWER(2, @i_capability - 1) | POWER(2, 1 - 1)) > 0)
			AND archGroupId > 0
		END
	END
	ELSE
	-- UNKNOWN_ITEM
	BEGIN
		SELECT -1
	END
	DROP TABLE #daGetEntityForUser_UserObjects
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'daGetEntityForUser')
	delete from GxQscripts where name = 'daGetEntityForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daGetEntityForUser')
	delete from GXDBVersions where aliasname = 'daGetEntityForUser'
GO

insert into GXDBVersions values(2, 'daGetEntityForUser',  '00010002007000040000', 'daGetEntityForUser', '00010002007000040000')
GO

