

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daExtRetInit.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daExtRetInit()
--  | Description:  Reset subclient referent time to start next job full
--	|				for selected appType.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daExtRetInit.sp,v $ $Id: daExtRetInit.sp,v 1.4.278.1 2018/03/20 19:53:08 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daExtRetInit <<<'

IF EXISTS (select * from sysobjects where name='daExtRetInit')
	drop procedure daExtRetInit
IF EXISTS (select * from GxQscripts where name='daExtRetInit')
	delete from GxQscripts where name = 'daExtRetInit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daExtRetInit')
	delete from GXDBVersions where aliasname = 'daExtRetInit'
GO
print '... Creating Procedure: daExtRetInit'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daExtRetInit
AS
  DECLARE @o_error integer;
SET NOCOUNT ON
	-- BEGIN TRANSACTION TranExtRetInit
	DECLARE	@errorCode INTEGER
	SET		@errorCode = 0
	DECLARE	@tblJobSelOnline TABLE (
			jobId int,
			copyId int,
			dataType int,
			commCellId int,
			primary key (jobId, copyId, dataType, commCellId)
			)
	-- Retention flags should be unset for child-logs of selective online full
	INSERT	INTO @tblJobSelOnline
	SELECT	DISTINCT b.childJobId, a.copyId, 0, a.commCellId
	FROM	ArchJobCopyExtended a WITH (NOLOCK), JMJobDataLink b WITH (NOLOCK)
	WHERE	a.jobId = b.parentJobId
	AND		a.commCellId = b.commCellId
	UNION
	SELECT	DISTINCT c.childJobId, a.copyId, 0, c.commCellId
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK), JMJobDataLink c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.archGrpCopyId
	AND		b.jobId = c.parentJobId
	AND		b.commCellId = c.commCellId
	AND		b.dataType = 1 					-- Check the status of the Data Job
	AND		((b.status = 1000) OR (b.disabled & 256 = 256) OR (b.retentionFlags = 0))
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Update the data only for selected appId Copy for Extended Retention
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, archJobCopyExtended b
	WHERE	a.retentionFlags > 0
	AND		a.appId = b.appId
	AND		a.archGrpCopyId = b.copyId
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
	-- Retention flags should be unset for child-jobs of selective online full
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a, @tblJobSelOnline b
	WHERE	a.jobId = b.jobId
	AND		a.commCellId = b.commCellId
	AND		a.archGrpCopyId = b.copyId
	AND		a.status NOT IN (2, 3, 1000)
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	-- COMMIT TRANSACTION TranExtRetInit
	SELECT @errorCode
	RETURN
CX_ERROR_EXIT:
	--  TRANSACTION TranExtRetInit
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daExtRetInit')
	delete from GxQscripts where name = 'daExtRetInit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daExtRetInit')
	delete from GXDBVersions where aliasname = 'daExtRetInit'
GO

insert into GXDBVersions values(2, 'daExtRetInit',  '00010004027800010000', 'daExtRetInit', '00010004027800010000')
GO

