

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDisableToBeCopiedJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daDisableToBeCopiedJobs.sp,v $ $Id: daDisableToBeCopiedJobs.sp,v 1.1.78.2 2018/12/27 16:45:03 vikashkumar Exp $";
--  +=============================================================================+
--  | Stored Proc:  daDisableToBeCopiedJobs()
--  |
--  | Description:  Disable To-Be-Copied jobs for Aux Copy if they met retention
--  +=============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daDisableToBeCopiedJobs')
BEGIN
	print '>>> Drop Stored Procedure: daDisableToBeCopiedJobs <<<'
	drop procedure daDisableToBeCopiedJobs
END
IF EXISTS (select * from GxQscripts where name='daDisableToBeCopiedJobs')
	delete from GxQscripts where name = 'daDisableToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDisableToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'daDisableToBeCopiedJobs'
GO
print '... Creating Procedure: daDisableToBeCopiedJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daDisableToBeCopiedJobs
  @i_dummy INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE	@errorCode 	INTEGER
	SET			@errorCode 	= 0
	DECLARE	@currCopyLevel 	INTEGER
	SET			@currCopyLevel 	= 1
	DECLARE	@disableToBeCopiedJobs	INTEGER
	SET			@disableToBeCopiedJobs	= 0
	/*************************** Create Temp Tables ***************************/
	if object_id('tempdb.dbo.#toBeCopiedJobsToDisable') is not null DROP TABLE #toBeCopiedJobsToDisable
	CREATE	TABLE #toBeCopiedJobsToDisable (
			JobId 			INTEGER,
			commCellId	INTEGER,
			archGrpId		INTEGER,
			CopyId			INTEGER,
			fileType		INTEGER,
			status			INTEGER,
			disabled		INTEGER,
	)
	CREATE INDEX Idx_toBeCopiedJobsToDisable_1 ON #toBeCopiedJobsToDisable (JobId, commCellId, CopyId, fileType)
	if object_id('tempdb.dbo.#tmpSrcCopyInfo') is not null DROP TABLE #tmpSrcCopyInfo
	CREATE	TABLE #tmpSrcCopyInfo (
			archGrpId				INTEGER,
			CopyId 					INTEGER,
			SourceCopyId		INTEGER,
			PrimaryCopyId		INTEGER,
			isSnapCopy			INTEGER,
			isMirrorCopy		INTEGER,
			mirrorSrcCopyId	INTEGER,
			copyLevel				INTEGER
	)
	CREATE INDEX Idx_tmpSrcCopyInfo_1 ON #tmpSrcCopyInfo (CopyId)
	SELECT @disableToBeCopiedJobs = isnull(value, 0)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_DISABLE_JOBS_FOR_AUXCOPY_THAT_MET_RETENTION'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF (@disableToBeCopiedJobs = 1)
	BEGIN
		-- Get all the to-be-copied jobs that are prunable by all rules except by the AuxCopy Rule
		INSERT INTO #toBeCopiedJobsToDisable
		SELECT DISTINCT T.JobId, T.commCellId, AGC.archGroupId, T.CopyId, T.fileType, T.dataStatus, T.disabled
		FROM #DA_JobCopyList T, archGroupCopy AGC WITH (NOLOCK)
		WHERE T.copyId = AGC.id
		AND		T.dataStatus IN (101, 102, 103)
		AND		T.disabled = 0
AND		(T.jobRetainReason & 512) > 0
AND 	(T.jobRetainReason & ~512) = 0
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get all the copies with source copy information
		--Do not process transitive copies or SILO copies
		INSERT INTO #tmpSrcCopyInfo
		SELECT AGC.archGroupId, AGC.id, AGC.sourceCopyId, CASE WHEN (AGC.isSnapCopy = 0) THEN AG.defaultCopy ELSE AG.defaultSnapCopy END,
					 AGC.isSnapCopy, AGC.isMirrorCopy, CASE WHEN (AGC.isMirrorCopy != 0) THEN AGC.sourceCopyId ELSE 0 END, 0
		FROM archGroup AG WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), (SELECT DISTINCT archGrpId FROM #DA_AppCopyList) T
		WHERE AG.id = AGC.archGroupId
		AND		AG.Id = T.archGrpId
AND		AGC.type != 5
AND		(AGC.flags & 524288) = 0
AND		(AGC.extendedFlags & 8) = 0
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- The source copy will be source of Mirror copy if source copy is Mirror Copy
		WHILE EXISTS(SELECT T.mirrorSrcCopyId FROM #tmpSrcCopyInfo T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.mirrorSrcCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
		BEGIN
			UPDATE	#tmpSrcCopyInfo
			SET 	mirrorSrcCopyId = AGC.sourceCopyId
			FROM	#tmpSrcCopyInfo T, archGroupCopy AGC WITH (NOLOCK)
			WHERE	T.mirrorSrcCopyId = AGC.id
			AND		AGC.isSnapCopy > 0
			AND		AGC.isMirrorCopy > 0
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		UPDATE #tmpSrcCopyInfo
		SET sourceCopyId = PrimaryCopyId
		WHERE sourceCopyId = 0
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpSrcCopyInfo
		SET mirrorSrcCopyId = PrimaryCopyId
		WHERE mirrorSrcCopyId = 0
		AND		isSnapCopy > 0
		AND		isMirrorCopy > 0
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the jobs from mirror copy with same jobRetainReason as source copy to compute retention correctly
		INSERT INTO #toBeCopiedJobsToDisable
SELECT DISTINCT JDS.JobId, JDS.commCellId, JDS.archGrpId, JDS.archGrpCopyId, T.fileType, MIN(JDS.status), MIN(JDS.disabled & 1)
		FROM #DA_JobCopyList T, #tmpSrcCopyInfo TMP, JMJobDataStats JDS WITH (NOLOCK)
		WHERE T.JobId = JDS.JobId
		AND		T.CommCellId = JDS.CommCellId
		AND		T.CopyId = TMP.mirrorSrcCopyId
		AND		TMP.CopyId = JDS.archGrpCopyId
		AND		TMP.isSnapCopy > 0
		AND		TMP.isMirrorCopy > 0
		AND		JDS.status IN (101, 102, 103)
AND		JDS.disabled & 1 = 0
AND		(T.jobRetainReason & 512) > 0
AND 	(T.jobRetainReason & ~512) = 0
		AND 	(	(T.fileType = 0)
						OR
(T.fileType = 1 AND JDS.dataType != 4)
						OR
(T.fileType = 4 AND JDS.dataType = 4)
					)
		GROUP BY JDS.JobId, JDS.commCellId, JDS.archGrpId, JDS.archGrpCopyId, T.fileType
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpSrcCopyInfo
		SET copyLevel = 1
		WHERE copyId NOT IN (SELECT DISTINCT sourceCopyId FROM #tmpSrcCopyInfo)
		OR		copyId = sourceCopyId
		OR		copyId = PrimaryCopyId
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		SET	@currCopyLevel 	= 1
		WHILE (1 = 1)
		BEGIN
			UPDATE JDS1
SET disabled = JDS1.disabled | (1 + 8192)
FROM JMJobDataStats JDS1, #toBeCopiedJobsToDisable T, #tmpSrcCopyInfo C
			WHERE JDS1.jobId = T.jobId
			AND		JDS1.commCellId = T.commCellId
			AND 	(	(T.fileType = 0)
							OR
(T.fileType = 1 AND JDS1.dataType != 4)
							OR
(T.fileType = 4 AND JDS1.dataType = 4)
						)
			AND		JDS1.archGrpCopyId = T.CopyId
			AND		JDS1.status IN (101, 102, 103)
			AND 	T.copyId = C.copyId
			AND		C.copyId != C.PrimaryCopyId
			AND 	C.copyLevel = @currCopyLevel
AND		JDS1.disabled & (1 | 256) = 0
			AND NOT EXISTS (
												SELECT JobId
FROM 	JMJobDataStats JDS2
												WHERE	JDS2.jobId = JDS1.jobId
												AND		JDS2.commCellId = JDS1.commCellId
												AND		JDS2.dataType = JDS1.dataType
												AND		JDS2.archGrpCopyId != JDS1.archGrpCopyId
												AND		JDS2.archGrpCopyId IN (SELECT copyId FROM #tmpSrcCopyInfo WHERE sourceCopyId = C.copyId)
												AND 	JDS2.status IN (101, 102, 103)
AND		JDS2.disabled & (1 | 256) = 0
										)
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			UPDATE #tmpSrcCopyInfo
			SET copyLevel = @currCopyLevel + 1
			WHERE copyId IN (SELECT DISTINCT sourceCopyId FROM #tmpSrcCopyInfo WHERE copyLevel = @currCopyLevel)
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			SET @currCopyLevel = @currCopyLevel + 1
			SET	@errorCode = @@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			IF NOT EXISTS (SELECT copyId FROM #tmpSrcCopyInfo WHERE copyLevel = @currCopyLevel AND CopyId != PrimaryCopyId)
				BREAK
		END
		--Check for child jobs in #toBeCopiedJobsToDisable
		--and do not disable child jobs if parent job on same copy is not disabled
		UPDATE JDS
SET	disabled = JDS.disabled & ~(1 + 8192)
FROM 	JMJobDataStats JDS, #toBeCopiedJobsToDisable T, JMJobDataLinkViewForDA JDL WITH (NOLOCK)
		WHERE	JDS.jobId = JDL.childJobId
		AND		JDS.commCellId = JDL.commCellId
		AND		JDS.jobId = T.jobId
		AND		JDS.commCellId = T.commCellId
		AND 	JDS.archGrpCopyId = T.CopyId
		AND		JDS.status IN (101, 102, 103)
		AND		(
						(
							JDL.parentJobId != JDL.childJobId
							AND (	(T.fileType = 0)
										OR
(T.fileType = 1 AND JDS.dataType != 4)
										OR
(T.fileType = 4 AND JDS.dataType = 4)
									)
						)
						OR
						(
							JDL.parentJobId = JDL.childJobId
AND T.fileType = 4
AND JDS.dataType = 4
						)
					)
AND		JDS.disabled & 1 > 0
AND		JDS.disabled & 8192 > 0
AND		JDS.disabled & 256 = 0
		AND EXISTS (SELECT J.JobId
FROM JMJobDataStats J WITH (NOLOCK)
								WHERE J.jobId = JDL.parentJobId
								AND		J.commCellId = JDL.commCellId
								AND		J.archGrpCopyId = T.CopyId
								AND		J.status IN (101, 102, 103)
								AND		( (JDL.parentJobId != JDL.childJobId)
												OR
												(
													JDL.parentJobId = JDL.childJobId
AND J.dataType = 1
												)
											)
AND		J.disabled & (1 | 256) = 0
							 )
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check for VSA backup jobs in #toBeCopiedJobsToDisable
		--and do not disable VSA jobs if App backup job on same copy is not disabled
		UPDATE JDS
SET	disabled = JDS.disabled & ~(1 + 8192)
FROM 	JMJobDataStats JDS, #toBeCopiedJobsToDisable T, JMVSAAppJobLink JDL WITH (NOLOCK)
		WHERE	JDS.jobId = JDL.parentJobId
		AND		JDS.commCellId = JDL.commCellId
		AND		JDS.jobId = T.jobId
		AND		JDS.commCellId = T.commCellId
		AND 	JDS.archGrpCopyId = T.CopyId
		AND		JDS.status IN (101, 102, 103)
AND		JDS.disabled & 1 > 0
AND		JDS.disabled & 8192 > 0
AND		JDS.disabled & 256 = 0
		AND EXISTS (SELECT J.JobId
FROM JMJobDataStats J WITH (NOLOCK)
								WHERE J.jobId = JDL.childJobId
								AND		J.commCellId = JDL.commCellId
								AND		J.archGrpCopyId = T.CopyId
								AND		J.status IN (101, 102, 103)
AND		J.disabled & (1 | 256) = 0
							 )
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check for BCD index or Tape Index from BCD for jobs in #toBeCopiedJobsToDisable
		--and disable index if data and/or log on same copy is disabled
		UPDATE JDS
SET	disabled = JDS.disabled | (1 + 8192)
		FROM 	JMJobDataStats JDS, archFile AF WITH (NOLOCK), #toBeCopiedJobsToDisable T
		WHERE	JDS.jobId = AF.jobId
		AND		JDS.commCellId = AF.commCellId
		AND		JDS.dataType = AF.fileType
		AND 	(
(JDS.dataType = 6)
					OR
((JDS.dataType = 2) AND ((AF.flags & (4 | 4096)) > 0))
					)
		AND 	JDS.jobId = T.jobId
		AND		JDS.commCellId = T.commCellId
		AND 	JDS.archGrpCopyId = T.CopyId
		AND		JDS.status IN (101, 102, 103)
AND		JDS.disabled & 1 = 0
AND		JDS.disabled & 256 = 0
		AND NOT EXISTS (SELECT J.JobId
								FROM JMJobDataStats J
								WHERE J.jobId = JDS.jobId
								AND		J.commCellId = JDS.commCellId
								AND		J.archGrpCopyId = JDS.archGrpCopyId
AND		J.dataType IN (1, 4)
								AND		J.status IN (101, 102, 103)
AND		J.disabled & (1 | 256) = 0
							 )
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check for BCD index or Tape Index from BCD for jobs in #toBeCopiedJobsToDisable
		--and do not disable index if data or log on same copy is not disabled
		UPDATE JDS
SET	disabled = JDS.disabled & ~(1 + 8192)
		FROM 	JMJobDataStats JDS, archFile AF WITH (NOLOCK), #toBeCopiedJobsToDisable T
		WHERE	JDS.jobId = AF.jobId
		AND		JDS.commCellId = AF.commCellId
		AND		JDS.dataType = AF.fileType
		AND 	(
(JDS.dataType = 6)
					OR
((JDS.dataType = 2) AND ((AF.flags & (4 | 4096)) > 0))
					)
		AND 	JDS.jobId = T.jobId
		AND		JDS.commCellId = T.commCellId
		AND 	JDS.archGrpCopyId = T.CopyId
		AND		JDS.status IN (101, 102, 103)
AND		JDS.disabled & 1 > 0
AND		JDS.disabled & 256 = 0
		AND EXISTS (SELECT J.JobId
								FROM JMJobDataStats J
								WHERE J.jobId = JDS.jobId
								AND		J.commCellId = JDS.commCellId
								AND		J.archGrpCopyId = JDS.archGrpCopyId
AND		J.dataType IN (1, 4)
								AND		J.status IN (101, 102, 103)
AND		J.disabled & (1 | 256) = 0
							 )
		SET	@errorCode = @@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	if object_id('tempdb.dbo.#toBeCopiedJobsToDisable') is not null
		DROP TABLE #toBeCopiedJobsToDisable
	if object_id('tempdb.dbo.#tmpSrcCopyInfo') is not null
		DROP TABLE #tmpSrcCopyInfo
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daDisableToBeCopiedJobs')
	delete from GxQscripts where name = 'daDisableToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDisableToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'daDisableToBeCopiedJobs'
GO

insert into GXDBVersions values(2, 'daDisableToBeCopiedJobs',  '00010001007800020000', 'daDisableToBeCopiedJobs', '00010001007800020000')
GO

