

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteJobOptionsHelper.sp] ---------- 

--  +========================================================================+
--  |		Name		:	daDeleteJobOptionsHelper
--  |		Description	:	Delete job options in batch based upon pre-populated temp table.
--	|		Author		:	Gokul Pattabiraman.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daDeleteJobOptionsHelper')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteJobOptionsHelper <<<'
	drop procedure daDeleteJobOptionsHelper
END
IF EXISTS (select * from GxQscripts where name='daDeleteJobOptionsHelper')
	delete from GxQscripts where name = 'daDeleteJobOptionsHelper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobOptionsHelper')
	delete from GXDBVersions where aliasname = 'daDeleteJobOptionsHelper'
GO
print '... Creating Procedure: daDeleteJobOptionsHelper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daDeleteJobOptionsHelper
  @maxRowsToPruneInBatch INTEGER,
  @o_retVal integer OUTPUT
,
  @o_rowsDeleted integer OUTPUT
AS
BEGIN TRY
	SET @o_rowsDeleted = 0
	DECLARE @tmpRowCount INTEGER = 0
	-- JMJobOptions
	DELETE	TOP (@maxRowsToPruneInBatch) JMJobOptions
	FROM	JMJobOptions A, #tblJobOptionsIdsToDeleteFromJMJobOptions B
	WHERE	A.id = B.id
	AND A.attributeId <> 86	--JM_THROUGHPUT_INFORMATION - Preserve till the job is aged
	SET @tmpRowCount = @@ROWCOUNT
	SET @o_rowsDeleted = @o_rowsDeleted + @tmpRowCount
	-- JMMisc
	DELETE	TOP (@maxRowsToPruneInBatch) JMMisc
	FROM	JMMisc A, #tblJobOptionsToDelete B
	WHERE	A.jobId = B.jobId
	AND 	A.commCellId = B.commCellId
	AND     (B.appType <> 53 /*Exchange DB agent*/ OR  A.itemType <> 28 /*JM_XMLJOB_INFO*/)
	AND	A.itemType <> 71 --JM_JOB_JOB_ENCRYPTION_TYPE - Preserve till the job is aged
AND	A.itemType <> 83 --JM_NAS_LAST_USED_MA_IN_BKP
	SET @tmpRowCount = @@ROWCOUNT
	SET @o_rowsDeleted = @o_rowsDeleted + @tmpRowCount
	-- Workflow Attempts Cleanup
	DELETE  TOP (@maxRowsToPruneInBatch) JMAdminJobAttemptStatsTable
	FROM    JMAdminJobAttemptStatsTable A, JMAdminJobStatsTable J, #tblJobOptionsToDelete B
	WHERE   A.jobId = J.jobId
	AND   	A.commCellId = J.commCellId
	AND     J.jobId = B.jobId
	AND     J.commCellId = B.commCellId
	AND     J.opType = 90
	SET @tmpRowCount = @@ROWCOUNT
	SET @o_rowsDeleted = @o_rowsDeleted + @tmpRowCount
	-- JMJobResourceHistory
	DELETE	TOP (@maxRowsToPruneInBatch) JMJobResourceHistory
	FROM	JMJobResourceHistory A, #tblJobOptionsToDelete B
	WHERE	A.jobId = B.jobId
	AND 	A.commCellId = B.commCellId
	SET @tmpRowCount = @@ROWCOUNT
	SET @o_rowsDeleted = @o_rowsDeleted + @tmpRowCount
	-- JMOracleRACClientsUsed
	IF OBJECT_ID('tempdb.dbo.#lastSuccessfulSnapJobForOracleRACBlockLvlSubclient') IS NOT null
        DROP TABLE #lastSuccessfulSnapJobForOracleRACBlockLvlSubclient
	CREATE TABLE #lastSuccessfulSnapJobForOracleRACBlockLvlSubclient
	(
		jobId 		int,
		commCellId 	int
	)
	INSERT INTO #lastSuccessfulSnapJobForOracleRACBlockLvlSubclient
	SELECT MAX(JBS.jobId), JBS.commCellId FROM JMOracleRACClientsUsed OCU
		INNER JOIN JMBkpStats JBS (NOLOCK) ON OCU.jobId = JBS.jobId AND OCU.commCellId = JBS.commCellId AND status IN (1,3,14) AND JBS.opType = 59
		INNER JOIN APP_SubClientProp SCP (NOLOCK) ON SCP.componentNameId = JBS.appId AND SCP.attrName = N'Use block level backup' AND SCP.attrVal = N'1' AND SCP.cs_attrName = CHECKSUM(N'Use block level backup') AND SCP.modified = 0
	GROUP BY JBS.appId, JBS.commCellId
	DELETE TOP (@maxRowsToPruneInBatch) JMOracleRACClientsUsed
	FROM JMOracleRACClientsUsed OCU
		LEFT OUTER JOIN #lastSuccessfulSnapJobForOracleRACBlockLvlSubclient BLK ON BLK.jobId = OCU.jobId AND BLK.commCellId = OCU.commCellId
		LEFT OUTER JOIN JMJobInfo JI (NOLOCK) ON JI.jobid = OCU.jobId AND JI.commcellId = OCU.commCellId
	WHERE BLK.jobId IS NULL AND JI.jobId IS NULL
	IF OBJECT_ID('tempdb.dbo.#lastSuccessfulSnapJobForOracleRACBlockLvlSubclient') IS NOT null
        DROP TABLE #lastSuccessfulSnapJobForOracleRACBlockLvlSubclient
	SET @tmpRowCount = @@ROWCOUNT
	SET @o_rowsDeleted = @o_rowsDeleted + @tmpRowCount
	SET @o_retVal = @@ERROR
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_retVal = @@ERROR
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteJobOptionsHelper')
	delete from GxQscripts where name = 'daDeleteJobOptionsHelper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobOptionsHelper')
	delete from GXDBVersions where aliasname = 'daDeleteJobOptionsHelper'
GO

insert into GXDBVersions values(2, 'daDeleteJobOptionsHelper',  '00000000000000000000', 'daDeleteJobOptionsHelper', '00000000000000000000')
GO

