

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteJobOptions.sp] ---------- 

--  +========================================================================+
--  |		Name		:	daDeleteJobOptions
--  |		Description	:	Delete job options based upon configured value.
--	|		Author		:	Gokul Pattabiraman.
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daDeleteJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteJobOptions <<<'
	drop procedure daDeleteJobOptions
END
IF EXISTS (select * from GxQscripts where name='daDeleteJobOptions')
	delete from GxQscripts where name = 'daDeleteJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobOptions')
	delete from GXDBVersions where aliasname = 'daDeleteJobOptions'
GO
print '... Creating Procedure: daDeleteJobOptions'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daDeleteJobOptions
  @daysToKeepJobOptions INTEGER,
  @daysToKeepBkpAtmptStats INTEGER,
  @daysToKeepJobPendingReasons INTEGER
AS
  DECLARE @errorCode integer
BEGIN
	SET NOCOUNT ON
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @currentTime INTEGER
	SET 		@currentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @cutOffTimeForOptions INTEGER
	SET @cutOffTimeForOptions = @currentTime - (@daysToKeepJobOptions * 24 * 60 * 60)
	DECLARE @cutOffTimeForBkpAtmptStats INTEGER
	SET @cutOffTimeForBkpAtmptStats = @currentTime - (@daysToKeepBkpAtmptStats * 24 * 60 * 60)
	DECLARE @cutOffTimeForFailureReasonJobs INTEGER
	SET @cutOffTimeForFailureReasonJobs = @currentTime - (@daysToKeepJobPendingReasons * 24 * 60 * 60)
	IF @daysToKeepJobOptions <= 0
		GOTO JM_BKP_ATMPT_STATS
	DECLARE @maxRowsToPruneInBatch 	INTEGER
	SET			@maxRowsToPruneInBatch	= 5000
	DECLARE @numJobToDelete INTEGER
	SET			@numJobToDelete = 0
	DECLARE @rowsDeleted INTEGER
	SET @rowsDeleted = 0
	IF OBJECT_ID('tempdb.dbo.#tblJobOptionsToDelete') IS NOT null
		DROP TABLE #tblJobOptionsToDelete
	CREATE TABLE #tblJobOptionsToDelete
	(
		jobId 		int,
		commCellId 	int,
		appType		int,
		primary key (jobId, commCellId)
	)
	------------------------------------------------------------------------------
	------------------ Get Backup Jobs whose endTime is expired ------------------
	------------------------------------------------------------------------------
	INSERT  INTO #tblJobOptionsToDelete
    SELECT  J.jobId, J.commCellId, J.appType
    FROM    JMBkpStats  J WITH (NOLOCK)
    WHERE
              J.servEndDate < @cutOffTimeForOptions
    ------------------------------------------------------------------------------
    ------------------ Get Restore Jobs whose endTime is expired -----------------
    ------------------------------------------------------------------------------
    UNION
    SELECT  J.jobId, J.commCellId, J.appType
    FROM    JMRestoreStats  J WITH (NOLOCK)
    WHERE
              J.servEndTime < @cutOffTimeForOptions
    ------------------------------------------------------------------------------
    ------------------ Get Admin Jobs whose endTime is expired -------------------
    ------------------------------------------------------------------------------
    UNION
    SELECT J.jobId, J.commCellId, 0
    FROM    JMAdminJobStatsTable  J WITH (NOLOCK)
    WHERE   J.servEnd < @cutOffTimeForOptions
	SELECT @retVal = @@ERROR
	IF @retVal <> 0 GOTO JM_FAILURE_REASON_MSG
	SELECT @numJobToDelete = COUNT(*) FROM #tblJobOptionsToDelete
	IF @numJobToDelete = 0
		GOTO JM_FAILURE_REASON_MSG
    IF OBJECT_ID('tempdb.dbo.#tblJobOptionsIdsToDeleteFromJMJobOptions') IS NOT null
        DROP TABLE #tblJobOptionsIdsToDeleteFromJMJobOptions
	CREATE TABLE #tblJobOptionsIdsToDeleteFromJMJobOptions
	(
		id int
	)
	CREATE CLUSTERED INDEX tblJobOptionsIdsToDeleteFromJMJobOptions_id_Index1 ON #tblJobOptionsIdsToDeleteFromJMJobOptions ([id])
	-- JMJobOptions
	INSERT  INTO #tblJobOptionsIdsToDeleteFromJMJobOptions
	SELECT  A.id
	FROM	JMJobOptions A WITH (NOLOCK), #tblJobOptionsToDelete B
	WHERE	A.jobId = B.jobId
	AND 	A.commCellId = B.commCellId
	AND     A.attributeName NOT IN ('DB Backup Time' /*JM_ORACLE_BACKUP_TIME_NAME*/,
									'stub size' /*JM_STUB_SIZE_NAME*/,
									'Last System state time for SynthFull'/*JM_RUNNING_LAST_SYSTEM_STATE_FOR_SYNTHFULL_NAME*/,
									'Additional extended retention options' /*JM_ADDITIONAL_EXTENDED_RETENTION_OPTIONS_NAME*/,
									'Size on Media' /*JM_JOB_SIZE_ON_MEDIA_NAME*/,
									'Job was cataloged' /*JM_JOB_WAS_CATALOGED_NAME*/,
									'OracleInstanceScript' /*JM_ORACLE_INSTANCE_SCRIPT*/,
									'Catalog job id for VM backup job' /*JMCATALOG_JOB_ID_FOR_VM_BKP_JOB_NAME*/
									)
	--INSERT DANGLING OPTIONS
	INSERT  INTO #tblJobOptionsIdsToDeleteFromJMJobOptions
	SELECT id
	FROM JMJobOptions (NOLOCK)
	WHERE jobId NOT IN
	(
		SELECT jobId FROM JMBkpStats (NOLOCK)
		UNION ALL
		SELECT jobId FROM JMRestoreStats (NOLOCK)
		UNION ALL
		SELECT jobId FROM JMAdminJobStatsTable (NOLOCK)
		UNION ALL
		SELECT jobId FROM JMJobInfo (NOLOCK)
		UNION ALL
		SELECT jobId FROM TM_Jobs (NOLOCK)
	)
	DECLARE @maxLoopRunTime INT
	DECLARE @tmpVar NVARCHAR(MAX) = '30'
	SET @tmpVar = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GxGlobalParam WHERE name = 'MaxRunTimeOfJobOptionPruning'), '30')
	SET @maxLoopRunTime = CAST (@tmpVar AS INT)
	SET @maxLoopRunTime = @maxLoopRunTime * 60
	DECLARE @loopEndTime INT = dbo.GetUnixTime(GETDATE()) + @maxLoopRunTime
	WHILE ( 1 = 1)
	BEGIN
		EXEC daDeleteJobOptionsHelper @maxRowsToPruneInBatch, @retVal output, @rowsDeleted output
		-- If error occurred or no rows to delete then, break
		IF @retVal <> 0 OR @rowsDeleted = 0
			BREAK
		-- Also If loop has been running for configured time, then break. This is to reduce runtime of first DA job.
		IF @loopEndTime < dbo.GetUnixTime(GETDATE())
			BREAK
		WAITFOR DELAY '00:00:02'
	END
JM_FAILURE_REASON_MSG:
    IF OBJECT_ID('tempdb.dbo.#tblFailureReasonJobsToDelete') IS NOT null
        DROP TABLE #tblFailureReasonJobsToDelete
	CREATE TABLE #tblFailureReasonJobsToDelete
	(
		id int,
		jobId int,
		commCellId int
	)
	CREATE CLUSTERED INDEX tblFailureReasonJobsToDelete_id_Index1 ON #tblFailureReasonJobsToDelete ([id])
	INSERT  INTO #tblFailureReasonJobsToDelete
	SELECT  FRM.id, FRM.jobId, FRM.commCellId
	FROM    JMFailureReasonMsg FRM WITH (NOLOCK)
	WHERE   FRM.failureReasonTime <> 0 AND FRM.failureReasonTime < @cutOffTimeForFailureReasonJobs
	-- JMFailureReasonMsg
	DECLARE @fcnt INTEGER = 1
	WHILE (@fcnt > 0)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) JMFailureReasonMsg
		FROM	JMFailureReasonMsg A, #tblFailureReasonJobsToDelete B
		WHERE	A.Id = B.Id
		SET @fcnt = @@ROWCOUNT
	END
	-- JMFailureReasonLocaleMsgCache
	SET @fcnt = 1
	WHILE (@fcnt > 0)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) JMFailureReasonLocaleMsgCache
		FROM	JMFailureReasonLocaleMsgCache A, #tblFailureReasonJobsToDelete B
		WHERE	A.jobId = B.jobId
		AND 	A.commCellId = B.commCellId
		SET @fcnt = @@ROWCOUNT
	END
JM_BKP_ATMPT_STATS:
	IF @daysToKeepBkpAtmptStats <= 0
		GOTO ALL_DONE
	IF OBJECT_ID('tempdb.dbo.#tblBkpAtmptStatsToDelete') IS NOT null
        DROP TABLE #tblBkpAtmptStatsToDelete
	CREATE TABLE #tblBkpAtmptStatsToDelete
	(
		jobId 		int,
		number		int,
		phase		int,
		commCellId 	int,
		copyId		int,
		primary key (jobId, number, phase, commCellId, copyId)
	)
	INSERT  INTO #tblBkpAtmptStatsToDelete
	SELECT  BAS.jobId, BAS.number, BAS.phase, BAS.commCellId, BAS.copyId
	FROM    JMBkpAtmptStats BAS WITH (NOLOCK)
	WHERE   BAS.servEndDate < @cutOffTimeForBkpAtmptStats
	SET @fcnt = 1
	WHILE (@fcnt > 0)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) JMBkpAtmptStats
		FROM	JMBkpAtmptStats A, #tblBkpAtmptStatsToDelete B
		WHERE	A.jobId = B.jobId
		AND		A.number = B.number
		AND		A.phase = B.phase
		AND		A.commCellId = B.commCellId
		AND		A.copyId = B.copyId
		SET @fcnt = @@ROWCOUNT
	END
ALL_DONE:
	IF OBJECT_ID('tempdb.dbo.#tblJobOptionsToDelete') IS NOT null
		DROP TABLE #tblJobOptionsToDelete
    IF OBJECT_ID('tempdb.dbo.#tblJobOptionsIdsToDeleteFromJMJobOptions') IS NOT null
        DROP TABLE #tblJobOptionsIdsToDeleteFromJMJobOptions
    IF OBJECT_ID('tempdb.dbo.#tblFailureReasonJobsToDelete') IS NOT null
        DROP TABLE #tblFailureReasonJobsToDelete
    IF OBJECT_ID('tempdb.dbo.#tblBkpAtmptStatsToDelete') IS NOT null
        DROP TABLE #tblBkpAtmptStatsToDelete
	SELECT @retVal
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteJobOptions')
	delete from GxQscripts where name = 'daDeleteJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobOptions')
	delete from GXDBVersions where aliasname = 'daDeleteJobOptions'
GO

insert into GXDBVersions values(2, 'daDeleteJobOptions',  '00000000000000000000', 'daDeleteJobOptions', '00000000000000000000')
GO

