

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteJobHistory.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daDeleteJobHistory()
--  | Description:  Delete job histories
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daDeleteJobHistory.sp,v $ $Id: daDeleteJobHistory.sp,v 1.7.56.13 2020/11/17 17:13:16 bzhu Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daDeleteJobHistory')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteJobHistory <<<'
	drop procedure daDeleteJobHistory
END
IF EXISTS (select * from GxQscripts where name='daDeleteJobHistory')
	delete from GxQscripts where name = 'daDeleteJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobHistory')
	delete from GXDBVersions where aliasname = 'daDeleteJobHistory'
GO
print '... Creating Procedure: daDeleteJobHistory'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daDeleteJobHistory
  @i_dummy integer
AS
  DECLARE @o_errorCode integer;
SET NOCOUNT ON
/*
	-- Create and populate this table before calling this SP
	CREATE TABLE #tblJobToDelete
	(
		jobId 			int,
		commCellId 	int,
		primary key (jobId, commCellId)
	)
*/
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @maxRetry INTEGER
	SET @maxRetry = 2
	SELECT @maxRetry = isnull(value, 2)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_NUMBER_OF_RETRY_ON_LOCK'
	DECLARE @retryCnt INTEGER
	SET @retryCnt = 0
	---------------------------------------------------------------------------
	-------- Delete from JMJobDataStats, JMJobDataLink and JMJobStats ---------
	---------------------------------------------------------------------------
	WHILE @retryCnt <= @maxRetry
	BEGIN
		BEGIN TRANSACTION
			BEGIN TRY
			BEGIN
				SET @retVal = 0
				DELETE	JMJobDataLink
				FROM	JMJobDataLink A INNER JOIN #tblJobToDelete B
				ON	A.parentJobId = B.jobId
				AND	A.commCellId = B.commCellId
				DELETE	JMJobDataLink
				FROM	JMJobDataLink A INNER JOIN #tblJobToDelete B
				ON	A.childJobId = B.jobId
				AND A.commCellId = B.commCellId
				DELETE	JMJobDataStats
				FROM	JMJobDataStats A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				AND	A.commCellId = B.commCellId
				--Added this due to missing FK to JMJobStats table
				--For safety to avoid data inconsistencies
				DELETE	JMBkpStats
				FROM	JMBkpStats A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				AND	A.commCellId = B.commCellId
				-- delete entries in App_VMProp table when clientJobID is deleted from JMbkpStats
				DELETE	APP_VMProp
				FROM	APP_VMProp A INNER JOIN #tblJobToDelete B
				ON	A.ClientJobId = B.jobId
				AND	A.commCellId = B.commCellId
				--Delete jobs from JMVSAAppJobLink table before deleting from JMJobStats table
				DELETE	JMVSAAppJobLink
				FROM	JMVSAAppJobLink A INNER JOIN #tblJobToDelete B
				ON	A.childJobId = B.jobId
				AND	A.commCellId = B.commCellId
				DELETE	JMVSAAppJobLink
				FROM	JMVSAAppJobLink A INNER JOIN #tblJobToDelete B
				ON	A.parentJobId = B.jobId
				AND	A.commCellId = B.commCellId
				DELETE	JMJobStats
				FROM	JMJobStats A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				AND	A.commCellId = B.commCellId
				-- MAIN JOB OPTION PRUNING IS DONE IN AppPruneJobOptions
				-- THIS PRUNES REMAINING ENTRIES THAT ARE LEFT TO DO RE-SUBMIT JOBS
				DELETE	TM_Jobs
				FROM	TM_Jobs A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				DELETE	TM_JobOptions
				FROM	TM_JobOptions A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				WHERE A.jobId > 0
				DELETE	TM_JobXMLOptions
				FROM	TM_JobXMLOptions A INNER JOIN #tblJobToDelete B
				ON	A.jobId = B.jobId
				WHERE A.jobId > 0
				DELETE			-- this is delete all values. So skipping modified = 0 check here.
				FROM APP_ClientProp
				WHERE
attrName = 'Last Backup Subclient'
					AND componentNameID IN (SELECT DISTINCT componentNameID
											FROM APP_ClientProp
											WHERE
												attrname = 'Last Backup JobID' AND attrVal in (select jobId from #tblJobToDelete))
				DELETE FROM APP_ClientProp where attrname = 'Last Backup JobID' AND attrVal in (select jobId from #tblJobToDelete)
				DELETE	JMJobRestoreHistoryInfo
				FROM	JMJobRestoreHistoryInfo H INNER JOIN #tblJobToDelete T
				ON	H.jobId = T.jobId
				AND 	H.commCellId = T.commCellId
				DELETE R
				FROM MMDataTransferRequest R
					INNER JOIN #tblJobToDelete T ON T.JobId = R.JobId
				WHERE T.commCellId = 2
				DELETE M
				FROM MMMountPathMove M
					INNER JOIN #tblJobToDelete T ON T.JobId = M.JobId
				WHERE T.commCellId = 2
			COMMIT TRANSACTION
			BREAK
		END
		END TRY
  	BEGIN CATCH
  	BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @retVal = ERROR_NUMBER()
    	ROLLBACK TRANSACTION
    	IF @retVal NOT IN (1222, 1205)
    	BEGIN
    		;THROW --Actually BREAK is not required as THROW will terminate the loop. But BREAK shouldn't harm either. So leaving BREAK to be safe, so we know we won't end up in an infinite loop.
    		BREAK
    	END
    	ELSE
    	BEGIN
    		SET @retryCnt = @retryCnt + 1
    		IF(@retryCnt > @maxRetry)
    		BEGIN
    			;THROW
    		END
    		ELSE
    		BEGIN
	    		WAITFOR DELAY '00:00:05'
	    		CONTINUE
	    	END
    	END
    END
  	END CATCH;
	END
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteJobHistory')
	delete from GxQscripts where name = 'daDeleteJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteJobHistory')
	delete from GXDBVersions where aliasname = 'daDeleteJobHistory'
GO

insert into GXDBVersions values(2, 'daDeleteJobHistory',  '00010007005600130000', 'daDeleteJobHistory', '00010007005600130000')
GO

