

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteHistoryDBInfo.sp] ---------- 

--  +========================================================================+
--  |		 Name:  daDeleteHistoryDBInfo()
--  | Description:  Delete archCheckHistory table in HistoryDB
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daDeleteHistoryDBInfo.sp,v $ $Id: daDeleteHistoryDBInfo.sp,v 1.1.2.1 2019/11/07 15:12:29 chandru Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daDeleteHistoryDBInfo')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteHistoryDBInfo <<<'
	drop procedure daDeleteHistoryDBInfo
END
IF EXISTS (select * from GxQscripts where name='daDeleteHistoryDBInfo')
	delete from GxQscripts where name = 'daDeleteHistoryDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteHistoryDBInfo')
	delete from GXDBVersions where aliasname = 'daDeleteHistoryDBInfo'
GO
print '... Creating Procedure: daDeleteHistoryDBInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure daDeleteHistoryDBInfo
AS
  DECLARE @o_errorCode integer;
  DECLARE @o_totalRowsPruned integer;
SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#ACHJobsToPrune') IS NOT NULL DROP TABLE #ACHJobsToPrune
	CREATE TABLE #ACHJobsToPrune (jobId INT, commcellId INT, archCopyId INT PRIMARY KEY (jobId, CommcellId, archCopyId))
	DECLARE	@TotalRowsPruned  INTEGER = 0
	DECLARE @ErrVal INTEGER = 0
	DECLARE @RowCount INTEGER = 0
	DECLARE @ErrorMessage 	NVARCHAR(MAX)
	SET			@ErrorMessage   = ''
	DECLARE @ErrorSeverity INTEGER
	SET			@ErrorSeverity = 0
	DECLARE @ErrorState INTEGER
	SET			@ErrorState = 0
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @maxRowsToPruneInBatch 	INTEGER = 25000
	SELECT	@maxRowsToPruneInBatch = ISNULL(value, 25000)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'DA_CONFIG_MAX_DASH_CHUNK_HISTORIES_TO_PRUNE_IN_BATCH'
	BEGIN TRY
		WHILE (1 = 1)
		BEGIN
			DELETE	TOP (@maxRowsToPruneInBatch) ACH
			FROM	archCheckHistory ACH LEFT OUTER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED)
						ON ACH.JobId = JDS.JobId
						   AND ACH.CommCellId = JDS.commCellId
						   AND ACH.archCopyId = JDS.archGrpCopyId
						   AND JDS.Status != 1000
			WHERE	JDS.JobId IS NULL
			SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
			IF @ErrVal <> 0
			BEGIN
				SET @RetVal = @ErrVal
				BREAK
			END
			IF @RowCount = 0
				BREAK
			ELSE
				SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
		END
		INSERT INTO #ACHJobsToPrune
		SELECT	JobId, CommCellId, archCopyId
		FROM	archCheckHistory WITH (READUNCOMMITTED)
		GROUP BY JobId, CommCellId, archCopyId
		HAVING COUNT(*) > 3
		IF EXISTS ( SELECT 1 FROM #ACHJobsToPrune)
		BEGIN
			; WITH archCheckHistoryRowId_CTE (JobId, CommCellId, archCopyId, archCheckEndTime, RowNum)
			AS
				(SELECT	ACH.JobId, ACH.CommCellId, ACH.archCopyId, ACH.archCheckEndTime,
				ROW_NUMBER() OVER (PARTITION BY ACH.JobId, ACH.CommCellId, ACH.archCopyId ORDER BY ACH.archCheckEndTime DESC) AS RowNum
				FROM	archCheckHistory ACH WITH (READUNCOMMITTED), #ACHJobsToPrune T
				WHERE	ACH.jobId = T.jobId
						AND ACH.commCellId = T.commcellId
						AND ACH.archCopyId = T.archCopyId)
			DELETE ACH
			FROM	archCheckHistory ACH, archCheckHistoryRowId_CTE T
			WHERE	ACH.jobId = T.jobId
					AND ACH.commCellId = T.commcellId
					AND ACH.archCopyId = T.archCopyId
					AND ACH.archCheckEndTime = T.archCheckEndTime
					AND RowNum > 3
			SELECT @RowCount = @@ROWCOUNT
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
		END
	END TRY
  	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @retVal = ERROR_NUMBER()
		SET	@ErrorSeverity = ERROR_SEVERITY()
		SET	@ErrorState = ERROR_STATE()
		SET @ErrorMessage = 'Procedure [' + ERROR_PROCEDURE() + '] Error Number [' + CONVERT(NVARCHAR(15), @retVal) + '] Error Line [' + CONVERT(NVARCHAR(15), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
		;THROW
  	END CATCH;
	SELECT	@RetVal, @TotalRowsPruned
	IF OBJECT_ID('tempdb.dbo.#ACHJobsToPrune') IS NOT NULL DROP TABLE #ACHJobsToPrune
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteHistoryDBInfo')
	delete from GxQscripts where name = 'daDeleteHistoryDBInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteHistoryDBInfo')
	delete from GXDBVersions where aliasname = 'daDeleteHistoryDBInfo'
GO

insert into GXDBVersions values(2, 'daDeleteHistoryDBInfo',  '00010001000200010000', 'daDeleteHistoryDBInfo', '00010001000200010000')
GO

