

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteDanglingAFForSAPCrossCheck.sp] ---------- 

--  +==============================================================================================+
--  |		 Name:  daDeleteDanglingAFForSAPCrossCheck()
--  | Description:  Delete dangling archive files of deleted client\instance before cross check
--  +==============================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daDeleteDanglingAFForSAPCrossCheck.sp,v $ $Id: daDeleteDanglingAFForSAPCrossCheck.sp,v 1.2.10.2 2021/05/21 01:03:17 hkapadia Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daDeleteDanglingAFForSAPCrossCheck')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteDanglingAFForSAPCrossCheck <<<'
	drop procedure daDeleteDanglingAFForSAPCrossCheck
END
IF EXISTS (select * from GxQscripts where name='daDeleteDanglingAFForSAPCrossCheck')
	delete from GxQscripts where name = 'daDeleteDanglingAFForSAPCrossCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteDanglingAFForSAPCrossCheck')
	delete from GXDBVersions where aliasname = 'daDeleteDanglingAFForSAPCrossCheck'
GO
print '... Creating Procedure: daDeleteDanglingAFForSAPCrossCheck'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daDeleteDanglingAFForSAPCrossCheck
  @i_dummy integer
AS
SET NOCOUNT ON
	DECLARE @retVal	INTEGER
	SET 		@retVal = 0
	DECLARE @maxRetry INTEGER
	SET @maxRetry = 2
	SELECT @maxRetry = isnull(value, 2)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_NUMBER_OF_RETRY_ON_LOCK'
	DECLARE @retryCnt INTEGER
	SET @retryCnt = 0
	DECLARE @rowCount INTEGER
	SET @rowCount = 0
	if object_id('tempdb.dbo.#tmpAFToDelete') is not null DROP TABLE #tmpAFToDelete
	CREATE	TABLE #tmpAFToDelete(
			archFileId INTEGER,
			commcellId INTEGER
			)
	CREATE CLUSTERED INDEX Idx_tmpAFToDelete_1 ON #tmpAFToDelete (archFileId, commcellId)
	-----------------------------------------------------------------------------------
	-------- Delete dangling AFs of deleted client\instance from archFileSAP  ---------
	-----------------------------------------------------------------------------------
	WHILE @retryCnt <= @maxRetry
	BEGIN
		BEGIN TRY
		BEGIN
			SET @retVal = 0
			TRUNCATE TABLE #tmpAFToDelete
			INSERT INTO #tmpAFToDelete
			SELECT TOP (5000) AFO.archFileId, AFO.commCellId
			FROM archFileSAP AFO WITH (NOLOCK) LEFT OUTER JOIN APP_Client C WITH (NOLOCK)
				ON  AFO.clientId = C.id
			LEFT OUTER JOIN APP_InstanceName I WITH (NOLOCK)
				ON AFO.instanceId	= I.id
			WHERE (C.id IS NULL OR I.id IS NULL)
			SELECT @rowCount = @@ROWCOUNT
			WHILE (@rowCount > 0)
			BEGIN
				DELETE archFileSAP
				FROM  archFileSAP AFO INNER JOIN #tmpAFToDelete TMP
				ON		AFO.archFileId = TMP.archFileId
				AND		AFO.commcellId = TMP.commcellId
				TRUNCATE TABLE #tmpAFToDelete
				INSERT INTO #tmpAFToDelete
				SELECT TOP (5000) AFO.archFileId, AFO.commCellId
				FROM archFileSAP AFO WITH (NOLOCK) LEFT OUTER JOIN APP_Client C WITH (NOLOCK)
					ON  AFO.clientId = C.id
				LEFT OUTER JOIN APP_InstanceName I WITH (NOLOCK)
					ON AFO.instanceId	= I.id
				WHERE (C.id IS NULL OR I.id IS NULL)
				SELECT @rowCount = @@ROWCOUNT
			END
			BREAK
		END
		END TRY
  	BEGIN CATCH
  	BEGIN
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @retVal = ERROR_NUMBER()
			IF @retVal NOT IN (1222, 1205)
    	BEGIN
    		;THROW --Actually BREAK is not required as THROW will terminate the loop. But BREAK shouldn't harm either. So leaving BREAK to be safe, so we know we won't end up in an infinite loop.
    		BREAK
    	END
    	ELSE
    	BEGIN
    		SET @retryCnt = @retryCnt + 1
    		IF(@retryCnt > @maxRetry)
    		BEGIN
    			;THROW
    		END
    		ELSE
    		BEGIN
	    		WAITFOR DELAY '00:00:05'
	    		CONTINUE
	    	END
    	END
    END
  	END CATCH;
	END
	if object_id('tempdb.dbo.#tmpAFToDelete') is not null DROP TABLE #tmpAFToDelete
	RETURN @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteDanglingAFForSAPCrossCheck')
	delete from GxQscripts where name = 'daDeleteDanglingAFForSAPCrossCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteDanglingAFForSAPCrossCheck')
	delete from GXDBVersions where aliasname = 'daDeleteDanglingAFForSAPCrossCheck'
GO

insert into GXDBVersions values(2, 'daDeleteDanglingAFForSAPCrossCheck',  '00010002001000020000', 'daDeleteDanglingAFForSAPCrossCheck', '00010002001000020000')
GO

