

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daDeleteArchChunkToReplicateInfo.sp] ---------- 

--  +========================================================================+
--  |		Name		:	daDeleteArchChunkToReplicateInfo
--  |		Description	:	Move the rows from ArchChunkToReplicate to ArchChunkToReplicateHistory based on configured Value
--  |		Description	:	Delete the rows from ArchChunkToReplicateHistory based on configured Value
--	|		Author		:	Chandrashekar Maranna.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daDeleteArchChunkToReplicateInfo')
BEGIN
	print '>>> Drop Stored Procedure: daDeleteArchChunkToReplicateInfo <<<'
	drop procedure daDeleteArchChunkToReplicateInfo
END
IF EXISTS (select * from GxQscripts where name='daDeleteArchChunkToReplicateInfo')
	delete from GxQscripts where name = 'daDeleteArchChunkToReplicateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteArchChunkToReplicateInfo')
	delete from GXDBVersions where aliasname = 'daDeleteArchChunkToReplicateInfo'
GO
print '... Creating Procedure: daDeleteArchChunkToReplicateInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daDeleteArchChunkToReplicateInfo
AS
  DECLARE @errorCode integer
BEGIN
	SET NOCOUNT ON
	DECLARE	@TotalRowsMoved  INTEGER = 0
	DECLARE	@TotalRowsPruned INTEGER = 0
	DECLARE @ErrVal INTEGER = 0
	DECLARE @RetVal INTEGER = 0
	DECLARE @RowCount INTEGER = 0
	DECLARE @minJobId	INTEGER = 0
	DECLARE @maxRowsToPruneInBatch 	INTEGER = 25000
	SELECT	@maxRowsToPruneInBatch = ISNULL(value, 25000)
	FROM	MMConfigs
	WHERE	name = 'DA_CONFIG_MAX_DASH_CHUNK_HISTORIES_TO_PRUNE_IN_BATCH'
	DECLARE @daysToKeepInArchChunkToReplicate 	INTEGER = 7
	SELECT	@daysToKeepInArchChunkToReplicate = ISNULL(value, 7)
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_DASHCOPY_JOB_CHUNK_INFO_PRUN_DAYS'
	DECLARE @daysToKeepInArchChunkToReplicateHistory 	INTEGER = 30
	SELECT	@daysToKeepInArchChunkToReplicateHistory = ISNULL(value, 30)
	FROM	MMConfigs
	WHERE	name = 'MMCONFIG_DASHCOPY_JOB_CHUNK_INFO_HISTORY_PRUN_DAYS'
	DECLARE	@currentTime INTEGER = dbo.GetUnixTime(GetUTCDate())
	DECLARE @moveJobsOlderThanTime INTEGER = @currentTime - (@daysToKeepInArchChunkToReplicate * 24 * 60 * 60)
	DECLARE @removeJobsOlderThanTime INTEGER = @currentTime - (@daysToKeepInArchChunkToReplicateHistory * 24 * 60 * 60)
	IF OBJECT_ID('tempDb.dbo.#CompletedDashCopyJobs') IS NOT NULL DROP TABLE #CompletedDashCopyJobs
		CREATE TABLE #CompletedDashCopyJobs
		(
			JobId		INTEGER,
			commCellId 	INTEGER,
			primary key (jobId, commCellId)
		)
	IF OBJECT_ID('tempdb.dbo.#rowsToMove') IS NOT null
		DROP TABLE #rowsToMove
	-- Move the rows older than configured value from ArchChunkToVerify2 to ArchChunkToVerify2History table
	-- Do not move the rows are associated with currently running dashcopy job
	TRUNCATE TABLE #CompletedDashCopyJobs
	SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
	FROM	ArchChunkToVerify2
	INSERT INTO #CompletedDashCopyJobs
	SELECT	JobId, CommCellId
	FROM	JMAdminJobStatsTable WITH (READUNCOMMITTED)
	WHERE	jobId >= @minJobId
			AND CommCellId = 2
			AND opType = 31 /*ARCHIVECHECK*/
			AND servEnd < @moveJobsOlderThanTime
	INSERT INTO #CompletedDashCopyJobs
	SELECT I.adminJobId, I.commCellId
	FROM (
			SELECT	R.adminJobId, R.CommCellId, MAX(R.Modified) maxModifiedTime
			FROM	ArchChunkToVerify2 R  WITH (READUNCOMMITTED) LEFT JOIN JMAdminJobStatsTable JS WITH (READUNCOMMITTED) ON JS.jobID = R.adminJobId
					LEFT JOIN JMAdminJobInfoTable JI WITH (READUNCOMMITTED) ON JI.jobID = R.adminJobId
			WHERE   JS.jobId IS NULL AND JI.jobId IS NULL
			GROUP BY R.adminJobId, R.CommCellId
		 ) I
	WHERE	I.maxModifiedTime < @moveJobsOlderThanTime
	WHILE (1 = 1)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) R
		OUTPUT  DELETED.AdminJobId,DELETED.BackupJobId,DELETED.ArchFileId,DELETED.CommCellId,DELETED.ArchChunkId,DELETED.ChunkCommCellId,DELETED.ChunkNumber,DELETED.SrcCopyId,DELETED.SrcStreamNum,DELETED.DestCopyId,DELETED.DestStreamNum,DELETED.PhysicalStartOffset,DELETED.PhysicalOffset,DELETED.LogicalOffset,DELETED.PhysicalSize,DELETED.LogicalSize,DELETED.unCompBytesSize,DELETED.SrcMAId,DELETED.Status,DELETED.Modified,DELETED.SkippedReason,DELETED.SkippedCount,DELETED.SkippedForSeconds,DELETED.ErrorCode,DELETED.extraFlags,DELETED.segmentId ,DELETED.IsParallelCopy,@currentTime,DELETED.streamReaderID INTO HistoryDB..ArchChunkToVerify2History
		FROM	ArchChunkToVerify2 R, #CompletedDashCopyJobs J
		WHERE	R.adminJobId = J.JobId
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsMoved = @TotalRowsMoved + @RowCount
	END
	-- Removed the rows older than configured value from ArchChunkToVerify2History table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch) R
		FROM	ArchChunkToVerify2History R
		WHERE	R.RowCreated < @removeJobsOlderThanTime
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
	END
	-- Move the rows older than configured value from ArchChunkToRecoverDDB to ArchChunkToRecoverDDBHistory table
	-- Do not move the rows are associated with currently running dashcopy job
	TRUNCATE TABLE #CompletedDashCopyJobs
	SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
	FROM	ArchChunkToRecoverDDB
	INSERT INTO #CompletedDashCopyJobs
	SELECT	JobId, CommCellId
	FROM	JMAdminJobStatsTable WITH (READUNCOMMITTED)
	WHERE	jobId >= @minJobId
			AND CommCellId = 2
			AND opType = 80 /*DEDUPDBSYNC*/
			AND servEnd < @moveJobsOlderThanTime
	INSERT INTO #CompletedDashCopyJobs
	SELECT I.adminJobId, 0
	FROM (
			SELECT	R.adminJobId, MAX(R.Modified) maxModifiedTime
			FROM	ArchChunkToRecoverDDB R  WITH (READUNCOMMITTED) LEFT JOIN JMAdminJobStatsTable JS WITH (READUNCOMMITTED) ON JS.jobID = R.adminJobId
					LEFT JOIN JMAdminJobInfoTable JI WITH (READUNCOMMITTED) ON JI.jobID = R.adminJobId
			WHERE   JS.jobId IS NULL AND JI.jobId IS NULL
			GROUP BY R.adminJobId
		 ) I
	WHERE	I.maxModifiedTime < @moveJobsOlderThanTime
	WHILE (1 = 1)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) R
		OUTPUT  DELETED.AdminJobId,DELETED.VolumeId,DELETED.MinChunkId,DELETED.MaxChunkId,DELETED.CurrChunkId,DELETED.ChunkCommCellId,DELETED.ArchGroupId,DELETED.SrcCopyId,DELETED.SrcStreamNum,DELETED.PhysicalSize,DELETED.LogicalSize,DELETED.unCompBytesSize,DELETED.chunksCount,DELETED.SrcMAId,DELETED.Status,DELETED.Modified,DELETED.SkippedReason,DELETED.SkippedCount,DELETED.SkippedForSeconds,DELETED.ErrorCode,DELETED.extraFlags,DELETED.segmentId,DELETED.streamReaderID,DELETED.processedChunksCount,DELETED.processedUnCompBytesSize,@currentTime INTO HistoryDB..ArchChunkToRecoverDDBHistory
		FROM	ArchChunkToRecoverDDB R, #CompletedDashCopyJobs J
		WHERE	R.adminJobId = J.JobId
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsMoved = @TotalRowsMoved + @RowCount
	END
	-- Removed the rows older than configured value from ArchChunkToRecoverDDBHistory table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch) R
		FROM	ArchChunkToRecoverDDBHistory R
		WHERE	R.RowCreated < @removeJobsOlderThanTime
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
	END
	-- Move the rows older than configured value from ArchChunkToReplicate to ArchChunkToReplicateHistory table
	-- Do not move the rows are associated with currently running dashcopy job
	TRUNCATE TABLE #CompletedDashCopyJobs
	SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
	FROM	ArchChunkToReplicate
	INSERT INTO #CompletedDashCopyJobs
	SELECT	JobId, CommCellId
	FROM	JMAdminJobStatsTable WITH (READUNCOMMITTED)
	WHERE	jobId >= @minJobId
			AND CommCellId = 2
			AND opType IN (104, 74)  /*AUXCOPY2, MEDIAREFRESHING*/
			AND servEnd < @moveJobsOlderThanTime
	INSERT INTO #CompletedDashCopyJobs
	SELECT I.adminJobId, I.commCellId
	FROM (
			SELECT	R.adminJobId, R.CommCellId, MAX(R.Modified) maxModifiedTime
			FROM	ArchChunkToReplicate R  WITH (READUNCOMMITTED) LEFT JOIN JMAdminJobStatsTable JS WITH (READUNCOMMITTED) ON JS.jobID = R.adminJobId
					LEFT JOIN JMAdminJobInfoTable JI WITH (READUNCOMMITTED) ON JI.jobID = R.adminJobId
			WHERE   JS.jobId IS NULL AND JI.jobId IS NULL
			GROUP BY R.adminJobId, R.CommCellId
		 ) I
	WHERE	I.maxModifiedTime < @moveJobsOlderThanTime
	WHILE (1 = 1)
	BEGIN
		DELETE	TOP (@maxRowsToPruneInBatch) R
		OUTPUT  DELETED.AdminJobId,DELETED.BackupJobId,DELETED.ArchFileId,DELETED.CommCellId,DELETED.ArchChunkId,DELETED.ChunkCommCellId,DELETED.ChunkNumber,DELETED.SrcCopyId,DELETED.SrcStreamNum,DELETED.DestCopyId,DELETED.DestStreamNum,DELETED.PhysicalStartOffset,DELETED.PhysicalOffset,DELETED.LogicalOffset,DELETED.PhysicalSize,DELETED.LogicalSize,DELETED.unCompBytesSize,DELETED.SrcMAId,DELETED.Status,DELETED.Modified,DELETED.SkippedReason,DELETED.SkippedCount,DELETED.SkippedForSeconds,DELETED.ErrorCode,DELETED.extraFlags,DELETED.segmentId ,DELETED.IsParallelCopy,@currentTime,DELETED.streamReaderID INTO HistoryDB..ArchChunkToReplicateHistory
		FROM	ArchChunkToReplicate R, #CompletedDashCopyJobs J
		WHERE	R.adminJobId = J.JobId
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsMoved = @TotalRowsMoved + @RowCount
	END
	-- Removed the rows older than configured value from archChunkToReplicateHistory table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch) R
		FROM	ArchChunkToReplicateHistory R
		WHERE	R.RowCreated < @removeJobsOlderThanTime
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
	END
	-- Move the rows older than configured value from ArchChunkToSF to ArchChunkToSFHistory table
	-- Do not move the rows are associated with currently running dashcopy job
	TRUNCATE TABLE #CompletedDashCopyJobs
	SELECT	@minJobId = ISNULL(MIN(adminJobId), 0)
	FROM	ArchChunkToSF
	INSERT INTO #CompletedDashCopyJobs
	SELECT	JobId, CommCellId
	FROm	JMBkpStats WITH (READUNCOMMITTED)
	WHERE	jobId >= @minJobId
			AND CommCellId = 2
			AND opType = 14 /*SYNTHFULL*/
			AND servEndDate < @moveJobsOlderThanTime
	INSERT INTO #CompletedDashCopyJobs
	SELECT I.adminJobId, I.commCellId
	FROM (
			SELECT	R.adminJobId, R.CommCellId, MAX(R.Modified) maxModifiedTime
			FROM	ArchChunkToSF R  WITH (READUNCOMMITTED) LEFT JOIN JMBkpStats JS WITH (READUNCOMMITTED) ON JS.jobID = R.adminJobId
					LEFT JOIN JMBkpJobInfo JI WITH (READUNCOMMITTED) ON JI.jobID = R.adminJobId
			WHERE   JS.jobId IS NULL AND JI.jobId IS NULL
			GROUP BY R.adminJobId, R.CommCellId
		 ) I
	WHERE	I.maxModifiedTime < @moveJobsOlderThanTime
	-- SELECT	*
	-- FROm	JMBkpJobInfo
	-- WHERE	bkpLevel IN (64/*SYNTHETIC_FULL*/, 128 /*SYNTHETIC_FULL_AND_INCR */, 16384 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
	SELECT	*
	INTO	#rowsToMove
	FROM	ArchChunkToSF
	WHERE	1 = 0
	WHILE (1 = 1)
	BEGIN
		DELETE FROM #rowsToMove
		DELETE	TOP (@maxRowsToPruneInBatch) R
		OUTPUT  DELETED.* INTO #rowsToMove
		FROM	ArchChunkToSF R, #CompletedDashCopyJobs J
		WHERE	R.adminJobId = J.JobId
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsMoved = @TotalRowsMoved + @RowCount
		INSERT INTO ArchChunkToSFHistory
		SELECT R.AdminJobId,R.BackupJobId,R.ArchFileId,R.CommCellId,R.ArchChunkId,R.ChunkCommCellId,R.ChunkNumber,R.SrcCopyId,R.SrcStreamNum,R.DestCopyId,R.DestStreamNum,R.PhysicalStartOffset,R.PhysicalOffset,R.LogicalOffset,R.PhysicalSize,R.LogicalSize,R.unCompBytesSize,R.SrcMAId,R.Status,R.Modified,R.SkippedReason,R.SkippedCount,R.SkippedForSeconds,R.ErrorCode,R.extraFlags,R.segmentId ,R.IsParallelCopy,@currentTime,R.streamReaderID
		FROM	#rowsToMove R
		SELECT @ErrVal = @@ERROR
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		DELETE ArchChunkToSFArchfiles
		FROM	ArchChunkToSFArchfiles AR, #rowsToMove R
		WHERE	AR.AdminJobId = R.AdminJobId
				AND AR.ArchFileId = R.ArchFileId
				AND AR.CommCellId = R.CommCellId
		SELECT @ErrVal = @@ERROR
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
	END
	-- Remove orphan rows from ArchChunkToSFArchfiles
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch) R
		FROM	ArchChunkToSFArchfiles R LEFT OUTER JOIN JMJobStats J ON R.AdminJobId = J.JobId AND J.CommCellId = 2
		WHERE	J.JobID IS NULL
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
	END
	-- Removed the rows older than configured value from ArchChunkToSFHistory table
	WHILE (1 = 1)
	BEGIN
		DELETE TOP (@maxRowsToPruneInBatch) R
		FROM	ArchChunkToSFHistory R
		WHERE	R.RowCreated < @removeJobsOlderThanTime
		SELECT @ErrVal = @@ERROR,  @RowCount = @@ROWCOUNT
		IF @ErrVal <> 0
		BEGIN
			SET @RetVal = @ErrVal
			BREAK
		END
		IF @RowCount = 0
			BREAK
		ELSE
			SET @TotalRowsPruned = @TotalRowsPruned + @RowCount
	END
ALL_DONE:
	SELECT	@RetVal, @TotalRowsMoved, @TotalRowsPruned
	IF OBJECT_ID('tempDb.dbo.#CompletedDashCopyJobs') IS NOT NULL DROP TABLE #CompletedDashCopyJobs
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'daDeleteArchChunkToReplicateInfo')
	delete from GxQscripts where name = 'daDeleteArchChunkToReplicateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daDeleteArchChunkToReplicateInfo')
	delete from GXDBVersions where aliasname = 'daDeleteArchChunkToReplicateInfo'
GO

insert into GXDBVersions values(2, 'daDeleteArchChunkToReplicateInfo',  '00000000000000000000', 'daDeleteArchChunkToReplicateInfo', '00000000000000000000')
GO

