

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daClearExtRetentionFlags.sp] ---------- 

--  +========================================================================+
--  |		Name:  				daClearExtRetentionFlags()
--  | 	Description: 	Resets the RetentionFlags for those jobs on copy which
--	|									has no extended retention rules.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daClearExtRetentionFlags.sp,v $ $Id: daClearExtRetentionFlags.sp,v 1.1.294.2 2018/03/20 19:52:04 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daClearExtRetentionFlags <<<'

IF EXISTS (select * from sysobjects where name='daClearExtRetentionFlags')
	drop procedure daClearExtRetentionFlags
IF EXISTS (select * from GxQscripts where name='daClearExtRetentionFlags')
	delete from GxQscripts where name = 'daClearExtRetentionFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daClearExtRetentionFlags')
	delete from GXDBVersions where aliasname = 'daClearExtRetentionFlags'
GO
print '... Creating Procedure: daClearExtRetentionFlags'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daClearExtRetentionFlags
  @i_dummy integer
AS
  DECLARE @o_error integer;
	SET NOCOUNT ON
	DECLARE	@errorCode INTEGER
	SET			@errorCode = 0
	-- Clear the Retention Flags for the jobs on the Copy with no Extended Retention Rules set.
	UPDATE	JMJobDataStats
	SET		retentionFlags = 0
	FROM	JMJobDataStats a LEFT OUTER JOIN archAgingRuleExtended b
	ON		a.archGrpCopyId = b.copyId
	WHERE	b.CopyId IS null
	AND		a.retentionFlags > 0
AND		a.Disabled & 256 = 0
	SELECT	@errorCode = @@ERROR
	IF @errorCode > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	SELECT @errorCode
	RETURN
CX_ERROR_EXIT:
	SELECT -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daClearExtRetentionFlags')
	delete from GxQscripts where name = 'daClearExtRetentionFlags'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daClearExtRetentionFlags')
	delete from GXDBVersions where aliasname = 'daClearExtRetentionFlags'
GO

insert into GXDBVersions values(2, 'daClearExtRetentionFlags',  '00010001029400020000', 'daClearExtRetentionFlags', '00010001029400020000')
GO

