

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daCalculateRetentionTimeForJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daCalculateRetentionTimeForJobs <<<'

IF EXISTS (select * from sysobjects where name='daCalculateRetentionTimeForJobs')
	drop procedure daCalculateRetentionTimeForJobs
IF EXISTS (select * from GxQscripts where name='daCalculateRetentionTimeForJobs')
	delete from GxQscripts where name = 'daCalculateRetentionTimeForJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daCalculateRetentionTimeForJobs')
	delete from GXDBVersions where aliasname = 'daCalculateRetentionTimeForJobs'
GO
print '... Creating Procedure: daCalculateRetentionTimeForJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daCalculateRetentionTimeForJobs
  @i_copyId integer = 0,
  @i_archGrpId integer = 0,
  @i_appId integer = 0
AS
/*
Inputs to this Proc
@i_startTime - @i_endTime -> List of jobs which will age in the given time period
@i_copyId -> Processes the jobs only of this copyID
@i_archGrpId -> Processes the jobs only of this Storage Policy.
@i_appId -> Processes the jobs only of this subclient.
*/
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tempJobRetention') IS NOT NULL DROP TABLE #tempJobRetention
IF OBJECT_ID('tempdb.dbo.#tempARExt') IS NOT NULL	DROP TABLE #tempARExt
IF OBJECT_ID('tempdb.dbo.#lastJobInCycle') IS NOT NULL	DROP TABLE #lastJobInCycle
/*
--Create this table before running this proc
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL	DROP TABLE #tempJobsToProcessForRetention
CREATE TABLE #tempJobsToProcessForRetention (jobId INT, commCellID INT, archGrpCopyId INT, appId INT, retentionEndTime BIGINT)
*/
CREATE TABLE #tempJobRetention (
 		jobId INT, commCellId INT, archGrpCopyId INT,
 		retentionDays BIGINT, extRetentionFlags INT,
 		manualRetentionEndTime BIGINT, manualRetained INT, appId INT ,
		fullCycleNum  INT , jobStartTime BIGINT, AppType INT,retentionEndTime BIGINT
		PRIMARY KEY (jobId, commCellId,archGrpCopyId))
CREATE TABLE #lastJobInCycle(
        appId int, copyId int, fullCycleNum int, jobStartTime int, jobId int, commcellId int, extRetFlags int, retentionDays BIGINT)
CREATE  TABLE #tempARExt (
        copyId          int,
        retentionDays   int,
        retentionRule   int)
CREATE INDEX tempJobRetention_copyId ON #tempJobRetention(archGrpCopyId)
CREATE CLUSTERED INDEX templastLobInCycle_appId ON #lastJobInCycle(appId)
DECLARE @MAXINT				bigint
SET		@MAXINT		=		0x7FFFFFFFFFFFFFFF
DECLARE @populate INT	=		0
DECLARE @retVal	INT = 0
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL
BEGIN
	IF EXISTS (SELECT 1 FROM #tempJobsToProcessForRetention)
	BEGIN
		-- Insert data protection jobs.
		INSERT INTO #tempJobRetention
		SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
					0,B.retentionFlags,
					(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2 , J.appId, J.fullCycleNum , J.servStartDate, J.appType,0
		FROM	JMJobDataStats B WITH (NOLOCK), JmBkpStats J WITH (NOLOCK),#tempJobsToProcessForRetention TJ
		WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
			AND	TJ.jobId = B.jobId AND TJ.archGrpCopyId = B.archGrpCopyId AND TJ.commCellID = B.commCellId
				AND B.status IN (100,102,103)
AND B.disabled & 256 = 0
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		-- Insert admin jobs.
		INSERT INTO #tempJobRetention
		SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
					0,B.retentionFlags,
					(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2 , J.appId, J.fullCycleNum , J.servStart,AAP.appTypeId,0
		FROM	JMJobDataStats B WITH (NOLOCK), JMAdminJobStatsTable J WITH (NOLOCK),APP_Application AAP WITH (NOLOCK),#tempJobsToProcessForRetention TJ
		WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
			AND	TJ.jobId = B.jobId AND TJ.archGrpCopyId = B.archGrpCopyId AND TJ.commCellID = B.commCellId
				AND B.status IN (100,102,103)
				AND	AAP.id = B.appId
AND B.disabled & 256 = 0
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
		SET	@populate = 1
	END
END
IF @populate = 0
BEGIN
	-- Insert data protection jobs.
	INSERT INTO #tempJobRetention
	SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
				0,B.retentionFlags,
				(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2 , J.appId, J.fullCycleNum , J.servStartDate, J.appType,0
	FROM	JMJobDataStats B WITH (NOLOCK), JmBkpStats J WITH (NOLOCK)
	WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
			AND B.status IN (100,102,103)
AND B.disabled & 256 = 0
			AND	(@i_copyId = B.archGrpCopyId OR @i_copyId = 0)
			AND	(@i_archGrpId = B.archGrpId OR @i_archGrpId = 0)
			AND	(@i_appId = B.appId OR @i_appId = 0)
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	-- Insert admin jobs.
	INSERT INTO #tempJobRetention
	SELECT	DISTINCT B.jobId, B.commCellId, B.archGrpCopyId,
				0,B.retentionFlags,
				(case when B.manualRetentionEndTime < 0 then @MAXINT else B.manualRetentionEndTime end) AS manualRetentionEndTime, B.disabled & 2 , J.appId, J.fullCycleNum , J.servStart,AAP.appTypeId,0
	FROM	JMJobDataStats B WITH (NOLOCK), JMAdminJobStatsTable J WITH (NOLOCK),APP_Application AAP WITH (NOLOCK)
	WHERE	B.commCellId = J.commCellId AND B.jobId = J.jobId
			AND B.status IN (100,102,103)
AND B.disabled & 256 = 0
			AND	AAP.id = B.appId
			AND	(@i_copyId = B.archGrpCopyId OR @i_copyId = 0)
			AND	(@i_archGrpId = B.archGrpId OR @i_archGrpId = 0)
			AND	(@i_appId = B.appId OR @i_appId = 0)
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
-- Update the retention days (archiver days or regular days)
UPDATE  #tempJobRetention
SET     retentionDays = (CASE WHEN ISNULL(HI.isDMAppType, 0) = 0 THEN AR.retentionDays ELSE AR.archiverRetDays END)
FROM    #tempJobRetention T
        INNER JOIN archAgingRule AR WITH (NOLOCK)
            ON AR.copyId = T.archGrpCopyId
        LEFT OUTER JOIN APP_IDATypeHandlingInfo HI WITH (NOLOCK)
            ON HI.appTypeId = T.appType
WHERE   manualRetentionEndTime <> @MAXINT
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
-- Get the list of subclients on which we need to perform the opration the rest of the calculation
DECLARE @tempAppCopyCycle table(appId int, copyId int, fullcycleNum int)
INSERT @tempAppCopyCycle
SELECT DISTINCT appId, archGrpCopyId, fullCycleNum
FROM #tempJobRetention J INNER JOIN APP_Application APP WITH(NOLOCK) ON J.appId = APP.id
LEFT OUTER JOIN APP_IDATypeHandlingInfo HI WITH(NOLOCK) ON HI.appTypeId = APP.appTypeId
WHERE ISNULL(HI.isDMAppType, 0) = 0
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
INSERT INTO #lastJobInCycle
SELECT J.appId, J.copyId, J.fullCycleNum, MAX(JBKP.servStartDate), 0, 0, 0, 0
FROM @tempAppCopyCycle J INNER JOIN
JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId AND J.fullCycleNum = JBKP.fullCycleNum
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
GROUP BY J.appId, J.copyId, J.fullCycleNum
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
UPDATE #lastJobInCycle
SET jobId = JBKP.jobId, commcellId = JBKP.commcellId, extRetFlags = JDS.retentionFlags
FROM #lastJobInCycle J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId AND J.jobStartTime = JBKP.servStartDate
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
INSERT INTO #lastJobInCycle
SELECT J.appId, J.copyId, J.fullCycleNum, MAX(AJ.servStart), 0, 0, 0, 0
FROM @tempAppCopyCycle J INNER JOIN
JMAdminJobStatsTable AJ WITH(NOLOCK) ON J.appId = AJ.appId AND J.fullCycleNum = AJ.fullCycleNum
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
GROUP BY J.appId, J.copyId, J.fullCycleNum
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
UPDATE #lastJobInCycle
SET jobId = AJ.jobId, commcellId = AJ.commcellId, extRetFlags = JDS.retentionFlags
FROM #lastJobInCycle J INNER JOIN JMAdminJobStatsTable AJ WITH(NOLOCK) ON J.appId = AJ.appId AND J.jobStartTime = AJ.servStart
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
-- Update job's retentionDays
UPDATE  #lastJobInCycle
SET     retentionDays = AR.retentionDays
FROM    archAgingRule AR WITH (NOLOCK)
WHERE   #lastJobInCycle.copyId = AR.copyId
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
--Insert extended retention entries
INSERT  INTO #tempARExt
SELECT  ARE.copyId, ARE.retentionDays, ARE.retentionRule
FROM    (SELECT DISTINCT archGrpCopyId FROM #tempJobRetention) T,
        archAgingRuleExtended ARE WITH (NOLOCK)
WHERE   ARE.copyId = T.archGrpCopyId
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF @@ERROR = 0 AND EXISTS(SELECT 1 FROM #tempARExt)
BEGIN
    UPDATE  #tempJobRetention
    SET     extRetentionFlags = (
            CASE
                                WHEN (extRetentionFlags & (64|4096)) <> 0     AND (T.retentionRules & 64) <> 0 THEN 64            /*EXTENDED_YEAR | EXTENDED_GRACE_YEAR*/
                                WHEN (extRetentionFlags & (32|2048)) <> 0     AND (T.retentionRules & 32) <> 0 THEN 32            /*EXTENDED_HALFYEAR | EXTENDED_GRACE_HALFYEAR*/
                                WHEN (extRetentionFlags & (16|1024)) <> 0     AND (T.retentionRules & 16) <> 0 THEN 16            /*EXTENDED_QUARTER | EXTENDED_GRACE_QUARTER*/
                                WHEN (extRetentionFlags & (8|512)) <> 0       AND (T.retentionRules & 8) <> 0 THEN 8              /*EXTENDED_MONTH | EXTENDED_GRACE_MONTH*/
                                WHEN (extRetentionFlags & (4|256)) <> 0       AND (T.retentionRules & 4) <> 0 THEN 4              /*EXTENDED_WEEK | EXTENDED_GRACE_WEEK*/
                                WHEN (extRetentionFlags & (524288)) <> 0      AND (T.retentionRules & 524288) <> 0 THEN 524288    /*EXTENDED_GRACE_DAY*/
                                WHEN (extRetentionFlags & (262144)) <> 0      AND (T.retentionRules & 262144) <> 0 THEN 262144    /*EXTENDED_GRACE_HOUR*/
                                WHEN (extRetentionFlags & (2))<> 0            AND (T.retentionRules & 2) <> 0 THEN 2              /*EXTENDED_ALLFULL*/
                                ELSE 0
                            END)
    FROM    (SELECT copyId, SUM(retentionRule) AS retentionRules FROM #tempARExt GROUP BY copyId) T
    WHERE   #tempJobRetention.archGrpCopyId = T.copyId
        AND #tempJobRetention.retentionDays >= 0 AND #tempJobRetention.extRetentionFlags <> 0
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
    UPDATE  #tempJobRetention
    SET     retentionDays = b.retentionDays
    FROM    #tempJobRetention a, #tempARExt b
    WHERE   a.extRetentionFlags = b.retentionRule AND a.archGrpCopyId = b.copyId
        AND a.retentionDays >= 0 AND (a.retentionDays < b.retentionDays OR b.retentionDays < 0)
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
    UPDATE  #lastJobInCycle
    SET     extRetFlags = (
                CASE
                                WHEN (extRetFlags & (64|4096)) <> 0     AND (T.retentionRules & 64) <> 0 THEN 64            /*EXTENDED_YEAR | EXTENDED_GRACE_YEAR*/
                                WHEN (extRetFlags & (32|2048)) <> 0     AND (T.retentionRules & 32) <> 0 THEN 32            /*EXTENDED_HALFYEAR | EXTENDED_GRACE_HALFYEAR*/
                                WHEN (extRetFlags & (16|1024)) <> 0     AND (T.retentionRules & 16) <> 0 THEN 16            /*EXTENDED_QUARTER | EXTENDED_GRACE_QUARTER*/
                                WHEN (extRetFlags & (8|512)) <> 0       AND (T.retentionRules & 8) <> 0 THEN 8              /*EXTENDED_MONTH | EXTENDED_GRACE_MONTH*/
                                WHEN (extRetFlags & (4|256)) <> 0       AND (T.retentionRules & 4) <> 0 THEN 4              /*EXTENDED_WEEK | EXTENDED_GRACE_WEEK*/
                                WHEN (extRetFlags & (524288)) <> 0      AND (T.retentionRules & 524288) <> 0 THEN 524288    /*EXTENDED_GRACE_DAY*/
                                WHEN (extRetFlags & (262144)) <> 0      AND (T.retentionRules & 262144) <> 0 THEN 262144    /*EXTENDED_GRACE_HOUR*/
                                WHEN (extRetFlags & (2))<> 0            AND (T.retentionRules & 2) <> 0 THEN 2              /*EXTENDED_ALLFULL*/
                                ELSE 0
				END)
	FROM    (SELECT copyId, SUM(retentionRule) AS retentionRules FROM #tempARExt GROUP BY copyId) T
	WHERE   #lastJobInCycle.copyId = T.copyId
            AND #lastJobInCycle.retentionDays >= 0 AND #lastJobInCycle.extRetFlags <> 0
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
	UPDATE  #lastJobInCycle
	SET     retentionDays = b.retentionDays
	FROM    #lastJobInCycle a, #tempARExt b
	WHERE   a.extRetFlags = b.retentionRule AND a.copyId = b.copyId
		AND a.retentionDays >= 0 AND (a.retentionDays < b.retentionDays OR b.retentionDays < 0)
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
UPDATE #tempJobRetention SET manualRetentionEndTime = CASE WHEN manualRetentionEndTime = @MAXINT OR J.retentionDays = -1 THEN manualRetentionEndTime
                                    WHEN LJ.retentionDays = -1 THEN @MAXINT
                                    WHEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) > ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime)
                                            AND ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) > manualRetentionEndTime
                                            THEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime)
                                    ELSE manualRetentionEndTime END
FROM #tempJobRetention J INNER JOIN #lastJobInCycle LJ ON J.appId = LJ.appId AND J.fullCycleNum = LJ.fullCycleNum AND J.archGrpCopyId = LJ.copyId AND J.jobId <> LJ.jobId
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
UPDATE	J
SET	retentionEndTime = CASE
							WHEN	manualRetentionEndTime = @MAXINT THEN -1
							ELSE	CASE
										WHEN	retentionDays >= 0 THEN
																			CASE
																				WHEN (manualRetentionEndTime) > (jobStartTime + (retentionDays)*24*60*60) THEN (manualRetentionEndTime)
																				ELSE (jobStartTime + (retentionDays)*24*60*60)
																			END
										ELSE	retentionDays
									END
						END
FROM	#tempJobRetention J
SET @retVal = @@ERROR
IF  @retVal <> 0 GOTO FINISH
IF OBJECT_ID('tempdb.dbo.#tempJobsToProcessForRetention') IS NOT NULL
BEGIN
	IF EXISTS (SELECT 1 FROM #tempJobsToProcessForRetention)
	BEGIN
		UPDATE	J
		SET		J.retentionEndTime = R.retentionEndTime
		FROM	#tempJobsToProcessForRetention J , #tempJobRetention R
		WHERE	J.jobId = R.jobId AND J.archGrpCopyId = R.archGrpCopyId AND J.commcellID = R.commcellID
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
	ELSE
	BEGIN
		INSERT INTO #tempJobsToProcessForRetention
		SELECT	jobId , commCellId , archGrpCopyId , appId  , retentionEndTime
		FROM	#tempJobRetention
		SET @retVal = @@ERROR
		IF  @retVal <> 0 GOTO FINISH
	END
END
ELSE
BEGIN
 	SELECT	jobId , commCellId , archGrpCopyId , appId  , retentionEndTime
	FROM	#tempJobRetention
	SET @retVal = @@ERROR
	IF  @retVal <> 0 GOTO FINISH
END
FINISH:
IF OBJECT_ID('tempdb.dbo.#tempJobRetention') IS NOT NULL DROP TABLE #tempJobRetention
IF OBJECT_ID('tempdb.dbo.#tempARExt') IS NOT NULL	DROP TABLE #tempARExt
IF OBJECT_ID('tempdb.dbo.#lastJobInCycle') IS NOT NULL	DROP TABLE #lastJobInCycle
IF OBJECT_ID('tempdb.dbo.#tblResultDaCalculateRetentionTimeForJobs') IS NOT NULL
BEGIN
	INSERT INTO #tblResultDaCalculateRetentionTimeForJobs
	SELECT	@retVal
END
ELSE
	SELECT	@retVal
RETURN 	@retVal
GO

IF EXISTS (select * from GxQscripts where name = 'daCalculateRetentionTimeForJobs')
	delete from GxQscripts where name = 'daCalculateRetentionTimeForJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daCalculateRetentionTimeForJobs')
	delete from GXDBVersions where aliasname = 'daCalculateRetentionTimeForJobs'
GO

insert into GXDBVersions values(2, 'daCalculateRetentionTimeForJobs',  '00000000000000000000', 'daCalculateRetentionTimeForJobs', '00000000000000000000')
GO

