

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyVSAJobLinkRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyVSAJobLinkRule.sp,v $ $Id: daApplyVSAJobLinkRule.sp,v 1.2.56.2 2018/12/27 16:44:18 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyVSAJobLinkRule()
--  |
--  | Description:  Apply Job Link Rule for VSA jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplyVSAJobLinkRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyVSAJobLinkRule <<<'
	drop procedure daApplyVSAJobLinkRule
END
IF EXISTS (select * from GxQscripts where name='daApplyVSAJobLinkRule')
	delete from GxQscripts where name = 'daApplyVSAJobLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyVSAJobLinkRule')
	delete from GXDBVersions where aliasname = 'daApplyVSAJobLinkRule'
GO
print '... Creating Procedure: daApplyVSAJobLinkRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyVSAJobLinkRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	CREATE TABLE #VSAJobsToRetain (
			jobId					INTEGER,
			childJobId		INTEGER,
 			commCellId 		INTEGER
 			PRIMARY KEY (jobId, childJobId, commCellId)
			)
	CREATE TABLE #VSAJobsOnCopy (
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			archGrpId 		INTEGER,
 			archGrpCopyId INTEGER,
 			appId					INTEGER,
 			retentionDays	INTEGER,
 			isBad					INTEGER,
 			appFlags		BIGINT,
 			retained 			INTEGER
 			PRIMARY KEY (JobId, CommCellId, archGrpCopyId)
			)
	CREATE TABLE #VSAJobMaxRet (
			JobId 				INTEGER,
			CommCellId 		INTEGER,
			archGrpId 		INTEGER,
			retentionDays INTEGER,
			Primary Key (JobId, CommCellId, archGrpId)
			)
	CREATE TABLE #VSACyclesToRetain (
 			appId					INTEGER,
 			archGrpCopyId INTEGER,
 			fullCycleNum	INTEGER,
 			StartTime			INTEGER,
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			PRIMARY KEY (appId, archGrpCopyId, fullCycleNum)
			)
	CREATE INDEX Idx_tmpVSACyclesToRetain_JobId_commCellId_archGrpCopyId ON #VSACyclesToRetain (JobId, CommCellId, archGrpCopyId)
	-------------------------------------------------------------------------------
	---------------------- Apply Job Link Rule for VSA jobs -----------------------
	-------------------------------------------------------------------------------
		-- Get all VSA jobs that are linked to non-aged child Jobs
		INSERT	INTO #VSAJobsToRetain
		SELECT	DISTINCT VAJ.parentJobId, VAJ.childJobId, VAJ.commCellId
FROM	#DA_JobCopyList JCL, JMVSAAppJobLink VAJ WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
		WHERE	JCL.JobId = VAJ.parentJobId
		AND 	JCL.CommCellId = VAJ.CommCellId
		AND		VAJ.childJobId = JDS.JobId
		AND		VAJ.CommCellId = JDS.CommCellId
		AND		JDS.status = 100
AND		JDS.disabled & 256 = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get VSA jobs on all available copies
		INSERT	INTO #VSAJobsOnCopy
		SELECT	JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END,
MAX(JC.JobFlags & 1), JC.appFlags, 0
FROM	#VSAJobsToRetain T, #DA_JobCopyList JC, ArchAppCopyToBeAged AC
		WHERE	T.jobId = JC.jobId
		AND 	T.commCellId = JC.commCellId
		AND		JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.FileType = AC.FileType
		AND		JC.dataStatus = 100
		GROUP BY JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END, JC.appFlags
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention and not marked BAD
		INSERT	INTO #VSAJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#VSAJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
		AND			TMP.isBad = 0
AND			A.appFlags & 33554432 = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention if no good job found
		INSERT	INTO #VSAJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#VSAJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		NOT EXISTS (SELECT T.JobId FROM #VSAJobMaxRet AS T
											WHERE TMP.JobId = T.jobId
											AND 	TMP.CommCellId = T.CommCellId
											AND		TMP.archGrpId = T.archGrpId)
		AND			TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
AND			A.appFlags & 33554432 = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- VSA Jobs linked to non-aged App jobs on same copy cannot be aged
		UPDATE a
		SET retained = 1
FROM #VSAJobsOnCopy a, #VSAJobsToRetain b, JMJobDataStats c WITH (NOLOCK)
		WHERE	a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND		b.childJobId = c.jobId
		AND		b.CommCellId = c.CommCellId
--AND		a.appFlags & 33554432 = 0
		AND		a.archGrpCopyId = c.archGrpCopyId
		AND		c.status = 100
AND		c.disabled & 256 = 0
		-- VSA Jobs linked to non-aged App jobs on highest retention copy cannot be aged
		UPDATE	a
		SET 	retained = 1
		FROM	#VSAJobsOnCopy a
		INNER JOIN #VSAJobMaxRet b
		ON 		a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND		a.archGrpId = b.archGrpId
		AND		a.retentionDays = b.retentionDays
AND 	a.appFlags & 33554432 = 0
		LEFT OUTER JOIN #VSAJobsOnCopy c ON a.jobId = c.JobId AND a.CommCellId = c.CommCellId AND c.retained = 1
		WHERE c.JobId IS NULL
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	a
SET 	jobRetainReason = a.jobRetainReason | 1024
		FROM	#DA_JobCopyList a INNER JOIN #VSAJobsOnCopy b ON a.jobId = b.jobId AND a.commcellId = b.commcellId AND a.copyId = b.archGrpCopyId
		WHERE 	b.retained = 1
		-- Get the cycle numbers of VSA linked jobs that are retained on highest retention copy
		-- Exclude snap copies as snap don't need entire VSA cycle for restorability of application jobs
		INSERT INTO #VSACyclesToRetain
		SELECT a.appId, a.CopyId, a.fullCycleNum, MAX(a.startTime), 0, 0
		FROM	#DA_JobCopyList a, #DA_AppCopyList b, #VSAJobsOnCopy c
		WHERE a.appId = b.appId
		AND   a.CopyId = b.CopyId
		AND   a.fileType = b.fileType
		AND   b.copyIsSnap = 0
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND 	a.CopyId = c.archGrpCopyId
AND		a.appFlags & 33554432 = 0
AND		a.jobRetainReason & 1024 > 0
		GROUP BY a.appId, a.CopyId, a.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get the latest jobId in the cycle that will keep the cycle image
		UPDATE	#VSACyclesToRetain
		SET 	jobId = b.jobId,
					commCellId = b.commCellId
		FROM	#VSACyclesToRetain a, #DA_JobCopyList b
		WHERE a.appId = b.appId
		AND		a.archGrpCopyId = b.CopyId
		AND		a.fullCycleNum = b.fullCycleNum
		AND		a.startTime = b.startTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain all VSA Jobs in same cycle that ran before VSA linked job for cycle dependency
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
		FROM	#DA_JobCopyList a, #VSACyclesToRetain b
		WHERE a.appId = b.appId
		AND 	a.CopyId = b.archGrpCopyId
		AND 	a.fullCycleNum = b.fullCycleNum
		AND		a.startTime <= b.startTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyVSAJobLinkRule')
	delete from GxQscripts where name = 'daApplyVSAJobLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyVSAJobLinkRule')
	delete from GXDBVersions where aliasname = 'daApplyVSAJobLinkRule'
GO

insert into GXDBVersions values(2, 'daApplyVSAJobLinkRule',  '00010002005600020000', 'daApplyVSAJobLinkRule', '00010002005600020000')
GO

