

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyTrueUpJobRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyTrueUpJobRule.sp,v $ $Id: daApplyTrueUpJobRule.sp,v 1.1.2.4 2018/12/27 16:34:25 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyTrueUpJobRule()
--  |
--  | Description:  Apply True-Up Job Rule for FS jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplyTrueUpJobRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyTrueUpJobRule <<<'
	drop procedure daApplyTrueUpJobRule
END
IF EXISTS (select * from GxQscripts where name='daApplyTrueUpJobRule')
	delete from GxQscripts where name = 'daApplyTrueUpJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyTrueUpJobRule')
	delete from GXDBVersions where aliasname = 'daApplyTrueUpJobRule'
GO
print '... Creating Procedure: daApplyTrueUpJobRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyTrueUpJobRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	IF OBJECT_ID('tempdb.dbo.#tmpAppIdtoCheck') IS NOT NULL DROP TABLE #tmpAppIdtoCheck
	CREATE TABLE #tmpAppIdtoCheck (
			appId								INTEGER,
			currCycleNum				INTEGER,
			isCurrFullSynthFull	INTEGER,
			retainJobsFromTime 	INTEGER
 			PRIMARY KEY (appId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpTrueUpJobInfo') IS NOT NULL DROP TABLE #tmpTrueUpJobInfo
	CREATE TABLE #tmpTrueUpJobInfo (
			appId								INTEGER,
			jobId								INTEGER,
 			CommCellId 					INTEGER,
			fullCycleNum				INTEGER,
			isBad								INTEGER
 			PRIMARY KEY (appId, jobId, CommCellId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpPreviousFullStartTime') IS NOT NULL DROP TABLE #tmpPreviousFullStartTime
	CREATE TABLE #tmpPreviousFullStartTime (
			appId								INTEGER,
			jobStartTime				INTEGER
 			PRIMARY KEY (appId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnCopy') IS NOT NULL DROP TABLE #tmpJobsOnCopy
	CREATE TABLE #tmpJobsOnCopy (
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			archGrpId 		INTEGER,
 			archGrpCopyId INTEGER,
 			appId					INTEGER,
 			retentionDays	INTEGER,
 			isBad					INTEGER,
 			copyIsSnap		INTEGER
 			PRIMARY KEY (JobId, CommCellId, archGrpCopyId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpJobMaxRet') IS NOT NULL DROP TABLE #tmpJobMaxRet
	CREATE TABLE #tmpJobMaxRet (
			JobId 				INTEGER,
			CommCellId 		INTEGER,
			archGrpId 		INTEGER,
			retentionDays INTEGER,
			Primary Key (JobId, CommCellId, archGrpId)
			)
	DECLARE	@honorTrueUpJobCheckRule		INTEGER
	SET			@honorTrueUpJobCheckRule		= 1
	DECLARE	@applyTrueUpJobCheckOnlyForSynthFull		INTEGER
	SET			@applyTrueUpJobCheckOnlyForSynthFull		= 1
	-------------------------------------------------------------------------------
	--------------------- Apply True-Up job Rule for FS jobs ----------------------
	-------------------------------------------------------------------------------
	SELECT @honorTrueUpJobCheckRule = isnull(value, 1)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_HONOR_TRUEUP_JOB_CHECK_RULE'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SELECT @applyTrueUpJobCheckOnlyForSynthFull = isnull(value, 1)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_APPLY_TRUEUP_JOB_CHECK_ONLY_FOR_SYNTH_FULL'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @honorTrueUpJobCheckRule = 1
	BEGIN
		-- Get all appIds that are eligible for trueup job check
		-- Do not consider de-configured or deleted subclients
		INSERT	INTO #tmpAppIdtoCheck
		SELECT	DISTINCT AppId, -1, 0, 0
		FROM		#DA_AppCopyList
WHERE		(AppFlags & 8388608) = 8388608
AND			(appFlags & (65536 | 32768)) = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get current cycle number
		UPDATE #tmpAppIdtoCheck
		SET currCycleNum = CAST(b.attrVal AS INT)
		FROM		#tmpAppIdtoCheck T, App_SubclientProp B WITH (NOLOCK)
		WHERE		T.AppId = B.componentNameId
		AND			B.attrName = 'sys:full cycle num'
		AND			B.modified = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpAppIdtoCheck
		SET currCycleNum = C.lastCycleNum
		FROM		#tmpAppIdtoCheck T, (SELECT B.appId, MAX(B.fullCycleNum) lastCycleNum
																 FROM JMBkpStats B WITH (NOLOCK), #tmpAppIdtoCheck TMP
																 WHERE	B.appId = TMP.appId
																 GROUP BY B.appId) C
		WHERE		T.appId = C.appId
		AND			T.currCycleNum = -1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Check if latest Full is Synth Full job
		UPDATE #tmpAppIdtoCheck
		SET 	 isCurrFullSynthFull = CASE WHEN JBKP.bkpLevel = 64 THEN 1 ELSE 0 END
		FROM		#tmpAppIdtoCheck T, JMBkpStats JBKP WITH (NOLOCK)
		WHERE		T.appId = JBKP.appId
		AND			T.currCycleNum = JBKP.fullCycleNum
		AND			JBKP.bkpLevel IN (1, 64, 128, 1024, 32768, 131072, 262144)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Exclude appIds with no cycle found
		DELETE #tmpAppIdtoCheck
		WHERE currCycleNum = -1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Exclude appIds if current Full is not Synth Full
		IF @applyTrueUpJobCheckOnlyForSynthFull = 1
		BEGIN
			DELETE #tmpAppIdtoCheck
			WHERE isCurrFullSynthFull = 0
		END
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get all TrueUp jobs
		INSERT INTO #tmpTrueUpJobInfo
SELECT JC.appId, JC.jobId, JC.commCellId, JC.fullCycleNum, MIN(JC.JobFlags & 1)
		FROM 	#DA_JobCopyList JC, JMBkpStats JBKP WITH (NOLOCK)
		WHERE JC.jobId = JBKP.jobId
		AND		JC.commcellId = JBKP.commcellId
		AND		JBKP.bkpAttributesEx & 0x8000000000 > 0
		GROUP BY JC.appId, JC.jobId, JC.commCellId, JC.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get all TrueUp jobs that completed in scan phase and has no data
		INSERT INTO #tmpTrueUpJobInfo
		SELECT JBKP.appId, JBKP.jobId, JBKP.commCellId, JBKP.fullCycleNum, 0
		FROM 	#tmpAppIdtoCheck T, JMBkpStats JBKP WITH (NOLOCK)
		WHERE T.appId = JBKP.appId
		AND		JBKP.bkpAttributesEx & 0x8000000000 > 0
		AND 	NOT EXISTS (SELECT TMP.jobId
											FROM #tmpTrueUpJobInfo AS TMP
											WHERE TMP.jobId = JBKP.jobId
											AND		TMP.commcellId = JBKP.commcellId
											AND		TMP.appId = JBKP.appId
											AND		TMP.fullCycleNum = JBKP.fullCycleNum)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Exclude appIds if trueUp job ran for current cycle
		DELETE #tmpAppIdtoCheck
		FROM #tmpAppIdtoCheck T, #tmpTrueUpJobInfo T1
		WHERE T.appId = T1.appId
		AND		T.currCycleNum = T1.fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get previous available Full job start time where trueUp job ran in that cycle and job is marked good
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC INNER JOIN #tmpAppIdtoCheck T1
		ON		JC.appId = T1.appId
		INNER JOIN JMBkpStats JBKP WITH (NOLOCK)
		ON 		JC.appId = JBKP.appId
		AND		JC.fullCycleNum = JBKP.fullCycleNum
		LEFT OUTER JOIN #tmpTrueUpJobInfo T
		ON 		JC.appId = T.appId
		AND		JC.fullCycleNum = T.fullCycleNum
		WHERE JC.BkpLevel = 1
AND		(JC.JobFlags & 1) = 0
		AND		JC.fullCycleNum < T1.currCycleNum
		AND		(
						(T.fullCycleNum IS NOT NULL AND	T.isBad = 0)
						OR
						(T.fullCycleNum IS NULL AND JBKP.bkpLevel IN (1, 128, 1024, 32768, 131072, 262144))
					)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--If no good trueUp job found in previous cycle(s) than get previous available Full job start time where trueUp job ran in that cycle
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC INNER JOIN #tmpAppIdtoCheck T1
		ON		JC.appId = T1.appId
		INNER JOIN JMBkpStats JBKP WITH (NOLOCK)
		ON 		JC.appId = JBKP.appId
		AND		JC.fullCycleNum = JBKP.fullCycleNum
		LEFT OUTER JOIN #tmpTrueUpJobInfo T
		ON 		JC.appId = T.appId
		AND		JC.fullCycleNum = T.fullCycleNum
		WHERE JC.BkpLevel = 1
AND		(JC.JobFlags & 1) = 0
		AND		JC.fullCycleNum < T1.currCycleNum
		AND		(
						(T.fullCycleNum IS NOT NULL)
						OR
						(T.fullCycleNum IS NULL AND JBKP.bkpLevel IN (1, 128, 1024, 32768, 131072, 262144))
					)
		AND 	NOT EXISTS (SELECT TMP.appId
											FROM #tmpPreviousFullStartTime AS TMP
											WHERE T1.appId = TMP.appId)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--If no trueUp job found in previous good cycle(s) than get any previous available Full job start time where trueUp job ran in that cycle
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC INNER JOIN #tmpAppIdtoCheck T1
		ON		JC.appId = T1.appId
		INNER JOIN JMBkpStats JBKP WITH (NOLOCK)
		ON 		JC.appId = JBKP.appId
		AND		JC.fullCycleNum = JBKP.fullCycleNum
		LEFT OUTER JOIN #tmpTrueUpJobInfo T
		ON 		JC.appId = T.appId
		AND		JC.fullCycleNum = T.fullCycleNum
		WHERE JC.BkpLevel = 1
		AND		JC.fullCycleNum < T1.currCycleNum
		AND		(
						(T.fullCycleNum IS NOT NULL)
						OR
						(T.fullCycleNum IS NULL AND JBKP.bkpLevel IN (1, 128, 1024, 32768, 131072, 262144))
					)
		AND 	NOT EXISTS (SELECT TMP.appId
											FROM #tmpPreviousFullStartTime AS TMP
											WHERE T1.appId = TMP.appId)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--If no trueUp job found in any previous cycle(s) than get most recent available good Full job start time from previous cycle(s)
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC, #tmpAppIdtoCheck T1
		WHERE JC.appId = T1.appId
		AND		JC.fullCycleNum < T1.currCycleNum
		AND 	JC.BkpLevel = 1
AND		(JC.JobFlags & 1) = 0
		AND 	NOT EXISTS (SELECT TMP.appId
											FROM #tmpPreviousFullStartTime AS TMP
											WHERE T1.appId = TMP.appId)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--If no good Full job found in any previous cycle(s) than get most recent any available Full job start time from previous cycle(s)
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC, #tmpAppIdtoCheck T1
		WHERE JC.appId = T1.appId
		AND		JC.fullCycleNum < T1.currCycleNum
		AND 	JC.BkpLevel = 1
		AND 	NOT EXISTS (SELECT TMP.appId
											FROM #tmpPreviousFullStartTime AS TMP
											WHERE T1.appId = TMP.appId)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--If no Full job found in any previous cycle(s) than get most recent available Full job start time
		INSERT INTO #tmpPreviousFullStartTime
		SELECT JC.appId, MAX(JC.StartTime)
		FROM 	#DA_JobCopyList JC, #tmpAppIdtoCheck T1
		WHERE JC.appId = T1.appId
		AND 	JC.BkpLevel = 1
		AND 	NOT EXISTS (SELECT TMP.appId
											FROM #tmpPreviousFullStartTime AS TMP
											WHERE T1.appId = TMP.appId)
		GROUP BY JC.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tmpAppIdtoCheck
		SET 	 retainJobsFromTime = T1.jobStartTime
		FROM 	 #tmpAppIdtoCheck T, #tmpPreviousFullStartTime T1
		WHERE  T.appId = T1.appId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get jobs to retain on all available copies
		INSERT	INTO #tmpJobsOnCopy
		SELECT	JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END,
MAX(JC.JobFlags & 1), AC.copyIsSnap
FROM	#tmpAppIdtoCheck T, #DA_JobCopyList JC, ArchAppCopyToBeAged AC
		WHERE	T.appId = JC.appId
		AND 	T.retainJobsFromTime <= JC.startTime
		AND		JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.FileType = AC.FileType
		AND		JC.dataStatus = 100
		GROUP BY JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END, AC.copyIsSnap
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention and not marked BAD
		INSERT	INTO #tmpJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tmpJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
		AND			TMP.isBad = 0
		AND			TMP.copyIsSnap = 0		--MR# 221274 - Do Not honor Trueup rule on snap copies
AND			A.appFlags & (1048576 | 33554432) = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention if no good job found
		INSERT	INTO #tmpJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tmpJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		NOT EXISTS (SELECT T.JobId FROM #tmpJobMaxRet AS T
											WHERE TMP.JobId = T.jobId
											AND 	TMP.CommCellId = T.CommCellId
											AND		TMP.archGrpId = T.archGrpId)
		AND			TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
		AND			TMP.copyIsSnap = 0		--MR# 221274 - Do Not honor Trueup rule on snap copies
AND			A.appFlags & (1048576 | 33554432) = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain jobs on highest retention copy until new trueUp job runs
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 134217728
		FROM	#DA_JobCopyList a, #tmpJobsOnCopy b, #tmpJobMaxRet c
		WHERE	a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND 	a.CopyId = b.archGrpCopyId
		AND		b.JobId = c.JobId
		AND 	b.CommCellId = c.CommCellId
		AND		b.archGrpId = c.archGrpId
		AND		b.retentionDays = c.retentionDays
		AND		a.dataStatus = 100
		AND		b.copyIsSnap = 0		--MR# 221274 - Do Not honor Trueup rule on snap copies
AND		a.appFlags & (1048576 | 33554432) = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpAppIdtoCheck') IS NOT NULL DROP TABLE #tmpAppIdtoCheck
	IF OBJECT_ID('tempdb.dbo.#tmpTrueUpJobInfo') IS NOT NULL DROP TABLE #tmpTrueUpJobInfo
	IF OBJECT_ID('tempdb.dbo.#tmpPreviousFullStartTime') IS NOT NULL DROP TABLE #tmpPreviousFullStartTime
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnCopy') IS NOT NULL DROP TABLE #tmpJobsOnCopy
	IF OBJECT_ID('tempdb.dbo.#tmpJobMaxRet') IS NOT NULL DROP TABLE #tmpJobMaxRet
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyTrueUpJobRule')
	delete from GxQscripts where name = 'daApplyTrueUpJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyTrueUpJobRule')
	delete from GXDBVersions where aliasname = 'daApplyTrueUpJobRule'
GO

insert into GXDBVersions values(2, 'daApplyTrueUpJobRule',  '00010001000200040000', 'daApplyTrueUpJobRule', '00010001000200040000')
GO

