

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplySubclientDaysRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplySubclientDaysRule.sp,v $ $Id: daApplySubclientDaysRule.sp,v 1.1.2.3 2018/12/27 16:45:51 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplySubclientDaysRule()
--  |
--  | Description:  Apply Subclient Days Rule for FS Turbo jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplySubclientDaysRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplySubclientDaysRule <<<'
	drop procedure daApplySubclientDaysRule
END
IF EXISTS (select * from GxQscripts where name='daApplySubclientDaysRule')
	delete from GxQscripts where name = 'daApplySubclientDaysRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplySubclientDaysRule')
	delete from GXDBVersions where aliasname = 'daApplySubclientDaysRule'
GO
print '... Creating Procedure: daApplySubclientDaysRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplySubclientDaysRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	DECLARE @copiesToRetainJobs INTEGER
	SET			@copiesToRetainJobs = 1
	DECLARE @checkSumCopiesToRetain INTEGER
	SET @checkSumCopiesToRetain = CHECKSUM(N'CopiesToRetainJobsForDaysOnlyRetention')
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	/*
		-- copiesToRetain
		-- 1 = Highest Retention Copy
		-- 2 = Primary Copy + Highest Retention Copy
		-- 3 = All copies
	*/
	IF OBJECT_ID('tempdb.dbo.#tmpAppIdtoCheck') IS NOT NULL DROP TABLE #tmpAppIdtoCheck
	CREATE TABLE #tmpAppIdtoCheck (
			appId						INTEGER,
			retentionDays		INTEGER,
			AgeTimeByDays		INTEGER,
			copiesToRetain	INTEGER
 			PRIMARY KEY (appId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnCopy') IS NOT NULL DROP TABLE #tmpJobsOnCopy
	CREATE TABLE #tmpJobsOnCopy (
 			JobId 				INTEGER,
 			CommCellId 		INTEGER,
 			archGrpId 		INTEGER,
 			archGrpCopyId INTEGER,
 			appId					INTEGER,
 			retentionDays	INTEGER,
 			isBad					INTEGER,
 			isPrimary			INTEGER
 			PRIMARY KEY (JobId, CommCellId, archGrpCopyId)
			)
	IF OBJECT_ID('tempdb.dbo.#tmpJobMaxRet') IS NOT NULL DROP TABLE #tmpJobMaxRet
	CREATE TABLE #tmpJobMaxRet (
			JobId 				INTEGER,
			CommCellId 		INTEGER,
			archGrpId 		INTEGER,
			retentionDays INTEGER,
			Primary Key (JobId, CommCellId, archGrpId)
			)
	-------------------------------------------------------------------------------
	------------------------- Apply Subclient Days Rule  --------------------------
	-------------------------------------------------------------------------------
	SELECT @copiesToRetainJobs = isnull(value, 1)
	FROM MMConfigs WITH (NOLOCK)
	WHERE name = 'DA_COPIES_TO_RETAIN_JOBS_FOR_DAYS_ONLY_RETENTION_SUBCLIENTS'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all appIds that are eligible for Subclient Days Rule
	INSERT	INTO #tmpAppIdtoCheck
	SELECT	DISTINCT AppId, -1, -1, @copiesToRetainJobs
	FROM		#DA_AppCopyList
WHERE		(AppFlags & 16777216) = 16777216
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Update with subclient level override
	UPDATE #tmpAppIdtoCheck
	SET 	 copiesToRetain = CAST(P.attrVal AS INT)
	FROM #tmpAppIdtoCheck T, App_SubclientProp P WITH (NOLOCK)
	WHERE T.appId = P.componentNameId
	AND		P.attrName = N'CopiesToRetainJobsForDaysOnlyRetention'
	AND		P.cs_attrName  = @checkSumCopiesToRetain
	AND		P.modified = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Default to highest retention copy if option set is not valid
	UPDATE #tmpAppIdtoCheck
	SET 	 copiesToRetain = 1
	WHERE  copiesToRetain NOT IN (1, 2, 3)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get subclient retentionDays
	UPDATE #tmpAppIdtoCheck
	SET 	 retentionDays = TMP.retentionDays
	FROM		#tmpAppIdtoCheck T, (	SELECT DISTINCT PROP1.componentNameId AS appId, ISNULL(CAST(PROP2.attrVal AS INT), 0) AS retentionDays
																FROM APP_SubClientProp PROP1 WITH (NOLOCK), APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP2 WITH (NOLOCK)
																WHERE	PROP1.attrName = 'Associated subclient Policy'
																AND 	PROP1.modified = 0
																AND 	CAST(PROP1.attrVal AS INT) = APP.Id
																AND 	APP.appTypeId = 1030
																AND		APP.Id = PROP2.componentNameId
																AND 	PROP2.attrName = 'User deleted stubs expiration days'
																AND 	PROP2.modified = 0
															) TMP
	WHERE T.appId = TMP.appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get subclient retentionDays
	UPDATE #tmpAppIdtoCheck
	SET 	 retentionDays = TMP.retentionDays
	FROM		#tmpAppIdtoCheck T, (
																SELECT DISTINCT PROP.componentNameId AS appId, ISNULL(CAST(PROP.attrVal AS INT), 0) AS retentionDays
																FROM 	APP_Application APP WITH (NOLOCK), APP_SubClientProp PROP WITH (NOLOCK)
																WHERE	APP.Id = PROP.componentNameId
																AND 	APP.appTypeId != 1030
																AND 	PROP.attrName = 'User deleted stubs expiration days'
																AND 	PROP.modified = 0
															) TMP
	WHERE T.appId = TMP.appId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tmpAppIdtoCheck
	SET 	 AgeTimeByDays = CASE WHEN retentionDays = -1 THEN -1 ELSE (@currentTime - retentionDays * 24 * 3600) END
	-- Get jobs to retain on all available copies
	INSERT	INTO #tmpJobsOnCopy
	SELECT	JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
					CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END,
MAX(JC.JobFlags & 1), MAX(CASE WHEN AC.copyId = AC.primaryCopyId THEN 1 ELSE 0 END)
FROM	#tmpAppIdtoCheck T, #DA_JobCopyList JC, ArchAppCopyToBeAged AC
	WHERE	T.appId = JC.appId
	AND		JC.appId = AC.appId
	AND		JC.copyId = AC.copyId
	AND		JC.FileType = AC.FileType
	AND		JC.dataStatus = 100
	GROUP BY JC.JobId, JC.CommCellId, AC.archGrpId, JC.CopyId, JC.appId,
					CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on copy with highest retention and not marked BAD
	INSERT	INTO #tmpJobMaxRet
	SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tmpJobsOnCopy TMP, ArchAppCopyToBeAged A
	WHERE		TMP.appId	= A.AppId
	AND			TMP.archGrpCopyId = A.CopyId
	AND			TMP.isBad = 0
AND			A.appFlags & 33554432 = 0
	GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on copy with highest retention if no good job found
	INSERT	INTO #tmpJobMaxRet
	SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tmpJobsOnCopy TMP, ArchAppCopyToBeAged A
	WHERE		NOT EXISTS (SELECT T.JobId FROM #tmpJobMaxRet AS T
										WHERE TMP.JobId = T.jobId
										AND 	TMP.CommCellId = T.CommCellId
										AND		TMP.archGrpId = T.archGrpId)
	AND			TMP.appId	= A.AppId
	AND			TMP.archGrpCopyId = A.CopyId
AND			A.appFlags & 33554432 = 0
	GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Retain jobs on highest retention copy based on subclient days retention
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | (CASE WHEN d.AgeTimeByDays = -1 THEN 2 ELSE 16 END)
	FROM	#DA_JobCopyList a, #tmpJobsOnCopy b, #tmpJobMaxRet c, #tmpAppIdtoCheck d
	WHERE	a.appId = d.appId
	AND		a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.archGrpCopyId
	AND		b.JobId = c.JobId
	AND 	b.CommCellId = c.CommCellId
	AND		b.archGrpId = c.archGrpId
	AND		((d.copiesToRetain = 1 AND b.retentionDays = c.retentionDays) OR (d.copiesToRetain = 2 AND (b.isPrimary = 1 OR b.retentionDays = c.retentionDays)) OR (d.copiesToRetain = 3))
	AND		a.StartTime >= d.AgeTimeByDays
AND		a.appFlags & 33554432 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpAppIdtoCheck') IS NOT NULL DROP TABLE #tmpAppIdtoCheck
	IF OBJECT_ID('tempdb.dbo.#tmpJobsOnCopy') IS NOT NULL DROP TABLE #tmpJobsOnCopy
	IF OBJECT_ID('tempdb.dbo.#tmpJobMaxRet') IS NOT NULL DROP TABLE #tmpJobMaxRet
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplySubclientDaysRule')
	delete from GxQscripts where name = 'daApplySubclientDaysRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplySubclientDaysRule')
	delete from GXDBVersions where aliasname = 'daApplySubclientDaysRule'
GO

insert into GXDBVersions values(2, 'daApplySubclientDaysRule',  '00010001000200030000', 'daApplySubclientDaysRule', '00010001000200030000')
GO

