

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyReferenceCopyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyReferenceCopyRule.sp,v $ $Id: daApplyReferenceCopyRule.sp,v 1.1.2.2 2018/03/20 19:54:34 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyReferenceCopyRule()
--  |
--  | Description:  Apply Reference Copy Rule for data aging
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyReferenceCopyRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyReferenceCopyRule')
	drop procedure daApplyReferenceCopyRule
IF EXISTS (select * from GxQscripts where name='daApplyReferenceCopyRule')
	delete from GxQscripts where name = 'daApplyReferenceCopyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyReferenceCopyRule')
	delete from GXDBVersions where aliasname = 'daApplyReferenceCopyRule'
GO
print '... Creating Procedure: daApplyReferenceCopyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyReferenceCopyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE 	@IgnoreRefCopyRule 	INTEGER
	SET		@IgnoreRefCopyRule 	= 0
	DECLARE 	@EnableRefCopyRuleForPsuedoRCClients 	INTEGER
	SET		@EnableRefCopyRuleForPsuedoRCClients 	= 0
	DECLARE 	@RetainJobsOnAllCopies 	INTEGER
	SET		@RetainJobsOnAllCopies = 1
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#tblAppIdToProcess') is not null DROP TABLE #tblAppIdToProcess
	CREATE TABLE #tblAppIdToProcess (
			appId					int,
			referenceTime	int
			)
	CREATE INDEX Idx_tblAppIdToProcess_1 ON #tblAppIdToProcess (appId)
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	CREATE TABLE #tblJobMaxRet (
			JobId					int,
			CommCellId		int,
			AgeTimeByDays	int,
			)
	CREATE INDEX Idx_tblJobMaxRet_1 ON #tblJobMaxRet (JobId, CommCellId, AgeTimeByDays)
	-------------------------------------------------------------------------------
	------------- Apply Reference Copy Rule based on Param Value ------------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreRefCopyRule = isnull(value, 0)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_IGNORE_REFERENCE_COPY_RULE'
	SELECT @EnableRefCopyRuleForPsuedoRCClients = isnull(value, 0)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_ENABLE_REFERENCE_COPY_RULE_FOR_PSUEDO_CLIENTS'
	SELECT @RetainJobsOnAllCopies = isnull(value, 1)
	FROM mmconfigs WITH (NOLOCK)
	WHERE name = 'DA_CONFIG_RETAIN_JOBS_ON_ALL_COPIES_BY_REFCOPY_RULE'
	-------------------------------------------------------------------------------
	----------------------- Apply Reference Copy Rule -----------------------------
	-------------------------------------------------------------------------------
	-- AgeTimeByDays will be 0 for copy with infinite retention
	-- Get job max retention time
	IF @IgnoreRefCopyRule = 0
	BEGIN
		--Get the appId to process for reference copy rule
		INSERT INTO #tblAppIdToProcess
		SELECT JRC.srcAppId, MIN(JRC.referenceTime)
		FROM JMReferenceCopy JRC WITH (NOLOCK), #DA_AppCopyList A, APP_Application APP WITH (NOLOCK)
		WHERE JRC.srcAppId = A.AppId
		AND		JRC.refAppId = APP.id
AND 	APP.subclientStatus & 0x10000 > 0 		-- 0x10000
AND		APP.subclientStatus & 0x00004 = 0
AND   APP.subclientStatus & 0x00002 = 0
		AND		JRC.componentType = 0																-- SUBCLIENT based
		AND		(	(@EnableRefCopyRuleForPsuedoRCClients = 1)
						OR
						(	@EnableRefCopyRuleForPsuedoRCClients = 0
							AND EXISTS (SELECT componentNameId
													FROM APP_SubClientProp PROP WITH (NOLOCK)
													WHERE PROP.componentNameId = JRC.refAppId
													AND PROP.attrName = 'Reference Copy Flag'
													AND PROP.modified = 0
													AND	(CAST(PROP.attrVal AS INTEGER) & 0x2) > 0
												 )
						)
					)
		GROUP BY JRC.srcAppId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy where job is NOT marked BAD
		INSERT	INTO #tblJobMaxRet
		SELECT	JC.JobId, JC.CommCellId, MIN(A.AgeTimeByDays)
		FROM	#DA_JobCopyList JC, #DA_AppCopyList A, #tblAppIdToProcess B
		WHERE	JC.AppId = A.AppId
		AND 	JC.CopyId = A.CopyId
		AND 	JC.FileType = A.FileType
		AND		A.AppId = B.AppId
		AND		JC.DataStatus = 100
AND		A.appFlags & 33554432 = 0
AND		(JC.JobFlags & 1) = 0
		GROUP BY JC.JobId, JC.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy with jobs marked BAD if no good jobs are available
		INSERT	INTO #tblJobMaxRet
		SELECT	JC.JobId, JC.CommCellId, MIN(A.AgeTimeByDays)
		FROM	#DA_JobCopyList JC, #DA_AppCopyList A, #tblAppIdToProcess B
		WHERE	JC.AppId = A.AppId
		AND 	JC.CopyId = A.CopyId
		AND 	JC.FileType = A.FileType
		AND		A.AppId = B.AppId
		AND		JC.DataStatus = 100
AND		A.appFlags & 33554432 = 0
		AND		NOT EXISTS (SELECT T.JobId FROM #tblJobMaxRet AS T
											WHERE JC.JobId = T.jobId
											AND 	JC.CommCellId = T.CommCellId)
		GROUP BY JC.JobId, JC.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain jobs on all copies by default based on config paramter [DA_CONFIG_RETAIN_JOBS_ON_ALL_COPIES_BY_REFCOPY_RULE]
		-- Retain jobs on max retention copy if config paramter is set to 0
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 67108864
		FROM	#DA_JobCopyList JC, #DA_AppCopyList A, #tblAppIdToProcess B, #tblJobMaxRet C
		WHERE	JC.AppId = A.AppId
		AND 	JC.CopyId = A.CopyId
		AND 	JC.FileType = A.FileType
AND		A.appFlags & 33554432 = 0
		AND		A.AppId = B.AppId
		AND		JC.JobId = C.JobId
		AND 	JC.CommCellId = C.CommCellId
		AND		JC.StartTime >= B.referenceTime
		AND		( (@RetainJobsOnAllCopies = 1)
						OR
						(@RetainJobsOnAllCopies = 0 AND A.AgeTimeByDays = C.AgeTimeByDays)
					)
	END
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyReferenceCopyRule')
	delete from GxQscripts where name = 'daApplyReferenceCopyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyReferenceCopyRule')
	delete from GXDBVersions where aliasname = 'daApplyReferenceCopyRule'
GO

insert into GXDBVersions values(2, 'daApplyReferenceCopyRule',  '00010001000200020000', 'daApplyReferenceCopyRule', '00010001000200020000')
GO

