

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyLogRetentionRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyLogRetentionRule.sp,v $ $Id: daApplyLogRetentionRule.sp,v 1.11.34.2.54.1 2021/05/28 00:27:09 pkrishnan Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyLogRetentionRule()
--  |
--  | Description: Retain logs on copy with maximum retention
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='daApplyLogRetentionRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyLogRetentionRule <<<'
	drop procedure daApplyLogRetentionRule
END
IF EXISTS (select * from GxQscripts where name='daApplyLogRetentionRule')
	delete from GxQscripts where name = 'daApplyLogRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyLogRetentionRule')
	delete from GXDBVersions where aliasname = 'daApplyLogRetentionRule'
GO
print '... Creating Procedure: daApplyLogRetentionRule'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure daApplyLogRetentionRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE 	@IgnoreLogRule 	INTEGER
	SET		@IgnoreLogRule 	= 0
	DECLARE 	@HonorLogRuleTS 	INTEGER
	SET		@HonorLogRuleTS 	= 0
	DECLARE @currentTime 	INTEGER
	SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	if object_id('tempdb.dbo.#tblSQLJobMaxRet') is not null DROP TABLE #tblSQLJobMaxRet
	CREATE TABLE #tblJobMaxRet (
			JobId			int,
			CommCellId		int,
			AgeTimeByDays	int,
			)
	CREATE INDEX Idx_tblJobMaxRet_1 ON #tblJobMaxRet (JobId, CommCellId, AgeTimeByDays)
	CREATE TABLE #tblSQLJobMaxRet (
			JobId			int,
			CommCellId		int,
			AgeTimeByDays	int,
			)
	CREATE INDEX Idx_tblSQLJobMaxRet_1 ON #tblSQLJobMaxRet (JobId, CommCellId, AgeTimeByDays)
	-------------------------------------------------------------------------------
	---------------- Apply SQL Log Rule based on Param Value ----------------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreLogRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_PRUNE_ALL_DB_AGENT_LOGS_BY_DAYS_ONLY_RETENTION'
	SELECT @HonorLogRuleTS = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_TIMESTAMP_TO_HONOR_LOG_RULE'
	-------------------------------------------------------------------------------
	---------------------- Apply the Log Retention Rule ---------------------------
	-------------------------------------------------------------------------------
	-- AgeTimeByDays will be 0 for copy with infinite retention
	-- Get job max retention time
	IF @IgnoreLogRule = 0
	BEGIN
		if object_id('tempdb.dbo.#DA_ArchAppCopyToBeAged') is not null DROP TABLE #DA_ArchAppCopyToBeAged
		-- Create just the table
		SELECT	*
		INTO	#DA_ArchAppCopyToBeAged
FROM ArchAppCopyToBeAged
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Set the AgeTimeByDays for each appId Copy
		UPDATE	#DA_ArchAppCopyToBeAged
		SET 		AgeTimeByDays = @currentTime - RetentionDays * 24 * 3600
		WHERE		RetentionDays >= 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy where job is NOT marked BAD
		INSERT	INTO #tblJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(a.JobFlags & 1) = 0
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy with jobs marked BAD if no good jobs are available
		INSERT	INTO #tblJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
		AND		NOT EXISTS (SELECT T.JobId FROM #tblJobMaxRet AS T
											WHERE a.JobId = T.jobId
											AND 	a.CommCellId = T.CommCellId)
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Jobs on copy with max retention days run after AgeTimeForLog cannot be aged
		-- This rule is applied for all non SQL logs
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 16384
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblJobMaxRet c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND   b.appFlags & 4096 = 0
AND		b.appFlags & 33554432 = 0
		AND		b.AgeTimeByDays = c.AgeTimeByDays
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND		a.StartTime >= b.AgeTimeForLog
		AND		a.DataStatus = 100
		AND		(@HonorLogRuleTS = 0 OR a.StartTime <= @HonorLogRuleTS)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- SQL logs on copy with max retention days run after AgeTimeForLog cannot be aged
		-- Only the logs chained to unprunable FULL jobs will be kept by SQL Log Rule
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 16384
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblJobMaxRet c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND   ((b.appFlags & 4096 > 0) AND (b.appFlags & 131072 > 0))
AND		b.appFlags & 33554432 = 0
		AND		b.AgeTimeByDays = c.AgeTimeByDays
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND		a.StartTime >= b.AgeTimeForLog
		AND		a.DataStatus = 100
		AND		(@HonorLogRuleTS = 0 OR a.StartTime <= @HonorLogRuleTS)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		TRUNCATE TABLE #tblSQLJobMaxRet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy where job is NOT marked BAD
		INSERT	INTO #tblSQLJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND		a.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		((b.appFlags & 4096 > 0) AND (b.appFlags & 131072 = 0))
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(c.JobFlags & 1) = 0
AND		(a.jobRetainReason & 65536) = 65536
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy with jobs marked BAD if no good jobs are available
		INSERT	INTO #tblSQLJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		and		A.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		((b.appFlags & 4096 > 0) AND (b.appFlags & 131072 = 0))
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(a.jobRetainReason & 65536) = 65536
		AND		NOT EXISTS (SELECT T.JobId FROM #tblSQLJobMaxRet AS T
											WHERE a.JobId = T.jobId
											AND 	a.CommCellId = T.CommCellId)
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain chained SQL logs on copy with max retention days
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 65536
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblSQLJobMaxRet c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		((b.appFlags & 4096 > 0) AND (b.appFlags & 131072 = 0))
AND		b.appFlags & 33554432 = 0
		AND		b.AgeTimeByDays = c.AgeTimeByDays
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND		a.DataStatus = 100
		AND		(@HonorLogRuleTS = 0 OR a.StartTime <= @HonorLogRuleTS)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- AgeTimeByDays will be 0 for copy with infinite retention
		-- Get chained log jobs max retention time
		-- This filter is only for SQL log jobs.
		TRUNCATE TABLE #tblSQLJobMaxRet
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy where job is NOT marked BAD
		INSERT	INTO #tblSQLJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND		a.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		b.appFlags & 4096 > 0
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(c.JobFlags & 1) = 0
AND		(a.jobRetainReason & 32768) = 32768
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get the Max Retention copy with jobs marked BAD if no good jobs are available
		INSERT	INTO #tblSQLJobMaxRet
		SELECT	a.JobId, a.CommCellId, MIN(b.AgeTimeByDays)
FROM	ArchSQLJobCopyToBeRetained a, #DA_ArchAppCopyToBeAged b, #DA_JobCopyList c
		WHERE	a.AppId = c.AppId
		AND 	a.CopyId = c.CopyId
		AND 	a.FileType = c.FileType
		AND		a.jobId = c.jobId
		AND		a.CommCellId = c.CommCellId
		AND		a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		b.appFlags & 4096 > 0
		AND		a.DataStatus = 100
AND		b.appFlags & 33554432 = 0
AND		(a.jobRetainReason & 32768) = 32768
		AND		NOT EXISTS (SELECT T.JobId FROM #tblSQLJobMaxRet AS T
											WHERE a.JobId = T.jobId
											AND 	a.CommCellId = T.CommCellId)
		GROUP BY a.JobId, a.CommCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain chained SQL logs on copy with max retention days
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 32768
		FROM	#DA_JobCopyList a, #DA_ArchAppCopyToBeAged b, #tblSQLJobMaxRet c
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
AND 	b.AppFlags & 4 > 0
AND		b.appFlags & 4096 > 0
AND		b.appFlags & 33554432 = 0
		AND		b.AgeTimeByDays = c.AgeTimeByDays
		AND		a.JobId = c.JobId
		AND 	a.CommCellId = c.CommCellId
		AND		a.DataStatus = 100
		AND		(@HonorLogRuleTS = 0 OR a.StartTime <= @HonorLogRuleTS)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	if object_id('tempdb.dbo.#DA_ArchAppCopyToBeAged') is not null DROP TABLE #DA_ArchAppCopyToBeAged
	IF OBJECT_ID('tempdb..#tempChainedJobsList') IS NOT NULL
		DROP TABLE #tempChainedJobsList
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyLogRetentionRule')
	delete from GxQscripts where name = 'daApplyLogRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyLogRetentionRule')
	delete from GXDBVersions where aliasname = 'daApplyLogRetentionRule'
GO

insert into GXDBVersions values(2, 'daApplyLogRetentionRule',  'v1.11.34.2.54.1', 'daApplyLogRetentionRule', 'v1.11.34.2.54.1')
GO

