

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyIndexCopyJobRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyIndexCopyJobRule.sp,v $ $Id: daApplyIndexCopyJobRule.sp,v 1.1.2.1 2018/10/30 03:57:04 hkapadia Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyIndexCopyJobRule()
--  |
--  | Description:  Apply Index Copy Job Rule for FS jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplyIndexCopyJobRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyIndexCopyJobRule <<<'
	drop procedure daApplyIndexCopyJobRule
END
IF EXISTS (select * from GxQscripts where name='daApplyIndexCopyJobRule')
	delete from GxQscripts where name = 'daApplyIndexCopyJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyIndexCopyJobRule')
	delete from GXDBVersions where aliasname = 'daApplyIndexCopyJobRule'
GO
print '... Creating Procedure: daApplyIndexCopyJobRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyIndexCopyJobRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	IF OBJECT_ID('tempdb.dbo.#tmpIndexCopyJobInfo') IS NOT NULL DROP TABLE #tmpIndexCopyJobInfo
	CREATE TABLE #tmpIndexCopyJobInfo (
			appId								INTEGER,
			jobId								INTEGER,
 			CommCellId 					INTEGER,
 			startTime						INTEGER,
			isNextSynthFullRun	SMALLINT
 			PRIMARY KEY (appId, jobId, CommCellId)
			)
	-------------------------------------------------------------------------------
	----------------- Apply Index Copy job Rule for FS BLR jobs -------------------
	-------------------------------------------------------------------------------
	--Get all Index Copy jobs
	INSERT INTO #tmpIndexCopyJobInfo
	SELECT DISTINCT appId, jobId, commCellId, StartTime, 0
	FROM 	#DA_JobCopyList
WHERE AppFlags & CAST(4294967296 AS bigint) > 0
AND		JobFlags & 32 > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Check if valid Synth Full job exists after index copy job
	UPDATE #tmpIndexCopyJobInfo
	SET isNextSynthFullRun = 1
	FROM #tmpIndexCopyJobInfo T, JMBkpStats JBK WITH (NOLOCK), JMJobDataStats JDS WITH (NOLOCK)
	WHERE T.appId = JBK.appId
	AND		T.startTime < JBK.servStartDate
	AND		JBK.bkpLevel = 64		-- Synth Full
	AND		JBK.status IN (1, 3, 14)
	AND		JBK.jobId = JDS.jobId
	AND		JBK.commcellId = JDS.commcellId
	AND		JDS.dataType = 1
	AND		JDS.status = 100
AND		JDS.disabled & 256 = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Retain index copy jobs on all copies until next Synth Full job runs
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 536870912
	FROM	#DA_JobCopyList JC, #tmpIndexCopyJobInfo T
	WHERE	JC.JobId = T.JobId
	AND 	JC.CommCellId = T.CommCellId
	AND		T.isNextSynthFullRun = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Reset all not prunable reasons on index copy jobs except for applicable reasons
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason & ((1 | 4 | 8 | 256 | 512 | 2048 | 131072 | 134217728 | 536870912))
	FROM	#DA_JobCopyList JC, #tmpIndexCopyJobInfo T
	WHERE	JC.JobId = T.JobId
	AND 	JC.CommCellId = T.CommCellId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpIndexCopyJobInfo') IS NOT NULL DROP TABLE #tmpIndexCopyJobInfo
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyIndexCopyJobRule')
	delete from GxQscripts where name = 'daApplyIndexCopyJobRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyIndexCopyJobRule')
	delete from GXDBVersions where aliasname = 'daApplyIndexCopyJobRule'
GO

insert into GXDBVersions values(2, 'daApplyIndexCopyJobRule',  '00010001000200010000', 'daApplyIndexCopyJobRule', '00010001000200010000')
GO

