

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyGraceExtendedYearlyFullRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyGraceExtendedYearlyFullRule.sp,v $ $Id: daApplyGraceExtendedYearlyFullRule.sp,v 1.4.86.1 2018/03/20 20:01:18 jiechen Exp $";
--  +==================================================================================+
--  | Stored Proc:  daApplyGraceExtendedYearlyFullRule()
--  |
--  | Description:  Retain the jobs based on grace extended retention Yearly Full rule
--  +==================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyGraceExtendedYearlyFullRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyGraceExtendedYearlyFullRule')
	drop procedure daApplyGraceExtendedYearlyFullRule
IF EXISTS (select * from GxQscripts where name='daApplyGraceExtendedYearlyFullRule')
	delete from GxQscripts where name = 'daApplyGraceExtendedYearlyFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyGraceExtendedYearlyFullRule')
	delete from GXDBVersions where aliasname = 'daApplyGraceExtendedYearlyFullRule'
GO
print '... Creating Procedure: daApplyGraceExtendedYearlyFullRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyGraceExtendedYearlyFullRule
  @agingAsofDays INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#ExtRetCopyInfo') is not null DROP TABLE #ExtRetCopyInfo
	CREATE TABLE #ExtRetCopyInfo (
			copyId 								INTEGER,
			retentionDays					INTEGER,
			extRetEndTime 				BIGINT,
			graceDays							INTEGER,
			pickJobFromLowerRule	INTEGER
			PRIMARY KEY (copyId)
			)
	if object_id('tempdb.dbo.#AppCopyGracePeriod') is not null DROP TABLE #AppCopyGracePeriod
	CREATE TABLE #AppCopyGracePeriod (
			gracePeriodId					INTEGER IDENTITY(1,1),
			appId									INTEGER,
			copyId 								INTEGER,
			yearEndTime 			INTEGER,
			graceEndTime					INTEGER
			PRIMARY KEY (appId, copyId, yearEndTime)
			)
	if object_id('tempdb.dbo.#ExtRetGraceJobInfo') is not null DROP TABLE #ExtRetGraceJobInfo
	CREATE TABLE #ExtRetGraceJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			JobId									INTEGER,
			commCellId						INTEGER,
			startTime							INTEGER,
			dataStatus						INTEGER,
			jobStatus							INTEGER,
			disabled							INTEGER,
			gracePeriodId					INTEGER
			PRIMARY KEY (appId, copyId, jobId, commCellId)
			)
	if object_id('tempdb.dbo.#ExtRetJobInfo') is not null DROP TABLE #ExtRetJobInfo
	CREATE TABLE #ExtRetJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			gracePeriodId					INTEGER,
			startTime							INTEGER,
			PRIMARY KEY (appId, copyId, gracePeriodId)
			)
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfo') is not null DROP TABLE #ExtRetToBeCopiedJobInfo
	CREATE TABLE #ExtRetToBeCopiedJobInfo (
			appId									INTEGER,
			copyId								INTEGER,
			gracePeriodId					INTEGER,
			startTime							INTEGER,
			PRIMARY KEY (appId, copyId, gracePeriodId)
			)
	if object_id('tempdb.dbo.#tblArchFailedKilledJobInfo') is not null DROP TABLE #tblArchFailedKilledJobInfo
	CREATE TABLE #tblArchFailedKilledJobInfo (
			JobId				INTEGER,
			commCellId			INTEGER,
			copyId				INTEGER,
			appId				INTEGER,
			appType				INTEGER,
			startTime			INTEGER,
			bkpLevel			INTEGER,
			calendarId			INTEGER,
			TimeZoneToHonor		VARCHAR(255),
			localStartTime		INTEGER,
			yearStartTime		INTEGER,
			yearEndTime			INTEGER,
			PRIMARY KEY (JobId, commCellId, copyId)
			)
	if object_id('tempdb.dbo.#ExtRetAppCopyInfo') is not null DROP TABLE #ExtRetAppCopyInfo
	CREATE TABLE #ExtRetAppCopyInfo (
			appId				INTEGER,
			copyId				INTEGER,
			calendarId			INTEGER,
			TimeZoneToHonor		VARCHAR(255),
		PRIMARY KEY (appId, copyId)
		)
	-------------------------------------------------------------------------------
	------------ Apply the Grace Extended Retention Yearly Full Rule --------------
	-------------------------------------------------------------------------------
	-- Get all Extended Retention Info for current list of copies being processed
	INSERT INTO #ExtRetCopyInfo
SELECT DISTINCT JCE.copyId, AARE.retentionDays, (@currentTime - cast(AARE.retentionDays as bigint) * 24 * 3600), AARE.graceDays, (AAR.flags & 32)
FROM ArchJobCopyExtended JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE JCE.copyId = AAR.copyId
	AND		AAR.copyId = AARE.copyId
AND		(AAR.flags & 1) = 0		-- GraceDays is only applied to Last Of Period
	AND		AARE.retentionRule & 64 = 64									-- EXTENDED_YEAR
	AND		AARE.graceDays > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetAppCopyInfo
	SELECT DISTINCT JCE.appId, JCE.copyId, JCE.calendarId, JCE.timeZoneStdName
FROM ArchJobCopyExtended JCE WITH (NOLOCK)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #tblArchFailedKilledJobInfo
	SELECT DISTINCT AFK.jobId, AFK.commCellId, ERCI.copyId, AFK.appId, AFK.appType, AFK.servStartDate, AFK.bkpLevel, ACI.calendarId, ACI.TimeZoneToHonor, 0, 0, 0
	FROM archFailedKilledJobInfo AFK WITH (NOLOCK), archGroupCopy AGC WITH (NOLOCK), #ExtRetCopyInfo ERCI, #ExtRetAppCopyInfo ACI
	WHERE AFK.archGrpId = AGC.archGroupId
	AND	  AGC.id = ERCI.copyId
	AND	  ACI.appId = AFK.appId
	AND	  ACI.copyId = ERCI.copyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblArchFailedKilledJobInfo
	SET localStartTime = dbo.getUnixTime(dbo.UTCToLocalTime(dbo.getDateTime(startTime), TimeZoneToHonor))
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblArchFailedKilledJobInfo
	SET yearStartTime = dbo.DAGetYearStart(localStartTime, calendarId),
		yearEndTime = dbo.DAGetYearEnd(localStartTime, calendarId)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get all Extended Grace Retention Period for current list of copies being processed
	-- Get only those for which job failed during end of period
	-- Consider only Online / Offline Fulls for Oracle and SAP
	INSERT INTO #AppCopyGracePeriod (appId, copyId, yearEndTime, graceEndTime)
	SELECT DISTINCT AFK.appId, AFK.copyId, AFK.yearEndTime, (AFK.yearEndTime + (ERCI.graceDays * 24 * 3600))
	FROM #tblArchFailedKilledJobInfo AFK INNER JOIN #ExtRetCopyInfo ERCI
	ON AFK.copyId = ERCI.copyId
LEFT OUTER JOIN ArchJobCopyExtended JCE WITH (NOLOCK)
	ON AFK.appId = JCE.appId
	AND	AFK.copyId = JCE.copyId
	AND	AFK.yearEndTime = JCE.yearEndTime
	AND	(JCE.retentionFlags & 64) > 0			-- EXTENDED_YEAR
	WHERE	( (AFK.appType IN (2, 22, 23, 80, 61, 79) AND AFK.bkpLevel IN (1024, 32768))
				OR
			  (AFK.appType NOT IN (2, 22, 23, 80, 61, 79) AND AFK.bkpLevel IN (1, 64, 128))
			)
	AND		(	(JCE.appId IS null AND JCE.copyId IS null AND JCE.yearEndTime IS null)
				OR
				(			AFK.localStartTime > JCE.yearStartTime
					AND 	AFK.localStartTime <= JCE.yearEndTime
					AND		(JCE.retentionFlags & 64) > 0			-- EXTENDED_YEAR
					AND		JCE.startTime < AFK.startTime
				)
			)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	INSERT INTO #ExtRetGraceJobInfo
	SELECT DISTINCT JCE.appId, JCE.copyId, JCE.jobId, JCE.commCellId, JCE.startTime, JCE.dataStatus, JCE.jobStatus, JCE.disabled, ACGP.gracePeriodId
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #AppCopyGracePeriod ACGP
	WHERE JCE.appId = ACGP.appId
	AND		JCE.copyId = ACGP.copyId
	AND		JCE.localStartTime > ACGP.yearEndTime
	AND		JCE.localStartTime <= ACGP.graceEndTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, Not Disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 1
	AND		EGJI.disabled = 0
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, Not disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 14
	AND		EGJI.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, Not disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 3
	AND		EGJI.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, Disabled and Copied jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 1
	AND		EGJI.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, Disabled and Copied Jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 14
	AND		EGJI.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, Disabled and Copied Jobs
	INSERT INTO #ExtRetJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus = 100
	AND		EGJI.jobStatus = 3
	AND		EGJI.disabled = 1
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Successful, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus IN (101, 102, 103)
	AND		EGJI.jobStatus = 1
	AND		EGJI.disabled = 0
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider completed with warning, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus IN (101, 102, 103)
	AND		EGJI.jobStatus = 14
	AND		EGJI.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Consider Partial Successful, To be Copied Jobs
	INSERT INTO #ExtRetToBeCopiedJobInfo
	SELECT EGJI.appId, EGJI.copyId, EGJI.gracePeriodId, MIN(EGJI.startTime)
	FROM #ExtRetGraceJobInfo EGJI, #ExtRetCopyInfo ERCI
	WHERE EGJI.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR EGJI.startTime >= ERCI.extRetEndTime)
	AND		EGJI.dataStatus IN (101, 102, 103)
	AND		EGJI.jobStatus = 3
	AND		EGJI.disabled = 0
	AND 	NOT EXISTS (SELECT *
										FROM 	#ExtRetToBeCopiedJobInfo ERJI
										WHERE EGJI.appId = ERJI.appId
										and 	EGJI.copyId = ERJI.copyId
										and 	EGJI.gracePeriodId = ERJI.gracePeriodId)
	GROUP BY EGJI.appId, EGJI.copyId, EGJI.gracePeriodId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- DO NOT retain jobs in grace period if the actual job retained is picked from lower rule
	DELETE #ExtRetJobInfo
FROM #ExtRetJobInfo ERJI, #ExtRetCopyInfo ERCI,  #AppCopyGracePeriod ACGP, ArchJobCopyExtended JCE WITH (NOLOCK)
	WHERE ERJI.copyId = ERCI.copyId
	AND		ERCI.pickJobFromLowerRule > 0
	AND		JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		ACGP.appId = ERJI.appId
	AND 	ACGP.copyId = ERJI.copyId
	AND 	ACGP.gracePeriodId = ERJI.gracePeriodId
	AND		ACGP.yearEndTime = JCE.yearEndTime
	AND		JCE.retentionFlags & 64 > 0											-- EXTENDED_YEAR IS SET
	AND		JCE.retentionFlags & (262144 | 524288 | 4 | 8 | 16 | 32) > 0			-- PICKED FROM LOWER RULE
	AND 	JCE.localStartTime >= (JCE.yearEndTime - ERCI.graceDays * 24 * 3600)
	AND		JCE.dataStatus = 100
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info for current list of copies being processed
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 4096 		-- EXTENDED_GRACE_YEAR
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.startTime = ERJI.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- UnSet Extended Retention if job found in Grace period
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~(64 + 131072) -- (EXTENDED_YEAR + EXTENDED_CANDIDATE_YEAR)
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfo ERJI, #AppCopyGracePeriod ACGP
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		ACGP.appId = ERJI.appId
	AND 	ACGP.copyId = ERJI.copyId
	AND 	ACGP.gracePeriodId = ERJI.gracePeriodId
	AND		ACGP.yearEndTime = JCE.yearEndTime
	AND		JCE.retentionFlags & (64 | 131072) > 0
	AND		JCE.dataStatus IN (100, 102, 103)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- UnSet Candidate flag if no other candidate flag set
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags & ~1 -- (EXTENDED_CANDIDATE)
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfo ERJI, #AppCopyGracePeriod ACGP
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		ACGP.appId = ERJI.appId
	AND 	ACGP.copyId = ERJI.copyId
	AND 	ACGP.gracePeriodId = ERJI.gracePeriodId
	AND		ACGP.yearEndTime = JCE.yearEndTime
	AND		JCE.retentionFlags & (1048576 | 2097152 | 8192 | 16384 | 32768 | 65536 | 131072) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET the EXTENDED_CANDIDATE flag on jobs that are not actual EXTENDED_GRACE_YEAR
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags | (1 + 131072) -- (EXTENDED_CANDIDATE + EXTENDED_CANDIDATE_YEAR)
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetJobInfo ERJI, #ExtRetToBeCopiedJobInfo ERTB
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.startTime = ERJI.startTime
	AND   JCE.retentionFlags & 4096 > 0
	AND		ERJI.appId = ERTB.appId
	AND		ERJI.copyId = ERTB.copyId
	AND		ERJI.gracePeriodId = ERTB.gracePeriodId
	AND		ERJI.startTime > ERTB.startTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- SET Extended Retention Info on TO-BE-COPIED jobs for current list of copies being processed
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 4096 		-- EXTENDED_GRACE_YEAR
FROM ArchJobCopyExtended JCE WITH (NOLOCK), #ExtRetToBeCopiedJobInfo ERJI
	WHERE JCE.appId = ERJI.appId
	AND		JCE.copyId = ERJI.copyId
	AND		JCE.startTime = ERJI.startTime
	AND  	(
					EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE ERJI.appId = EJI.appId
										AND 	ERJI.copyId = EJI.copyId
										AND 	ERJI.gracePeriodId = EJI.gracePeriodId
										AND		ERJI.startTime < EJI.startTime)
					OR
					NOT EXISTS (SELECT *
										FROM 	#ExtRetJobInfo EJI
										WHERE ERJI.appId = EJI.appId
										AND 	ERJI.copyId = EJI.copyId
										AND 	ERJI.gracePeriodId = EJI.gracePeriodId)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#ExtRetCopyInfo') is not null DROP TABLE #ExtRetCopyInfo
	if object_id('tempdb.dbo.#AppCopyGracePeriod') is not null DROP TABLE #AppCopyGracePeriod
	if object_id('tempdb.dbo.#ExtRetGraceJobInfo') is not null DROP TABLE #ExtRetGraceJobInfo
	if object_id('tempdb.dbo.#ExtRetJobInfo') is not null DROP TABLE #ExtRetJobInfo
	if object_id('tempdb.dbo.#ExtRetToBeCopiedJobInfo') is not null DROP TABLE #ExtRetToBeCopiedJobInfo
	if object_id('tempdb.dbo.#tblArchFailedKilledJobInfo') is not null DROP TABLE #tblArchFailedKilledJobInfo
	if object_id('tempdb.dbo.#ExtRetAppCopyInfo') is not null DROP TABLE #ExtRetAppCopyInfo
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyGraceExtendedYearlyFullRule')
	delete from GxQscripts where name = 'daApplyGraceExtendedYearlyFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyGraceExtendedYearlyFullRule')
	delete from GXDBVersions where aliasname = 'daApplyGraceExtendedYearlyFullRule'
GO

insert into GXDBVersions values(2, 'daApplyGraceExtendedYearlyFullRule',  '00010004008600010000', 'daApplyGraceExtendedYearlyFullRule', '00010004008600010000')
GO

