

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyExtendedRetentionRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyExtendedRetentionRule.sp,v $ $Id: daApplyExtendedRetentionRule.sp,v 1.2.304.2 2018/03/20 19:51:00 jiechen Exp $";
--  +=============================================================================+
--  | Stored Proc:  daApplyExtendedRetentionRule()
--  |
--  | Description: Do not age the jobs that are retained by extended retention
--  +=============================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyExtendedRetentionRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyExtendedRetentionRule')
	drop procedure daApplyExtendedRetentionRule
IF EXISTS (select * from GxQscripts where name='daApplyExtendedRetentionRule')
	delete from GxQscripts where name = 'daApplyExtendedRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyExtendedRetentionRule')
	delete from GXDBVersions where aliasname = 'daApplyExtendedRetentionRule'
GO
print '... Creating Procedure: daApplyExtendedRetentionRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyExtendedRetentionRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	------------------- Apply the Extended Retention Rules ------------------------
	-------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_BY_EXTRETAINED
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 128
	FROM	#DA_JobCopyList a, JMJobDataStats b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.archGrpCopyId
	AND 	a.commCellId = b.commCellId
	AND		(a.FileType = 0 OR a.FileType = b.dataType)
	AND 	a.jobId = b.JobId
	AND		b.retentionFlags > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyExtendedRetentionRule')
	delete from GxQscripts where name = 'daApplyExtendedRetentionRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyExtendedRetentionRule')
	delete from GXDBVersions where aliasname = 'daApplyExtendedRetentionRule'
GO

insert into GXDBVersions values(2, 'daApplyExtendedRetentionRule',  '00010002030400020000', 'daApplyExtendedRetentionRule', '00010002030400020000')
GO

