

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyExtendedAllFullRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyExtendedAllFullRule.sp,v $ $Id: daApplyExtendedAllFullRule.sp,v 1.2.278.1 2018/03/20 20:05:49 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyExtendedAllFullRule()
--  |
--  | Description:  Retain the jobs based on extended retention All Full rule
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyExtendedAllFullRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyExtendedAllFullRule')
	drop procedure daApplyExtendedAllFullRule
IF EXISTS (select * from GxQscripts where name='daApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daApplyExtendedAllFullRule'
GO
print '... Creating Procedure: daApplyExtendedAllFullRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyExtendedAllFullRule
  @agingAsofDays INTEGER,
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @currentTime 	INTEGER
		SET 		@currentTime	= dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE	@ExtRetCopyInfo TABLE (
			copyId 					INTEGER,
			retentionDays		INTEGER,
			extRetEndTime 	BIGINT,
			firstOfPeriod 	INTEGER
			PRIMARY KEY (copyId)
			)
	-------------------------------------------------------------------------------
	--------------- Apply the Extended Retention All Full Rule --------------------
	-------------------------------------------------------------------------------
	-- Get all Extended Retention Info for current list of copies being processed
	INSERT INTO @ExtRetCopyInfo
SELECT DISTINCT JCE.copyId, AARE.retentionDays, (@currentTime - cast(AARE.retentionDays as bigint) * 24 * 3600), (AAR.flags & 1)
FROM ArchJobCopyExtended JCE WITH (NOLOCK), archAgingRule AAR WITH (NOLOCK), archAgingRuleExtended AARE WITH (NOLOCK)
	WHERE JCE.copyId = AAR.copyId
	AND		AAR.copyId = AARE.copyId
	AND		AARE.retentionRule & 2 = 2 -- EXTENDED_ALLFULL
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Set Extended Retention Info for current list of copies being processed
	-- Set the retentionFlags even for TO-BE-COPIED/DISABLED/PARTIAL_SUCCESSFUL FULL jobs
UPDATE ArchJobCopyExtended
	SET retentionFlags = retentionFlags | 2 -- EXTENDED_ALLFULL
FROM ArchJobCopyExtended JCE WITH (NOLOCK), @ExtRetCopyInfo ERCI
	WHERE JCE.copyId = ERCI.copyId
	AND		(ERCI.retentionDays = -1 OR JCE.startTime >= ERCI.extRetEndTime)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyExtendedAllFullRule')
	delete from GxQscripts where name = 'daApplyExtendedAllFullRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyExtendedAllFullRule')
	delete from GXDBVersions where aliasname = 'daApplyExtendedAllFullRule'
GO

insert into GXDBVersions values(2, 'daApplyExtendedAllFullRule',  '00010002027800010000', 'daApplyExtendedAllFullRule', '00010002027800010000')
GO

