

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyDataLinkRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyDataLinkRule.sp,v $ $Id: daApplyDataLinkRule.sp,v 1.5.34.3 2018/12/27 16:47:40 vikashkumar Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyDataLinkRule()
--  |
--  | Description:  Apply Data Link Rule for Selective Online Full jobs
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplyDataLinkRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyDataLinkRule <<<'
	drop procedure daApplyDataLinkRule
END
IF EXISTS (select * from GxQscripts where name='daApplyDataLinkRule')
	delete from GxQscripts where name = 'daApplyDataLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyDataLinkRule')
	delete from GXDBVersions where aliasname = 'daApplyDataLinkRule'
GO
print '... Creating Procedure: daApplyDataLinkRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyDataLinkRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	if object_id('tempdb.dbo.#tblCopySource') is not null DROP TABLE #tblCopySource
	if object_id('tempdb.dbo.#tblChildJobs') is not null DROP TABLE #tblChildJobs
	if object_id('tempdb.dbo.#tblJobSelFull') is not null DROP TABLE #tblJobSelFull
	if object_id('tempdb.dbo.#tblLinkedJobsOnCopy') is not null DROP TABLE #tblLinkedJobsOnCopy
	if object_id('tempdb.dbo.#tblParentJobStatus') is not null DROP TABLE #tblParentJobStatus
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	CREATE	TABLE #tblCopySource (
			CopyId 					int,
			sourceCopyId 		int,
			primaryCopy 		int
			)
	CREATE INDEX Idx_tblCopySource_1 ON #tblCopySource (CopyId, sourceCopyId)
	CREATE	TABLE #tblChildJobs (
			parentJobId		int,
 			childJobId 		int,
 			commCellId 		int
			)
	CREATE INDEX Idx_tblChildJobs_1 ON #tblChildJobs (parentJobId, commCellId)
	CREATE	TABLE #tblJobSelFull (
			parentJobId 		int,
			childJobId 			int,
			commCellId 			int,
			archGrpCopyId 	int,
			dataType				int,
			parentStatus	 	int,
			parentAged 			int,
			parentDisabled	int
			)
	CREATE INDEX Idx_tblJobSelFull_1 ON #tblJobSelFull (parentJobId, CommCellId, archGrpCopyId)
	CREATE INDEX Idx_tblJobSelFull_2 ON #tblJobSelFull (childJobId, CommCellId, archGrpCopyId)
	CREATE	TABLE #tblLinkedJobsOnCopy (
 			JobId 				int,
 			CommCellId 		int,
 			archGrpId 		int,
 			archGrpCopyId int,
 			appId					int,
 			appTypeId			int,
 			retentionDays	int,
 			isBad					int
			)
	CREATE INDEX Idx_tblLinkedJobsOnCopy_1 ON #tblLinkedJobsOnCopy (JobId, CommCellId, archGrpCopyId)
	CREATE INDEX Idx_tblLinkedJobsOnCopy_2 ON #tblLinkedJobsOnCopy (appId, archGrpCopyId)
	CREATE	TABLE #tblParentJobStatus (
			childJobId 			int,
			commCellId 			int,
			parentStatus 		int,
			parentAged 		int
			)
	CREATE INDEX Idx_tblParentJobStatus_1 ON #tblParentJobStatus (childJobId, commCellId)
	CREATE	TABLE #tblJobMaxRet (
			JobId 				int,
			CommCellId 		int,
			archGrpId 		int,
			retentionDays int,
			)
	CREATE INDEX Idx_tblJobMaxRet_1 ON #tblJobMaxRet (JobId, CommCellId, archGrpId)
	-------------------------------------------------------------------------------
	-------------- Apply Data Link Rule for all dependent jobs --------------------
	-------------------------------------------------------------------------------
		-- Get SQL Diff-Full mapping
		-- #tblChildJobs will be populated with Diff-Full dependent jobs
	  EXEC daGetSQLDiffChainData 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get all Child Jobs
		INSERT	INTO #tblChildJobs
		SELECT	DISTINCT JDL.parentJobId, JDL.childJobId, JDL.commCellId
		FROM	#DA_JobCopyList JCL, JMJobDataLinkViewForDA JDL WITH (NOLOCK)
		WHERE	JCL.JobId = JDL.ChildJobId
		AND 	JCL.CommCellId = JDL.CommCellId
		AND		JDL.parentJobId != JDL.childJobId
		UNION
		--Get all index copy jobs as parent job and jobs on source appId from associated fullCycleNumber before index copy start time as child jobs for BLR FS
		SELECT	DISTINCT BLR.IndexCopyJobId, JCL.JobId, JCL.CommCellId
		FROM	#DA_JobCopyList JCL, BlrParentAppMap BLR WITH (NOLOCK), JMBkpStats JBK WITH (NOLOCK)
		WHERE	JCL.appId = BLR.ParentAppId
		AND		JCL.fullCycleNum = BLR.ParentFullCycleNum
		AND		BLR.IndexCopyJobId = JBK.JobId
		AND 	BLR.IndexCopyCommcellId = JBK.CommCellId
		AND		JCL.StartTime <= JBK.servStartDate
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get Parent Jobs on all copies with AgedStatus
		INSERT	INTO #tblJobSelFull
		SELECT	DISTINCT T.parentJobId, T.childJobId, T.commCellId,
						JDS.archGrpCopyId, JDS.dataType, JDS.status,
JDS.Disabled & 256,
JDS.Disabled & 1
		FROM	#tblChildJobs T, JMJobDataStats JDS WITH (NOLOCK)
		WHERE	T.parentJobId = JDS.jobId
		AND 	T.CommCellId = JDS.CommCellId
		AND		JDS.dataType = 1
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get source copy information of SNAP MIRROR Copies
		INSERT	INTO #tblCopySource
		SELECT	a.id, a.sourceCopyId, b.defaultSnapCopy
		FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
		WHERE	a.archGroupId = b.id
		AND		a.isMirrorCopy > 0
		AND		a.isSnapCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- The source copy will be source of Mirror copy if source copy is Mirror Copy
		WHILE EXISTS(SELECT T.sourceCopyId FROM #tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
		BEGIN
			UPDATE	#tblCopySource
			SET 	sourceCopyId = AGC.sourceCopyId
			FROM	#tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
			WHERE	T.sourceCopyId = AGC.id
			AND		AGC.isSnapCopy > 0
			AND		AGC.isMirrorCopy > 0
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		-- The source copy will be primary copy if no source copy defined
		UPDATE	#tblCopySource
		SET 	sourceCopyId = primaryCopy
		WHERE	sourceCopyId = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Set the jobRetainReason here so that linked jobs also get retained
		-- Get job datastatus and agedstatus for selective online full from the current list being processed
		UPDATE	#tblJobSelFull
		SET 	ParentStatus = b.DataStatus,
					ParentAged = CASE WHEN (b.jobRetainReason > 0) THEN 0 ELSE 256 END,
					parentDisabled = b.Disabled
		FROM	#tblJobSelFull a, #DA_JobCopyList b
		WHERE	a.parentJobId = b.JobId
		AND 	a.commCellId = b.commCellId
		AND 	a.archGrpCopyId = b.CopyId
		AND 	(b.fileType = 0 OR a.dataType = b.fileType)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Update the status for mirror copy jobs too
		UPDATE	#tblJobSelFull
		SET 	ParentStatus = b.DataStatus,
					ParentAged = CASE WHEN (b.jobRetainReason > 0) THEN 0 ELSE 256 END
		FROM	#tblJobSelFull a, #DA_JobCopyList b, #tblCopySource TT
		WHERE	a.parentJobId = b.JobId
		AND 	a.commCellId = b.commCellId
		AND 	a.archGrpCopyId = TT.CopyId
		AND		b.CopyId = TT.sourceCopyId
		AND 	(b.fileType = 0 OR a.dataType = b.fileType)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get child jobs on available copies
		INSERT	INTO #tblLinkedJobsOnCopy
		SELECT	JDS.jobId, JDS.CommCellId, JDS.archGrpId, JDS.archGrpCopyId, JDS.appId, APP.appTypeId,
						CASE AR.retentionDays WHEN -1 THEN @maxIntVal ELSE AR.retentionDays END,
MAX(JDS.Disabled & 64)
		FROM	#tblJobSelFull T, JMJobDataStats JDS WITH (NOLOCK), APP_Application APP WITH (NOLOCK), ArchAgingRule AR WITH (NOLOCK)
		WHERE	T.childJobId = JDS.JobId
		AND 	T.commCellId = JDS.CommCellId
		AND		JDS.appId = APP.Id
		AND		JDS.archGrpCopyId = AR.copyId
		AND		JDS.status = 100
AND		JDS.disabled & 256 = 0
		GROUP BY JDS.jobId, JDS.CommCellId, JDS.archGrpId, JDS.archGrpCopyId, JDS.appId, APP.appTypeId,
						CASE AR.retentionDays WHEN -1 THEN @maxIntVal ELSE AR.retentionDays END
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Update the retentionDays for Migrator and Archiver AppTypes
		UPDATE	#tblLinkedJobsOnCopy
		SET		retentionDays = CASE AR.archiverRetDays WHEN -1 THEN @maxIntVal ELSE AR.archiverRetDays END
		FROM	#tblLinkedJobsOnCopy T, ArchAgingRule AR WITH (NOLOCK)
		WHERE	T.archGrpCopyId = AR.copyId
		AND	T.appTypeId IN (
							SELECT appTypeId
							FROM APP_IDATypeHandlingInfo
							WHERE isDMAppType = 1
				)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO #tblParentJobStatus
		SELECT T.childJobId, T.commCellId, MIN(T.parentStatus), MIN(T.parentAged)
		FROM #tblJobSelFull T
		WHERE T.parentStatus = 100
		GROUP BY T.childJobId, T.commCellId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention and not marked BAD
		INSERT	INTO #tblJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tblLinkedJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		TMP.isBad = 0
		AND			TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
AND			A.appFlags & 33554432 = 0
		AND			A.copyIsSnapMirror = 0 -- Do Not consider Snap Mirror
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention if no good job found
		INSERT	INTO #tblJobMaxRet
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#tblLinkedJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		NOT EXISTS (SELECT T.JobId FROM #tblJobMaxRet AS T
											WHERE TMP.JobId = T.jobId
											AND 	TMP.CommCellId = T.CommCellId
											AND		TMP.archGrpId = T.archGrpId)
		AND			TMP.appId	= A.AppId
		AND			TMP.archGrpCopyId = A.CopyId
AND			A.appFlags & 33554432 = 0
		AND			A.copyIsSnapMirror = 0 -- Do Not consider Snap Mirror
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Jobs linked to parent jobs cannot be aged
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 8192
		FROM	#DA_JobCopyList a, #tblJobSelFull b
		WHERE	a.JobId = b.ChildJobId
		AND 	a.CommCellId = b.CommCellId
		AND 	a.CopyId = b.archGrpCopyId
		AND		((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.disabled = 0))
AND		((a.appFlags & CAST(2147483648 AS bigint) > 0) OR (a.appFlags & 33554432 = 0))
		AND 	((b.ParentStatus = 100) OR (b.ParentStatus IN (101, 102, 103) AND b.parentDisabled = 0))
		AND		b.ParentAged = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Remove the linked jobs that is retained with DONOTAGE_REQBYDATA reason on same copy as parent
		DELETE #tblLinkedJobsOnCopy
		FROM #tblLinkedJobsOnCopy JC, #tblJobSelFull T, #DA_JobCopyList a
		WHERE JC.JobId = T.childJobId
		AND	  JC.commCellId = T.commCellId
		AND		JC.JobId = a.JobId
		AND 	JC.commCellId = a.commCellId
AND		a.jobRetainReason & 8192 > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Retain all linked jobs on copy with higher retention if they are not on same copy as that of parent job
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 8192
		FROM	#DA_JobCopyList a, #tblLinkedJobsOnCopy JC, #tblJobMaxRet MR, #tblParentJobStatus T
		WHERE 	JC.JobId = MR.JobId
		AND 		JC.commCellId = MR.commCellId
		AND			JC.retentionDays = MR.retentionDays
		AND			JC.JobId = a.JobId
		AND 		JC.commCellId = a.commCellId
		AND			JC.archGrpId = MR.archGrpId
		AND			JC.archGrpCopyId = a.CopyId
		AND			a.DataStatus = 100
		AND			JC.JobId = T.childJobId
		AND 		JC.commCellId = T.commCellId
AND			a.appFlags & 33554432 = 0
		AND 		T.ParentStatus = 100
		AND			T.ParentAged = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	if object_id('tempdb.dbo.#tblCopySource') is not null DROP TABLE #tblCopySource
	if object_id('tempdb.dbo.#tblChildJobs') is not null DROP TABLE #tblChildJobs
	if object_id('tempdb.dbo.#tblJobSelFull') is not null DROP TABLE #tblJobSelFull
	if object_id('tempdb.dbo.#tblLinkedJobsOnCopy') is not null DROP TABLE #tblLinkedJobsOnCopy
	if object_id('tempdb.dbo.#tblParentJobStatus') is not null DROP TABLE #tblParentJobStatus
	if object_id('tempdb.dbo.#tblJobMaxRet') is not null DROP TABLE #tblJobMaxRet
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyDataLinkRule')
	delete from GxQscripts where name = 'daApplyDataLinkRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyDataLinkRule')
	delete from GXDBVersions where aliasname = 'daApplyDataLinkRule'
GO

insert into GXDBVersions values(2, 'daApplyDataLinkRule',  '00010005003400030000', 'daApplyDataLinkRule', '00010005003400030000')
GO

