

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyCycleDependencyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyCycleDependencyRule.sp,v $ $Id: daApplyCycleDependencyRule.sp,v 1.3.116.3 2018/12/27 16:50:01 vikashkumar Exp $";
--  +===================================================================================+
--  | Stored Proc:  daApplyCycleDependencyRule()
--  |
--  | Description:  Retain entire cycle if some jobs in cycle are retained by days
--  +===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='daApplyCycleDependencyRule')
BEGIN
	print '>>> Drop Stored Procedure: daApplyCycleDependencyRule <<<'
	drop procedure daApplyCycleDependencyRule
END
IF EXISTS (select * from GxQscripts where name='daApplyCycleDependencyRule')
	delete from GxQscripts where name = 'daApplyCycleDependencyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyCycleDependencyRule')
	delete from GXDBVersions where aliasname = 'daApplyCycleDependencyRule'
GO
print '... Creating Procedure: daApplyCycleDependencyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyCycleDependencyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @rowCnt		INTEGER
	SET			@rowCnt		= 0
	DECLARE @maxIntVal 		INTEGER
	SET			@maxIntVal 		= 2147483647
	DECLARE	@RetentionDaysWhenCyclesIgnored		INTEGER
	SET		@RetentionDaysWhenCyclesIgnored			= 30
	-------------------------------------------------------------------------------
	-- Table declarations
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#tblReqCycles') is not null DROP TABLE #tblReqCycles
	CREATE	TABLE #tblReqCycles(
			AppId 								INTEGER,
			CopyId 								INTEGER,
			FileType 							INTEGER,
			CommCellId 						INTEGER,
			JobId 								INTEGER,
			StartTime 						INTEGER,
			fullCycleNum 					INTEGER,
			retainIncrBeforeDiff 	INTEGER,
			lastDiffStartTime 		INTEGER,
			isFullJobCWE 					INTEGER,
			isFullJobCS 					INTEGER,
			retentionDays 				INTEGER,
			retentionCycles 			INTEGER
			)
	CREATE INDEX Idx_tblReqCycles_1 ON #tblReqCycles (AppId, CopyId, FileType, fullCycleNum)
	if object_id('tempdb.dbo.#tblActiveCloneJobs') is not null DROP TABLE #tblActiveCloneJobs
	CREATE	TABLE #tblActiveCloneJobs(
			AppId 				INTEGER,
			CopyId 				INTEGER,
			FileType 			INTEGER,
			CommCellId 		INTEGER,
			JobId 				INTEGER,
			StartTime 		INTEGER,
			fullCycleNum	INTEGER,
			MountJobId 		INTEGER
			)
	CREATE INDEX Idx_tblActiveCloneJobs_1 ON #tblActiveCloneJobs (AppId, CopyId, FileType, fullCycleNum)
	CREATE INDEX Idx_tblActiveCloneJobs_2 ON #tblActiveCloneJobs (JobId, CommCellId, CopyId)
	if object_id('tempdb.dbo.#tblActiveCloneCycle') is not null DROP TABLE #tblActiveCloneCycle
	CREATE	TABLE #tblActiveCloneCycle(
			AppId 				INTEGER,
			CopyId 				INTEGER,
			FileType 			INTEGER,
			CommCellId 		INTEGER,
			JobId 				INTEGER,
			StartTime 		INTEGER,
			fullCycleNum 	INTEGER,
			MountJobId 		INTEGER
			)
	CREATE INDEX Idx_tblActiveCloneCycle_1 ON #tblActiveCloneCycle (AppId, CopyId, FileType, fullCycleNum)
	if object_id('tempdb.dbo.#activeCloneJobsOnCopy') is not null DROP TABLE #activeCloneJobsOnCopy
	CREATE TABLE #activeCloneJobsOnCopy (
			AppId 				INTEGER,
			CopyId 				INTEGER,
			FileType 			INTEGER,
			CommCellId 		INTEGER,
			JobId 				INTEGER,
 			archGrpId 		INTEGER,
 			retentionDays	INTEGER,
 			isBad					INTEGER
			)
	CREATE CLUSTERED INDEX Idx_activeCloneJobsOnCopy_1 ON #activeCloneJobsOnCopy (JobId, CommCellId, CopyId)
	if object_id('tempdb.dbo.#activeCloneJobMaxRet') is not null DROP TABLE #activeCloneJobMaxRet
	CREATE TABLE #activeCloneJobMaxRet (
			JobId 				INTEGER,
			CommCellId 		INTEGER,
			FileType 			INTEGER,
			archGrpId 		INTEGER,
			retentionDays INTEGER
			)
	CREATE CLUSTERED INDEX Idx_activeCloneJobMaxRet_1 ON #activeCloneJobMaxRet (JobId, CommCellId, archGrpId)
	if object_id('tempdb.dbo.#tmpSplitCyleInfo') is not null DROP TABLE #tmpSplitCyleInfo
	CREATE TABLE #tmpSplitCyleInfo (
			appId									INTEGER,
			FileType							INTEGER,
			fullCycleNum 					INTEGER,
			lastJobStartTime			INTEGER,
			lastJobId							INTEGER,
			CommCellId 						INTEGER,
			Primary Key (appId, FileType, fullCycleNum)
			)
	if object_id('tempdb.dbo.#tmpJobMaxRet') is not null DROP TABLE #tmpJobMaxRet
	CREATE TABLE #tmpJobMaxRet (
			appId							INTEGER,
			FileType					INTEGER,
			fullCycleNum 			INTEGER,
			JobId 						INTEGER,
			CommCellId 				INTEGER,
			archGrpId 				INTEGER,
			StartTime 				INTEGER,
			retentionDays 		INTEGER
			Primary Key (JobId, CommCellId, archGrpId)
			)
	-------------------------------------------------------------------------------
	--------------- Get number of days when cycles are ignored --------------------
	-------------------------------------------------------------------------------
	SELECT @RetentionDaysWhenCyclesIgnored = isnull(value, 30)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_RETENTION_DAYS_WHEN_CYCLES_IGNORED'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-------------------------------------------------------------------------------
	-------------------- Apply the Cycle Dependency Rule --------------------------
	-------------------------------------------------------------------------------
	-- Get the first job for each cycle for subclient + copy that is retaind by days retention
	-- Need to compute each cycle due to incremental job running in parallel to Synth Full and moving to older cycle
	INSERT	INTO #tblReqCycles
	SELECT DISTINCT AppId, CopyId, FileType, 0, 0, MIN(StartTime), fullCycleNum, 1, 0, 0, 0, 0, 0
	FROM	#DA_JobCopyList
WHERE jobRetainReason & 16 = 16
	GROUP BY AppId, CopyId, FileType, fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblReqCycles
	SET commCellId = b.commCellId,
			jobId = b.JobId
	FROM #tblReqCycles a, #DA_JobCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.StartTime = b.StartTime
	AND		a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Show the last job in cycle for "Required By Jobs"
	UPDATE #tblReqCycles
	SET jobId = b.JobId
	FROM #tblReqCycles a, (SELECT AppId, CopyId, FileType, fullCycleNum,  MAX(jobId) AS JobId
													FROM #DA_JobCopyList
													GROUP BY AppId, CopyId, FileType, fullCycleNum) b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Check the JobStatus of corresponding Full job if it is CWE / Custom Scripts Job
	UPDATE #tblReqCycles
	SET isFullJobCWE = CASE WHEN (b.JobStatus IN (3)) THEN 1 ELSE 0 END,
isFullJobCS = CASE WHEN (b.JobFlags & 16777216 > 0 AND b.JobFlags & 8388608 = 0) THEN 1 ELSE 0 END
	FROM #tblReqCycles a, #DA_JobCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.fullCycleNum = b.fullCycleNum
	AND		b.BkpLevel = 1
	AND		(
(b.JobFlags & 64 = 0)
					OR
(b.JobFlags & 128 > 0)
				)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblReqCycles
	SET retentionDays = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN @RetentionDaysWhenCyclesIgnored ELSE b.retentionDays END,
		retentionCycles = CASE WHEN ((a.isFullJobCS = 1 OR (a.isFullJobCWE = 1 AND b.isCWEjobValid != 1)) AND b.retentionDays = 0 AND b.retentionCycles > 0) THEN 0 ELSE b.retentionCycles END,
		retainIncrBeforeDiff = b.retainIncrBeforeDiff
FROM #tblReqCycles a, ArchAppCopyToBeAged b
	WHERE a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	UPDATE #tblReqCycles
	SET lastDiffStartTime = b.lastDiffStartTime
	FROM #tblReqCycles a,
				(SELECT T.AppId, T.CopyId, T.fileType, T.fullCycleNum, MAX(T.StartTime) AS lastDiffStartTime
					FROM #DA_JobCopyList T, #tblReqCycles T1
					WHERE T.DataStatus = 100
					AND		T.BkpLevel = 4
					AND		T.AppId = T1.AppId
					AND 	T.CopyId = T1.CopyId
					AND 	T.FileType = T1.FileType
					AND		T.fullCycleNum = T1.fullCycleNum
					AND		T.StartTime <= T1.StartTime
					GROUP BY T.AppId, T.CopyId, T.fileType, T.fullCycleNum) b
	WHERE a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_REQBYJOB
	-- All the jobs with the required fullCycleNum will not be pruned
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
	FROM	#DA_JobCopyList a, #tblReqCycles b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.CommCellId = b.CommCellId
	AND 	a.jobRetainReason = 0
	AND		a.StartTime < b.StartTime
	AND		a.fullCycleNum = b.fullCycleNum
	AND		(b.retainIncrBeforeDiff = 1 OR b.lastDiffStartTime = 0)
	AND 	b.retentionDays > 0
AND		((b.retentionCycles > 0) OR ((b.retentionCycles = 0) AND ((a.appFlags & 1048576) = 0)))
AND		(a.appFlags & 2048) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Update the jobRetainReason flag with DONOTAGE_REQBYJOB
	-- All the jobs with the required fullCycleNum will not be pruned
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
	FROM	#DA_JobCopyList a, #tblReqCycles b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.CommCellId = b.CommCellId
	AND 	a.jobRetainReason = 0
	AND		a.StartTime < b.StartTime
	AND		a.fullCycleNum = b.fullCycleNum
	AND		b.retainIncrBeforeDiff = 0
	AND		b.lastDiffStartTime > 0
	AND		(a.BkpLevel = 1 OR a.StartTime >= b.lastDiffStartTime)
	AND 	b.retentionDays > 0
AND		((b.retentionCycles > 0) OR ((b.retentionCycles = 0) AND ((a.appFlags & 1048576) = 0)))
AND		(a.appFlags & 2048) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get the list of subclient cycles that are split into multiple SPs
	INSERT INTO #tmpSplitCyleInfo
	SELECT T.AppId, T.FileType, T.fullCycleNum, 0, 0, 0
FROM	#DA_JobCopyList T, ArchAppCopyToBeAged AC
	WHERE T.AppId = AC.AppId
	AND		T.CopyId = AC.CopyId
	AND 	T.FileType = AC.FileType
	GROUP BY T.AppId, T.FileType, T.fullCycleNum
	HAVING COUNT(DISTINCT AC.archGrpId) > 1
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get latest valid job info in each split cycle that is retained based on BASIC_DAYS
	UPDATE TMP
	SET 	lastJobStartTime = TMP1.lastJobStartTime
	FROM	#tmpSplitCyleInfo TMP, (SELECT JC.AppId, JC.FileType, JC.fullCycleNum, MAX(JC.StartTime) as lastJobStartTime
															  FROM	#tmpSplitCyleInfo T,	#DA_JobCopyList JC
																WHERE T.AppId = JC.AppId
																AND 	T.FileType = JC.FileType
																AND		T.fullCycleNum = JC.fullCycleNum
AND		JC.jobRetainReason & 16 = 16
																AND		((JC.dataStatus = 100) OR (JC.dataStatus IN (101, 102, 103) AND JC.disabled = 0))
																GROUP BY JC.AppId, JC.FileType, JC.fullCycleNum
																) TMP1
	WHERE TMP.AppId = TMP1.AppId
	AND 	TMP.FileType = TMP1.FileType
	AND		TMP.fullCycleNum = TMP1.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get latest jobId in cycle
	UPDATE #tmpSplitCyleInfo
	SET		 lastJobId = JC.jobId,
				 CommCellId = JC.CommCellId
	FROM 	#tmpSplitCyleInfo T, #DA_JobCopyList JC
	WHERE T.appId = JC.appId
	AND		T.FileType = JC.FileType
	AND		T.fullCycleNum = JC.fullCycleNum
	AND		T.lastJobStartTime = JC.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on sync copy with highest retention and not marked BAD
	INSERT INTO #tmpJobMaxRet
	SELECT DISTINCT A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime, MAX(CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END)
FROM	#DA_JobCopyList A, #tmpSplitCyleInfo B, ArchAppCopyToBeAged AC
	WHERE	A.AppId = B.AppId
	AND 	A.FileType = B.FileType
	AND		A.fullCycleNum = B.fullCycleNum
	AND		A.StartTime <= B.lastJobStartTime
AND		A.JobFlags & 1 = 0
	AND		A.appId	= AC.AppId
	AND		A.CopyId = AC.CopyId
	AND		A.FileType = AC.FileType
	AND		AC.copyType != 2  -- (Selective Copy)
AND		A.appFlags & (1048576 | 33554432) = 0
	AND		A.dataStatus = 100
	GROUP BY A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on selective copy with highest retention if no good job found on sync copy
	INSERT	INTO #tmpJobMaxRet
	SELECT DISTINCT A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime, MAX(CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END)
FROM	#DA_JobCopyList A, #tmpSplitCyleInfo B, ArchAppCopyToBeAged AC
	WHERE	A.AppId = B.AppId
	AND 	A.FileType = B.FileType
	AND		A.fullCycleNum = B.fullCycleNum
	AND		A.StartTime <= B.lastJobStartTime
AND		A.JobFlags & 1 = 0
	AND		A.appId	= AC.AppId
	AND		A.CopyId = AC.CopyId
	AND		A.FileType = AC.FileType
	AND		AC.copyType = 2  -- (Selective Copy)
AND		A.appFlags & (1048576 | 33554432) = 0
	AND		A.dataStatus = 100
	AND		NOT EXISTS (SELECT T.JobId
										FROM #tmpJobMaxRet AS T
										WHERE A.JobId = T.jobId
										AND 	A.CommCellId = T.CommCellId
										AND		AC.archGrpId = T.archGrpId)
	GROUP BY A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on sync copy with highest retention if no good job found
	INSERT	INTO #tmpJobMaxRet
	SELECT DISTINCT A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime, MAX(CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END)
FROM	#DA_JobCopyList A, #tmpSplitCyleInfo B, ArchAppCopyToBeAged AC
	WHERE	A.AppId = B.AppId
	AND 	A.FileType = B.FileType
	AND		A.fullCycleNum = B.fullCycleNum
	AND		A.StartTime <= B.lastJobStartTime
	AND		A.appId	= AC.AppId
	AND		A.CopyId = AC.CopyId
	AND		A.FileType = AC.FileType
	AND		AC.copyType != 2  -- (Selective Copy)
AND		A.appFlags & (1048576 | 33554432) = 0
	AND		A.dataStatus = 100
	AND		NOT EXISTS (SELECT T.JobId
										FROM #tmpJobMaxRet AS T
										WHERE A.JobId = T.jobId
										AND 	A.CommCellId = T.CommCellId
										AND		AC.archGrpId = T.archGrpId)
	GROUP BY A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get job on selective copy with highest retention if no good job found
	INSERT	INTO #tmpJobMaxRet
	SELECT DISTINCT A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime, MAX(CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END)
FROM	#DA_JobCopyList A, #tmpSplitCyleInfo B, ArchAppCopyToBeAged AC
	WHERE	A.AppId = B.AppId
	AND 	A.FileType = B.FileType
	AND		A.fullCycleNum = B.fullCycleNum
	AND		A.StartTime <= B.lastJobStartTime
	AND		A.appId	= AC.AppId
	AND		A.CopyId = AC.CopyId
	AND		A.FileType = AC.FileType
	AND		AC.copyType = 2  -- (Selective Copy)
AND		A.appFlags & (1048576 | 33554432) = 0
	AND		A.dataStatus = 100
	AND		NOT EXISTS (SELECT T.JobId
										FROM #tmpJobMaxRet AS T
										WHERE A.JobId = T.jobId
										AND 	A.CommCellId = T.CommCellId
										AND		AC.archGrpId = T.archGrpId)
	GROUP BY A.AppId, A.FileType, A.fullCycleNum, A.JobId, A.CommCellId, AC.archGrpId, A.StartTime
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Retain previous jobs based on latest jobs in cycle. Don't retain entire cycle as it will break Incremental Policy use case
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 1024
FROM	#DA_JobCopyList A, ArchAppCopyToBeAged AC, #tmpJobMaxRet C
	WHERE	A.AppId = AC.AppId
	AND 	A.CopyId = AC.CopyId
	AND 	A.FileType = AC.FileType
	AND		AC.archGrpId = C.archGrpId
	AND		(CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END) = C.retentionDays
	AND		A.JobId = C.JobId
	AND		A.CommCellId = C.CommCellId
AND		A.appFlags & (2048 | 1048576 | 33554432) = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	--Get the list of jobs with active clones running
	INSERT	INTO #tblActiveCloneJobs (AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum, MountJobId)
	SELECT a.AppId, a.CopyId, a.FileType, a.CommCellId, a.JobId, a.StartTime, a.fullCycleNum, SMV.MountJobId
	FROM	#DA_JobCopyList a, #DA_AppCopyList b, archFile AF WITH (NOLOCK),
				SMVolume SV WITH (NOLOCK), SMMountVolume SMV WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND		b.appType IN (104, 81, 22, 80, 125)
	AND		a.jobId = AF.jobId
	AND		a.commCellId = AF.commCellId
AND		AF.flags & 4194304 > 0
	AND		AF.id = SV.archFileId
	AND		AF.commCellId = SV.commCellId
	AND		a.copyId = SV.copyId
	AND		SV.SMVolumeId = SMV.SMVolumeId
AND		SMV.MountFlags & 2048 > 0
	AND		SMV.MountStatus <= 59
	SELECT	@errorCode = @@ERROR, @rowCnt = @@ROWCOUNT
	IF	@errorCode != 0 GOTO CX_EXIT
	IF @rowCnt > 0
	BEGIN
		--Get the latest job in the cycle that has active clone running
		INSERT	INTO #tblActiveCloneCycle (AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum, MountJobId)
		SELECT 	AppId, CopyId, FileType, 0, 0, MAX(StartTime), fullCycleNum, 0
		FROM	#tblActiveCloneJobs
		GROUP BY AppId, CopyId, FileType, fullCycleNum
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE #tblActiveCloneCycle
		SET commCellId = b.commCellId,
		jobId = b.JobId,
		MountJobId = b.MountJobId
		FROM #tblActiveCloneCycle a, #tblActiveCloneJobs b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		a.StartTime = b.StartTime
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		-- Get all the jobs to retained for ACTIVE_CLONE requirements on all available copies
		INSERT	INTO #activeCloneJobsOnCopy (AppId, CopyId, FileType, CommCellId, JobId, archGrpId, retentionDays, isBad)
		SELECT	JC.appId, JC.CopyId, JC.FileType, JC.CommCellId, JC.JobId, AC.archGrpId,
						CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END,
MAX(JC.JobFlags & 1)
FROM	#tblActiveCloneCycle T, #DA_JobCopyList JC, ArchAppCopyToBeAged AC
		WHERE	T.AppId = JC.AppId
		AND 	T.FileType = JC.FileType
		AND 	T.CommCellId = JC.CommCellId
		AND		T.fullCycleNum = JC.fullCycleNum
		AND		T.StartTime >= JC.StartTime
		AND		JC.appId = AC.appId
		AND		JC.copyId = AC.copyId
		AND		JC.FileType = AC.FileType
		AND		JC.dataStatus = 100
		GROUP BY JC.appId, JC.CopyId, JC.FileType, JC.CommCellId, JC.JobId, AC.archGrpId,
						 CASE AC.retentionDays WHEN -1 THEN @maxIntVal ELSE AC.retentionDays END
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention and not marked BAD
		INSERT	INTO #activeCloneJobMaxRet(JobId, CommCellId, FileType, archGrpId, retentionDays)
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.FileType, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#activeCloneJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		TMP.appId	= A.AppId
		AND			TMP.CopyId = A.CopyId
		AND 		TMP.FileType = A.FileType
		AND			TMP.isBad = 0
AND			A.appFlags & 33554432 = 0
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.FileType, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Get job on copy with highest retention if no good job found
		INSERT	INTO #activeCloneJobMaxRet(JobId, CommCellId, FileType, archGrpId, retentionDays)
		SELECT	DISTINCT TMP.JobId, TMP.CommCellId, TMP.FileType, TMP.archGrpId, MAX(TMP.retentionDays)
FROM		#activeCloneJobsOnCopy TMP, ArchAppCopyToBeAged A
		WHERE		TMP.appId	= A.AppId
		AND			TMP.CopyId = A.CopyId
		AND 		TMP.FileType = A.FileType
AND			A.appFlags & 33554432 = 0
		AND			NOT EXISTS (SELECT T.JobId
												FROM #activeCloneJobMaxRet AS T
												WHERE TMP.JobId = T.jobId
												AND 	TMP.CommCellId = T.CommCellId
												AND		TMP.FileType = T.FileType
												AND		TMP.archGrpId = T.archGrpId)
		GROUP BY TMP.JobId, TMP.CommCellId, TMP.FileType, TMP.archGrpId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		---------------------------------------------------------------------------------------------------------------------
		-- Retain all the jobs in the cycle before the job that has active clone running on that copy
		-- Update the jobRetainReason flag with DONOTAGE_ACTIVECLONE
		---------------------------------------------------------------------------------------------------------------------
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 268435456
		FROM	#DA_JobCopyList a, #tblActiveCloneCycle b
		WHERE	a.AppId = b.AppId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND 	a.CommCellId = b.CommCellId
		AND		a.fullCycleNum = b.fullCycleNum
		AND		a.StartTime <= b.StartTime
		AND		a.dataStatus = 100
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		--Do not retain the job on max retention copy if it is already retained on the same copy as active clone
		DELETE #activeCloneJobMaxRet
		FROM #activeCloneJobMaxRet T, #DA_JobCopyList JC
		WHERE T.JobId = JC.JobId
		AND 	T.CommCellId = JC.CommCellId
		AND 	T.FileType = JC.FileType
AND		JC.jobRetainReason & 268435456 > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 268435456
		FROM	#DA_JobCopyList a, #activeCloneJobsOnCopy b, #activeCloneJobMaxRet c
		WHERE	a.JobId = b.JobId
		AND 	a.CommCellId = b.CommCellId
		AND 	a.CopyId = b.CopyId
		AND 	a.FileType = b.FileType
		AND		b.JobId = c.JobId
		AND 	b.CommCellId = c.CommCellId
		AND 	a.FileType = c.FileType
		AND		b.archGrpId = c.archGrpId
		AND		b.retentionDays = c.retentionDays
AND		a.appFlags & 33554432 = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	if object_id('tempdb.dbo.#tblReqCycles') is not null DROP TABLE #tblReqCycles
	if object_id('tempdb.dbo.#tblActiveCloneCycle') is not null DROP TABLE #tblActiveCloneCycle
	if object_id('tempdb.dbo.#activeCloneJobsOnCopy') is not null DROP TABLE #activeCloneJobsOnCopy
	if object_id('tempdb.dbo.#activeCloneJobMaxRet') is not null DROP TABLE #activeCloneJobMaxRet
	if object_id('tempdb.dbo.#tmpSplitCyleInfo') is not null DROP TABLE #tmpSplitCyleInfo
	if object_id('tempdb.dbo.#tmpJobMaxRet') is not null DROP TABLE #tmpJobMaxRet
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyCycleDependencyRule')
	delete from GxQscripts where name = 'daApplyCycleDependencyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyCycleDependencyRule')
	delete from GXDBVersions where aliasname = 'daApplyCycleDependencyRule'
GO

insert into GXDBVersions values(2, 'daApplyCycleDependencyRule',  '00010003011600030000', 'daApplyCycleDependencyRule', '00010003011600030000')
GO

