

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyCompliancePolicyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyCompliancePolicyRule.sp,v $ $Id: daApplyCompliancePolicyRule.sp,v 1.1.290.1 2018/03/20 19:50:54 jiechen Exp $";
--  +============================================================================+
--  | Stored Proc:  daApplyCompliancePolicyRule()
--  |
--  | Description:  Do not age the jobs if they are not processed
--	|								by Compliance Policy
--  +============================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyCompliancePolicyRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyCompliancePolicyRule')
	drop procedure daApplyCompliancePolicyRule
IF EXISTS (select * from GxQscripts where name='daApplyCompliancePolicyRule')
	delete from GxQscripts where name = 'daApplyCompliancePolicyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyCompliancePolicyRule')
	delete from GXDBVersions where aliasname = 'daApplyCompliancePolicyRule'
GO
print '... Creating Procedure: daApplyCompliancePolicyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyCompliancePolicyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE	@errorCode		INTEGER
	SET		@errorCode		= 0
	DECLARE 	@IgnoreCompliancePolicyRule 	INTEGER
	SET		@IgnoreCompliancePolicyRule 	= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @tblCISourceCopyList TABLE
	(
		archGrpId		INT,
		copyId			INT
		PRIMARY KEY (archGrpId, copyId)
	)
	-------------------------------------------------------------------------------
	------------ Apply Compliance Policy Rule based on Param Value ----------------
	-------------------------------------------------------------------------------
	SELECT @IgnoreCompliancePolicyRule = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_IGNORE_COMPLIANCE_POLICY_RULE'
	-------------------------------------------------------------------------------
	--------------------- Apply the Compliance Policy Rule ------------------------
	-------------------------------------------------------------------------------
	IF @IgnoreCompliancePolicyRule = 0
	BEGIN
		-- Call the JM Stored Procedure to populate the jobs pending to be processed
		-- by each available Compliance Policy
		EXEC @errorCode = JMFillCompPolicyQualifiedJobs 0
		IF	@@ERROR != 0 GOTO CX_EXIT
		IF	@errorCode != 0 GOTO CX_EXIT
		INSERT INTO @tblCISourceCopyList
		SELECT DISTINCT CIR.archGroupId, AC.copyId
		FROM archContentIndexingRules CIR WITH (NOLOCK), #DA_AppCopyList AC
		WHERE CIR.archGroupId = AC.archGrpId
		AND		(CIR.sourceCopyId = AC.copyId OR CIR.sourceCopyId = 0)
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
		UPDATE	#DA_JobCopyList
SET 		jobRetainReason = jobRetainReason | 1048576
		FROM	#DA_JobCopyList JC, @tblCISourceCopyList SC, JMCompliancePolicyQualifiedJobs CP WITH (NOLOCK)
		WHERE	JC.jobId = CP.jobId
		AND		JC.commCellId = CP.commCellId
		AND		JC.CopyId = SC.copyId
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyCompliancePolicyRule')
	delete from GxQscripts where name = 'daApplyCompliancePolicyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyCompliancePolicyRule')
	delete from GXDBVersions where aliasname = 'daApplyCompliancePolicyRule'
GO

insert into GXDBVersions values(2, 'daApplyCompliancePolicyRule',  '00010001029000010000', 'daApplyCompliancePolicyRule', '00010001029000010000')
GO

