

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyAuxCopyRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyAuxCopyRule.sp,v $ $Id: daApplyAuxCopyRule.sp,v 1.2.248.1 2018/03/20 19:46:44 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyAuxCopyRule()
--  |
--  | Description:  Do not age the jobs that are not yet copied
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyAuxCopyRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyAuxCopyRule')
	drop procedure daApplyAuxCopyRule
IF EXISTS (select * from GxQscripts where name='daApplyAuxCopyRule')
	delete from GxQscripts where name = 'daApplyAuxCopyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyAuxCopyRule')
	delete from GXDBVersions where aliasname = 'daApplyAuxCopyRule'
GO
print '... Creating Procedure: daApplyAuxCopyRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyAuxCopyRule
  @dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	DECLARE @considerInactiveCopy 	INTEGER
	SET 		@considerInactiveCopy 	= 1
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE	@tblCopySource TABLE(
			CopyId 					int,
			sourceCopyId 		int,
			isActive 				int,
			primaryCopy 		int
			Primary Key (CopyId)
			)
	DECLARE	@tblOldestNotCopied TABLE(
			AppId int, CopyId int, StartTimeOldestNotCopied int,
			Primary Key (AppId, CopyId)
			)
	------------------------------------------------------------------------------------
	---------------------------- Apply the Aux Copy Rule -------------------------------
	------------------------------------------------------------------------------------
	-- Get the configurable value DA_CONFIG_CONSIDER_INACTIVE_COPY_FOR_AUX_COPY_CHECK
	SELECT @considerInactiveCopy = isnull(value, 0)
	FROM mmconfigs
	WHERE name = 'DA_CONFIG_CONSIDER_INACTIVE_COPY_FOR_AUX_COPY_CHECK'
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		-- Get source copy information
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, a.isActive, CASE a.isSnapCopy WHEN 0 THEN b.defaultCopy ELSE b.defaultSnapCopy END
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	--AND		a.isMirrorCopy = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- The source copy will be source of Mirror copy if source copy is Mirror Copy
	WHILE EXISTS(SELECT T.sourceCopyId FROM @tblCopySource T, archGroupCopy AGC WITH (NOLOCK) WHERE	T.sourceCopyId = AGC.id AND AGC.isSnapCopy > 0 AND AGC.isMirrorCopy > 0)
	BEGIN
		UPDATE	@tblCopySource
		SET 	sourceCopyId = AGC.sourceCopyId
		FROM	@tblCopySource T, archGroupCopy AGC WITH (NOLOCK)
		WHERE	T.sourceCopyId = AGC.id
		AND		AGC.isSnapCopy > 0
		AND		AGC.isMirrorCopy > 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- The source copy will be primary copy if no source copy defined
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Check whether to consider the inactive copy for Aux Copy check or not
	IF @considerInactiveCopy = 0
	BEGIN
		-- Do not consider inactive copy for Aux Copy Check
		DELETE	FROM @tblCopySource
		WHERE		copyId = sourceCopyId
		OR 			isActive = 0
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	-- The Jobs on source copy which are not yet copied to destination copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
SET 	RetainForAuxCopy = 1, jobRetainReason = jobRetainReason | 512
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.sourceCopyId
	AND 	b.CopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	c.DataStatus in (101, 102, 103)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Jobs on destination copy which are not yet copied from the source copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
SET 	RetainForAuxCopy = 1, jobRetainReason = jobRetainReason | 512
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.sourceCopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	a.DataStatus in (101, 102, 103)
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- Get oldest uncopied job only for subclients linked to log
	INSERT	INTO @tblOldestNotCopied
	SELECT	a.AppId, a.CopyId, MIN(a.StartTime)
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.RetainForAuxCopy = 1
	AND		b.LinkToLog > 0
	AND 	b.DoNotAge = 0
	GROUP	BY a.AppId, a.CopyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	-- AgeTimeNotCopied will be used by log aging if it is not 0
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeNotCopied = b.StartTimeOldestNotCopied
	FROM	#DA_AppCopyList a, @tblOldestNotCopied b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyAuxCopyRule')
	delete from GxQscripts where name = 'daApplyAuxCopyRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyAuxCopyRule')
	delete from GXDBVersions where aliasname = 'daApplyAuxCopyRule'
GO

insert into GXDBVersions values(2, 'daApplyAuxCopyRule',  '00010002024800010000', 'daApplyAuxCopyRule', '00010002024800010000')
GO

