

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daApplyASRBasicCyclesRule.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daApplyASRBasicCyclesRule.sp,v $ $Id: daApplyASRBasicCyclesRule.sp,v 1.7.78.1 2018/03/20 19:44:38 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daApplyASRBasicCyclesRule()
--  |
--  | Description:  Retain the jobs based on cycle retention on each copy
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daApplyASRBasicCyclesRule <<<'

IF EXISTS (select * from sysobjects where name='daApplyASRBasicCyclesRule')
	drop procedure daApplyASRBasicCyclesRule
IF EXISTS (select * from GxQscripts where name='daApplyASRBasicCyclesRule')
	delete from GxQscripts where name = 'daApplyASRBasicCyclesRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyASRBasicCyclesRule')
	delete from GXDBVersions where aliasname = 'daApplyASRBasicCyclesRule'
GO
print '... Creating Procedure: daApplyASRBasicCyclesRule'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daApplyASRBasicCyclesRule
  @i_PickToBeCopiedJobs INTEGER,
  @i_dummy INTEGER
AS
  DECLARE @o_retVal INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	SET			@errorCode		= 0
	-------------------------------------------------------------------------------
	-- Table variable declarations
	-------------------------------------------------------------------------------
	DECLARE @AppCopyListCursorFlag 						INTEGER
	DECLARE @curAppId													INTEGER
	DECLARE @curCopyId												INTEGER
	DECLARE @curFileType											INTEGER
	DECLARE @curRetentionCycles								INTEGER
	DECLARE @fullJobFound 										INTEGER
	SET 	@AppCopyListCursorFlag 							= 0
	SET 	@curAppId														= 0
	SET 	@curCopyId													= 0
	SET 	@curFileType												= 0
	SET		@curRetentionCycles									= 0
	SET		@fullJobFound 											= 0
	DECLARE	@ReqFullCycles TABLE (
			AppId int, CopyId int, FileType int,
			CommCellId int, StartTime int, fullCycleNum int
			)
	-------------------------------------------------------------------------------
	----------------- Apply the Basic Retention Cycles Rule -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Declare cursor for AppId Copy to be processed -----------------
	-------------------------------------------------------------------------------
	DECLARE	AppCopyListCursor CURSOR STATIC FOR
			SELECT	DISTINCT AppId, CopyId, FileType, RetentionCycles
			FROM	#DA_AppCopyList
			WHERE DoNotAge = 0
			AND 	RetentionCycles > 0
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	SET		@AppCopyListCursorFlag = 1
	OPEN	AppCopyListCursor
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	FETCH	NEXT
	FROM AppCopyListCursor
	INTO	@curAppId, @curCopyId, @curFileType, @curRetentionCycles
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		-- Clean the temp table for each appId/CopyId
		DELETE FROM @ReqFullCycles
		-- Do not Consider the jobs on linked storage policy copy
		-- Partial or Disabled full will be treated as valid cycle based on appType settings
		-- Do Not consider the jobs that are marked bad for cycles retention
		INSERT	INTO #DA_ReqFullCycles
				( AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum )
		SELECT	TOP (@curRetentionCycles) a.AppId, a.CopyId, a.FileType, a.CommCellId, a.JobId, a.StartTime, a.fullCycleNum
		FROM	#DA_JobCopyList a
		WHERE	a.AppId = @curAppId
		AND 	a.CopyId = @curCopyId
		AND 	a.FileType = @curFileType
		AND 	(
						(a.isCWEjobValid = 1 AND a.JobStatus IN (1, 3, 14))
						OR
				 		(a.isCWEjobValid <> 1 AND a.JobStatus IN (1, 14))
					)
		AND 	(
						(@i_PickToBeCopiedJobs = 0 AND a.DataStatus = 100)
						OR
						(@i_PickToBeCopiedJobs = 1 AND ((a.DataStatus = 100) OR (a.DataStatus IN (101, 102, 103) AND a.Disabled = 0)))
					)
AND		(a.JobFlags & 1) = 0
		ORDER	BY a.AppId, a.CopyId, a.FileType, a.StartTime DESC
		SELECT 	@errorCode = @@ERROR, @fullJobFound = @@ROWCOUNT
		IF		@errorCode != 0 GOTO CX_EXIT
		-- If no valid Full job found on copy, then get the required cycle numbers to retain them
		IF		@fullJobFound = 0
		BEGIN
			INSERT	INTO @ReqFullCycles
					( AppId, CopyId, FileType, CommCellId, StartTime, fullCycleNum )
			SELECT	a.AppId, a.CopyId, a.FileType, a.CommCellId, max(StartTime), a.fullCycleNum
			FROM	#DA_JobCopyList a
			WHERE	a.AppId = @curAppId
			AND 	a.CopyId = @curCopyId
			AND 	a.FileType = @curFileType
			GROUP BY a.AppId, a.CopyId, a.FileType, a.CommCellId, a.fullCycleNum
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
			INSERT	INTO #DA_ReqFullCycles
					( AppId, CopyId, FileType, CommCellId, JobId, StartTime, fullCycleNum )
			SELECT	TOP (@curRetentionCycles) a.AppId, a.CopyId, a.FileType, a.CommCellId, 0, 0, a.fullCycleNum
			FROM	@ReqFullCycles a
			ORDER	BY a.AppId, a.CopyId, a.FileType, a.StartTime DESC
			SET	@errorCode	=	@@ERROR
			IF	@errorCode != 0 GOTO CX_EXIT
		END
		FETCH	NEXT
		FROM AppCopyListCursor
		INTO	@curAppId, @curCopyId, @curFileType, @curRetentionCycles
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT
	END
	--------------------------------------------------------------------------------------
	-- Retain the jobs based on cycle number
	--------------------------------------------------------------------------------------
	-- Update the jobRetainReason flag with DONOTAGE_BYASRCYCLES
	UPDATE	#DA_JobCopyList
SET 	jobRetainReason = jobRetainReason | 4096
	FROM	#DA_JobCopyList a, #DA_ReqFullCycles b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		a.CommCellId = b.CommCellId
	AND 	a.fullCycleNum = b.fullCycleNum
	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
CX_EXIT:
	IF @AppCopyListCursorFlag = 1
	BEGIN
			CLOSE				AppCopyListCursor
			DEALLOCATE	AppCopyListCursor
	END
	SELECT	@errorCode
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daApplyASRBasicCyclesRule')
	delete from GxQscripts where name = 'daApplyASRBasicCyclesRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daApplyASRBasicCyclesRule')
	delete from GXDBVersions where aliasname = 'daApplyASRBasicCyclesRule'
GO

insert into GXDBVersions values(2, 'daApplyASRBasicCyclesRule',  '00010007007800010000', 'daApplyASRBasicCyclesRule', '00010007007800010000')
GO

