

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeEraseBkp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeEraseBkp.sp,v $ $Id: daAgeEraseBkp.sp,v 1.6.304.2 2018/03/20 19:57:06 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeEraseBkp()
--  |
--  | Description:  Prune Erase Backups older than the oldest non-erase-backup
--  |				data cross the whole client and appType.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeEraseBkp <<<'

IF EXISTS (select * from sysobjects where name='daAgeEraseBkp')
	drop procedure daAgeEraseBkp
IF EXISTS (select * from GxQscripts where name='daAgeEraseBkp')
	delete from GxQscripts where name = 'daAgeEraseBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeEraseBkp')
	delete from GXDBVersions where aliasname = 'daAgeEraseBkp'
GO
print '... Creating Procedure: daAgeEraseBkp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeEraseBkp
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numAppIdAged	= 0
	SET		@numJobAged		= 0
	BEGIN TRANSACTION TranAgeEraseBkp
	DECLARE @tblEraseAppId TABLE (
			clientId int, appTypeId int, appid int,
			primary key (clientId, appTypeId, appId)
			)
	DECLARE @tblDataAppId TABLE (
			clientId int, appTypeId int, appId int,
			primary key (clientId, appTypeId, appId)
			)
	DECLARE @tblDataArchFile TABLE (
			clientId int, appTypeId int, appId int,
			jobId int, fileType int, archFileId int, commCellId int, cTime int,
			primary key (archFileId, commCellId)
			)
	DECLARE @tblAppDataTime TABLE (
			clientId int, appTypeId int, oldestDataTime int,
			primary key (clientId, appTypeId)
			)
	-- Find Erase Backup appId with archive file
	INSERT	INTO @tblEraseAppId
	SELECT	DISTINCT B.clientId, B.appTypeId, B.id
	FROM	archfile A WITH (NOLOCK), App_Application B WITH (NOLOCK)
	WHERE	A.appId = B.id
AND		B.subclientStatus & 0x0200 > 0
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	-- Find appId in the same client with the same apptype with Index
	INSERT	INTO @tblDataAppId
	SELECT	DISTINCT B.clientId, B.appTypeId, A.appId
	FROM	JMJobDataStats A WITH (NOLOCK), App_Application B WITH (NOLOCK), @tblEraseAppId C
	WHERE	A.appId = B.id
	AND		A.appId <> C.appId
	AND		B.clientId = C.clientId
	AND		B.appTypeId = C.appTypeId
	AND		A.status = 100
	AND		A.disabled & 256 = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Find all archive files for the client and apptype involved
	INSERT	INTO @tblDataArchFile
	SELECT	DISTINCT B.clientId, B.appTypeId, A.appId, A.jobId, A.fileType, A.id, A.commCellId, A.cTime
	FROM	ArchFile A WITH (NOLOCK), App_Application B WITH (NOLOCK), @tblEraseAppId C
	WHERE	A.appId = B.id
	AND		A.isValid = 1
	AND		B.clientId = C.clientId
	AND		B.appTypeId = C.appTypeId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Find oldest data for apptype in @tblDataAppId
	INSERT	INTO @tblAppDataTime
	SELECT	A.clientId, A.appTypeId, MIN(A.cTime)
	FROM	@tblDataArchFile A, ArchFileCopy B WITH (NOLOCK), @tblDataAppId C
	WHERE	A.appId = C.appId
	AND		A.archFileId = B.archFileId
	AND		A.commCellId = B.commCellId
	AND		B.isValid = 1
	AND		B.flags & 256 = 0
	GROUP	BY A.clientId, A.appTypeId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- All selective deletion data older than client oldestDataTime are prunable
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	DISTINCT A.jobId, B.archcopyid, A.filetype, A.commcellid, A.appId
	FROM	@tblDataArchFile a, archfilecopy B WITH (NOLOCK), @tblEraseAppId C, @tblAppDataTime D
	WHERE	A.appId = C.appId
	AND		A.archfileid = B.archfileid
	AND		A.commcellid = B.commcellid
	AND		B.flags & 256 = 0
	AND		C.clientId = D.clientId
	AND		C.appTypeId = D.appTypeId
	AND		A.ctime < D.oldestDataTime
	SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	COMMIT	TRANSACTION TranAgeEraseBkp
	SELECT	@numAppIdAged, @numJobAged
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TranAgeEraseBkp
	SELECT -1, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeEraseBkp')
	delete from GxQscripts where name = 'daAgeEraseBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeEraseBkp')
	delete from GXDBVersions where aliasname = 'daAgeEraseBkp'
GO

insert into GXDBVersions values(2, 'daAgeEraseBkp',  '00010006030400020000', 'daAgeEraseBkp', '00010006030400020000')
GO

