

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeAppIdSqlData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeAppIdSqlData.sp,v $ $Id: daAgeAppIdSqlData.sp,v 1.2.304.2 2018/03/20 20:05:13 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeAppIdSqlData()
--  |
--  | Description:  Age SQL Subclients that have been checked for restore chain.
--	|				It is to be called after daPreSQLAging.sp
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeAppIdSqlData <<<'

IF EXISTS (select * from sysobjects where name='daAgeAppIdSqlData')
	drop procedure daAgeAppIdSqlData
IF EXISTS (select * from GxQscripts where name='daAgeAppIdSqlData')
	delete from GxQscripts where name = 'daAgeAppIdSqlData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdSqlData')
	delete from GXDBVersions where aliasname = 'daAgeAppIdSqlData'
GO
print '... Creating Procedure: daAgeAppIdSqlData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeAppIdSqlData
  @numAppIdToAge INTEGER
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@numJobAged		= 0
	BEGIN TRANSACTION TranDaAgeAppIdSqlData
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	CREATE	TABLE #DA_JobDataStats (
			AppId int, archGrpId int, CopyId int,
			JobId int, CommCellId int, DataStatus int,
			Disabled int, ManualRet int
			)
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	CREATE	TABLE #DA_JobCopyList (
			AppId int, CopyId int, FileType int,
			JobId int, CommCellId int,
			StartTime int,
			BkpLevel int, ManualRet int,
			RetainForAuxCopy int,
			ExtendedJob int
			)
	CREATE INDEX Idx_DA_JobCopyList_1 ON #DA_JobCopyList (AppId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_2 ON #DA_JobCopyList (JobId, CommCellId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_3 ON #DA_JobCopyList (StartTime)
	CREATE INDEX Idx_DA_JobCopyList_4 ON #DA_JobCopyList (BkpLevel)
	DECLARE @tblAppCopyList TABLE (
			AppCopyId int IDENTITY(1,1),
			appId int, copyId int, fileType int,
			Primary key (appId, copyId, fileType)
			)
	DECLARE	@tblCopySource TABLE(
			CopyId int, sourceCopyId int, isActive int, primaryCopy int,
			Primary Key (CopyId)
			)
	DECLARE	@tblOldestNotCopied TABLE(
			AppId int, CopyId int, StartTimeOldestNotCopied int,
			Primary Key (AppId, CopyId)
			)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------------- DATA AGING CALCULATION START HERE -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblAppCopyList
			(appId, copyId, fileType)
	SELECT	appId, copyId, fileType
	FROM	ArchAppCopyToBeAged
WHERE	AgeStatus = 4
	AND 	DoNotAge = 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdToAge > 0
			DELETE	FROM @tblAppCopyList
			WHERE	AppCopyId > @numAppIdToAge
	-- Get appId to be processed
	SELECT	b.*
	INTO	#DA_AppCopyList
	FROM	@tblAppCopyList a, ArchAppCopyToBeAged b
	WHERE	a.appId = b.appId
	AND 	a.copyId = b.copyId
	AND 	a.fileType = b.fileType
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Retrieve data from JMJobDataStats table for given appIds on all copies.
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
			Disabled=MAX(b.Disabled & 1), ManualRet=MAX(b.Disabled & 2)
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
	AND 	b.Disabled & 256 = 0
	AND 	a.FileType = b.dataType
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get all jobs, assume they are all incremental and partially successful by default
	INSERT	INTO #DA_JobCopyList
	SELECT	a.AppId, a.CopyId, a.FileType,
			b.JobId, b.CommCellId,
			StartTime=MIN(b.cTime), BkpLevel=2,
			ManualRet=0, RetainForAuxCopy=0, ExtendedJob=0
	FROM	#DA_AppCopyList a, ArchFile b WITH (NOLOCK), ArchFileCopy c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = c.archCopyId
	AND 	b.id = c.ArchFileId
	AND 	b.CommCellId = c.CommCellId
	AND 	b.isValid <> -1
	AND 	c.Flags & 256 = 0
	AND 	(a.FileType = 0 OR a.FileType = b.FileType)
	GROUP	BY a.AppId, a.CopyId, a.FileType,
			b.JobId, b.CommCellId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numJobCopy = 0 GOTO CX_UPDATE
	-- Do Not Prune Running Job
	DELETE	#DA_JobCopyList
	FROM	#DA_JobCopyList a, JMJobInfo b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate,
			BkpLevel = b.BkpLevel
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- No need to process jobs within basic retention
	DELETE	#DA_JobCopyList
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.StartTime >= b.AgeTimeBasicRet
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Update ManualRet
	UPDATE	#DA_JobCopyList
	SET 	ManualRet = 1
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.ManualRet > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Update ExtendedJob flag for jobs to be retained by extended retention
	UPDATE	#DA_JobCopyList
	SET 	ExtendedJob = 1
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	a.BkpLevel in (1, 64, 128)
	AND 	b.ExtendedRetention = 1
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get source copy information
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, a.isActive, b.defaultCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	DELETE	FROM @tblCopySource
	WHERE	copyId = sourceCopyId OR isActive = 0
	-- Jobs on source copy which to-be-copied to dest copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.sourceCopyId
	AND 	b.CopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	c.DataStatus in (101, 102, 103)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Jobs to-be-copied on dest copy which not disabled on source copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.sourceCopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	a.DataStatus in (101, 102, 103)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get oldest uncopied job only for subclients linked to log
	INSERT	INTO @tblOldestNotCopied
	SELECT	a.AppId, a.CopyId, MIN(a.StartTime)
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.RetainForAuxCopy = 1
	AND		b.LinkToLog > 0
	AND 	b.DoNotAge = 0
	GROUP	BY a.AppId, a.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- AgeTimeNotCopied will be used by log aging if it is not 0
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeNotCopied = b.StartTimeOldestNotCopied
	FROM	#DA_AppCopyList a, @tblOldestNotCopied b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	--***************************************************************************--
	--***************************************************************************--
	--**************     ACTUAL DATABASE UPDATE STARTS NOW    *******************--
	--***************************************************************************--
	--***************************************************************************--
	-- Age jobs older than AgeTimeBasicRet
	-- Jobs older than AgeTimeBasicRet have been filtered out
	-- Jobs cannot be aged if it is retained by manual or extended retention or aux copy
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	JobId, CopyId, FileType, CommCellId, AppId
	FROM	#DA_JobCopyList
	WHERE	ManualRet = 0
	AND 	ExtendedJob = 0
	AND 	RetainForAuxCopy = 0
	SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_UPDATE:
	-- Mark aging results
	UPDATE	ArchAppCopyToBeAged
SET 	AgeStatus = 1
	FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	COMMIT TRANSACTION TranDaAgeAppIdSqlData
	SELECT	@numAppIdAged, @numJobAged
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	ROLLBACK TRANSACTION TranDaAgeAppIdSqlData
	SELECT	-1, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeAppIdSqlData')
	delete from GxQscripts where name = 'daAgeAppIdSqlData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdSqlData')
	delete from GXDBVersions where aliasname = 'daAgeAppIdSqlData'
GO

insert into GXDBVersions values(2, 'daAgeAppIdSqlData',  '00010002030400020000', 'daAgeAppIdSqlData', '00010002030400020000')
GO

