

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeAppIdLogPrepare.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeAppIdLogPrepare.sp,v $ $Id: daAgeAppIdLogPrepare.sp,v 1.2.304.2 2018/03/20 19:48:11 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeAppIdLogPrepare()
--  |
--  | Description:  Process log archive files after all data aging and
--	|				aging time for log have been calculated.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeAppIdLogPrepare <<<'

IF EXISTS (select * from sysobjects where name='daAgeAppIdLogPrepare')
	drop procedure daAgeAppIdLogPrepare
IF EXISTS (select * from GxQscripts where name='daAgeAppIdLogPrepare')
	delete from GxQscripts where name = 'daAgeAppIdLogPrepare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdLogPrepare')
	delete from GXDBVersions where aliasname = 'daAgeAppIdLogPrepare'
GO
print '... Creating Procedure: daAgeAppIdLogPrepare'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeAppIdLogPrepare
AS
  DECLARE @o_numAppIdToAge INTEGER;
	SET NOCOUNT ON
	BEGIN TRANSACTION TranDaAgeAppIdLogPrepare
	DECLARE @numAppIdToAge	INTEGER
	SET		@numAppIdToAge	= 0
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE	@tblLogInstance TABLE ( InstanceId int, AgeTimeForLog int)
	DECLARE	@tblLogBackupSet TABLE ( BackupSetId int, AgeTimeForLog int)
	DECLARE	@tblLogSubclient TABLE ( AppId int, AgeTimeForLog int)
	-- Keep logs forever if its related data are not aged successfully
	UPDATE	ArchAppCopyToBeAged
SET		AgeStatus = 2,
DoNotAge = DoNotAge | 1,
			AgeTimeForLog = -1
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
AND		AgeStatus <> 1
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Retain log based on data retained by basic retention
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = AgeTimeBasicRet
WHERE	AppFlags & 2 > 0
AND		AgeStatus = 1
	AND		LinkToLog > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Jobs not copied will retain logs
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = AgeTimeNotCopied
WHERE	AppFlags & 2 > 0
AND		AgeStatus = 1
	AND		LinkToLog > 0
	AND		AgeTimeNotCopied < AgeTimeForLog
	AND		AgeTimeNotCopied > 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get time for the oldest logs to be retained on Instance level
	INSERT	INTO @tblLogInstance
	SELECT	InstanceId, MIN(AgeTimeForLog)
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
AND		logAgingLevel = 1
	GROUP	BY InstanceId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get time for the oldest logs to be retained on BackupSet level
	INSERT	INTO @tblLogBackupSet
	SELECT	BackupSetId, MIN(AgeTimeForLog)
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
AND		logAgingLevel = 2
	GROUP	BY BackupSetId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get time for the oldest logs to be retained for Subclient on multiple copy
	INSERT	INTO @tblLogSubclient
	SELECT	AppId, MIN(AgeTimeForLog)
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 2 > 0
AND		logAgingLevel = 3
	GROUP	BY AppId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update time for the oldest logs to be retained on Instance level
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
	FROM	ArchAppCopyToBeAged a, @tblLogInstance b
WHERE	a.AppFlags & 4 > 0
	AND 	a.InstanceId = b.InstanceId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update time for the oldest logs to be retained on BackupSet level
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
	FROM	ArchAppCopyToBeAged a, @tblLogBackupSet b
WHERE	a.AppFlags & 4 > 0
	AND 	a.BackupSetId = b.BackupSetId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Update time for the oldest logs to be retained on Subclient level
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = b.AgeTimeForLog
	FROM	ArchAppCopyToBeAged a, @tblLogSubclient b
WHERE	a.AppFlags & 4 > 0
	AND 	a.AppId = b.AppId
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Do not age log if any subclient failed to be aged for its log aging level
	UPDATE	ArchAppCopyToBeAged
SET		AgeStatus = 2,
DoNotAge = DoNotAge | 1
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
	AND		AgeTimeForLog = -1
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Get age time for Subclient based on retention days
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeByDays = @currentTime - RetentionDays * 24 * 60 * 60
WHERE	AppFlags & 4 > 0
	AND		DoNotAge = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Use @currentTime as AgeTimeForLog if no data is found for given log
	UPDATE	ArchAppCopyToBeAged
	SET		AgeTimeForLog = @currentTime
WHERE	AppFlags & 4 > 0
	AND		DoNotAge = 0
	AND		AgeTimeForLog = 0
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	SET		@numAppIdToAge	= (
			SELECT	COUNT(*) FROM ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
			AND 	AgeStatus = 0
			)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
CX_EXIT:
	COMMIT TRANSACTION TranDaAgeAppIdLogPrepare
	SELECT	@numAppIdToAge
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION TranDaAgeAppIdLogPrepare
	SELECT	-1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeAppIdLogPrepare')
	delete from GxQscripts where name = 'daAgeAppIdLogPrepare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdLogPrepare')
	delete from GXDBVersions where aliasname = 'daAgeAppIdLogPrepare'
GO

insert into GXDBVersions values(2, 'daAgeAppIdLogPrepare',  '00010002030400020000', 'daAgeAppIdLogPrepare', '00010002030400020000')
GO

