

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeAppIdLog.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeAppIdLog.sp,v $ $Id: daAgeAppIdLog.sp,v 1.5.304.2 2018/03/20 19:56:53 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeAppIdLog()
--  |
--  | Description:  Process Subclients. ASR, LOG will be aged later!
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeAppIdLog <<<'

IF EXISTS (select * from sysobjects where name='daAgeAppIdLog')
	drop procedure daAgeAppIdLog
IF EXISTS (select * from GxQscripts where name='daAgeAppIdLog')
	delete from GxQscripts where name = 'daAgeAppIdLog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdLog')
	delete from GXDBVersions where aliasname = 'daAgeAppIdLog'
GO
print '... Creating Procedure: daAgeAppIdLog'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeAppIdLog
  @numAppIdToAge INTEGER
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@numJobAged		= 0
	BEGIN TRANSACTION TranDaAgeAppIdLog
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	CREATE	TABLE #DA_JobDataStats (
			AppId int, archGrpId int, CopyId int,
			JobId int, CommCellId int, DataStatus int,
			Disabled int, ManualRet int
			)
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	CREATE	TABLE #DA_JobCopyList (
			AppId int, CopyId int,
			JobId int, CommCellId int,
			AgeTimeByDays int, AgeTimeForLog int,
			StartTime int, BkpLevel int,
			DataStatus int, Disabled int, ManualRet int,
			RetainForAuxCopy int,
			MaxRetCopy int, CanBeAged int
			)
	CREATE INDEX Idx_DA_JobCopyList_1 ON #DA_JobCopyList (AppId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_2 ON #DA_JobCopyList (JobId, CommCellId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_3 ON #DA_JobCopyList (StartTime)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	DECLARE @tblAppIdList TABLE (
			rowId int IDENTITY(1,1),
			appType int,
			appId int,
			fileType int,
			Primary Key (appId, fileType)
			)
	DECLARE @tblJobMaxRet TABLE (
			JobId int, CommCellId int, AgeTimeByDays int,
			Primary Key (JobId, CommCellId)
			)
	DECLARE	@tblJobSelFull TABLE (
			AppId int, CopyId int, DataType int,
			ParentJobId int, ChildJobId int, CommCellId int,
			ParentStatus int, ParentAged int
			)
	DECLARE	@tblCopySource TABLE(
			CopyId int, sourceCopyId int, isActive int, primaryCopy int,
			Primary Key (CopyId)
			)
	DECLARE	@tblOldestNotCopied TABLE(
			AppId int, CopyId int, JobCopyId int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------------- DATA AGING CALCULATION START HERE -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblAppIdList
			(appType, appId, fileType)
	SELECT	DISTINCT appType, appId, fileType
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 4 > 0
	AND		AgeStatus = 0
	ORDER	BY AppType, appId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdToAge > 0
			DELETE	FROM @tblAppIdList
			WHERE	rowId > @numAppIdToAge
	-- Aging status is ignored here
	-- Data on copy which donot need to be aged will still be calculated
	-- to see if its retention is the longest for job
	SELECT	b.*
	INTO	#DA_AppCopyList
	FROM	@tblAppIdList a, ArchAppCopyToBeAged b
WHERE	b.AppFlags & 4 > 0
	AND 	a.appId = b.appId
	AND 	a.fileType = b.fileType
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Retrieve data from JMJobDataStats table for given appIds on all copies.
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
			Disabled=MAX(b.Disabled & 1), ManualRet=MAX(b.Disabled & 2)
	FROM	@tblAppIdList a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
	AND 	b.Disabled & 256 = 0
	AND 	a.FileType = b.dataType
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get jobs from ArchFile table
	-- Assume all jobs can be aged and then apply rules to retain them as needed
	INSERT	INTO #DA_JobCopyList
	SELECT	a.AppId, a.CopyId, b.JobId, b.CommCellId,
			a.AgeTimeByDays, a.AgeTimeForLog, MIN(b.cTime), 1,
			DataStatus=102, Disabled=0, ManualRet=0,
			RetainForAuxCopy=0, MaxRetCopy=1, CanBeAged=1
	FROM	#DA_AppCopyList a, ArchFile b WITH (NOLOCK), ArchFileCopy c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = c.ArchCopyId
	AND 	b.id = c.ArchFileId
	AND 	b.CommCellId = c.CommCellId
	AND 	b.isValid <> -1
	AND 	c.Flags & 256 = 0
	AND 	a.FileType = b.FileType
	GROUP	BY a.AppId, a.CopyId, b.JobId, b.CommCellId,
			a.AgeTimeByDays, a.AgeTimeForLog
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numJobCopy = 0 GOTO CX_UPDATE
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate, Bkplevel = b.BkpLevel
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update DataStatus
	UPDATE	#DA_JobCopyList
	SET 	DataStatus = b.DataStatus
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.DataStatus <> 100
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Update Disabled
	UPDATE	#DA_JobCopyList
	SET 	Disabled = 1
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.Disabled > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Logs manually retained cannot be aged
	UPDATE	#DA_JobCopyList
	SET 	ManualRet = 1, CanBeAged = 0
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.ManualRet > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------  Get Job Retained for Aux Copy   -------------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get source copy information
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, a.isActive, b.defaultCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	DELETE	FROM @tblCopySource
	WHERE	copyId = sourceCopyId OR isActive = 0
	-- Jobs on source copy which to-be-copied to dest copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1, CanBeAged = 0
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.sourceCopyId
	AND 	b.CopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	c.DataStatus in (101, 102, 103)
	-- Jobs to-be-copied on dest copy which not disabled on source copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1, CanBeAged = 0
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.sourceCopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	a.DataStatus in (101, 102, 103)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update DataStatus and Disabled for Selective Online Full
	IF EXISTS (SELECT * FROM #DA_JobCopyList WHERE BkpLevel = 32768)
	BEGIN
			-- Get selective online full linked to log
			-- Assume data part is deleted from database by default
			INSERT	INTO @tblJobSelFull
			SELECT	a.AppId, a.CopyId, 1,
					b.ParentJobId, b.ChildJobId, b.CommCellId,
					ParentStatus=1000, ParentAged=1
			FROM	#DA_JobCopyList a, JMJobDataLink b WITH (NOLOCK)
			WHERE	a.JobId = b.ChildJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.BkpLevel = 32768
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Get job data status for selective online full
			UPDATE	@tblJobSelFull
			SET 	ParentStatus = b.status, ParentAged = b.Disabled & 256
			FROM	@tblJobSelFull a, JMJobDataStats b WITH (NOLOCK)
			WHERE	a.ParentJobId = b.JobId
			AND 	a.CopyId = b.ArchGrpCopyId
			AND 	a.DataType = b.DataType
			AND 	a.CommCellId = b.CommCellId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Log linked selective online full cannot be aged
			UPDATE	#DA_JobCopyList
			SET 	CanBeAged = 0
			FROM	#DA_JobCopyList a, @tblJobSelFull b
			WHERE	a.CanBeAged = 1
			AND		a.JobId = b.ChildJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.ParentStatus <> 1000
			AND		b.ParentAged = 0
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get job max retention time
	-- Consider both valid and to be copied data
	INSERT	INTO @tblJobMaxRet
	SELECT	JobId, CommCellId, MIN(AgeTimeByDays)
	FROM	#DA_JobCopyList
	WHERE	DataStatus = 100 OR RetainForAuxCopy = 1
	GROUP BY JobId, CommCellId
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	MaxRetCopy = 0
	FROM	#DA_JobCopyList a, @tblJobMaxRet b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		a.AgeTimeByDays <> b.AgeTimeByDays
	-- Jobs on copy with max retention days run after AgeTimeForLog cannot be aged
	UPDATE	#DA_JobCopyList
	SET		CanBeAged = 0
	FROM	#DA_JobCopyList
	WHERE	CanBeAged = 1
	AND		MaxRetCopy = 1
	AND		StartTime >= AgeTimeForLog
	-- Jobs within copy basic retention days cannot be aged
	UPDATE	#DA_JobCopyList
	SET		CanBeAged = 0
	WHERE	CanBeAged = 1
	AND		StartTime >= AgeTimeByDays
	--***************************************************************************--
	--***************************************************************************--
	--**************     ACTUAL DATABASE UPDATE STARTS NOW    *******************--
	--***************************************************************************--
	--***************************************************************************--
	INSERT	INTO ArchJobCopyToBeAged
SELECT	a.JobId, a.CopyId, 4, a.CommCellId, a.AppId
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND		a.CanBeAged = 1
AND		(b.AgeStatus = 4 OR b.AgeStatus = 0)
	SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_UPDATE:
	-- Mark Subclient on Copy Aged
	UPDATE	ArchAppCopyToBeAged
SET 	AgeStatus = 1
	FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
AND		(a.AgeStatus = 4 OR a.AgeStatus = 0)
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	COMMIT TRANSACTION TranDaAgeAppIdLog
	SELECT	@numAppIdAged, @numJobAged
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	ROLLBACK TRANSACTION TranDaAgeAppIdLog
	SELECT	-1, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeAppIdLog')
	delete from GxQscripts where name = 'daAgeAppIdLog'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdLog')
	delete from GXDBVersions where aliasname = 'daAgeAppIdLog'
GO

insert into GXDBVersions values(2, 'daAgeAppIdLog',  '00010005030400020000', 'daAgeAppIdLog', '00010005030400020000')
GO

