

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeAppIdByRules.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeAppIdByRules.sp,v $ $Id: daAgeAppIdByRules.sp,v 1.14.304.2 2018/03/20 19:52:34 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeAppIdByRules()
--  |
--  | Description:  Process data of Subclients. ASR, LOG are not aged here.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeAppIdByRules <<<'

IF EXISTS (select * from sysobjects where name='daAgeAppIdByRules')
	drop procedure daAgeAppIdByRules
IF EXISTS (select * from GxQscripts where name='daAgeAppIdByRules')
	delete from GxQscripts where name = 'daAgeAppIdByRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdByRules')
	delete from GXDBVersions where aliasname = 'daAgeAppIdByRules'
GO
print '... Creating Procedure: daAgeAppIdByRules'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeAppIdByRules
  @numAppIdToAge INTEGER,
  @appSqlFlag INTEGER
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@numJobAged		= 0
	BEGIN TRANSACTION TranDaAgeAppIdByRules
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyTemp') is not null DROP TABLE #DA_JobCopyTemp
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	CREATE	TABLE #DA_JobDataStats (
			AppId int, archGrpId int, CopyId int,
			JobId int, CommCellId int, DataStatus int,
			Disabled int, ManualRet int
			)
	CREATE	TABLE #DA_JobCopyTemp (
			AppId int, CopyId int, JobId int, CommCellId int, StartTime int,
			Primary Key (AppId, CopyId, JobId, CommCellId)
			)
	CREATE	TABLE #DA_JobCopyList (
			AppId int, AppFlags int,
			CopyId int, FileType int,
			JobId int, CommCellId int,
			StartTime int, EndTime int,
			BkpLevel int, JobStatus int,
			DataStatus int, Disabled int,
			ManualRet int, RetainForAuxCopy int,
			ExtendedJob int, OnLinkedSP int
			)
	CREATE INDEX Idx_DA_JobCopyList_1 ON #DA_JobCopyList (AppId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_2 ON #DA_JobCopyList (JobId, CommCellId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_3 ON #DA_JobCopyList (StartTime)
	CREATE INDEX Idx_DA_JobCopyList_4 ON #DA_JobCopyList (BkpLevel)
	-- Identity used to prevent two jobs have the same start time due to job queue
	CREATE	TABLE #DA_JobRetDays (
			JobCopyId int IDENTITY(1,1),
			AppId int, CopyId int,
			JobId int, CommCellId int,
			BkpLevel int, StartTime int, EndTime int,
			Primary Key (JobCopyId)
			)
	CREATE INDEX Idx_DA_JobRetDays ON #DA_JobRetDays (AppId, CopyId, EndTime)
	-- Identity used to prevent two jobs have the same start time due to job queue
	CREATE	TABLE #DA_JobFullCycles (
			JobCopyId int IDENTITY(1,1),
			AppId int, CopyId int,
			JobId int, CommCellId int,
			StartTime int,
			Primary Key (JobCopyId)
			)
	CREATE INDEX Idx_DA_JobFullCycles ON #DA_JobFullCycles (AppId, CopyId)
	-- Identity used to prevent two archive files have the same cTime
	CREATE	TABLE #DA_ArchFileSQLDB (
			AFileId int IDENTITY(1,1),
			AppId int, ArchFileId int,
			JobId int, CommCellId int,
			StartTime int, SqlDbBackupFileId int,
			Primary Key (AFileId)
			)
	CREATE INDEX Idx_DA_ArchFileSQLDB_1 ON #DA_ArchFileSQLDB (JobId, CommCellId)
	CREATE INDEX Idx_DA_ArchFileSQLDB_2 ON #DA_ArchFileSQLDB (ArchFileId, CommCellId)
	CREATE INDEX Idx_DA_ArchFileSQLDB_3 ON #DA_ArchFileSQLDB (SqlDbBackupFileId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	DECLARE @tblAppCopyList TABLE (
			AppCopyId int IDENTITY(1,1),
			appId int,
			copyId int,
			fileType int,
			Primary key (appId, copyId, fileType)
			)
	DECLARE	@tblJobSelFullLog TABLE (
			AppId int, CopyId int, FileType int,
			ParentJobId int, ChildJobId int, CommCellId int,
			DataStatus int, Disabled int
			)
	DECLARE	@tblOldestJob TABLE (
			AppId int,
			CopyId int,
			FileType int,
			StartTimeOldestJob int,
			Primary Key (AppId, CopyId, FileType)
	)
	DECLARE	@tblCopySource TABLE(
			CopyId int, sourceCopyId int, isActive int, primaryCopy int,
			Primary Key (CopyId)
			)
	DECLARE @tblJobOnLinkedSP TABLE (
			AppId int, AppFlags int, CopyId int, FileType int,
			JobId int, CommCellId int
			)
	DECLARE	@tblOldestNotCopied TABLE(
			AppId int, CopyId int, StartTimeOldestNotCopied int,
			Primary Key (AppId, CopyId)
			)
	DECLARE	@tblJobAfterRetDays TABLE(
			AppId int, CopyId int, JobCopyId int,
			StartTime int, BkpLevel int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	DECLARE	@tblJobBeforeRetDays TABLE(
			AppId int, CopyId int, JobCopyId int,
			StartTime int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	DECLARE	@tblJobRetCycles TABLE(
			AppId int, CopyId int, JobCopyId int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------------- DATA AGING CALCULATION START HERE -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	IF @appSqlFlag = 0
	BEGIN
			INSERT	INTO @tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
			FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & (2 | 16 | 32) =  2
			ORDER	BY copyId, appType, appId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
IF @appSqlFlag = 16
	BEGIN
			INSERT	INTO @tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
			FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & 16 > 0
			ORDER	BY copyId, appType, appId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
IF @appSqlFlag = 32
	BEGIN
			INSERT	INTO @tblAppCopyList
					(appId, copyId, fileType)
			SELECT	appId, copyId, fileType
			FROM	ArchAppCopyToBeAged
			WHERE	AgeStatus = 0
AND		AppFlags & 32 > 0
			ORDER	BY copyId, appType, appId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
	IF		@numAppIdToAge > 0
			DELETE	FROM @tblAppCopyList
			WHERE	AppCopyId > @numAppIdToAge
	-- Get appId to be processed
	SELECT	b.*
	INTO	#DA_AppCopyList
	FROM	@tblAppCopyList a, ArchAppCopyToBeAged b
	WHERE	a.appId = b.appId
	AND 	a.copyId = b.copyId
	AND 	a.fileType = b.fileType
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Retrieve data from JMJobDataStats table for given appIds on all copies.
	-- This table may contain entries for ASR backup
	INSERT	INTO #DA_JobDataStats
	SELECT	b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId, DataStatus=MAX(b.status),
Disabled=MAX(b.Disabled & 1), ManualRet=MAX(b.Disabled & 2)
	FROM	#DA_AppCopyList a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	b.status <> 1000
AND 	b.Disabled & 256 = 0
	AND 	(a.FileType = 0 OR a.FileType = b.dataType)
	GROUP	BY b.AppId, b.archGrpId, b.archGrpCopyId,
			b.JobId, b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	CREATE INDEX Idx_DA_JobDataStats ON #DA_JobDataStats (JobId, CommCellId, CopyId)
	-- Remove ASR backups if there is any
	DELETE	#DA_JobDataStats
	FROM	#DA_JobDataStats a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	AND		b.BkpLevel = 512
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get jobs from ArchFile table
	INSERT	INTO #DA_JobCopyTemp
	SELECT	a.AppId, a.CopyId, b.JobId, b.CommCellId, MIN(b.cTime)
	FROM	#DA_AppCopyList a, ArchFile b WITH (NOLOCK), ArchFileCopy c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = c.ArchCopyId
	AND 	b.id = c.ArchFileId
	AND 	b.CommCellId = c.CommCellId
	AND 	b.isValid <> -1
	AND 	b.BackupLevel <> 512 --?
AND 	c.Flags & 256 = 0
	AND 	(a.FileType = 0 OR a.FileType = b.FileType)
	GROUP	BY a.AppId, a.CopyId, b.JobId, b.CommCellId
	-- DATODO - backuplevel is set by application and is unreliable - ask system test to run ASR backup and check archfile backuplevel
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Add jobs from JMJobDataStats table with no archive file
	-- This will ensure extended retention being covered for jobs not yet copied
	-- This will also allow to be copied jobs being considered for basic retention
	-- It will ensure to be copied jobs being aged if basic retention reached
	INSERT	INTO #DA_JobCopyTemp
	SELECT	b.AppId, b.CopyId, b.JobId, b.CommCellId, 0
	FROM	 #DA_JobDataStats b
				 LEFT OUTER JOIN #DA_JobCopyTemp c ON
						c.AppId = b.AppId
						AND		c.CopyId = b.CopyId
						AND		c.JobId = b.JobId
						AND		c.CommCellId = b.CommCellId
  WHERE c.JobId is null
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get all jobs with archive files, assume they are all incremental and partially successful by default
	INSERT	INTO #DA_JobCopyList
	SELECT	a.AppId, a.AppFlags, a.CopyId, a.FileType,
			b.JobId, b.CommCellId,
			b.StartTime, EndTime=0,
			BkpLevel=2, JobStatus=3,
			DataStatus=102, Disabled=0, ManualRet=0,
			RetainForAuxCopy=0,
			ExtendedJob=0, OnLinkedSP=0
	FROM	#DA_AppCopyList a, #DA_JobCopyTemp b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numJobCopy = 0 GOTO CX_UPDATE
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStartDate,
			EndTime = b.ServEndDate,
			BkpLevel = b.BkpLevel,
			JobStatus = b.Status
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Update job info for DR backup and ERASE backup
	UPDATE	#DA_JobCopyList
	SET 	StartTime = b.ServStart,
			EndTime = b.ServEnd,
			BkpLevel = b.ER_BkpLevel,
			JobStatus = b.Status
	FROM	#DA_JobCopyList a, JMAdminJobStatsTable b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_JobCopyList
	SET 	EndTime = StartTime
	WHERE	EndTime = 0
	/*  put into below query
	-- Update DataStatus
	UPDATE	#DA_JobCopyList
	SET 	DataStatus = b.DataStatus
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.DataStatus <> 100
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	*/
	-- Update Disabled and ManualRet
	UPDATE	#DA_JobCopyList
	SET 	Disabled = b.Disabled,
				ManualRet = b.ManualRet,
				DataStatus = b.DataStatus
				-- DATODO - why keep fully copied and available jobs set as partially copied??
	FROM	#DA_JobCopyList a, #DA_JobDataStats b
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND 	a.CopyId = b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Do not process disabled job without data
	DELETE	FROM #DA_JobCopyList
	WHERE	DataStatus = 101
	AND		Disabled > 0
	-- DATODO - is case taken care of where job is disabled on source?
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update DataStatus and Disabled for Selective Online Full
	IF EXISTS (SELECT * FROM #DA_JobCopyList WHERE BkpLevel = 32768)
	BEGIN
			-- Get logs linked to selective online full
			INSERT	INTO @tblJobSelFullLog
SELECT	a.AppId, a.CopyId, 4,
					b.ParentJobId, b.ChildJobId, b.CommCellId,
					DataStatus=101, Disabled=0
			FROM	#DA_JobCopyList a, JMJobDataLink b WITH (NOLOCK)
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.BkpLevel = 32768
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Get job data status for selective online full logs
			UPDATE	@tblJobSelFullLog
SET 	DataStatus = b.status, Disabled = b.Disabled & 1
			FROM	@tblJobSelFullLog a, JMJobDataStats b WITH (NOLOCK)
			WHERE	a.ChildJobId = b.JobId
			AND 	a.CopyId = b.ArchGrpCopyId
			AND 	a.FileType = b.DataType
			AND 	a.CommCellId = b.CommCellId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Update DataStatus for selective online full
			-- Assume parent job is to-be-copied if its child job is to-be-copied
			UPDATE	#DA_JobCopyList
			SET 	DataStatus = b.DataStatus
			FROM	#DA_JobCopyList a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.DataStatus <> 100
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Update Disabled for selective online full
			-- Assume parent job is disabled if its child job is disabled
			UPDATE	#DA_JobCopyList
			SET 	Disabled = 1
			FROM	#DA_JobCopyList a, @tblJobSelFullLog b
			WHERE	a.JobId = b.ParentJobId
			AND 	a.CommCellId = b.CommCellId
			AND 	a.CopyId = b.CopyId
			AND 	b.Disabled > 0
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update ExtendedJob flag for jobs to be retained by extended retention
	UPDATE	#DA_JobCopyList
	SET 	ExtendedJob = 1
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND 	b.ExtendedRetention = 1
AND 	( b.AppFlags & 1024 = 0 AND a.BkpLevel = 1
OR  	  b.AppFlags & 1024 > 0 AND a.BkpLevel in (1024, 32768) )
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Treat Synthetic Fulls, offline fulls and Migrator Jobs as Regular Fulls
	-- This is to simply pruning logic for time based and extended retention
	UPDATE	#DA_JobCopyList
	SET 	BkpLevel = 1
	WHERE	BkpLevel in (64, 128, 1024, 32768)
OR  	AppFlags & 2048 > 0
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------  Get Job Retained for Aux Copy   -------------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- SKIP CHAINED SQL SUBCLIENTS FOR NOT COPIED CHECKING
	-- CHAINED SQL SUBCLIENTS WILL BE AGED BY daAgeAppIdSQL
	IF @appSqlFlag > 0 GOTO SKIP_AUX_COPY_CHECK_FOR_SQL
	-- Get source copy information
	INSERT	INTO @tblCopySource
	SELECT	a.id, a.sourceCopyId, a.isActive, b.defaultCopy
	FROM	archGroupCopy a WITH (NOLOCK), archGroup b WITH (NOLOCK)
	WHERE	a.archGroupId = b.id
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblCopySource
	SET 	sourceCopyId = primaryCopy
	WHERE	sourceCopyId = 0
	DELETE	FROM @tblCopySource
	WHERE	copyId = sourceCopyId OR isActive = 0
	-- Jobs on source copy which to-be-copied to dest copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.sourceCopyId
	AND 	b.CopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	c.DataStatus in (101, 102, 103)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Jobs to-be-copied on dest copy which not disabled on source copy will be retained for aux copy
	UPDATE	#DA_JobCopyList
	SET 	RetainForAuxCopy = 1
	FROM	#DA_JobCopyList a, @tblCopySource b, #DA_JobDataStats c
	WHERE	a.JobId = c.JobId
	AND 	a.CommCellId = c.CommCellId
	AND 	a.CopyId = b.CopyId
	AND 	b.sourceCopyId = c.CopyId
	AND 	a.Disabled = 0
	AND 	c.Disabled = 0
	AND 	a.DataStatus in (101, 102, 103)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Get oldest uncopied job only for subclients linked to log
	INSERT	INTO @tblOldestNotCopied
	SELECT	a.AppId, a.CopyId, MIN(a.StartTime)
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.RetainForAuxCopy = 1
	AND		b.LinkToLog > 0
	AND 	b.DoNotAge = 0
	GROUP	BY a.AppId, a.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- AgeTimeNotCopied will be used by log aging if it is not 0
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeNotCopied = b.StartTimeOldestNotCopied
	FROM	#DA_AppCopyList a, @tblOldestNotCopied b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Skip checking aux copy status for SQL jobs that needs to be chained and aged later
	SKIP_AUX_COPY_CHECK_FOR_SQL:
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Start to calculate the time used to age data  -----------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblOldestJob
	SELECT	b.AppId, b.CopyId, b.FileType,
			MIN(a.StartTime)
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	AND		(a.dataStatus = 100 or a.RetainForAuxCopy = 1)
	GROUP	BY b.AppId, b.CopyId, b.FileType
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Filter out running job after we got oldest data for subclient
	DELETE	#DA_JobCopyList
	FROM	#DA_JobCopyList a, JMJobInfo b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET		StartTimeOldestJob = b.StartTimeOldestJob
	FROM	#DA_AppCopyList a, @tblOldestJob b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		a.FileType = b.FileType
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByDays = @currentTime - RetentionDays * 24 * 60 * 60
	-- Data run after StartTimeLastFull cannot be aged
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByDays = StartTimeLastFull
	WHERE	AgeTimeByDays > StartTimeLastFull
	AND		StartTimeLastFull > 0
	-- NOTHING prunable based on RetentionDays
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByDays = StartTimeOldestJob,
DoNotAge = DoNotAge | 16
	WHERE	DoNotAge = 0
	AND 	StartTimeOldestJob >= AgeTimeByDays
	-------------------------------------------------------------------------------
	------------- Combine Jobs When Incrmental Storage Policy Defined -------------
	-------------------------------------------------------------------------------
	-- Get all valid jobs to be combined and assign its current CopyId
	INSERT	INTO @tblJobOnLinkedSP
	SELECT	DISTINCT a.AppId, a.AppFlags,
			a.CopyId, a.FileType, b.JobId, b.CommCellId
	FROM	#DA_AppCopyList a, #DA_JobDataStats b
	WHERE	a.AppId = b.AppId
	AND 	a.IncrArchGrpId > 0
	AND 	b.DataStatus = 100
	AND 		((a.ArchGrpId = a.FullArchGrpId AND b.ArchGrpId = a.IncrArchGrpId)
			OR	 (a.ArchGrpId = a.IncrArchGrpId AND b.ArchGrpId = a.FullArchGrpId))
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Set DataStatus = 100 and OnLinkedSP = 1 for jobs linked
	INSERT	INTO #DA_JobCopyList
	SELECT	a.AppId, a.AppFlags, a.CopyId, a.FileType,
			a.JobId, a.CommCellId,
			b.servStartDate, b.servEndDate,
			b.BkpLevel, b.status,
			100, 0, 0, 0, 0, 1
	FROM	@tblJobOnLinkedSP a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND 	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	AND		b.BkpLevel <> 512
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-------------- Get Oldest Job by Retention Days   -----------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Use EndTime to sort because no two jobs of the same AppId should have same EndTime
	INSERT	INTO #DA_JobRetDays
			( AppId, CopyId, JobId, CommCellId,
			BkpLevel, StartTime, EndTime )
	SELECT	a.AppId, a.CopyId,
			a.JobId, a.CommCellId,
			a.BkpLevel, a.StartTime, a.EndTime
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	b.DoNotAge = 0
	AND 	b.RetentionDays > 0
	ORDER	BY a.AppId, a.CopyId, a.EndTime, a.JobId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get the job right after AgeTimeByDays
	-- Use EndTime to search here to catch job started before AgeTimeByDays but finished after
	-- Default AgeTimeByDays = currentTime for AppId on copy
	INSERT	INTO @tblJobAfterRetDays
	SELECT	a.AppId, a.CopyId, MIN(a.JobCopyId), @currentTime, 1
	FROM	#DA_JobRetDays a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.EndTime >= b.AgeTimeByDays
	AND 	b.RetentionDays > 0
	GROUP	BY a.AppId, a.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblJobAfterRetDays
	SET 	StartTime = b.StartTime, BkpLevel = b.BkpLevel
	FROM	@tblJobAfterRetDays a, #DA_JobRetDays b
	WHERE	a.JobCopyId = b.JobCopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- All data can be aged after the full found based on retention days
	-- All data can be aged for appId in @tblJobAfterRetDays with JobCopyId = 0
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByDays = b.StartTime
	FROM	#DA_AppCopyList a, @tblJobAfterRetDays b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	b.BkpLevel = 1
	-- Remove appIds which have been processed
	DELETE	#DA_JobRetDays
	FROM	#DA_JobRetDays a, @tblJobAfterRetDays b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	b.BkpLevel = 1
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	IF EXISTS (SELECT * FROM #DA_JobRetDays)
	BEGIN
			-- Non-Full job found right after AgeTimeByDays
			-- Get full job right before AgeTimeByDays
			-- Default AgeTimeByDays = StartTimeOldestJob for AppId on copy when no full found before AgeTimeByDays
			-- Use EndTime to search here to catch job started before AgeTimeByDays but finished after
			INSERT	INTO @tblJobBeforeRetDays
			SELECT	a.AppId, a.CopyId, MAX(a.JobCopyId), b.StartTimeOldestJob
			FROM	#DA_JobRetDays a, #DA_AppCopyList b
			WHERE	a.AppId = b.AppId
			AND 	a.CopyId = b.CopyId
			AND 	a.EndTime < b.AgeTimeByDays
			AND 	a.BkpLevel = 1
			AND 	b.RetentionDays > 0
			GROUP	BY a.AppId, a.CopyId, b.StartTimeOldestJob
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			UPDATE	@tblJobBeforeRetDays
			SET 	StartTime = b.StartTime
			FROM	@tblJobBeforeRetDays a, #DA_JobRetDays b
			WHERE	a.JobCopyId = b.JobCopyId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
			-- Full job found before AgeTimeByDays
			-- All backups are prunable after the full found based on RetentionDays
			-- No data can be aged for appId in @tblJobBeforeRetDays with JobCopyId = 0
			UPDATE	#DA_AppCopyList
			SET 	AgeTimeByDays = b.StartTime
			FROM	#DA_AppCopyList a, @tblJobBeforeRetDays b
			WHERE	a.AppId = b.AppId
			AND 	a.CopyId = b.CopyId
			IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	END
	-- NOTHING prunable based on RetentionDays
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByDays = StartTimeOldestJob,
DoNotAge = DoNotAge | 16
	WHERE	DoNotAge = 0
	AND 	StartTimeOldestJob >= AgeTimeByDays
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------  Get Oldest Job by Retention Cycles  ---------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Set aging time to current time by default
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByCycles = @currentTime
	-- Partial or Disabled full won't be treated as valid cycle
	INSERT	INTO #DA_JobFullCycles
			( AppId, CopyId, JobId, CommCellId, StartTime )
	SELECT	a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.BkpLevel = 1
	AND 	a.JobStatus = 1
	AND 	a.DataStatus = 100
	AND 	a.Disabled = 0
	AND 	b.DoNotAge = 0
	AND 	b.RetentionCycles > 0
	ORDER	BY a.AppId, a.CopyId, a.EndTime, a.JobId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblJobRetCycles
	SELECT	T1.AppId, T1.CopyId, T1.JobCopyId
	FROM	#DA_JobFullCycles T1, #DA_AppCopyList T3
	WHERE	T1.AppId = T3.AppId
	AND 	T1.CopyId = T3.CopyId
	AND 	EXISTS (
			SELECT  *
			FROM	#DA_JobFullCycles T2
			WHERE	T2.AppId = T1.AppId
			AND 	T2.CopyId = T1.CopyId
			AND 	T2.JobCopyId >= T1.JobCopyId
			GROUP	BY AppId, CopyId
			HAVING	COUNT(*) <= T3.RetentionCycles)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByCycles = b.StartTime
	FROM	#DA_AppCopyList a, #DA_JobFullCycles b,
			( SELECT	AppId, CopyId, MIN(JobCopyId) as JobCopyId
			 FROM	@tblJobRetCycles
			 GROUP	BY AppId, CopyId ) c
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	b.JobCopyId = c.JobCopyId
	-- Retain all jobs if not enough cycles found
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByCycles = StartTimeOldestJob,
DoNotAge = DoNotAge | 32
	FROM	#DA_AppCopyList a,
			( SELECT	AppId, CopyId, COUNT(JobCopyId) as NumCycle
			 FROM	@tblJobRetCycles
			 GROUP	BY AppId, CopyId ) b
	WHERE	a.DoNotAge = 0
	AND 	a.RetentionCycles > 0
	AND 	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	b.NumCycle < a.RetentionCycles
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Set	AgeTimeBasicRet to the MIN of the following
	--		AgeTimeByDays int,
	--		AgeTimeByCycles int,
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeBasicRet = AgeTimeByDays
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeBasicRet = AgeTimeByCycles
	WHERE	AgeTimeByDays > AgeTimeByCycles
	--***************************************************************************--
	--***************************************************************************--
	--**************     ACTUAL DATABASE UPDATE STARTS NOW    *******************--
	--***************************************************************************--
	--***************************************************************************--
	-- Age jobs older than AgeTimeBasicRet
	-- Jobs are not retained by extended retention and aux copy
	IF @appSqlFlag = 0
	BEGIN
			INSERT	INTO ArchJobCopyToBeAged
			SELECT	a.JobId, a.CopyId, a.FileType, a.CommCellId, a.AppId
			FROM	#DA_JobCopyList a, #DA_AppCopyList b
			WHERE	a.AppId = b.AppId
			AND 	a.CopyId = b.CopyId
			AND 	a.FileType = b.FileType
			AND 	a.OnLinkedSP = 0
			AND 	a.ManualRet = 0
			AND 	b.DoNotAge = 0
			AND 	a.ExtendedJob = 0
			AND 	a.RetainForAuxCopy = 0
			AND 	a.StartTime < b.AgeTimeBasicRet
			SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
			IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	END
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Select Jobs to be processed by Extended Retention -------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Jobs in ArchJobCopyExtended will be processed later
	-- Jobs will be marked with extended retention flags if match extended retention rules
	-- Jobs will be aged later if no extended retention applied and older than ageTimeBasicRet
	INSERT	INTO ArchJobCopyExtended
	SELECT	AppId, JobId, CopyId, FileType, CommCellId,
			StartTime, EndTime, DataStatus, JobStatus,
			Disabled, ManualRet, RetainForAuxCopy, 0
	FROM	#DA_JobCopyList
	WHERE	ExtendedJob = 1
	AND 	OnLinkedSP = 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_UPDATE:
	-- Mark Subclient on Copy Aged
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 1
	-- Don not age SQL subclients, mark them to be chained
	UPDATE	#DA_AppCopyList
SET 	AgeStatus = 3
	WHERE	@appSqlFlag > 0
	AND		DoNotAge = 0
	-- Update aging results, some columns are updated for log aging
	UPDATE	ArchAppCopyToBeAged
	SET 	AgeStatus = b.AgeStatus,
			DoNotAge = b.DoNotAge,
			AgeTimeBasicRet = b.AgeTimeBasicRet,
			AgeTimeByDays = b.AgeTimeByDays,
			AgeTimeByCycles = b.AgeTimeByCycles,
			StartTimeOldestJob = b.StartTimeOldestJob
	FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyTemp') is not null DROP TABLE #DA_JobCopyTemp
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	COMMIT TRANSACTION TranDaAgeAppIdByRules
	SELECT	@numAppIdAged, @numJobAged
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobDataStats') is not null DROP TABLE #DA_JobDataStats
	if object_id('tempdb.dbo.#DA_JobCopyTemp') is not null DROP TABLE #DA_JobCopyTemp
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	if object_id('tempdb.dbo.#DA_ArchFileSQLDB') is not null DROP TABLE #DA_ArchFileSQLDB
	ROLLBACK TRANSACTION TranDaAgeAppIdByRules
	SELECT	-1, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeAppIdByRules')
	delete from GxQscripts where name = 'daAgeAppIdByRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdByRules')
	delete from GXDBVersions where aliasname = 'daAgeAppIdByRules'
GO

insert into GXDBVersions values(2, 'daAgeAppIdByRules',  '00010014030400020000', 'daAgeAppIdByRules', '00010014030400020000')
GO

