

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/daAgeAppIdASR.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/daAgeAppIdASR.sp,v $ $Id: daAgeAppIdASR.sp,v 1.6.304.2 2018/03/20 19:47:59 jiechen Exp $";
--  +========================================================================+
--  | Stored Proc:  daAgeAppIdASR()
--  |
--  | Description:  Process ASR backups only.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: daAgeAppIdASR <<<'

IF EXISTS (select * from sysobjects where name='daAgeAppIdASR')
	drop procedure daAgeAppIdASR
IF EXISTS (select * from GxQscripts where name='daAgeAppIdASR')
	delete from GxQscripts where name = 'daAgeAppIdASR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdASR')
	delete from GXDBVersions where aliasname = 'daAgeAppIdASR'
GO
print '... Creating Procedure: daAgeAppIdASR'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure daAgeAppIdASR
AS
  DECLARE @o_numAppIdAged INTEGER;
  DECLARE @o_numJobAged INTEGER;
	SET NOCOUNT ON
	DECLARE @errorCode		INTEGER
	DECLARE @numAppIdAged	INTEGER
	DECLARE @numJobCopy		INTEGER
	DECLARE @numJobAged		INTEGER
	SET		@errorCode		= 0
	SET		@numAppIdAged	= 0
	SET		@numJobCopy		= 0
	SET		@numJobAged		= 0
	BEGIN TRANSACTION TranDaAgeAppIdASR
	DECLARE @currentTime INTEGER
	SET @currentTime = dbo.GetUnixTime(GETUTCDATE())
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	CREATE	TABLE #DA_JobCopyList (
			AppId int, CopyId int,
			JobId int, CommCellId int,
			StartTime int, EndTime int,
			JobStatus int, Disabled int, ManualRet int
			)
	CREATE INDEX Idx_DA_JobCopyList_1 ON #DA_JobCopyList (AppId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_2 ON #DA_JobCopyList (JobId, CommCellId, CopyId)
	CREATE INDEX Idx_DA_JobCopyList_3 ON #DA_JobCopyList (StartTime)
	-- Identity used to prevent two jobs have the same start time due to job queue
	CREATE	TABLE #DA_JobRetDays (
			JobCopyId int IDENTITY(1,1),
			AppId int, CopyId int,
			JobId int, CommCellId int,
			StartTime int, EndTime int,
			Primary Key (JobCopyId)
			)
	CREATE INDEX Idx_DA_JobRetDays ON #DA_JobRetDays (AppId, CopyId)
	-- Identity used to prevent two jobs have the same start time due to job queue
	CREATE	TABLE #DA_JobFullCycles (
			JobCopyId int IDENTITY(1,1),
			AppId int, CopyId int,
			JobId int, CommCellId int,
			StartTime int,
			Primary Key (JobCopyId)
			)
	CREATE INDEX Idx_DA_JobFullCycles ON #DA_JobFullCycles (AppId, CopyId)
	DECLARE	@tblOldestJob TABLE (
			AppId int, CopyId int, StartTimeOldestJob int,
			Primary Key (AppId, CopyId)
			)
	DECLARE	@tblJobAfterRetDays TABLE(
			AppId int, CopyId int, JobCopyId int, StartTime int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	DECLARE	@tblJobRetCycles TABLE(
			AppId int, CopyId int, JobCopyId int,
			Primary Key (AppId, CopyId, JobCopyId)
			)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------------- DATA AGING CALCULATION START HERE -----------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get all appids on copy.
	SELECT	*
	INTO	#DA_AppCopyList
	FROM	ArchAppCopyToBeAged
WHERE	AppFlags & 512 > 0
	AND		DoNotAge = 0
	AND		AgeStatus = 0
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numAppIdAged = 0 GOTO CX_EXIT
	CREATE INDEX Idx_DA_AppCopyList ON #DA_AppCopyList (AppId, CopyId)
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get all jobs, assume they are all incremental and partially successful by default
	INSERT	INTO #DA_JobCopyList
	SELECT	a.AppId, a.CopyId, b.JobId, b.CommCellId,
			StartTime=MIN(b.cTime), EndTime=0,
			JobStatus=3, Disabled=0, ManualRet=0
	FROM	#DA_AppCopyList a, archFile b WITH (NOLOCK), archFileCopy c WITH (NOLOCK)
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = c.archCopyId
	AND		b.id = c.archFileId
	AND		b.CommCellId = c.CommCellId
	AND		b.isValid <> -1
	AND		b.backupLevel = 512
	AND		(c.flags & 256) = 0
	GROUP	BY a.AppId, a.CopyId, b.JobId, b.CommCellId
	SELECT 	@errorCode = @@ERROR, @numJobCopy = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	IF		@numJobCopy = 0 GOTO CX_UPDATE
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Update job info for regular backup
	UPDATE	#DA_JobCopyList
	SET		StartTime = b.servStartDate,
			EndTime = b.servEndDate,
			JobStatus = b.status
	FROM	#DA_JobCopyList a, JMBkpStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_JobCopyList
	SET		EndTime = StartTime
	WHERE	EndTime = 0
	-- Update Disabled and ManualRet
	UPDATE	#DA_JobCopyList
	SET		Disabled = b.Disabled & 1, ManualRet = b.Disabled & 2
	FROM	#DA_JobCopyList a, JMJobDataStats b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND		a.CommCellId = b.CommCellId
	AND		a.CopyId = b.ArchGrpCopyId
	AND		b.Disabled > 0
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------- Start to calculate the time used to age data  -----------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	INSERT	INTO @tblOldestJob
	SELECT	b.AppId, b.CopyId, MIN(a.StartTime)
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	GROUP	BY b.AppId, b.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET		StartTimeOldestJob = b.StartTimeOldestJob
	FROM	#DA_AppCopyList a, @tblOldestJob b
	WHERE	a.AppId = b.AppId
	AND 	a.CopyId = b.CopyId
	-- Filter out running job after we got oldest data for subclient
	DELETE	#DA_JobCopyList
	FROM	#DA_JobCopyList a, JMJobInfo b WITH (NOLOCK)
	WHERE	a.JobId = b.JobId
	AND 	a.CommCellId = b.CommCellId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	#DA_AppCopyList
	SET		AgeTimeByDays = @currentTime - RetentionDays * 24 * 60 * 60
	-- NOTHING prunable based on RetentionDays
	UPDATE	#DA_AppCopyList
	SET		AgeTimeByDays = StartTimeOldestJob,
DoNotAge = DoNotAge | 16
	WHERE	StartTimeOldestJob >= AgeTimeByDays
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-------------- Get Oldest Job by Retention Days   -----------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Use EndTime to sort because no two jobs of the same AppId should have same EndTime
	INSERT	INTO #DA_JobRetDays
			( AppId, CopyId, JobId, CommCellId,
			StartTime, EndTime )
	SELECT	a.AppId, a.CopyId,
			a.JobId, a.CommCellId,
			a.StartTime, a.EndTime
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		b.DoNotAge = 0
	AND 	b.RetentionDays > 0
	ORDER	BY a.AppId, a.CopyId, a.EndTime, a.JobId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Get the job right after AgeTimeByDays
	-- Use EndTime to search here to catch job started before AgeTimeByDays but finished after
	-- Default AgeTimeByDays = currentTime for AppId on copy
	INSERT	INTO @tblJobAfterRetDays
	SELECT	a.AppId, a.CopyId, MIN(a.JobCopyId), @currentTime
	FROM	#DA_JobRetDays a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		a.EndTime >= b.AgeTimeByDays
	AND 	b.RetentionDays > 0
	GROUP	BY a.AppId, a.CopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	UPDATE	@tblJobAfterRetDays
	SET		StartTime = b.StartTime
	FROM	@tblJobAfterRetDays a, #DA_JobRetDays b
	WHERE	a.JobCopyId = b.JobCopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- Full job found right after AgeTimeByDays
	-- All backups are prunable after the full found based on RetentionDays
	UPDATE	#DA_AppCopyList
	SET		AgeTimeByDays = b.StartTime
	FROM	#DA_AppCopyList a, @tblJobAfterRetDays b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	--------------  Get Oldest Job by Retention Cycles  ---------------------------
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Set aging time to current time by default
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeByCycles = @currentTime
	-- Do not check AppId which has been checked for AgeTimeByCycles
	-- Partial or Disabled full won't be treated as valid cycle
	INSERT	INTO #DA_JobFullCycles
			( AppId, CopyId, JobId, CommCellId, StartTime )
	SELECT	a.AppId, a.CopyId, a.JobId, a.CommCellId, a.StartTime
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND 	a.JobStatus = 1
	AND 	a.DataStatus = 100
	AND 	a.Disabled = 0
	AND		b.DoNotAge = 0
	AND 	b.RetentionCycles > 0
	ORDER	BY a.AppId, a.CopyId, a.EndTime, a.JobId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Default AgeTimeByCycles = 0 for AppId on copy
	INSERT	INTO @tblJobRetCycles
	SELECT	T1.AppId, T1.CopyId, T1.JobCopyId
	FROM	#DA_JobFullCycles T1, #DA_AppCopyList T3
	WHERE	T1.AppId = T3.AppId
	AND		T1.CopyId = T3.CopyId
	AND		EXISTS (
			SELECT  *
			FROM	#DA_JobFullCycles T2
			WHERE	T2.AppId = T1.AppId
			AND		T2.CopyId = T1.CopyId
			AND		T2.JobCopyId >= T1.JobCopyId
			GROUP	BY AppId, CopyId
			HAVING	COUNT(*) <= T3.RetentionCycles)
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-- All backups are prunable after the full found based on RetentionCycles
	UPDATE	#DA_AppCopyList
	SET		AgeTimeByCycles = b.StartTime
	FROM	#DA_AppCopyList a, #DA_JobFullCycles b,
			( SELECT	AppId, CopyId, MIN(JobCopyId) as JobCopyId
			 FROM	@tblJobRetCycles
			 GROUP	BY AppId, CopyId ) c
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		b.JobCopyId = c.JobCopyId
	IF		@@ERROR != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
	-- Set	AgeTimeBasicRet to the MIN of the following
	--		AgeTimeByDays int,
	--		AgeTimeByCycles int
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeBasicRet = AgeTimeByDays
	UPDATE	#DA_AppCopyList
	SET 	AgeTimeBasicRet = AgeTimeByCycles
	WHERE	AgeTimeByDays > AgeTimeByCycles
	--***************************************************************************--
	--***************************************************************************--
	--**************     ACTUAL DATABASE UPDATE STARTS NOW    *******************--
	--***************************************************************************--
	--***************************************************************************--
	-- Prune jobs older than AgeTimeBasicRet
	INSERT	INTO ArchJobCopyToBeAged
	SELECT	a.JobId, a.CopyId, 0, a.CommCellId, a.AppId
	FROM	#DA_JobCopyList a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND		a.ManualRet = 0
	AND		b.DoNotAge = 0
	AND		a.StartTime < b.AgeTimeBasicRet
	SELECT 	@errorCode = @@ERROR, @numJobAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_UPDATE:
	-- Update aging results, many column updated just for debug purpose
	UPDATE	ArchAppCopyToBeAged
SET		AgeStatus = 1,
			DoNotAge = b.DoNotAge,
			AgeTimeBasicRet = b.AgeTimeBasicRet,
			AgeTimeByDays = b.AgeTimeByDays,
			AgeTimeByCycles = b.AgeTimeByCycles,
			StartTimeOldestJob = b.StartTimeOldestJob
	FROM	ArchAppCopyToBeAged a, #DA_AppCopyList b
	WHERE	a.AppId = b.AppId
	AND		a.CopyId = b.CopyId
	AND 	a.FileType = b.FileType
	SELECT 	@errorCode = @@ERROR, @numAppIdAged = @@ROWCOUNT
	IF		@errorCode != 0 GOTO CX_ERROR_EXIT
	-------------------------------------------------------------------------------
	-------------------------------------------------------------------------------
CX_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	COMMIT TRANSACTION TranDaAgeAppIdASR
	SELECT	@numAppIdAged, @numJobAged
	RETURN
CX_ERROR_EXIT:
	if object_id('tempdb.dbo.#DA_AppCopyList') is not null DROP TABLE #DA_AppCopyList
	if object_id('tempdb.dbo.#DA_JobCopyList') is not null DROP TABLE #DA_JobCopyList
	if object_id('tempdb.dbo.#DA_JobRetDays') is not null DROP TABLE #DA_JobRetDays
	if object_id('tempdb.dbo.#DA_JobFullCycles') is not null DROP TABLE #DA_JobFullCycles
	ROLLBACK TRANSACTION TranDaAgeAppIdASR
	SELECT	-1, -1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'daAgeAppIdASR')
	delete from GxQscripts where name = 'daAgeAppIdASR'
GO

IF EXISTS (select * from GXDBVersions where aliasname='daAgeAppIdASR')
	delete from GXDBVersions where aliasname = 'daAgeAppIdASR'
GO

insert into GXDBVersions values(2, 'daAgeAppIdASR',  '00010006030400020000', 'daAgeAppIdASR', '00010006030400020000')
GO

