

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cxPurgeUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cxPurgeUser.sp,v $ $Id: cxPurgeUser.sp,v 1.16.42.2 2018/03/22 00:56:24 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						PROCEDURE: "cxPurgeUser"						|
--	|																		|
--	|		Purge all records in all tables for specified UID				|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cxPurgeUser <<<'

IF EXISTS (select * from sysobjects where name='cxPurgeUser')
	drop procedure cxPurgeUser
IF EXISTS (select * from GxQscripts where name='cxPurgeUser')
	delete from GxQscripts where name = 'cxPurgeUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cxPurgeUser')
	delete from GXDBVersions where aliasname = 'cxPurgeUser'
GO
print '... Creating Procedure: cxPurgeUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cxPurgeUser
  @uid integer
AS
  DECLARE @retVal integer;
  DECLARE @retString varchar(64);
begin tran
	DECLARE @rowCount  integer
	DECLARE @thisTable varchar(32)
	set @retString = '>> '
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'TM_Task' TABLE	|
--	+-----------------------------------------------+
	set @thisTable = 'TM_Task'
	delete from TM_Task where ownerId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMProfile' TABLE		|
--	+-----------------------------------------------+
	set @thisTable = 'UMProfile'
	delete UMProfile where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMUserGroup' TABLE	|
--	+-----------------------------------------------+
	set @thisTable = 'UMUserGroup'
	delete UMUserGroup where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+---------------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMDSUserGroup' TABLE	|
--	+---------------------------------------------------+
	set @thisTable = 'UMDSUserGroup'
	delete UMDSUserGroup where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
	DELETE UG 	FROM UMUSERGRoup UG JOIN UMGROUPS G ON G.id=UG.groupId WHERE userId = @uid   and G.umdsProviderId<>0
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-------------------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'UMUserCredentials' TABLE	|
--	+-------------------------------------------------------+
	set @thisTable = 'UMUserCredentials'
	delete UMUserCredentials where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'evFilterContent'	|
--	|  AND 'evFilterName TABLEs						|
--	+-----------------------------------------------+
	set @thisTable = 'evFilterContent'
	DELETE evFilterContent
	WHERE evFilterNameId in (select id from evFilterName where userId = @uid)
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'evFilterName'
	delete evFilterName where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'evParam'			|
--	|  AND 'evMsg TABLEs							|
--	+-----------------------------------------------+
	set @thisTable = 'evParam'
	DELETE evParam
	WHERE evMsgId in (select id from evMsg where userId = @uid)
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'evMsg'
	delete evMsg where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+-----------------------------------------------+
-- 	|  DELETE ENTRIES FROM THE 'JMJobInfo' and 	|
--	|  AND related tables							|
--	+-----------------------------------------------+
	set @thisTable = 'JMBkpAttemptInfo'
	DELETE JMBkpAttemptInfo
	FROM  JMBkpAttemptInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMBkpJobInfo'
	DELETE JMBkpJobInfo
	FROM  JMBkpJobInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMJobStreams'
	DELETE JMJobStreams
	FROM  JMJobStreams b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMRstAttemptInfo'
	DELETE JMRstAttemptInfo
	FROM  JMRstAttemptInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
	set @thisTable = 'JMRstJobInfo'
	DELETE JMRstJobInfo
	FROM  JMRstJobInfo b, JMJobInfo j
	where j.userID = @uid
	 	  AND b.jobId = j.jobId
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	-----------------------------------------------
--	-----------------------------------------------
	set @thisTable = 'JMJobInfo'
	delete JMJobInfo where userId = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+', '+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--	+================================================+
--	+-----------------------------------------------+
-- 	|  FINALLY, CAN NOW DELETE 'user' TABLE entry!	|
--	+-----------------------------------------------+
	set @thisTable = 'UMUsers'
	delete UMUsers where id = @uid
	SELECT @retVal = @@ERROR, @rowCount = @@ROWCOUNT
	if @retVal != 0
		GOTO CX_DELETE_ERROR_EXIT
	set @retString=@retString+@thisTable+'['+convert(varchar(5), @rowCount)+']'
--  +----------------------------+
--  |	NORMAL, 'HAPPY' EXIT:    |
--  +----------------------------+
	select @retVal, @retString
	commit tran
	return @retVal;
--  +----------------------------+
--  |	ABNORMAL, 'ERROR' EXIT:  |
--  +----------------------------+
CX_DELETE_ERROR_EXIT:
	rollback transaction
	select @retVal, @thisTable
	return @retVal
GO

IF EXISTS (select * from GxQscripts where name = 'cxPurgeUser')
	delete from GxQscripts where name = 'cxPurgeUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cxPurgeUser')
	delete from GXDBVersions where aliasname = 'cxPurgeUser'
GO

insert into GXDBVersions values(2, 'cxPurgeUser',  '00010016004200020000', 'cxPurgeUser', '00010016004200020000')
GO

