

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvsp_kill_jobs.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvsp_kill_jobs.sp,v $ $Id: cvsp_kill_jobs.sp,v 1.14.294.1 2017/12/29 20:23:17 pkrishnan Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_kill_jobs()
--  |
--  | Description:  Stored procedure to kill all active jobs
--  |
--  |       Input:  dummyNum
--	|
--  |      Output:  string message
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_kill_jobs <<<'

IF EXISTS (select * from sysobjects where name='cvsp_kill_jobs')
	drop procedure cvsp_kill_jobs
IF EXISTS (select * from GxQscripts where name='cvsp_kill_jobs')
	delete from GxQscripts where name = 'cvsp_kill_jobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_kill_jobs')
	delete from GXDBVersions where aliasname = 'cvsp_kill_jobs'
GO
print '... Creating Procedure: cvsp_kill_jobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvsp_kill_jobs
  @dummyNum integer
AS
SET NOCOUNT ON
BEGIN TRANSACTION KillJobs
select * into #runningJob from JMJobInfo
----------------------------
declare @tmpStr varchar(1024)
set @tmpStr = 'cvsp_kill_jobs -- No running jobs!'
-- Check if there is any running job
declare @rowcount integer
set @rowcount = (select count(*) from JMJobInfo)
if @rowcount = 0 GOTO GOOD_EXIT
----------------------------
-- START: update archive manager tables
set @tmpStr = 'cvsp_kill_jobs -- Failed to kill running jobs!'
-- Do not change isvalid for oracle and informix jobs
-- For all other jobs, set isvalid to -1
update archfile
set isvalid = -1
from archfile b, JMJobInfo c
where b.jobId = c.jobId
and b.commcellid = c.commcellid
and b.appid not in (select id from APP_Application where apptypeid in (2, 3, 22, 23))
if @@ERROR != 0 goto ERROR_EXIT
-- Change killed full backup to incremental for oracle and informix jobs
-- This will prevent data aging to treat it as a full job.
update archfile
set backuplevel = 2
from archfile b, JMJobInfo c
where b.jobId = c.jobId
and b.commcellid = c.commcellid
and b.backuplevel <> 2
and b.appid in (select id from APP_Application where apptypeid in (2, 3, 22, 23))
if @@ERROR != 0 goto ERROR_EXIT
----------------------------
-- START: update media manager tables
update MMCopyManager
set CurrentConcurrency = 0
where copyManagerId != 0
if @@ERROR != 0 goto ERROR_EXIT
update MMDrivePool
set ReservedDrives = 0
where drivePoolId != 0
if @@ERROR != 0 goto ERROR_EXIT
update MMMasterPool
set ReservedDrives = 0
where masterPoolId != 0
if @@ERROR != 0 goto ERROR_EXIT
delete MMMountPath
from MMMountPath a, MMMediaSide b, MMMedia c
where a.mediaSideId = b.mediaSideId and b.mediaId = c.mediaId
and a.mountPathId != 0 and c.mediaTypeId != 10001
if @@ERROR != 0 goto ERROR_EXIT
update MMMountPath
set NumberOfWriters = 0
where mountPathId != 0
if @@ERROR != 0 goto ERROR_EXIT
----------------------------
-- START: update job manager tables
delete JMJobDataLink
from JMJobDataLink b, JMJobInfo c
where ((b.parentJobId = c.jobId )
		or (b.childJobId = c.jobId ))
and b.commcellid = c.commcellid
if @@ERROR != 0 goto ERROR_EXIT
delete JMBkpAttemptInfo
from JMBkpAttemptInfo b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMBkpJobInfo
from JMBkpJobInfo b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMAdminJobAttemptInfoTable
from JMAdminJobAttemptInfoTable b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMAdminJobInfoTable
from JMAdminJobInfoTable b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMJobControlInfo
from JMJobControlInfo b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMRstAttemptInfo
from JMRstAttemptInfo b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete JMRstJobInfo
from JMRstJobInfo b, JMJobInfo c
where b.jobId = c.jobId
if @@ERROR != 0 goto ERROR_EXIT
delete from JMJobInfo
if @@ERROR != 0 goto ERROR_EXIT
-- 07/24/2007, cliu
-- Table JMJobResourceInfo is removed from 7.0
-- delete from JMJobResourceInfo
-- if @@ERROR != 0 goto ERROR_EXIT
----------------------------
delete JMJobStats
from JMJobStats b, #runningJob c
where b.jobId = c.jobId
and b.commcellid = c.commcellid
if @@ERROR != 0 goto ERROR_EXIT
-----------------------------------------------------------------------------------
--************ EXIT ************
GOOD_EXIT:
	DROP TABLE #runningJob
	COMMIT TRANSACTION KillJobs
	select 'cvsp_kill_jobs -- Successful!'
	RETURN 0
ERROR_EXIT:
	DROP TABLE #runningJob
	ROLLBACK TRANSACTION KillJobs
	select @tmpStr
	RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_kill_jobs')
	delete from GxQscripts where name = 'cvsp_kill_jobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_kill_jobs')
	delete from GXDBVersions where aliasname = 'cvsp_kill_jobs'
GO

insert into GXDBVersions values(2, 'cvsp_kill_jobs',  '00010014029400010000', 'cvsp_kill_jobs', '00010014029400010000')
GO

