

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvsp_commcell_clone.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvsp_commcell_clone.sp,v $ $Id: cvsp_commcell_clone.sp,v 1.55.42.5 2018/11/05 22:47:27 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_commcell_clone()
--  |
--  | Description:  Stored procedure to clone commcell
--  |
--  |       Input:  new commcell number
--	|
--  |      Output:  string message
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvsp_commcell_clone')
BEGIN
	print '>>> Drop Stored Procedure: cvsp_commcell_clone <<<'
	drop procedure cvsp_commcell_clone
END
IF EXISTS (select * from GxQscripts where name='cvsp_commcell_clone')
	delete from GxQscripts where name = 'cvsp_commcell_clone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_commcell_clone')
	delete from GXDBVersions where aliasname = 'cvsp_commcell_clone'
GO
print '... Creating Procedure: cvsp_commcell_clone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvsp_commcell_clone
  @currCommCellNum integer,
  @bReuseMedia integer,
  @bStartTransaction integer
AS
  DECLARE @errCode integer
  DECLARE @errStr varchar(1024)
SET NOCOUNT ON
IF 1 = @bStartTransaction
	BEGIN TRANSACTION CloneTran
--************ Check database ************
declare @tmpStr varchar(1024)
declare @retCode integer
-- Check if the database is up to date and exit if so.
declare @rowcount integer
set @rowcount = (select count(*) from APP_CommCell where id = 2 and number = @currCommCellNum)
if @rowcount > 0
begin
	set @tmpStr = 'CommcellClone -- Commserver is up to date!'
	GOTO ERROR_EXIT
end
set @rowcount = (select count(*) from APP_CommCell where number = @currCommCellNum)
if @rowcount > 0
begin
	set @retCode = -1
	set @tmpStr = 'CommcellClone -- commcell number is used already!'
	GOTO ERROR_EXIT
end
declare @lastArchFile integer
set @lastArchFile = (select isnull(next_l, 0) from GXCounter where name = 'lastArchFile')
if @lastArchFile > 0
	set @rowcount = (select count(*) from archfile where commcellid = 2 and id <= @lastArchFile)
if @rowcount > 0
begin
	set @retCode = -1
	set @tmpStr = 'CommcellClone -- Abort: Old data with evaluation license or before 5.0 exist!'
	GOTO ERROR_EXIT
end
--************ Kill all active jobs ************
declare @result table(result varchar(1024))
set @tmpStr = 'CommcellClone -- Failed to kill active jobs!'
insert @result
execute @retCode = cvsp_kill_jobs 0
if @retCode != 0 goto ERROR_EXIT
--************ DB cleanup before cloning ************
delete from ArchJobCopyToBeAged
if @@ERROR > 0 GOTO ERROR_EXIT
delete from ArchMagAFToBeAged
if @@ERROR > 0 GOTO ERROR_EXIT
--************ Create new commcell id ************
declare @currCommCellId integer
set @currCommCellId = 2
set @tmpStr = 'CommcellClone -- Failed to add new commcell id!'
insert into APP_CommCell
select number, 0, parentid, aliasname, flags, reftime, username, userpassword, smtpserver, timezone, ipaddress, modified, ccOpMode, drIpAddress, encNumber, csGUID, type
from APP_CommCell where id = @currCommCellId
if @@ERROR > 0 GOTO ERROR_EXIT
update APP_CommCell set number = @currCommCellNum where id = @currCommCellId
if @@ERROR > 0 GOTO ERROR_EXIT
declare @newCommCellId integer
set @newCommCellId = (select max(id) from APP_CommCell)
-- create a new GUID and update the client props and commcell tables
if exists( select attrVal from APP_ClientProp where componentNameId = @currCommCellId and attrName = 'GUID' and modified = 0)
begin
	update APP_ClientProp set attrVal = newid(), created = dbo.GetUnixTime(GetUTCDate())
	where componentNameId = @currCommCellId and attrName = 'GUID' and modified = 0
end
else
begin
	insert APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			values(@currCommCellId, 'GUID', 1, newid(), dbo.GetUnixTime(GetUTCDate()), 0)
end
update APP_CommCell set csGUID = (select top 1 attrVal from APP_ClientProp where componentNameId = @currCommCellId and attrName = 'GUID' and modified = 0)
where id = @currCommCellId
---------------------------------------------------------
--************ Start to drop foreign keys ************
set @tmpStr = 'CommcellClone -- Failed to drop foreign keys!'
declare @fromTable varchar(1024)
declare @fromColumn varchar(1024)
declare @toTable varchar(1024)
-- archFileCopyDedup.tbl(57): foreign key (archFileId, commCellId, archCopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archFileCopyDedup', @fromColumn = 'archFileId', @toTable = 'archFileCopy'
if @retCode != 0 goto ERROR_EXIT
-- archCopySIDBStore.tbl(57): foreign key (SIDBStoreId, CommCellId) references IdxSIDBStore(SIDBStoreId, commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archCopySIDBStore', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBStore'
if @retCode != 0 goto ERROR_EXIT
-- MMMagLibFADTaskInfo.tbl(57): foreign key (adminJobId, commCellId) references JMJobStats (jobId, commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'MMMagLibFADTaskInfo', @fromColumn = 'adminJobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- archChunkMapping.tbl(57): foreign key (archChunkId, commCellId) references archChunk(id, commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'archChunkMapping', @fromColumn = 'archChunkId', @toTable = 'archChunk'
if @retCode != 0 goto ERROR_EXIT
-- archChunkMapping.tbl(58): foreign key (archFileId, commCellId, archCopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'archChunkMapping', @fromColumn = 'archFileId', @toTable = 'archFileCopy'
if @retCode != 0 goto ERROR_EXIT
-- archDB2Log.tbl(35): foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archDB2Log', @fromColumn = 'archFileId', @toTable = 'archFile'
if @retCode != 0 goto ERROR_EXIT
-- archFileCopy.tbl(42): foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archFileCopy', @fromColumn = 'archFileId', @toTable = 'archFile'
if @retCode != 0 goto ERROR_EXIT
-- archCheckHistory.tbl(76): foreign key (jobID_l,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archCheckHistory', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- CNJobBkpAttemptHistory.tbl(44): foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'CNJobBkpAttemptHistory', @fromColumn = 'JobID', @toTable = 'CNJobBkpHistory'
-- if @retCode != 0 goto ERROR_EXIT
-- CNJobDataStatsHistory.tbl(50): foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'CNJobDataStatsHistory', @fromColumn = 'JobID', @toTable = 'CNJobBkpHistory'
-- if @retCode != 0 goto ERROR_EXIT
-- CNJobQRVolumeHistory.tbl(48): foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'CNJobQRVolumeHistory', @fromColumn = 'JobID', @toTable = 'CNJobBkpHistory'
-- if @retCode != 0 goto ERROR_EXIT
-- CNJobRstAttemptHistory.tbl(37): foreign key (CommCellID, JobID) references CNJobRstHistory (CommCellID, JobID) ON Delete CASCADE
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'CNJobRstAttemptHistory', @fromColumn = 'JobID', @toTable = 'CNJobRstHistory'
-- if @retCode != 0 goto ERROR_EXIT
-- JMQinetixDownloadStatus.tbl(76): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMQinetixDownloadStatus', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMQinetixUpdateStatus.tbl(76): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMQinetixUpdateStatus', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMRegisteredPipelines.tbl(76): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMRegisteredPipelines', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMOracleRACClientsUsed.tbl(76): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMOracleRACClientsUsed', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMAdminJobAttemptStatsTable.tbl(44): foreign key (jobID_h, jobID_l,commCellId) references JMAdminJobStatsTable(jobID_h, jobID_l,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMAdminJobAttemptStatsTable', @fromColumn = 'jobID', @toTable = 'JMAdminJobStatsTable'
if @retCode != 0 goto ERROR_EXIT
-- JMAdminJobStatsTable.tbl(76): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMAdminJobStatsTable', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMBkpAtmptStats.tbl(71): foreign key (jobId,commCellId) references JMBkpStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMBkpAtmptStats', @fromColumn = 'jobId', @toTable = 'JMBkpStats'
if @retCode != 0 goto ERROR_EXIT
-- JMBkpStats.tbl(72): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMBkpStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMDataCopiedStatsTable.tbl(35): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMDataCopiedStatsTable', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMFailureReasonMsg.tbl(46): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMFailureReasonMsg', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobDataLink.tbl(37): foreign key (parentJobId,commCellId) references JMJobStats(jobId,commCellId),
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobDataLink', @fromColumn = 'parentJobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobDataLink.tbl(38): foreign key (childJobId,commCellId) references JMJobStats(jobId,commCellId),
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobDataLink', @fromColumn = 'childJobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobDataStats.tbl(46): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId),
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobDataStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobOptions.tbl(36): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobOptions', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobResourceHistory.tbl(46): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobResourceHistory', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMMisc.tbl(44): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMMisc', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMRestoreAtmptStats.tbl(50): foreign key (jobId,commCellId) references JMRestoreStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMRestoreAtmptStats', @fromColumn = 'jobId', @toTable = 'JMRestoreStats'
if @retCode != 0 goto ERROR_EXIT
-- JMRestoreStats.tbl(59): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMRestoreStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- QRJobVolumeHistory.tbl(39): foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'QRJobVolumeHistory', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- SybArchFileInfo.tbl(29): foreign key (archFileId,commCellId) references archFile(id,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'SybArchFileInfo', @fromColumn = 'archFileId', @toTable = 'archFile'
if @retCode != 0 goto ERROR_EXIT
-- sybSystemDevices.tbl(35): foreign key (sybBackupJobId_l,commCellId) references JMJobStats(jobId,commCellId) on delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'sybSystemDevices', @fromColumn = 'sybBackupJobId_l', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- sybSystemUsages.tbl(33): foreign key (sybBackupJobId_l,commCellId) references JMJobStats(jobId,commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'sybSystemUsages', @fromColumn = 'sybBackupJobId_l', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobSnapshotStats.tbl: foreign key (jobId, commcellId) references JMJobStats(jobId, commcellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobSnapshotStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMCompliancePolicyQualifiedJobs.tbl:  foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMCompliancePolicyQualifiedJobs', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobWF.tbl: foreign key (jobId,commcellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobWF', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMSnapTapeWF.tbl: foreign key (jobId,commcellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
--execute @retCode = cvsp_drop_fkeys @fromTable = 'JMSnapTapeWF', @fromColumn = 'jobId', @toTable = 'JMJobStats'
--if @retCode != 0 goto ERROR_EXIT
-- JMAdminInfoMgmtStats.tbl: foreign key (commCellId) references APP_CommCell(id),
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'JMAdminInfoMgmtStats', @fromColumn = 'commCellId', @toTable = 'APP_CommCell'
-- if @retCode != 0 goto ERROR_EXIT
-- No need to remove a FK that just has a reference to CommcellId
-- JMAdminInfoMgmtStats.tbl: foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMAdminInfoMgmtStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobInfo.tbl: foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobInfo', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- archFileSiloVolume.tbl: foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'archFileSiloVolume', @fromColumn = 'archFileId', @toTable = 'archFile'
if @retCode != 0 goto ERROR_EXIT
IF EXISTS (SELECT * FROM sysobjects WHERE type = 'u' AND name = 'SMSnapShot')
BEGIN
-- SMSnapShot.tbl: foreign key (ArchFileId, CommCellId, CopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON DELETE CASCADE,
execute @retCode = cvsp_drop_fkeys @fromTable = 'SMSnapShot', @fromColumn = 'archFileId', @toTable = 'archFileCopy'
if @retCode != 0 goto ERROR_EXIT
END
-- evFilterName.tbl: foreign key (commCellId) references APP_CommCell(id)
-- execute @retCode = cvsp_drop_fkeys @fromTable = 'evFilterName', @fromColumn = 'commCellId', @toTable = 'APP_CommCell'
-- if @retCode != 0 goto ERROR_EXIT
-- JMJobMiningStats.tbl:   foreign key (jobId, commCellId) references JMJobStats(jobId, commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobMiningStats', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMPreparedJob.tbl:      foreign key (jobId, commCellId) references JMJobStats(jobId, commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMPreparedJob', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- MMTempDeletedAF.tbl:   foreign key (SIDBStoreId, commCellId) references IdxSIDBStore(SIDBStoreId, commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'MMTempDeletedAF', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBStore'
if @retCode != 0 goto ERROR_EXIT
-- IdxSIDBSubStore.tbl:   foreign key (SIDBStoreId, commCellId) references IdxSIDBStore(SIDBStoreId, commCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'IdxSIDBSubStore', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBStore'
if @retCode != 0 goto ERROR_EXIT
-- IdxSIDBRecoveryHistory.tbl:   foreign key (SIDBStoreId, CommCellId)references	 IDXSIDBStore(SIDBStoreId, CommCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'IdxSIDBRecoveryHistory', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBStore'
if @retCode != 0 goto ERROR_EXIT
-- IdxSIDBRecoveryHistory.tbl:   foreign key (SIDBStoreId, SubStoreId, CommCellId)references	IdxSIDBSubStore(SIDBStoreId, SubStoreId, CommCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'IdxSIDBRecoveryHistory', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBSubStore'
if @retCode != 0 goto ERROR_EXIT
-- SMJobCopyToBackupIDMap.tbl:   (JobId, CommCellId) REFERENCES CommServ.dbo.JMJobStats (JobId, CommCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'SMJobCopyToBackupIDMap', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- SMExternalJobMapHist.tbl (AuxCopyJobId, CommCellId) REFERENCES CommServ.dbo.JMJobStats (JobId, CommCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'SMExternalJobMapHist', @fromColumn = 'AuxCopyJobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- App_VMProp.tbl (jobId, CommCellId) REFERENCES CommServ.dbo.JMJobStats (JobId, CommCellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'App_VMProp', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 7.0		--
----------------------------------
-- JMJobOptions.tbl: foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobOptions', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobResourceHistory.tbl: foreign key (jobId, commCellId) references JMJobStats(jobId, commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobResourceHistory', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
-- JMJobStreams.tbl: foreign key (jobId, commCellId) references JMJobStats(jobId,commCellId) on delete cascade
execute @retCode = cvsp_drop_fkeys @fromTable = 'JMJobStreams', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 8.0		--
----------------------------------
-- archDAAlertInfo.tbl: foreign key (jobId, commCellId) references JMJobStats(jobId, commCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'archDAAlertInfo', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
----------------------------------
-- Tables for 9.0       --
----------------------------------
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlFileSubClient', 		@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlFileSubClientGroup', 	@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlLogMarkNames', 		@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlServer', 				@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlDatabase', 			@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlFileGroup', 			@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlFile', 				@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlBackupSet', 			@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlLSNs', 				@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'sqlBackupFile', 			@fromColumn = 'commCellId', 		@toTable = 'APP_CommCell'
if @retCode != 0 goto ERROR_EXIT
--execute @retCode = cvsp_drop_fkeys @fromTable = 'IdxSIDBUsageHistory2', 			@fromColumn = 'SIDBStoreId', 		@toTable = 'IdxSIDBStore'
--if @retCode != 0 goto ERROR_EXIT
----------------------------------
-- Tables for 10.0       --
----------------------------------
--evParam.tbl foreign key (evMsgId,commcellId) references evMsg(id,commcellId)
execute @retCode = cvsp_drop_fkeys @fromTable = 'evParam', @fromColumn = 'evMsgId', @toTable = 'evMsg'
if @retCode != 0 goto ERROR_EXIT
--EvGuiAuditMessage.tbl foreign key (evMsgId, commcellId) references evMsg(id, commcellId) ON delete CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'EvGuiAuditMessage', @fromColumn = 'evMsgId', @toTable = 'evMsg'
if @retCode != 0 goto ERROR_EXIT
--IdxSIDBUsageHistory.tbl foreign key (SIDBStoreId, CommCellId) references IdxSIDBStore(SIDBStoreId, CommCellId) ON DELETE CASCADE
execute @retCode = cvsp_drop_fkeys @fromTable = 'IdxSIDBUsageHistory', @fromColumn = 'SIDBStoreId', @toTable = 'IdxSIDBStore'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'archFileCopyDedupVerifyHistory', @fromColumn = 'jobId', @toTable = 'JMJobStats'
if @retCode != 0 goto ERROR_EXIT
execute @retCode = cvsp_drop_fkeys @fromTable = 'archChunkMappingNASDedup', @fromColumn = 'archChunkId', @toTable = 'archChunkMapping'
if @retCode != 0 goto ERROR_EXIT
----------------------------------------------------------------------------------
--************ Start to update tables ************'
set @tmpStr = 'CommcellClone -- Failed to update tables!'
-- check origCCcommCellId instead
update ArchGroup set origCCcommcellid = @newCommCellId, origCCarchGroupId = case origCCarchGroupId when 0 then id else origCCarchGroupId end
where origCCcommCellId = 0 or origCCcommCellid = 2 -- origCCarchGroupId = 0
if @@ERROR != 0 goto ERROR_EXIT
update ArchGroup set description = 'Automatically Modified - CommCellClone'
if @@ERROR != 0 goto ERROR_EXIT
-- check origCCcommCellId instead
update ArchGroupCopy set origCCcommcellid = @newCommCellId, origCCarchCopyId = case origCCarchCopyId when 0 then id else origCCarchCopyId end
where origCCcommCellId = 0 or origCCcommCellid = 2 -- origCCarchCopyId = 0
if @@ERROR != 0 goto ERROR_EXIT
-- Reset the Ref Time - To Trigger Full Backups -- for all subclient
update APP_SubClientProp set attrVal = N'0' where modified = 0 and attrname = N'sys:last'
if @@ERROR != 0 goto ERROR_EXIT
update archFileCopyDedup set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archCopySIDBStore set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update MMMagLibFADTaskInfo set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archChunk set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archChunkMapping set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archChunkMapping set chunkCommcellId = @newCommCellId where chunkCommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archdb2Log set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archFileCopy set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archFile set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archCheckHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
-- check origCCcommCellId instead
update MMMountPath set origCCcommCellID = @newCommCellId, origCCmediaSideID = case origCCmediaSideId when 0 then MediaSideId else origCCmediaSideId end
where origCCcommCellId = 0 or origCCcommCellid = 2 -- origCCmediaSideID = 0
if @@ERROR != 0 goto ERROR_EXIT
-- check origCCcommCellId instead
update MMVolume set origCCcommCellID = @newCommCellId, origCCvolumeID = case origCCvolumeId when 0 then VolumeId else origCCvolumeId end
where origCCcommCellId = 0 or origCCcommCellid = 2 -- origCCvolumeID = 0
if @@ERROR != 0 goto ERROR_EXIT
-- check origCCcommCellId instead
update MMMedia set origCCcommCellID = @newCommCellId, origCCmediaID = case origCCmediaId when 0 then MediaId else origCCmediaId end
where origCCcommCellId = 0 or origCCcommCellid = 2 -- origCCmediaID = 0
if @@ERROR != 0 goto ERROR_EXIT
update JMQinetixDownloadStatus set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMQinetixUpdateStatus set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMRegisteredPipelines set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMOracleRACClientsUsed set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMAdminJobAttemptStatsTable set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMAdminJobStatsTable set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMBkpAtmptStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMBkpJobInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMBkpStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMDataCopiedStatsTable set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMFailureReasonMsg set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobDataLink set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobDataStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobOptions set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobResourceHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMMisc set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMRestoreAtmptStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMRestoreStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMRstJobInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update QRJobVolumeHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update sqlArchiveSet set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update sqlArchiveInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SybArchFileInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SybSystemDevices set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SybSystemUsages set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobSnapshotStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMCompliancePolicyQualifiedJobs set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobWF set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--update JMSnapTapeWF set commcellid = @newCommCellId where commCellId = @currCommCellId
--if @@ERROR != 0 goto ERROR_EXIT
update JMAdminInfoMgmtStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archFileSiloVolume set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
IF EXISTS (SELECT * FROM sysobjects WHERE type = 'u' AND name = 'SMSnapShot')
BEGIN
update SMSnapShot set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
END
update evFilterName set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobMiningStats set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMPreparedJob set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
-- 07/24/2007 cliu
-- Tables are removed from 7.0
-- update CNJobBkpAttemptHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
-- update CNJobBkpHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
-- update CNJobDataStatsHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
-- update CNJobQRVolumeHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
-- update CNJobRstAttemptHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
-- update CNJobRstHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
-- if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 7.0		--
----------------------------------
update archContentIndexingAged set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archContentIndexingRestart set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archFileOracle set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update archFileSIDBKeys set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update ArchJobCopyExtended set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--update archJobCopyExtendedRpt set commcellid = @newCommCellId where commCellId = @currCommCellId
--if @@ERROR != 0 goto ERROR_EXIT
update ArchPipelineJobList set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update ArchSQLJobCopyToBeRetained set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update IdxSIDBStore set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMStubRecallJobs set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobOptions set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobResourceHistory set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update JMJobStreams set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update MMDeletedAF set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update MMDeletedAF set chunkCommCellId = @newCommCellId where chunkCommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update MMTempDeletedAF set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update MMTempDeletedAF set chunkCommCellId = @newCommCellId where chunkCommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update IdxSIDBSubStore set commcellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update IdxSIDBRecoveryHistory set commcellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SMJobCopyToBackupIDMap set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SMExternalJobMapHist set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update SMVolume set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update App_VMProp set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 8.0		--
----------------------------------
update archDAAlertInfo set commcellid = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 9.0		--
----------------------------------
update sqlFileSubClient set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--QRFLRConsistencyPoint
update QRFLRConsistencyPoint  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--IdxSIDBStorePruningLogs	            CommCellId	Needs handling
update IdxSIDBStorePruningLogs  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlFileSubClientGroup	            commCellId	Needs handling
update sqlFileSubClientGroup  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--GXDRFull	                        commCellId	Needs handling
update GXDRFull  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--GXDRDiff	                        commCellId	Needs handling
update GXDRDiff  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--SMVolAction	                        CommCellId	Needs handling
update SMVolAction  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlLogMarkNames	                    commCellId	Needs handling
update sqlLogMarkNames  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--SMVolActionHistory	                CommCellId	Needs handling
update SMVolActionHistory  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--SMDeletedSnapShot	                CommCellId	Needs handling
update SMDeletedSnapShot  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--GRCJMJobDataStatsTracking	        commCellId	Needs handling
update GRCJMJobDataStatsTracking  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlAnalysisDbBackupInfo	            commCellId	Needs handling
update sqlAnalysisDbBackupInfo  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlAnalysisArchiveInfo	            commCellId	Needs handling
update sqlAnalysisArchiveInfo  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFilePruningLogs	                commCellId	Needs handling
update archFilePruningLogs  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileCopyPruningLogs	            commCellId	Needs handling
update archFileCopyPruningLogs  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlVersion	                        commCellId	Needs handling
update sqlVersion  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileSIDBKeysPruningLogs	        commCellId	Needs handling
update archFileSIDBKeysPruningLogs  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlServer	                        commCellId	Needs handling
update sqlServer  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkPruningLogs	            commCellId	Needs handling
update archChunkPruningLogs  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkMappingPruningLogs	        commCellId	Needs handling
update archChunkMappingPruningLogs  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--evMsg	                            commCellID	Viewing events of cloned jobs actually works, we should still update this table though
update evMsg  set commCellID = @newCommCellId where commCellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlDatabase	                        commCellId	Needs handling
update sqlDatabase  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--IdxSIDBUsageHistory	                CommCellId	Needs handling
update IdxSIDBUsageHistory  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileSAP	                        commCellId	Needs handling
update archFileSAP  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileContentStore	            commCellId	Needs handling
update archFileContentStore  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkToSilo	                    commCellId	Needs handling
update archChunkToSilo  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkToSyncDDB	                commCellId	Needs handling
update archChunkToSyncDDB  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--CCMEntitiesCaptured	                CommCellId	Needs handling
update CCMEntitiesCaptured  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--UMUserCredentials	                commCellId	Needs handling
update UMUserCredentials  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlFileGroup	                    commCellId	Needs handling
update sqlFileGroup  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFailedKilledJobInfo	            commCellId	Needs handling
update archFailedKilledJobInfo  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlFile	                            commCellId	Needs handling
update sqlFile  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--SMVolume	                        CommCellId	Needs handling
update SMVolume  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlBackupSet	                    commCellId	Needs handling
update sqlBackupSet  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--CCMMergeEntityMap	                commCellId	Needs handling
update CCMMergeEntityMap  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archContentIndexingAF	            commCellId	Needs handling
update archContentIndexingAF  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlLSNs	                            commCellId	Needs handling
update sqlLSNs  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkSkipped	                commCellId	Needs handling
update archChunkSkipped  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--SMVolumeDeleted	                    CommCellId	Needs handling
update SMVolumeDeleted  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--sqlBackupFile	                    commCellId	Needs handling
update sqlBackupFile  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--MMEntityProp	                    CommCellId	Needs handling
update MMEntityProp  set CommCellId = @newCommCellId where CommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--JMJobDataStatsTracking	            commCellId	Needs handling
update JMJobDataStatsTracking  set commCellId = @newCommCellId where commCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--DM2Container	                    origCommcellID	Not sure, probably needs handling
update DM2Container  set origCommcellID = @newCommCellId where origCommcellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--IdxSIDBUsageHistory2	                    commCellId Needs handling
--update IdxSIDBUsageHistory2  set CommcellID = @newCommCellId where CommcellID = @currCommCellId
--if @@ERROR != 0 goto ERROR_EXIT
--archFileSubStore	                    commCellId Needs handling
update archFileSubStore  set CommcellID = @newCommCellId where CommcellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileSubStoreHistory	                    commCellId Needs handling
update archFileSubStoreHistory  set CommcellID = @newCommCellId where CommcellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkMappingNASDedup	                    commCellId Needs handling
update archChunkMappingNASDedup  set CommcellID = @newCommCellId where CommcellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archChunkMappingNASDedup	                    chunkCommCellId Needs handling
update archChunkMappingNASDedup  set chunkCommCellId = @newCommCellId where chunkCommCellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
--archFileCopyDedupVerifyHistory	                    commCellId Needs handling
update archFileCopyDedupVerifyHistory  set CommcellID = @newCommCellId where CommcellID = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 10.0		--
----------------------------------
update evParam set commcellId = @newCommCellId where commcellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
update EvGuiAuditMessage set commcellId = @newCommCellId where commcellId = @currCommCellId
if @@ERROR != 0 goto ERROR_EXIT
-----------------------------------------------------------------------------------
--************ Start to add foreign keys ************
set @tmpStr = 'CommcellClone -- Failed to add foreign keys!'
alter table archFileCopyDedup add foreign key(archFileId, commCellId, archCopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archCopySIDBStore add foreign key(SIDBStoreId,CommCellId) references IdxSIDBStore(SIDBStoreId,CommCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table MMMagLibFADTaskInfo add foreign key(adminJobId, commCellId) references JMJobStats (jobId, commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archChunkMapping add foreign key (archChunkId, chunkCommCellId) references archChunk(id, commCellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table archChunkMapping add  foreign key (archFileId, commCellId, archCopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archDB2Log add foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archFileCopy add foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archCheckHistory add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
-- alter table CNJobBkpAttemptHistory add foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- if @@ERROR != 0 goto ERROR_EXIT
-- alter table CNJobDataStatsHistory add foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- if @@ERROR != 0 goto ERROR_EXIT
-- alter table CNJobQRVolumeHistory add foreign key (CommCellID, JobID) references CNJobBkpHistory (CommCellID, JobID) ON Delete CASCADE
-- if @@ERROR != 0 goto ERROR_EXIT
-- alter table CNJobRstAttemptHistory add foreign key (CommCellID, JobID) references CNJobRstHistory (CommCellID, JobID) ON Delete CASCADE
-- if @@ERROR != 0 goto ERROR_EXIT
alter table JMQinetixUpdateStatus add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMQinetixDownloadStatus add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMRegisteredPipelines add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMOracleRACClientsUsed add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMAdminJobAttemptStatsTable add foreign key (jobID,commCellId) references JMAdminJobStatsTable(jobID,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMAdminJobStatsTable add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMBkpAtmptStats add foreign key (jobId,commCellId) references JMBkpStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMBkpStats add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMDataCopiedStatsTable add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMFailureReasonMsg add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobDataLink add foreign key (parentJobId,commCellId) references JMJobStats(jobId,commCellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobDataLink add foreign key (childJobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobDataStats add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobOptions add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobResourceHistory add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobStreams add foreign key (jobId, commcellId) references JMJobStats(jobId, commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMMisc add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMRestoreAtmptStats add foreign key (jobId,commCellId) references JMRestoreStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMRestoreStats add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table QRJobVolumeHistory add foreign key (JobId,commCellId) references JMJobStats(jobId,commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table SybArchFileInfo add foreign key (archFileId,commCellId) references archFile(id,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table sybSystemDevices add foreign key (sybBackupJobId_l,commCellId) references JMJobStats(jobId,commCellId) on delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table sybSystemUsages add foreign key (sybBackupJobId_l,commCellId) references JMJobStats(jobId,commCellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobSnapshotStats add foreign key (jobId, commcellId) references JMJobStats(jobId, commcellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMCompliancePolicyQualifiedJobs add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobWF add foreign key (jobId,commcellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
--alter table JMSnapTapeWF add foreign key (jobId,commcellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
--if @@ERROR != 0 goto ERROR_EXIT
-- alter table JMAdminInfoMgmtStats add foreign key (commCellId) references APP_CommCell(id)
-- if @@ERROR != 0 goto ERROR_EXIT
-- also commented out removing
alter table JMAdminInfoMgmtStats add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMJobInfo add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table archFileSiloVolume add foreign key (archFileId, commCellId) references archFile(id, commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
IF EXISTS (SELECT * FROM sysobjects WHERE type = 'u' AND name = 'SMSnapShot')
BEGIN
alter table SMSnapShot add foreign key (ArchFileId, CommCellId, CopyId) references archFileCopy(archFileId, commCellId, archCopyId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
END
-- alter table evFilterName add foreign key (commCellId) references APP_CommCell(id)
-- if @@ERROR != 0 goto ERROR_EXIT
-- also commented out removing
alter table JMJobMiningStats add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table JMPreparedJob add foreign key (jobId,commCellId) references JMJobStats(jobId,commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table MMTempDeletedAF add foreign key (SIDBStoreId,commCellId) references IdxSIDBStore(SIDBStoreId, CommCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table IdxSIDBSubStore add foreign key (SIDBStoreId, commCellId)references	 IdxSIDBStore(SIDBStoreId, commCellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table IdxSIDBRecoveryHistory add foreign key (SIDBStoreId, CommCellId)references IDXSIDBStore(SIDBStoreId, CommCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table IdxSIDBRecoveryHistory add foreign key (SIDBStoreId, SubStoreId, CommCellId)references IdxSIDBSubStore(SIDBStoreId, SubStoreId, CommCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table SMJobCopyToBackupIDMap add foreign key (jobId, CommCellId) references JMJobStats(jobId, CommCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table SMExternalJobMapHist   add foreign key (AuxCopyJobId, CommCellId) references JMJobStats (jobId, commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table App_VMProp add foreign key (jobId, CommCellId) references JMJobStats (jobId, commCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 7.0		--
----------------------------------
--alter table JMJobOptions add foreign key (jobId, commcellId) references JMJobStats(jobId, commCellId)
--if @@ERROR != 0 goto ERROR_EXIT
--alter table JMJobResourceHistory add foreign key (jobId, commcellId) references JMJobStats(jobId, commCellId)
--if @@ERROR != 0 goto ERROR_EXIT
--alter table JMJobStreams add foreign key (jobId, commcellId) references JMJobStats(jobId, commCellId)
--if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 8.0		--
----------------------------------
alter table archDAAlertinfo add foreign key (jobId, commcellId) references JMJobStats(jobId, commCellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 9.0		--
----------------------------------
alter table sqlFileSubClient		add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlFileSubClientGroup	add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlLogMarkNames			add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlServer				add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlDatabase				add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlFileGroup			add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlFile					add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlBackupSet			add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlLSNs					add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
alter table sqlBackupFile			add foreign key(commCellId)		references  	APP_CommCell (id)
if @@ERROR != 0 goto ERROR_EXIT
--alter table IdxSIDBUsageHistory2 	add foreign key (SIDBStoreId,commCellId) 	references 	IdxSIDBStore (SIDBStoreId,commCellId) ON DELETE CASCADE
--if @@ERROR != 0 goto ERROR_EXIT
ALTER TABLE archChunkMappingNASDedup  ADD CONSTRAINT archChunkMappingNASDedup_archChunkId_archFileId_commCellId_chunkCommcellId_FK	foreign key (archChunkId, archFileId, commCellId, chunkCommcellId)references	 archChunkMapping(archChunkId, archFileId, commCellId, chunkCommcellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
ALTER TABLE archFileCopyDedupVerifyHistory  ADD CONSTRAINT archFileCopyDedupVerifyHistory_jobId_commcellid_FK	foreign key (jobId, commcellid)references	 JMJobStats(jobId, commcellid) ON Delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
----------------------------------
--	Tables for 10.0		--
----------------------------------
alter table evParam  add foreign key (evMsgId,commcellId)references	 evMsg(id,commcellId)
if @@ERROR != 0 goto ERROR_EXIT
alter table EvGuiAuditMessage  add	foreign key (evMsgId, commcellId)references	 evMsg(id, commcellId) ON delete CASCADE
if @@ERROR != 0 goto ERROR_EXIT
alter table IdxSIDBUsageHistory  add foreign key (SIDBStoreId, CommCellId) references IdxSIDBStore(SIDBStoreId, CommCellId) ON DELETE CASCADE
if @@ERROR != 0 goto ERROR_EXIT
-----------------------------------------------------------------------------------
--A Store is tied to a CommcellId.
--So since the commcellId is being updated we need to seal all the stores and create new stores for the copies
--with new commcell Id.
--	*Get all stores that got the newCommcellId
--	*Get all the copies from archCopySIDBStore associated with these stores and with newCommCellId
--	*call archCopyStartNewSIDBStore on those copies (which will seal the active store of that copy and create a new store)
-- Donot seal stores migrated in GRC having client Id  1
DECLARE @StoresToSeal table(StoreId integer)
DECLARE @CopyIdsToCreateNewStore  table (CopyId integer)
DECLARE @CopyIdNeedsStore integer
DECLARE @resultSet table (copyId int,storeId_1 int, storeName_1 varchar(256), storeId_2 int, storeName_2 varchar(256),HasPartialAF int,SealedReason int)
INSERT @StoresToSeal
SELECT DISTINCT SIDBStoreId from IdxSIDBStore
WHERE CommCellId = @newCommCellId
AND SIDBStoreId <> 0 AND ClientId > 1
IF @@ERROR > 0
BEGIN
	SET @tmpStr = '@StoresToSeal  -- INSERT FAILED'
	GOTO ERROR_EXIT
END
IF EXISTS (SELECT * FROM @StoresToSeal)
BEGIN
	DECLARE @copiesString varchar(max)
	SET @copiesString = null
	DECLARE @copyIdsWithPartialJobs table(copyId int)
	INSERT @copyIdsWithPartialJobs
	SELECT distinct afd.archCopyId
	FROM archFileCopyDedup afd inner join @StoresToSeal stores ON afd.SIDBStoreId = stores.StoreId
	inner join archFile af ON af.id = afd.archFileId AND af.commCellId = afd.commCellId
	inner join JMJobDataStats jds ON af.jobId = jds.jobId AND af.commCellId = jds.commCellId AND jds.archGrpCopyId = afd.archCopyId
	WHERE (jds.disabled & (1+256)) = 0 AND jds.status in (102,103)
	IF EXISTS(SELECT * FROM @copyIdsWithPartialJobs)
	BEGIN
		SELECT @copiesString = COALESCE(@copiesString + ', ', '') + (AG.name + '\' + AGC.name)
        FROM archGroupCopy AGC INNER JOIN archGroup AG ON AGC.archGroupId = AG.id
			INNER JOIN @copyIdsWithPartialJobs copy ON AGC.id = copy.copyId
		SET @tmpStr = 'ERROR: StoragePolicies\Copies [' + @copiesString + '] have jobs partially copied, Please try clone after copying completely or mark them as "Do not copy" or "Recopy" '
		GOTO ERROR_EXIT
	END
	INSERT @CopyIdsToCreateNewStore
	SELECT DISTINCT id FROM archGroupCopy
	WHERE id in (SELECT DISTINCT CS.CopyId FROM @StoresToSeal S, archCopySIDBStore CS WHERE S.StoreID = CS.SIDBStoreID)
AND (dedupeFlags & (262144|134217728)) = 262144
	AND id <> 0
	IF @@ERROR > 0
	BEGIN
		SET @tmpStr = '@CopyIdsToCreateNewStore  -- INSERT FAILED'
		GOTO ERROR_EXIT
	END
	DECLARE CopyIdCursor CURSOR FOR
	SELECT DISTINCT CopyId FROM @CopyIdsToCreateNewStore
	OPEN CopyIdCursor
	FETCH NEXT FROM CopyIdCursor INTO @CopyIdNeedsStore
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT @resultSet
EXEC archCopyStartNewSIDBStore @CopyIdNeedsStore,2
		SET @retCode = @@ERROR
		IF @retCode <> 0
		BEGIN
			DELETE @resultSet
			SET @tmpStr = 'Sealing stores failed with @@ERROR[' + CAST (@retCode as varchar(10))+']'
			+' for Storage Policy ['+(SELECT name from archGroup where id = (select archGroupId from archGroupCopy where id = @CopyIdNeedsStore))+'] /'
			+'Copy Id ['+cast(@CopyIdNeedsStore as varchar(10))+']'+' Copy Name ['+isnull((select name from archGroupCopy where id = @CopyIdNeedsStore),'N/A')+'].'
			GOTO ERROR_EXIT
		END
		SET @retCode = (SELECT top 1 copyId FROM @resultSet)
		IF @retCode <> @CopyIdNeedsStore
		BEGIN
			DELETE @resultSet
			SET @tmpStr = 'Sealing stores failed with error code [' + CAST (@retCode as varchar(10))+']'
			+' for Storage Policy ['+(SELECT name from archGroup where id = (select archGroupId from archGroupCopy where id = @CopyIdNeedsStore))+'] /'
			+' Copy Id ['+cast(@CopyIdNeedsStore as varchar(10))+']'+' Copy Name ['+isnull((select name from archGroupCopy where id = @CopyIdNeedsStore),'N/A')+'].'
			IF @retCode = -1
				SET @tmpStr = @tmpStr + ' Failed to find active SIDB stores to seal from the database.'
			ELSE IF @retCode = -2
				SET @tmpStr = @tmpStr + ' There could be volumes reserved by active jobs associated with this sidb store. Kill/Complete running jobs and retry.'
			ELSE IF @retCode = -4
				SET @tmpStr = @tmpStr + ' There could be partially copied jobs for this copy. Please delete the partial jobs or completely auxcopy the jobs or mark them recopy and retry.'
			GOTO ERROR_EXIT
		END
		DELETE @resultSet
	FETCH NEXT FROM CopyIdCursor INTO @CopyIdNeedsStore
	END
	DELETE @CopyIdsToCreateNewStore
	DELETE @StoresToSeal
	CLOSE CopyIdCursor
	DEALLOCATE CopyIdCursor
END
----------------------------------------------
--	Set Media Reusable by other Commcell	--
----------------------------------------------
if @bReuseMedia > 0
	update MMMedia
set Attributes = Attributes | 268435456
--Mount paths should not be used for new backups after clone
--PrasadNara: 2:00 PM 7/19/2012 Do this for all the mountPaths cloned previously or migrated. We are already marking mountPaths readonly in CCM
update MMMountPath set MaxConcurrentWriters = 0
WHERE origCCcommCellID NOT IN (0,2)
--MEDIA_FLAG_READONLY 4
update MMMedia set MediaFlags = 4
WHERE MediaTypeId = 10001 and origCCcommCellID  NOT IN (0,2)
--************ EXIT ************
GOOD_EXIT:
	IF 1 = @bStartTransaction
		COMMIT TRANSACTION CloneTran
	select 0,'CommcellClone -- Successful!'
	RETURN 0
ERROR_EXIT:
	IF (Cursor_Status('LOCAL', 'CopyIdCursor') >= -1)
	BEGIN
		CLOSE CopyIdCursor
		DEALLOCATE CopyIdCursor
	END
	IF 1 = @bStartTransaction
		ROLLBACK TRANSACTION CloneTran
	select @retCode,@tmpStr
	RETURN -1
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_commcell_clone')
	delete from GxQscripts where name = 'cvsp_commcell_clone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_commcell_clone')
	delete from GXDBVersions where aliasname = 'cvsp_commcell_clone'
GO

insert into GXDBVersions values(2, 'cvsp_commcell_clone',  '00010055004200050000', 'cvsp_commcell_clone', '00010055004200050000')
GO

