

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvsp_check_space.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvsp_check_space.sp,v $ $Id: cvsp_check_space.sp,v 1.1 2005/08/17 19:10:36 ylu Exp $";
--  +========================================================================+
--  |   Procedure:  cvsp_check_space()
--  | Description:  output space occupied by each table
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_check_space <<<'

IF EXISTS (select * from sysobjects where name='cvsp_check_space')
	drop procedure cvsp_check_space
IF EXISTS (select * from GxQscripts where name='cvsp_check_space')
	delete from GxQscripts where name = 'cvsp_check_space'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_check_space')
	delete from GXDBVersions where aliasname = 'cvsp_check_space'
GO
print '... Creating Procedure: cvsp_check_space'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_check_space
AS
IF object_id('tempdb.dbo.#cvsp_check_space__tableList') is not null DROP TABLE #cvsp_check_space__tableList
IF object_id('tempdb.dbo.#cvsp_check_space__TableSizes') is not null DROP TABLE #cvsp_check_space__TableSizes
set nocount on
create table #cvsp_check_space__TableSizes (
	TableName varchar(64),
	NumRows integer,
	Reserved_KB varchar(64),
	Data_KB varchar(64),
	Index_Size_KB varchar(64),
	UnUsed_KB varchar(64),
	)
create table #cvsp_check_space__tableList (
	table_qualifier varchar(255),
	table_owner varchar(255),
	table_name varchar(255),
	table_type varchar(255),
	table_remarks varchar(255),
	)
insert into #cvsp_check_space__tableList
	exec sp_tables
declare  @fromTable varchar(255)
declare table_cur cursor for select table_name
from #cvsp_check_space__tableList where table_type <> 'SYSTEM TABLE'
open table_cur
fetch table_cur into @fromTable
while @@fetch_status = 0
begin
	insert into #cvsp_check_space__TableSizes
		EXEC sp_SpaceUsed @fromTable, 'TRUE'
	fetch table_cur into @fromTable
end
close table_cur
deallocate table_cur
UPDATE #cvsp_check_space__TableSizes SET Data_KB = SUBSTRING(Data_KB, 1, LEN(Data_KB) - 3)
UPDATE #cvsp_check_space__TableSizes SET Reserved_KB = SUBSTRING(Reserved_KB, 1, LEN(Reserved_KB) - 3)
UPDATE #cvsp_check_space__TableSizes SET Index_Size_KB = SUBSTRING(Index_Size_KB, 1, LEN(Index_Size_KB) - 3)
UPDATE #cvsp_check_space__TableSizes SET Unused_KB = SUBSTRING(Unused_KB, 1, LEN(Unused_KB) - 3)
select	*
from #cvsp_check_space__TableSizes
order by Data_KB DESC
drop table #cvsp_check_space__tableList
drop table #cvsp_check_space__TableSizes
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_check_space')
	delete from GxQscripts where name = 'cvsp_check_space'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_check_space')
	delete from GXDBVersions where aliasname = 'cvsp_check_space'
GO

insert into GXDBVersions values(2, 'cvsp_check_space',  '00010001000000000000', 'cvsp_check_space', '00010001000000000000')
GO

