

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchQuery.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchQuery.sp,v $ $Id: cvEntitySearchQuery.sp,v 1.1.2.17 2020/10/28 20:13:07 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvEntitySearchQuery
--  |
--  | Description:  Stored Procedure to search in CV Entity Search table
--  |
--  |
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='cvEntitySearchQuery')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchQuery <<<'
	drop procedure cvEntitySearchQuery
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchQuery')
	delete from GxQscripts where name = 'cvEntitySearchQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchQuery')
	delete from GXDBVersions where aliasname = 'cvEntitySearchQuery'
GO
print '... Creating Procedure: cvEntitySearchQuery'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure cvEntitySearchQuery
  @xmlInput XML, 
  @xmlResult XML OUTPUT
AS
DECLARE @userId INT,
        @query NVARCHAR(255),
        @searchType NVARCHAR(255),
        @startRowId INT = 0,
        @totalRow INT = 5,
        @detailed INT = 1,
        @exactMatch INT = 1,
        @cur DATETIME,
        @cutoff DATETIME,
        @tstatus INT,
        @header XML,
        @isEnable NVARCHAR(16),
        @cacheValidityInMinutes INT,
		@commcellGUID NVARCHAR(40) = NULL,
		@commcellstr NVARCHAR(255)
SET @isEnable = (SELECT CONVERT(NVARCHAR(16),value) AS value FROM APP_AdvanceSettings
                    WHERE keyName = 'bEnableEntitySearch' AND enabled = 1
                    AND deleted = 0 AND entityType = 3 AND entityId = 2)
IF @isEnable = N'FALSE'
    BEGIN
SET @xmlResult = (SELECT 5 AS '@status' FOR XML PATH('App_GlobalEntitySearchResp'))
        RETURN
    END
SET @userId  =    ISNULL((SELECT ref.value('@userId', 'INT')          FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),0)
SET @query =      ISNULL((SELECT ref.value('@query', 'NVARCHAR(255)') FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),N'')
SET @startRowId = ISNULL((SELECT ref.value('@startIndex', 'INT')      FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),0)
SET @totalRow =   ISNULL((SELECT ref.value('@limit', 'INT')           FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),5)
SET @detailed =   ISNULL((SELECT ref.value('@detailed', 'INT')        FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),1)
SET @exactMatch = ISNULL((SELECT ref.value('@exactMatch', 'INT')        FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),0)
SET @commcellGUID = ISNULL((SELECT ref.value('@csGUID', 'NVARCHAR(255)')          FROM @xmlInput.nodes('App_GlobalEntitySearchReq/commcell') R(ref)),N'')
IF LEN(@query) = 0
    BEGIN
SET @xmlResult = (select 6 AS '@status' FOR XML PATH('App_GlobalEntitySearchResp'))
        RETURN
    END
IF (@totalRow = 0)
	SET @totalRow = 5
SET @cacheValidityInMinutes = (SELECT CONVERT(INT, CONVERT(NVARCHAR(16),value)) AS value FROM APP_AdvanceSettings
                                   WHERE keyName = N'nEntitySearchCacheValidityPeriod' AND enabled = 1
                                   AND deleted = 0 AND entityType = 3 AND entityId = 2)
IF @cacheValidityInMinutes IS NULL OR @cacheValidityInMinutes < 15 OR @cacheValidityInMinutes > 1440
SET @cacheValidityInMinutes = 60
SET @cacheValidityInMinutes = 0 - @cacheValidityInMinutes
SET @cur = GETDATE();
SET @cutoff = DATEADD(MINUTE,@cacheValidityInMinutes,@cur);
SET @query = LTRIM(RTRIM(@query));
SELECT @tstatus =  (SELECT TOP 1 tstatus  FROM [CacheDB].[dbo].[UserCVEntitySearch] WHERE user_id = @userId AND created_at > @cutoff);
IF @tstatus IS NULL
BEGIN
SET @tstatus = 4
END
CREATE TABLE #temptable(id INT, search_type INT, name NVARCHAR(255), search_id NVARCHAR(255), basic_attribute XML, xmlText XML,
                        prefix_id int default null, suffix_id int default null, context_id int default null, sub_type int default 0,
						prefix nvarchar(255) default null, suffix nvarchar(255) default null, context nvarchar(255) default null, commcell_guid NVARCHAR(40) default NULL)
CREATE INDEX temptable_id ON #temptable(id) INCLUDE (name,xmlText,basic_attribute)
CREATE INDEX temptable_prefix_id ON #temptable(prefix_id)
CREATE INDEX temptable_suffix_id ON #temptable(suffix_id)
CREATE INDEX temptable_context_id ON #temptable(context_id)
CREATE INDEX temptable_search ON #temptable(search_type, search_id)
CREATE INDEX temptable_commcell ON #temptable(commcell_guid)
CREATE TABLE #temptable2(tri NVARCHAR(3), search_id INT)
CREATE INDEX temptable2_id ON #temptable2(tri)
DECLARE @pos INT = 1;
DECLARE @len INT = LEN(@query);
IF @exactMatch = 1
BEGIN
    SET @query = REPLACE(@query,'\','\\');
    SET @query = REPLACE(@query,'_','\_');
    INSERT INTO #temptable
        SELECT 1,search_type, N.entityName, search_id, basic_attribute, "xmlText" = CASE WHEN @detailed = 1 THEN xmlText ELSE '' END, prefix_id, suffix_id, context_id, subtype_id, NULL, NULL, NULL, commcell_guid
        FROM [CacheDB].[dbo].[CVEntitySearch] S WITH(NOLOCK) JOIN [CacheDB].[dbo].[CVEntitySearchName] N ON S.search_name_id = N.entityNameId
        WHERE user_id = @userId AND  N.entityName = @query
        AND
        (
            (
		EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
			AND search_type IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
            OR
            (
		NOT EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
        )
END
ELSE IF @len > 2
BEGIN
    WHILE @pos <= @len - 2
    BEGIN
        INSERT INTO #temptable2 (tri, search_id) VALUES(SUBSTRING(@query, @pos, 3),-1)
        SET @pos = @pos + 1;
    END
    DECLARE @trigramCount INT = @len - 2
    INSERT INTO #temptable
        SELECT 1,search_type, N.entityName, search_id, basic_attribute, "xmlText" = CASE WHEN @detailed = 1 THEN xmlText ELSE '' END, prefix_id, suffix_id, context_id, subtype_id, NULL, NULL, NULL, commcell_guid
        FROM [CacheDB].[dbo].[CVEntitySearch] S WITH(NOLOCK) JOIN [CacheDB].[dbo].[CVEntitySearchName] N ON S.search_name_id = N.entityNameId
        WHERE user_id = @userId AND S.search_name_id IN (SELECT DISTINCT entityNameId FROM #temptable2 T
            JOIN [CacheDB].[dbo].[CVEntitySearchNameTrigram] N ON T.tri = N.trigramString
            GROUP BY entityNameId  HAVING COUNT(*)  = @trigramCount)
        AND
        (
            (
		EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
			AND search_type IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
            OR
            (
		NOT EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
        )
END
ELSE
BEGIN
    SET @query = REPLACE(@query,'\','\\');
    SET @query = REPLACE(@query,'_','\_');
    INSERT INTO #temptable
        SELECT 1,search_type, N.entityName, search_id, basic_attribute, "xmlText" = CASE WHEN @detailed = 1 THEN xmlText ELSE '' END, prefix_id, suffix_id, context_id, subtype_id, NULL, NULL, NULL, commcell_guid
        FROM [CacheDB].[dbo].[CVEntitySearch] S WITH(NOLOCK) JOIN [CacheDB].[dbo].[CVEntitySearchName] N ON S.search_name_id = N.entityNameId
        WHERE user_id = @userId AND S.search_name_id IN (SELECT DISTINCT SN.entityNameId FROM [CacheDB].[dbo].CVEntitySearchName SN
             JOIN [CacheDB].[dbo].CVEntitySearchNameTrigram ST ON SN.entityNameId = ST.entityNameId where ST.trigramString like '' + @query + '%' {escape '\'})
        AND
        (
            (
		EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
			AND search_type IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
            OR
            (
		NOT EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
        )
END
DECLARE @isValidJobID INT, @jobId INT, @searchTypeForJob INT, @xmlString XML
SET @searchTypeForJob = 17
IF @query like '%[0-9]%' AND TRY_CONVERT(INT, @query) IS NOT NULL AND
        (
            (
                EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
                        AND @searchTypeForJob IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
            OR
            (
                NOT EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
        )
BEGIN
    SET @jobId = CAST(@query AS INT)
    SET @xmlString = N'<Users><User Id="0"/></Users>'
    SET @xmlString.modify(' replace value of (/Users/User/@Id)[1] with (sql:variable("@userId"))')
    DECLARE @t TABLE (userId int, isVisible int)
	DECLARE @GUID NVARCHAR(40) = NULL
	SELECT @GUID = (SELECT  csGUID from APP_CommCell where id = 2)
    INSERT INTO @t
        EXEC   [dbo].[JMCheckUserJobVisibilityV2]
                                @inCommcellId = 2,
                                @inJobid = @jobId,
                                @inUserXML = @xmlString
    set  @isValidJobID =  ISNULL((SELECT isVisible  FROM @t), 0)
    IF @isValidJobID = 1
        INSERT INTO #temptable  (id, search_type, name, search_id, commcell_guid)
            SELECT 1,@searchTypeForJob,@query,@query, @GUID
END
DELETE #temptable  FROM #temptable F WHERE  sub_type not in (
    SELECT min(sub_type)
    FROM   #temptable S
    WHERE  F.search_type = S.search_type
	AND    F.search_id = S.search_id
)
/*
Filter out search entries from SERVERS if there exists the same one in (VM, HyperVisor, Device, FileServer)
*/
CREATE TABLE #duplicateRemovalTemptable( search_id NVARCHAR(255))
-- Get unique search_ids for For (HyperVisor, Device, FileServer)
INSERT INTO #duplicateRemovalTemptable (search_id)
SELECT DISTINCT search_id
FROM #temptable
WHERE search_type in (3, 25, 14)
--Get unique search_ids for VM by parsing xmlText
INSERT INTO #duplicateRemovalTemptable (search_id)
SELECT
xmlText.value('(detailedProperty/vmProperty/vmStatusInfoList/client/@clientId)[1]', 'varchar(max)') [clientId]
FROM  #temptable where search_type = 5
DELETE FROM #temptable
WHERE search_type = 1 AND
search_id in (
SELECT DISTINCT search_id FROM #duplicateRemovalTemptable)
/*
Filter out temp table by commcell_id
*/
IF @commcellGUID is NOT NULL AND @commcellGUID != N''
BEGIN
	DELETE FROM #temptable where commcell_guid != @commcellGUID
END
UPDATE #tempTable SET prefix = S.entityname
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.prefix_id = S.entityNameId
UPDATE #tempTable SET context = '(' + S.entityname + ')'
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.context_id = S.entityNameId
UPDATE #tempTable SET suffix = S.entityname
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.suffix_id = S.entityNameId
declare @timestamp datetime
set @timestamp = (select created_at from [CacheDB].[dbo].UserCVEntitySearch where user_id = @userId)
SET @xmlResult = (SELECT @tstatus AS '@status', @timestamp as '@user_timestamp',
(
    SELECT count(*) AS '@totalMatchingEntityCount',
           search_type AS '@searchType',
           (
               SELECT  name AS '@name', search_id AS '@id', sub_type as '@subtype_id', commcell_guid as '@commcellGuid', CONCAT(prefix, name, suffix, context) as '@displayName', basic_attribute AS 'node()', xmlText AS 'node()'
                   FROM #tempTable
                   WHERE search_type = Tbl1.search_type ORDER BY name OFFSET @startRowId ROWS FETCH NEXT @totalRow ROWS ONLY
                       FOR XML PATH('entityInfo'), TYPE
            )
	FROM #tempTable Tbl1
	GROUP BY search_type
	FOR XML PATH('entitySearchResultInfo'), TYPE
)
FOR XML PATH('App_GlobalEntitySearchResp'))
DROP TABLE #temptable
DROP TABLE #duplicateRemovalTemptable
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchQuery')
	delete from GxQscripts where name = 'cvEntitySearchQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchQuery')
	delete from GXDBVersions where aliasname = 'cvEntitySearchQuery'
GO

insert into GXDBVersions values(2, 'cvEntitySearchQuery',  '00010001000200170000', 'cvEntitySearchQuery', '00010001000200170000')
GO

