

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchList.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchList.sp,v $ $Id: cvEntitySearchList.sp,v 1.1.2.3 2020/03/23 22:59:17 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvEntitySearchList
--  |
--  | Description:  Stored Procedure to search in CV Entity Search table
--  |
--  |
--  |
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchList')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchList <<<'
	drop procedure cvEntitySearchList
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchList')
	delete from GxQscripts where name = 'cvEntitySearchList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchList')
	delete from GXDBVersions where aliasname = 'cvEntitySearchList'
GO
print '... Creating Procedure: cvEntitySearchList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchList
  @xmlInput XML, 
  @xmlResult XML OUTPUT
AS
DECLARE @userId INT,
        @startRowId INT = 0,
        @totalRow INT = 5,
        @detailed INT = 1,
        @cur DATETIME,
        @cutoff DATETIME,
        @tstatus INT,
        @header XML,
        @isEnable NVARCHAR(16),
        @cacheValidityInMinutes INT,
		@commcellGUID UNIQUEIDENTIFIER = NULL,
		@commcellstr NVARCHAR(255),
		@searchType INT
SET @isEnable = (SELECT CONVERT(NVARCHAR(16),value) AS value FROM APP_AdvanceSettings
                    WHERE keyName = 'bEnableEntitySearch' AND enabled = 1
                    AND deleted = 0 AND entityType = 3 AND entityId = 2)
IF @isEnable = N'FALSE'
    BEGIN
SET @xmlResult = (SELECT 5 AS '@status' FOR XML PATH('App_GlobalEntitySearchResp'))
        RETURN
    END
SET @userId  =    ISNULL((SELECT ref.value('@userId', 'INT')          FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),0)
SET @startRowId = ISNULL((SELECT ref.value('@startIndex', 'INT')      FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),0)
SET @totalRow =   ISNULL((SELECT ref.value('@limit', 'INT')           FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),5)
SET @detailed =   ISNULL((SELECT ref.value('@detailed', 'INT')        FROM @xmlInput.nodes('App_GlobalEntitySearchReq') R(ref)),1)
SET @commcellstr = ISNULL((SELECT ref.value('@csGUID', 'NVARCHAR(255)')          FROM @xmlInput.nodes('App_GlobalEntitySearchReq/commcell') R(ref)),N'')
--(SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
-- length of GUID is 36 characters
-- try to cast commcellstr from nvarchar to uniqueidentifier, if it fails set it to get current commcellguid
-- default @commcellGUID is current commcellGUID
SELECT @commcellGUID = CONVERT(uniqueidentifier, csGUID) from [CommServ].[dbo].[APP_CommCell] where id = 2
IF @commcellstr is NOT NULL AND len(@commcellstr) = 36
BEGIN
	BEGIN TRY
	SET @commcellGUID = CONVERT(uniqueidentifier,@commcellstr)
	END TRY
	BEGIN CATCH
		SELECT @commcellGUID = CONVERT(uniqueidentifier, csGUID) from [CommServ].[dbo].[APP_CommCell] where id = 2
	END CATCH
END
--SET @xmlResult = (select 6 AS '@status' FOR XML PATH('App_GlobalEntitySearchResp'))
IF (@totalRow = 0)
	SET @totalRow = 500
SET @cacheValidityInMinutes = (SELECT CONVERT(INT, CONVERT(NVARCHAR(16),value)) AS value FROM APP_AdvanceSettings
                                   WHERE keyName = N'nEntitySearchCacheValidityPeriod' AND enabled = 1
                                   AND deleted = 0 AND entityType = 3 AND entityId = 2)
IF @cacheValidityInMinutes IS NULL OR @cacheValidityInMinutes < 15 OR @cacheValidityInMinutes > 1440
SET @cacheValidityInMinutes = 60
SET @cacheValidityInMinutes = 0 - @cacheValidityInMinutes
SET @cur = GETDATE();
SET @cutoff = DATEADD(MINUTE,@cacheValidityInMinutes,@cur);
SELECT @tstatus =  (SELECT TOP 1 tstatus  FROM [CacheDB].[dbo].[UserCVEntitySearch] WHERE user_id = @userId AND created_at > @cutoff);
IF @tstatus IS NULL
BEGIN
SET @tstatus = 4
END
CREATE TABLE #temptable(id INT, search_type INT, name NVARCHAR(255), search_id NVARCHAR(255), basic_attribute XML, xmlText XML,
                        prefix_id int default null, suffix_id int default null, context_id int default null, sub_type int default 0,
						prefix nvarchar(255) default null, suffix nvarchar(255) default null, context nvarchar(255) default null, commcell_guid UNIQUEIDENTIFIER default NULL)
CREATE INDEX temptable_id ON #temptable(id) INCLUDE (name,xmlText,basic_attribute)
CREATE INDEX temptable_prefix_id ON #temptable(prefix_id)
CREATE INDEX temptable_suffix_id ON #temptable(suffix_id)
CREATE INDEX temptable_context_id ON #temptable(context_id)
CREATE INDEX temptable_search ON #temptable(search_type, search_id)
CREATE TABLE #temptable2(tri NVARCHAR(3), search_id INT)
CREATE INDEX temptable2_id ON #temptable2(tri)
INSERT INTO #temptable
SELECT 1,search_type, N.entityName, search_id, basic_attribute, "xmlText" = CASE WHEN @detailed = 1 THEN xmlText ELSE '' END,
prefix_id, suffix_id, context_id, subtype_id, NULL, NULL, NULL, commcell_guid
FROM [CacheDB].[dbo].[CVEntitySearch] S WITH(NOLOCK) JOIN [CacheDB].[dbo].[CVEntitySearchName] N ON S.search_name_id = N.entityNameId
WHERE user_id = @userId
AND S.commcell_guid = @commcellGUID
--AND S.search_type IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
AND
        (
            (
		EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
			AND S.search_type IN (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
            OR
            (
		NOT EXISTS (SELECT ref.value('@val', 'INT') FROM @xmlInput.nodes('App_GlobalEntitySearchReq/searchEntityType') R(ref))
            )
        )
ORDER BY S.created_at OFFSET @startRowId ROWS FETCH NEXT @totalRow ROWS ONLY
DELETE #temptable  FROM #temptable F WHERE  sub_type not in (
    SELECT min(sub_type)
    FROM   #temptable S
    WHERE  F.search_type = S.search_type
	AND    F.search_id = S.search_id
)
--select @startRowId, @totalRow
--select * from #temptable
UPDATE #tempTable SET prefix = S.entityname
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.prefix_id = S.entityNameId
UPDATE #tempTable SET context = '(' + S.entityname + ')'
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.context_id = S.entityNameId
UPDATE #tempTable SET suffix = S.entityname
FROM #tempTable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.suffix_id = S.entityNameId
declare @timestamp datetime
set @timestamp = (select created_at from [CacheDB].[dbo].UserCVEntitySearch where user_id = @userId)
SET @xmlResult = (SELECT @tstatus AS '@status', @timestamp as '@user_timestamp',
(
    SELECT count(*) AS '@totalMatchingEntityCount',
           search_type AS '@searchType',
           (
               SELECT  name AS '@name', search_id AS '@id', sub_type as '@subtype_id', commcell_guid as '@commcellGuid', CONCAT(prefix, name, suffix, context) as '@displayName', basic_attribute AS 'node()', xmlText AS 'node()'
                   FROM #tempTable
                   WHERE search_type = Tbl1.search_type --ORDER BY name OFFSET @startRowId ROWS FETCH NEXT @totalRow ROWS ONLY
                       FOR XML PATH('entityInfo'), TYPE
            )
	FROM #tempTable Tbl1
	GROUP BY search_type
	FOR XML PATH('entitySearchResultInfo'), TYPE
)
FOR XML PATH('App_GlobalEntitySearchResp'))
DROP TABLE #temptable
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchList')
	delete from GxQscripts where name = 'cvEntitySearchList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchList')
	delete from GXDBVersions where aliasname = 'cvEntitySearchList'
GO

insert into GXDBVersions values(2, 'cvEntitySearchList',  '00010001000200030000', 'cvEntitySearchList', '00010001000200030000')
GO

