

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertWorkFlow.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchInsertWorkFlow.sp,v $ $Id: cvEntitySearchInsertWorkFlow.sp,v 1.1.2.5 2019/12/04 23:27:41 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertWorkFlow')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertWorkFlow <<<'
	drop procedure cvEntitySearchInsertWorkFlow
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertWorkFlow')
	delete from GxQscripts where name = 'cvEntitySearchInsertWorkFlow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertWorkFlow')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertWorkFlow'
GO
print '... Creating Procedure: cvEntitySearchInsertWorkFlow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertWorkFlow
  @userId INT,
  @xmlResult XML OUTPUT,
  @entityType INT = 0,
  @inputXML XML=N''
AS
IF @userId < 0 -- for hidden user simply return
BEGIN
SET @xmlResult =  (SELECT 1 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
	RETURN
END
DECLARE @isEnable NVARCHAR(16)
set @isEnable = (SELECT CONVERT(NVARCHAR(16),value) AS value FROM APP_AdvanceSettings
                     WHERE keyName = 'bEnableEntitySearch'
                     AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
IF @isEnable = N'FALSE'
	BEGIN
SET @xmlResult =  (select 5 as '@status' for xml path('App_GlobalEntitySearchInsertResp'))
		RETURN
	END
DECLARE @cacheValidityInMinutes INT
SET @cacheValidityInMinutes = (SELECT CONVERT(INT, CONVERT(NVARCHAR(16),value)) AS value FROM APP_AdvanceSettings
                                   WHERE keyName = N'nEntitySearchCacheValidityPeriod'
                                   AND enabled = 1
                                   AND deleted = 0
                                   AND entityType = 3
                                   AND entityId = 2)
IF @cacheValidityInMinutes IS NULL OR @cacheValidityInMinutes < 15 OR @cacheValidityInMinutes > 1440
SET @cacheValidityInMinutes = 60
SET @cacheValidityInMinutes = 0 - @cacheValidityInMinutes
DECLARE @cur DATETIME, @cutoff DATETIME, @tstatus INT
SET @cur = GETDATE();
SET @cutoff = DATEADD(MINUTE,@cacheValidityInMinutes,@cur);
SELECT @tstatus =  (SELECT TOP 1 tstatus FROM [CacheDB].[dbo].[UserCVEntitySearch] WHERE user_id = @userId AND created_at > @cutoff ORDER BY created_at DESC);
-- check if user has queried before
IF @entityType = 0 AND @tstatus = 0 -- Already being processed some other thread
	BEGIN
		SET @xmlResult = (SELECT @tstatus AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
		RETURN
	END
ELSE IF @entityType = 0 AND @tstatus = 1 -- Already contains in the table
	BEGIN
		SET @xmlResult = (SELECT @tstatus AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
		RETURN
	END
ELSE IF @entityType = 0 AND (@tstatus IS NULL OR @tstatus = 2 OR @tstatus = 3  OR @tstatus = 7) -- Doesn't contains or something went wrong or has partial entry
	BEGIN
		BEGIN TRY
IF NOT EXISTS(SELECT * FROM [CacheDB].[dbo].[UserCVEntitySearch] WHERE user_id = @userId AND tstatus = 0 AND created_at > @cutoff)
			BEGIN
				-- delete all previous search entries for the user -- can be this procastinated?
				-- EXECUTE cvEntitySearchDelete @userId
				-- EXECUTE cvEntitySearchDeleteUser @userId, @cutoff
EXECUTE cvEntitySearchInsertUser @userId, 0
				EXECUTE cvEntitySearchInsertSearchEntities @userId, @entityType, 0,@inputXML
UPDATE [CacheDB].[dbo].[UserCVEntitySearch] SET tstatus = 1 WHERE user_id = @userId;
SET @xmlResult = (SELECT 1 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
			END
			ELSE
			BEGIN
SET @xmlResult = (SELECT 0 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
				RETURN
			END
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			-- ROLLBACK TRANSACTION [ST1]
SET @xmlResult = (SELECT 2 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
UPDATE [CacheDB].[dbo].[UserCVEntitySearch] SET tstatus = 2 WHERE user_id = @userId;
			RETURN
		END CATCH
	END
ELSE IF @entityType <> 0
	BEGIN
		BEGIN TRY
EXECUTE cvEntitySearchInsertUser @userId, 3
				EXECUTE cvEntitySearchInsertSearchEntities @userId, @entityType, 0, @inputXML
SET @xmlResult = (SELECT 1 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @xmlResult = (SELECT 2 AS '@status' for xml path('App_GlobalEntitySearchInsertResp'))
			RETURN
		END CATCH
	END
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertWorkFlow')
	delete from GxQscripts where name = 'cvEntitySearchInsertWorkFlow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertWorkFlow')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertWorkFlow'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertWorkFlow',  '00010001000200050000', 'cvEntitySearchInsertWorkFlow', '00010001000200050000')
GO

