

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertStoragePool.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchInsertStoragePool.sp,v $ $Id: cvEntitySearchInsertStoragePool.sp,v 1.1.2.9 2020/10/23 13:13:01 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertStoragePool')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertStoragePool <<<'
	drop procedure cvEntitySearchInsertStoragePool
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertStoragePool')
	delete from GxQscripts where name = 'cvEntitySearchInsertStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertStoragePool')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertStoragePool'
GO
print '... Creating Procedure: cvEntitySearchInsertStoragePool'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertStoragePool
  @userId INT,
  @searchType INT,
  @entityId INT = 0
AS
CREATE TABLE #tmp1(StoragePoolId int,StoragePoolName nvarchar(max), StoragePoolType int,SIDBStoreId int,ClientGroupName nvarchar(max),	Libraries varchar(1024),LibraryType int,NumOfMediaAgents int,
TotalControllers	int,OnlineControllers int,LibraryOfflineReason	int,MountPathOfflineReason	int,MediaAgentOfflineReason	int,MountPathType	int,StatusCode int, DeviceTypeId INT, LibrarySubType INT)
INSERT INTO #tmp1
EXEC    [dbo].[MMGetStoragePools]
		@i_userId = @userId
;with storagePool_cte
AS (
	SELECT	StoragePoolId, StoragePoolName, NumOfMediaAgents, StatusCode,
			CASE
				WHEN StoragePoolType = 4 THEN 3   --Api::StoragePoolType_SCALE_OUT -- Api::StorageType_HYPERSCALE
WHEN LibraryType <> 3 THEN	4 --Api::StorageType_TAPE
				WHEN MountPathType = 7 THEN 2 --Api::StorageType_CLOUD
				ELSE 1 --Api::StorageType_DISK-
			END AS storageType
	FROM	#tmp1
)
INSERT INTO #CVEntitySearchTempTable
			(
			[search_id],
			[name],
			[xmlText]
			)
SELECT StoragePoolId, StoragePoolName,
(SELECT (SELECT (SELECT storageType as "@storagePoolType",
NumOfMediaAgents as "@numberOfNodes",
StatusCode as "@statusCode"
FOR XML PATH ('storagePoolProperty'), TYPE) FOR XML PATH ('detailedProperty'))) as xmlText
from storagePool_cte c
where @entityId = 0 OR c.StoragePoolId = @entityId
drop table #tmp1
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertStoragePool')
	delete from GxQscripts where name = 'cvEntitySearchInsertStoragePool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertStoragePool')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertStoragePool'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertStoragePool',  '00010001000200090000', 'cvEntitySearchInsertStoragePool', '00010001000200090000')
GO

