

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertSearchEntity.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchInsertSearchEntity.sp,v $ $Id: cvEntitySearchInsertSearchEntity.sp,v 1.1.2.13 2020/10/28 20:13:10 cnaik Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertSearchEntity')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertSearchEntity <<<'
	drop procedure cvEntitySearchInsertSearchEntity
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertSearchEntity')
	delete from GxQscripts where name = 'cvEntitySearchInsertSearchEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertSearchEntity')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertSearchEntity'
GO
print '... Creating Procedure: cvEntitySearchInsertSearchEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure cvEntitySearchInsertSearchEntity
  @userId INT,
  @searchType INT,
  @spName NVARCHAR(255),
  @entityId INT = 0,
  @inpXML XML = N''
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
/*
Either execute SPs to get data
OR
inpXML will contain payload
*/
CREATE TABLE #CVEntitySearchTempTable (name NVARCHAR(255),
                                       id INT,
									   commcell_guid 		NVARCHAR(40),
                                       search_id NVARCHAR(255),
                                       basic_attribute XML,
                                       xmlText XML,
                                       subtypeId INT default 0,
                                       context NVARCHAR(255),
                                       contextId INT,
                                       prefix NVARCHAR(255),
                                       prefixId INT,
                                       suffix NVARCHAR(255),
                                       suffixId INT);
CREATE INDEX #CVEntitySearchTempTable_idx ON #CVEntitySearchTempTable(name)
CREATE INDEX #CVEntitySearchTempTable_search_id_idx ON #CVEntitySearchTempTable(search_id,subtypeId)
CREATE INDEX #CVEntitySearchTempTable_context_idx ON #CVEntitySearchTempTable(context)
CREATE INDEX #CVEntitySearchTempTable_prefix_idx ON #CVEntitySearchTempTable(prefix)
CREATE INDEX #CVEntitySearchTempTable_suffix_idx ON #CVEntitySearchTempTable(suffix)
IF @inpXML is NOT NULL AND @inpXML.exist('*') != 0
BEGIN
	-- get data from XML and populate temp table
	INSERT INTO #CVEntitySearchTempTable
			(
			[search_id],
			[name],
			[commcell_guid],
			[xmlText],
			[subtypeId]
			)
	SELECT
		EntityInfo.N.value('@id', 'NVARCHAR(255)') AS search_id,
		EntityInfo.N.value('@name', 'NVARCHAR(255)') AS name,
		EntityInfo.N.value('@commcellGuid', 'NVARCHAR(40)') AS commcell_guid,
		(CAST(EntityInfo.N.query('detailedProperty[1]') AS XML)) AS detailedProperty,
		CASE WHEN ISNUMERIC(EntityInfo.N.value('@subtype_id', 'INT')) = 1 THEN CAST(EntityInfo.N.value('@subtype_id', 'INT')AS INT) ELSE 0 END AS subtypeId
		FROM @inpXml.nodes('/App_GlobalEntitySearchResp') AS GlobalSearchInfo(N)
		cross apply GlobalSearchInfo.N.nodes('entitySearchResultInfo') as  EntitySearchInfo(N)
		cross apply EntitySearchInfo.N.nodes('entityInfo') as  EntityInfo(N)
END
ELSE
BEGIN
	EXECUTE @spName @userId,@searchType
	declare @commcell NVARCHAR(40)
	select @commcell=(SELECT csGUID from [CommServ].[dbo].APP_CommCell where id = 2)
	Update #CVEntitySearchTempTable
	Set commcell_guid = @commcell
	Where commcell_guid is NULL
END
DELETE FROM #CVEntitySearchTempTable where name is NULL or search_id is NULL
EXECUTE cvEntitySearchInsertEntityName
;
WITH CTE AS(
   SELECT *,
       RN = ROW_NUMBER()OVER(PARTITION BY search_id,subtypeId ORDER BY search_id)
   FROM #CVEntitySearchTempTable
)
DELETE FROM CTE WHERE RN > 1
IF @entityId = 0 AND (@inpXML is NULL OR @inpXML.exist('*') = 0)
BEGIN
DELETE CS FROM [CacheDB].[dbo].[CVEntitySearch] CS
LEFT JOIN #CVEntitySearchTempTable T ON CS.search_id = T.search_id
WHERE CS.user_id = @userId AND CS.search_type = @searchType AND T.search_id IS NULL
END
UPDATE CS SET CS.search_name_id = T.id, CS.created_at = SYSDATETIME(), CS.prefix_id = T.prefixId, CS.suffix_id = T.suffixId, CS.context_id = T.contextId, CS.basic_attribute = T.basic_attribute, CS.xmlText = T.xmlText
FROM [CacheDB].[dbo].[CVEntitySearch] CS INNER JOIN #CVEntitySearchTempTable T ON CS.search_id = T.search_id
WHERE CS.user_id = @userId AND CS.search_type = @searchType AND CS.subtype_id = T.subtypeId -- AND (CS.search_name_id <> T.id OR CS.prefix_id <> T.prefixId OR CS.suffix_id <> T.suffixId OR CS.context_id <> T.contextId)
INSERT INTO [CacheDB].[dbo].[CVEntitySearch]
	([user_id],
	[search_type],
	[commcell_guid],
	[search_id],
	[search_name_id],
	[xmlText],
	[basic_attribute],
	[created_at],
	[context_id],
	[prefix_id],
	[suffix_id],
	[subtype_id]
	)
SELECT
	@userId AS user_id,
	@searchType AS [search_type],
	[commcell_guid],
	search_id,
	id,
	xmlText,
	basic_attribute,
	SYSDATETIME() AS created_at,
	contextId,
	prefixId,
	suffixId,
	subtypeId
	FROM #CVEntitySearchTempTable T
WHERE NOT EXISTS(
	SELECT GS.search_type
	FROM [CacheDB].[dbo].[CVEntitySearch] GS
	WHERE GS.user_id = @userId and GS.search_type = @searchType AND GS.search_id = T.search_id AND GS.subtype_id=T.subtypeId AND GS.commcell_guid = T.commcell_guid)
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertSearchEntity')
	delete from GxQscripts where name = 'cvEntitySearchInsertSearchEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertSearchEntity')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertSearchEntity'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertSearchEntity',  '00010001000200130000', 'cvEntitySearchInsertSearchEntity', '00010001000200130000')
GO

