

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertSalesforceOrganizations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertSalesforceOrganizations')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertSalesforceOrganizations <<<'
	drop procedure cvEntitySearchInsertSalesforceOrganizations
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertSalesforceOrganizations')
	delete from GxQscripts where name = 'cvEntitySearchInsertSalesforceOrganizations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertSalesforceOrganizations')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertSalesforceOrganizations'
GO
print '... Creating Procedure: cvEntitySearchInsertSalesforceOrganizations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertSalesforceOrganizations
  @userId INT,
  @searchType INT,
  @entityId INT = 0
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
DECLARE @cloudAppAccountsReqXML XML = '<Api_CloudAppAccountsReq vendorType="3"><processinginstructioninfo> <user userId="'+CAST(@userId AS NVARCHAR(255))+'"/></processinginstructioninfo></Api_CloudAppAccountsReq>'
DECLARE @cloudAppAccountsRespXML XML
DECLARE @cloudAppAccountsListTable TABLE (cloudAppAccountsInfo XML)
INSERT INTO @cloudAppAccountsListTable
EXEC [dbo].[AppGetCloudAppAccounts] @cloudAppAccountsReqXML
--Now retrive @cloudAppAccountsListTable.cloudAppAccountsInfo XML and populate it to @cloudAppAccountsRespXML and then globally.
SELECT @cloudAppAccountsRespXML = cloudAppAccountsInfo FROM @cloudAppAccountsListTable
--Now globally into #CVEntitySearchTempTable
-- for salesforce we list client name
INSERT INTO #CVEntitySearchTempTable
            (
            [search_id],
            [name]
            )
SELECT
    CloudAppsAccount.Instance.value('instance[1]/@clientId', 'NVARCHAR(255)') AS search_id,
CloudAppsAccount.Instance.value('instance[1]/@clientName', 'NVARCHAR(255)') AS name
    FROM @cloudAppAccountsRespXML.nodes('/Api_CloudAppAccountsResp/account') as CloudAppsAccount(Instance)
	WHERE CloudAppsAccount.Instance.value('@vendorType', 'int') = 3
	-- sample response --
	--<Api_CloudAppAccountsResp>
    --<error errorMessage="" errorCode="0" />
    --<account vendorType="33" backupSize="0" slaStatus="2" vendorDisplayName="GitHub" backupTime="0" status="0">
        --<instance clientId="1012" clientName="test-m-github-1" instanceName="test-m-github-1" instanceId="5" />
        --<plan planName="Server plan" planId="1" />
    --</account>
	--</Api_CloudAppAccountsResp>
	-- sample response --
	--#CVEntitySearchTempTable is limiting name size to 255.
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertSalesforceOrganizations')
	delete from GxQscripts where name = 'cvEntitySearchInsertSalesforceOrganizations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertSalesforceOrganizations')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertSalesforceOrganizations'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertSalesforceOrganizations',  '00000000000000000000', 'cvEntitySearchInsertSalesforceOrganizations', '00000000000000000000')
GO

