

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertGitAppsAccounts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertGitAppsAccounts')
BEGIN
	print '>>> Drop Stored Procedure: cvEntitySearchInsertGitAppsAccounts <<<'
	drop procedure cvEntitySearchInsertGitAppsAccounts
END
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertGitAppsAccounts')
	delete from GxQscripts where name = 'cvEntitySearchInsertGitAppsAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertGitAppsAccounts')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertGitAppsAccounts'
GO
print '... Creating Procedure: cvEntitySearchInsertGitAppsAccounts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertGitAppsAccounts
  @userId INT,
  @searchType INT,
  @entityId INT = 0
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON;
DECLARE @cloudAppAccountsReqXML XML = '<Api_CloudAppAccountsReq><processinginstructioninfo> <user userId="'+CAST(@userId AS NVARCHAR(255))+'"/></processinginstructioninfo></Api_CloudAppAccountsReq>'
DECLARE @cloudAppAccountsRespXML XML
DECLARE @cloudAppAccountsListTable TABLE (cloudAppAccountsInfo XML)
INSERT INTO @cloudAppAccountsListTable
EXEC [dbo].[AppGetCloudAppAccounts] @cloudAppAccountsReqXML
--Now retrive @cloudAppAccountsListTable.cloudAppAccountsInfo XML and populate it to @cloudAppAccountsRespXML and then globally.
SELECT @cloudAppAccountsRespXML = cloudAppAccountsInfo FROM @cloudAppAccountsListTable
--Now globally into #CVEntitySearchTempTable
INSERT INTO #CVEntitySearchTempTable
            (
            [search_id],
            [name],
			[xmlText]
            )
SELECT
    CloudAppsAccount.Instance.value('instance[1]/@instanceId', 'NVARCHAR(255)') AS search_id,
CloudAppsAccount.Instance.value('instance[1]/@instanceName', 'NVARCHAR(255)') AS name,
	(SELECT (SELECT CAST(CloudAppsAccount.Instance.query('.') AS XML) FOR XML PATH('cloudAppsProperty'), Type)  FOR XML PATH('detailedProperty')) as xmlText
    FROM @cloudAppAccountsRespXML.nodes('/Api_CloudAppAccountsResp/account') as CloudAppsAccount(Instance)
	WHERE CloudAppsAccount.Instance.value('@vendorType', 'int') <> 3 -- exclude salesforce instance
	-- sample response --
	--<Api_CloudAppAccountsResp>
    --<error errorMessage="" errorCode="0" />
    --<account vendorType="33" backupSize="0" slaStatus="2" vendorDisplayName="GitHub" backupTime="0" status="0">
        --<instance clientId="1012" clientName="test-m-github-1" instanceName="test-m-github-1" instanceId="5" />
        --<plan planName="Server plan" planId="1" />
    --</account>
	--</Api_CloudAppAccountsResp>
	-- sample response --
	--#CVEntitySearchTempTable is limiting name size to 255.
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertGitAppsAccounts')
	delete from GxQscripts where name = 'cvEntitySearchInsertGitAppsAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertGitAppsAccounts')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertGitAppsAccounts'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertGitAppsAccounts',  '00000000000000000000', 'cvEntitySearchInsertGitAppsAccounts', '00000000000000000000')
GO

