

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/cvEntitySearchInsertEntityName.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/cvEntitySearchInsertEntityName.sp,v $ $Id: cvEntitySearchInsertEntityName.sp,v 1.1.2.4 2018/09/26 18:00:31 surajbharech Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvEntitySearchInsertEntityName <<<'

IF EXISTS (select * from sysobjects where name='cvEntitySearchInsertEntityName')
	drop procedure cvEntitySearchInsertEntityName
IF EXISTS (select * from GxQscripts where name='cvEntitySearchInsertEntityName')
	delete from GxQscripts where name = 'cvEntitySearchInsertEntityName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertEntityName')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertEntityName'
GO
print '... Creating Procedure: cvEntitySearchInsertEntityName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure cvEntitySearchInsertEntityName
AS
DECLARE @maxEntiyNameId INTEGER
SET @maxEntiyNameId = ISNULL((SELECT Max(entitynameid) FROM [CacheDB].[dbo].CVEntitySearchName), 0)   -- get the max id till now
INSERT INTO [cachedb].[dbo].[cventitysearchname] (entityname)
	SELECT DISTINCT T.name FROM #cventitysearchtemptable T LEFT JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.name = S.entityName WHERE S.entityName IS NULL -- insert the names which are missing
INSERT INTO [cachedb].[dbo].[cventitysearchname] (entityname)
	SELECT DISTINCT T.context FROM #cventitysearchtemptable T LEFT JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.context = S.entityName WHERE T.context is not null and S.entityName IS NULL -- insert the names which are missing
INSERT INTO [cachedb].[dbo].[cventitysearchname] (entityname)
	SELECT DISTINCT T.prefix FROM #cventitysearchtemptable T LEFT JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.prefix = S.entityName WHERE T.prefix is not null and S.entityName IS NULL -- insert the names which are missing
INSERT INTO [cachedb].[dbo].[cventitysearchname] (entityname)
	SELECT DISTINCT T.suffix FROM #cventitysearchtemptable T LEFT JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.suffix = S.entityName WHERE T.suffix is not null and S.entityName IS NULL -- insert the names which are missing
UPDATE #cventitysearchtemptable SET id = S.entitynameid
FROM #cventitysearchtemptable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.name = S.entityName
UPDATE #cventitysearchtemptable SET contextId = S.entitynameid
FROM #cventitysearchtemptable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.context = S.entityName
UPDATE #cventitysearchtemptable SET prefixId = S.entitynameid
FROM #cventitysearchtemptable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.prefix = S.entityName
UPDATE #cventitysearchtemptable SET suffixId = S.entitynameid
FROM #cventitysearchtemptable T INNER JOIN [CacheDB].[dbo].CVEntitySearchName S ON T.suffix = S.entityName
INSERT INTO [CacheDB].[dbo].CVEntitySearchNameTrigram
	(entityNameId, trigramString)
	SELECT DISTINCT T.id, GT.trigram
	FROM #cventitysearchtemptable T LEFT JOIN [CacheDB].[dbo].CVEntitySearchNameTrigram S ON T.id = S.entityNameId
	CROSS APPLY dbo.cvEntitySearchGenerateTrigrams(T.name) AS GT
	WHERE T.id > @maxEntiyNameId AND S.entityNameId IS NULL
GO

IF EXISTS (select * from GxQscripts where name = 'cvEntitySearchInsertEntityName')
	delete from GxQscripts where name = 'cvEntitySearchInsertEntityName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvEntitySearchInsertEntityName')
	delete from GXDBVersions where aliasname = 'cvEntitySearchInsertEntityName'
GO

insert into GXDBVersions values(2, 'cvEntitySearchInsertEntityName',  '00010001000200040000', 'cvEntitySearchInsertEntityName', '00010001000200040000')
GO

